/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.DMatrixQrd;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Stopwatch;

public class QrdBench {
    public static void main(String[] args) {
        double maxtime = 5.0;
        int m = 100;
        int n = 5;
        int nrhs = 5;
        edu.mines.jtk.la.DMatrix aj = edu.mines.jtk.la.DMatrix.random(m, n);
        edu.mines.jtk.la.DMatrix bj = edu.mines.jtk.la.DMatrix.random(m, nrhs);
        DMatrix al = new DMatrix(aj.get());
        DMatrix bl = new DMatrix(bj.get());
        Stopwatch sw = new Stopwatch();
        while (true) {
            edu.mines.jtk.la.DMatrixQrd qrdj = null;
            edu.mines.jtk.la.DMatrix xj = null;
            sw.restart();
            int nqrd = 0;
            while (sw.time() < maxtime) {
                qrdj = new edu.mines.jtk.la.DMatrixQrd(aj);
                xj = qrdj.solve(bj);
                ++nqrd;
            }
            sw.stop();
            double sum = Array.sum(xj.getArray());
            double rate = (double)nqrd / sw.time();
            System.out.println("Pure Java: rate=" + rate + " sum=" + sum);
            DMatrixQrd qrdl = null;
            DMatrix xl = null;
            sw.restart();
            nqrd = 0;
            while (sw.time() < maxtime) {
                qrdl = new DMatrixQrd(al);
                xl = qrdl.solve(bl);
                ++nqrd;
            }
            sw.stop();
            sum = Array.sum(xl.getArray());
            rate = (double)nqrd / sw.time();
            System.out.println("   LAPACK: rate=" + rate + " sum=" + sum);
        }
    }
}

