/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Stopwatch;

public class FftBench {
    public static void main(String[] args) {
        block0: while (true) {
            int nfft = 1;
            while (true) {
                if (nfft > 720720) continue block0;
                int nfftSmall = FftComplex.nfftSmall(nfft);
                int nfftFast = FftComplex.nfftFast(nfft);
                double timeSmall = FftBench.time(nfftSmall);
                if (nfftFast == nfftSmall) {
                    System.out.printf("nsmall=%d tsmall=%.14f\n", nfftSmall, timeSmall);
                } else {
                    double timeFast = nfftFast > nfftSmall ? FftBench.time(nfftFast) : timeSmall;
                    System.out.printf("nsmall=%d tsmall=%.14f tfast=%.14f\n", nfftSmall, timeSmall, timeFast);
                    if (timeSmall < timeFast) {
                        System.out.println("*** WARNING: tsmall<tfast! ***");
                    }
                }
                nfft = 1 + nfftSmall;
            }
            break;
        }
    }

    private static double time(int nfft) {
        double maxtime = 2.0;
        FftComplex fft = new FftComplex(nfft);
        float[] cx = Array.crandfloat(nfft);
        Stopwatch sw = new Stopwatch();
        sw.start();
        int count = 0;
        while (sw.time() < maxtime) {
            fft.complexToComplex(-1, cx, cx);
            fft.complexToComplex(1, cx, cx);
            fft.scale(nfft, cx);
            ++count;
        }
        sw.stop();
        double time = sw.time() / (double)count;
        return time;
    }
}

