/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import edu.mines.jtk.io.DataFile;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Stopwatch;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;

public class DataFileBench
extends TestCase {
    public static void main(String[] args) {
        DataFileBench.benchBigEndian();
        DataFileBench.benchLittleEndian();
    }

    public static void benchBigEndian() {
        DataFileBench.bench(DataFile.ByteOrder.BIG_ENDIAN);
    }

    public static void benchLittleEndian() {
        DataFileBench.bench(DataFile.ByteOrder.LITTLE_ENDIAN);
    }

    private static void bench(DataFile.ByteOrder order) {
        System.out.println("order=" + (Object)((Object)order));
        int n = 1000000;
        File file = null;
        DataFile df = null;
        try {
            file = File.createTempFile("junk", "dat");
            df = new DataFile(file, "rw", order);
            DataFileBench.benchFloat(df, n);
            DataFileBench.benchDouble(df, n);
            if (df != null) {
                df.close();
            }
            if (file != null) {
                file.delete();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void benchFloat(DataFile df, int n) throws IOException {
        float[] a = Array.randfloat(n);
        float[] b = Array.zerofloat(n);
        Stopwatch sw = new Stopwatch();
        sw.start();
        int nio = 0;
        while (sw.time() < 5.0) {
            df.seek(0L);
            df.writeFloats(a);
            df.seek(0L);
            df.readFloats(b);
            ++nio;
        }
        sw.stop();
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            throw new RuntimeException(" float: i/o failure");
        }
        double time = sw.time();
        double rate = 8.0E-6 * (double)nio * (double)n / time;
        System.out.println(" float: rate=" + rate + " MB/s");
    }

    private static void benchDouble(DataFile df, int n) throws IOException {
        double[] a = Array.randdouble(n);
        double[] b = Array.zerodouble(n);
        Stopwatch sw = new Stopwatch();
        sw.start();
        int nio = 0;
        while (sw.time() < 5.0) {
            df.seek(0L);
            df.writeDoubles(a);
            df.seek(0L);
            df.readDoubles(b);
            ++nio;
        }
        sw.stop();
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            throw new RuntimeException("double: i/o failure");
        }
        double time = sw.time();
        double rate = 1.6E-5 * (double)nio * (double)n / time;
        System.out.println("double: rate=" + rate + " MB/s");
    }
}

