/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import edu.mines.jtk.io.ArrayFile;
import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import junit.framework.TestCase;

public class ArrayFileBench
extends TestCase {
    public static void main(String[] args) {
        ArrayFileBench.benchBigEndian();
        ArrayFileBench.benchLittleEndian();
    }

    public static void benchBigEndian() {
        ArrayFileBench.bench(ByteOrder.BIG_ENDIAN);
    }

    public static void benchLittleEndian() {
        ArrayFileBench.bench(ByteOrder.LITTLE_ENDIAN);
    }

    private static void bench(ByteOrder order) {
        System.out.println("order=" + order);
        int n = 1000000;
        File file = null;
        ArrayFile af = null;
        try {
            file = File.createTempFile("junk", "dat");
            af = new ArrayFile(file, "rw", order, order);
            ArrayFileBench.benchFloat(af, n);
            ArrayFileBench.benchDouble(af, n);
            if (af != null) {
                af.close();
            }
            if (file != null) {
                file.delete();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void benchFloat(ArrayFile af, int n) throws IOException {
        float[] a = Array.randfloat(n);
        float[] b = Array.zerofloat(n);
        Stopwatch sw = new Stopwatch();
        sw.start();
        int nio = 0;
        while (sw.time() < 5.0) {
            af.seek(0L);
            af.writeFloats(a);
            af.seek(0L);
            af.readFloats(b);
            ++nio;
        }
        sw.stop();
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            throw new RuntimeException(" float: i/o failure");
        }
        double time = sw.time();
        double rate = 8.0E-6 * (double)nio * (double)n / time;
        System.out.println(" float: rate=" + rate + " MB/s");
    }

    private static void benchDouble(ArrayFile af, int n) throws IOException {
        double[] a = Array.randdouble(n);
        double[] b = Array.zerodouble(n);
        Stopwatch sw = new Stopwatch();
        sw.start();
        int nio = 0;
        while (sw.time() < 5.0) {
            af.seek(0L);
            af.writeDoubles(a);
            af.seek(0L);
            af.readDoubles(b);
            ++nio;
        }
        sw.stop();
        for (int i = 0; i < n; ++i) {
            if (a[i] == b[i]) continue;
            throw new RuntimeException("double: i/o failure");
        }
        double time = sw.time();
        double rate = 1.6E-5 * (double)nio * (double)n / time;
        System.out.println("double: rate=" + rate + " MB/s");
    }
}

