/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.awt;

import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.util.Check;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import javax.swing.event.EventListenerList;

public class ColorMap {
    public static final IndexColorModel GRAY = ColorMap.getGray();
    public static final IndexColorModel JET = ColorMap.getJet();
    public static final IndexColorModel HUE = ColorMap.getHue();
    public static final IndexColorModel PRISM = ColorMap.getPrism();
    public static final IndexColorModel RED_WHITE_BLUE = ColorMap.getRedWhiteBlue();
    private double _vmin = 0.0;
    private double _vmax = 1.0;
    private IndexColorModel _colorModel;
    private Color[] _colors = new Color[256];
    private EventListenerList _colorMapListeners = new EventListenerList();

    public ColorMap(double vmin, double vmax, IndexColorModel colorModel) {
        Check.argument(colorModel.isValid(0), "0 is valid for color model");
        Check.argument(colorModel.isValid(255), "255 is valid for color model");
        this._vmin = vmin;
        this._vmax = vmax;
        this._colorModel = colorModel;
        this.cacheColors();
    }

    public ColorMap(double vmin, double vmax, Color[] c) {
        this(vmin, vmax, ColorMap.getReds(c), ColorMap.getGreens(c), ColorMap.getBlues(c));
    }

    public ColorMap(double vmin, double vmax, byte[] r, byte[] g, byte[] b) {
        this(vmin, vmax, new IndexColorModel(8, 256, r, g, b));
    }

    public ColorMap(double vmin, double vmax, float[] r, float[] g, float[] b) {
        this(vmin, vmax, ColorMap.getBytes(r), ColorMap.getBytes(g), ColorMap.getBytes(b));
    }

    public double getMinValue() {
        return this._vmin;
    }

    public double getMaxValue() {
        return this._vmax;
    }

    public IndexColorModel getColorModel() {
        return this._colorModel;
    }

    public Color getColor(double v) {
        return this._colors[this.getIndex(v)];
    }

    public int getIndex(double v) {
        v = Math.max(this._vmin, Math.min(this._vmax, v));
        return (int)Math.round(255.0 * (v - this._vmin) / (this._vmax - this._vmin));
    }

    public void setValueRange(double vmin, double vmax) {
        if (this._vmin != vmin || this._vmax != vmax) {
            this._vmin = vmin;
            this._vmax = vmax;
            this.fireColorMapChanged();
        }
    }

    public void setColorModel(IndexColorModel colorModel) {
        this._colorModel = colorModel;
        this.cacheColors();
        this.fireColorMapChanged();
    }

    public void addListener(ColorMapListener cml) {
        this._colorMapListeners.add(ColorMapListener.class, cml);
        cml.colorMapChanged(this);
    }

    public void removeListener(ColorMapListener cml) {
        this._colorMapListeners.remove(ColorMapListener.class, cml);
    }

    public static IndexColorModel getGray() {
        return ColorMap.getGray(0.0, 1.0);
    }

    public static IndexColorModel getGray(double g0, double g255) {
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float g = (float)(g0 + (double)i * (g255 - g0) / 255.0);
            c[i] = new Color(g, g, g);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel getJet() {
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float a;
            float x = (float)i / 255.0f;
            if (x < 0.125f) {
                a = x / 0.125f;
                c[i] = new Color(0.0f, 0.0f, 0.5f + 0.5f * a);
                continue;
            }
            if (x < 0.375f) {
                a = (x - 0.125f) / 0.25f;
                c[i] = new Color(0.0f, a, 1.0f);
                continue;
            }
            if (x < 0.625f) {
                a = (x - 0.375f) / 0.25f;
                c[i] = new Color(a, 1.0f, 1.0f - a);
                continue;
            }
            if (x < 0.875f) {
                a = (x - 0.625f) / 0.25f;
                c[i] = new Color(1.0f, 1.0f - a, 0.0f);
                continue;
            }
            a = (x - 0.875f) / 0.125f;
            c[i] = new Color(1.0f - 0.5f * a, 0.0f, 0.0f);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel getPrism() {
        return ColorMap.getHue(0.0, 8.0);
    }

    public static IndexColorModel getHue() {
        return ColorMap.getHue(0.0, 0.67);
    }

    public static IndexColorModel getHue(double h0, double h255) {
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float h = (float)(h0 + (double)i * (h255 - h0) / 255.0);
            c[i] = Color.getHSBColor(h, 1.0f, 1.0f);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel getRedWhiteBlue() {
        Color[] c = new Color[256];
        for (int i = 0; i < 256; ++i) {
            float a;
            float x = (float)i / 255.0f;
            if (x < 0.5f) {
                a = x / 0.5f;
                c[i] = new Color(1.0f, a, a);
                continue;
            }
            a = (x - 0.5f) / 0.5f;
            c[i] = new Color(1.0f - a, 1.0f - a, 1.0f);
        }
        return ColorMap.makeIndexColorModel(c);
    }

    public static IndexColorModel makeIndexColorModel(Color[] c) {
        return new IndexColorModel(8, 256, ColorMap.getReds(c), ColorMap.getGreens(c), ColorMap.getBlues(c));
    }

    private void fireColorMapChanged() {
        Object[] listeners = this._colorMapListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            ColorMapListener cml = (ColorMapListener)listeners[i + 1];
            cml.colorMapChanged(this);
        }
    }

    private void cacheColors() {
        for (int index = 0; index < 256; ++index) {
            this._colors[index] = new Color(this._colorModel.getRGB(index));
        }
    }

    private static byte[] getReds(Color[] color) {
        int n = color.length;
        byte[] r = new byte[n];
        for (int i = 0; i < n; ++i) {
            r[i] = (byte)color[i].getRed();
        }
        return r;
    }

    private static byte[] getGreens(Color[] color) {
        int n = color.length;
        byte[] g = new byte[n];
        for (int i = 0; i < n; ++i) {
            g[i] = (byte)color[i].getGreen();
        }
        return g;
    }

    private static byte[] getBlues(Color[] color) {
        int n = color.length;
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)color[i].getBlue();
        }
        return b;
    }

    private static byte[] getBytes(float[] f) {
        int n = f.length;
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = (byte)(f[i] * 255.0f + 0.5f);
        }
        return b;
    }
}

