/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.prefs.Preferences;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.MMException;

public class SnapLiveContrastSettings {
    private static final String CHANNEL = "_CHANNEL";
    private static final String GAMMA = "_GAMMA";
    private static final String MIN = "_MIN";
    private static final String MAX = "_MAX";
    private Preferences prefs_ = Preferences.userNodeForPackage(this.getClass());

    public void saveSettings(ContrastSettings contrastSettings, int n, String string) {
        if (!this.isValidPixelType(string)) {
            return;
        }
        this.prefs_.putDouble(string + CHANNEL + n + GAMMA, contrastSettings.gamma);
        this.prefs_.putInt(string + CHANNEL + n + MAX, contrastSettings.max);
        this.prefs_.putInt(string + CHANNEL + n + MIN, contrastSettings.min);
    }

    private int loadMin(String string, int n) throws MMException {
        if (!this.isValidPixelType(string)) {
            throw new MMException("Invalid pixel type");
        }
        return this.prefs_.getInt(string + CHANNEL + n + MIN, 0);
    }

    private int loadMax(String string, int n) throws MMException {
        if (!this.isValidPixelType(string)) {
            throw new MMException("Invalid pixel type");
        }
        int n2 = string.startsWith("GRAY") ? (string.equals("GRAY8") ? 255 : 65535) : (string.equals("RGB32") ? 255 : 65535);
        return this.prefs_.getInt(string + CHANNEL + n + MAX, n2);
    }

    private double loadGamma(String string, int n) throws MMException {
        if (!this.isValidPixelType(string)) {
            throw new MMException("Invalid pixel type");
        }
        return this.prefs_.getDouble(string + CHANNEL + n + GAMMA, 1.0);
    }

    public ContrastSettings loadSettings(String string, int n) throws MMException {
        return new ContrastSettings(this.loadMin(string, n), this.loadMax(string, n), this.loadGamma(string, n));
    }

    private boolean isValidPixelType(String string) {
        return string.equals("GRAY8") || string.equals("GRAY16") || string.equals("GRAY32") || string.equals("RGB32") || string.equals("RGB64");
    }
}

