/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import ij.ImagePlus;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.TextRoi;
import java.awt.Font;
import java.text.NumberFormat;

public class ScaleBar {
    private Position pos_ = Position.TOPLEFT;
    private final int OFFSET = 10;
    private ImagePlus ip_;
    private Font font_ = new Font("Helvetics", 0, 12);
    private double pixelSizeUm_;
    private final double MULTIPLIER = Math.sqrt(10.0);
    private int exponent_ = 0;
    private int barWidth_;
    private int barHeight_;
    private String value_;
    private String units_ = "\u00b5m";

    public ScaleBar(ImagePlus imagePlus) {
        this.ip_ = imagePlus;
        double d = imagePlus.getCalibration().pixelWidth;
        this.units_ = imagePlus.getCalibration().getXUnit();
        if (d > 0.0) {
            double d2;
            int n = this.ip_.getWidth();
            int n2 = this.ip_.getHeight();
            this.barHeight_ = n2 / 75;
            int n3 = n / 20;
            int n4 = n / 4;
            double d3 = d2 = 1.0 / d;
            while (d3 < (double)n3) {
                d3 *= this.MULTIPLIER;
                ++this.exponent_;
            }
            while (d3 > (double)n4) {
                d3 /= this.MULTIPLIER;
                --this.exponent_;
            }
            double d4 = Math.pow(this.MULTIPLIER, this.exponent_);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(1);
            if (d4 > 10.0) {
                numberFormat.setMaximumFractionDigits(0);
            }
            this.value_ = numberFormat.format(d4);
            this.barWidth_ = (int)d3;
        }
    }

    public void setPosition(Position position) {
        this.pos_ = position;
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public void addToOverlay(Overlay overlay) {
        this.font_ = this.font_.deriveFont((int)(0.015 * (double)this.ip_.getWidth()));
        TextRoi textRoi = new TextRoi(10, 10, this.value_ + this.units_, this.font_);
        int n = this.ip_.getProcessor().getStringWidth(this.value_ + this.units_);
        if (this.pos_ == Position.TOPLEFT) {
            textRoi.setLocation((int)(10.0 + 0.5 * (double)this.barWidth_ - 0.5 * (double)n), 10 - this.barHeight_ - 2);
        } else if (this.pos_ == Position.TOPRIGHT) {
            textRoi.setLocation((int)((double)(this.ip_.getWidth() - 10) - 0.5 * (double)this.barWidth_ - 0.5 * (double)n), 10 - this.barHeight_ - 2);
        } else if (this.pos_ == Position.BOTTOMLEFT) {
            textRoi.setLocation((int)(10.0 + 0.5 * (double)this.barWidth_ - 0.5 * (double)n), this.ip_.getHeight() - 10 - 3 * this.barHeight_ - 2);
        } else if (this.pos_ == Position.BOTTOMRIGHT) {
            textRoi.setLocation((int)((double)(this.ip_.getWidth() - 10) - 0.5 * (double)this.barWidth_ - 0.5 * (double)n), this.ip_.getHeight() - 10 - 3 * this.barHeight_ - 2);
        }
        overlay.add((Roi)textRoi);
        Roi roi = new Roi(10, 10 + this.barHeight_, this.barWidth_, this.barHeight_);
        if (this.pos_ == Position.TOPRIGHT) {
            roi.setLocation(this.ip_.getWidth() - 10 - this.barWidth_, 10 + this.barHeight_);
        } else if (this.pos_ == Position.BOTTOMLEFT) {
            roi.setLocation(10, this.ip_.getHeight() - 10 - this.barHeight_);
        } else if (this.pos_ == Position.BOTTOMRIGHT) {
            roi.setLocation(this.ip_.getWidth() - 10 - this.barWidth_, this.ip_.getHeight() - 10 - this.barHeight_);
        }
        overlay.add(roi);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        TOPLEFT,
        TOPRIGHT,
        BOTTOMLEFT,
        BOTTOMRIGHT;

    }
}

