/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.DeviceType;
import mmcorej.PropertySetting;
import mmcorej.StrVector;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMPropertyTableModel;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.ShowFlags;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyTableData
extends AbstractTableModel
implements MMPropertyTableModel {
    private static final long serialVersionUID = -5582899855072387637L;
    int PropertyNameColumn_;
    protected int PropertyValueColumn_;
    int PropertyUsedColumn_;
    public boolean disabled = false;
    public String groupName_;
    public String presetName_;
    public ShowFlags flags_;
    public ScriptInterface gui_;
    public boolean showUnused_;
    protected boolean showReadOnly_;
    String[] columnNames_ = new String[3];
    public ArrayList<PropertyItem> propList_ = new ArrayList();
    public ArrayList<PropertyItem> propListVisible_ = new ArrayList();
    protected CMMCore core_ = null;
    Configuration[] groupData_;
    PropertySetting[] groupSignature_;
    private String[] presetNames_;
    private volatile boolean updating_;
    private boolean groupOnly_;

    public PropertyTableData(CMMCore cMMCore, String string, String string2, int n, int n2, boolean bl) {
        this.core_ = cMMCore;
        this.groupName_ = string;
        this.presetName_ = string2;
        this.PropertyNameColumn_ = 0;
        this.PropertyValueColumn_ = n;
        this.PropertyUsedColumn_ = n2;
        this.groupOnly_ = bl;
    }

    public ArrayList<PropertyItem> getProperties() {
        return this.propList_;
    }

    public String findMatchingPreset() {
        ArrayList<PropertyItem> arrayList = new ArrayList<PropertyItem>();
        for (PropertyItem propertyItem : this.propList_) {
            if (!propertyItem.confInclude) continue;
            arrayList.add(propertyItem);
        }
        for (int i = 0; i < this.groupData_.length; ++i) {
            int n = 0;
            for (PropertyItem propertyItem : arrayList) {
                PropertySetting propertySetting = new PropertySetting(propertyItem.device, propertyItem.name, propertyItem.value);
                if (!this.groupData_[i].isSettingIncluded(propertySetting)) continue;
                ++n;
            }
            if (n != arrayList.size()) continue;
            return this.presetNames_[i];
        }
        return null;
    }

    public PropertyItem getItem(String string, String string2) {
        for (PropertyItem propertyItem : this.propList_) {
            if (!propertyItem.device.contentEquals(string) || !propertyItem.name.contentEquals(string2)) continue;
            return propertyItem;
        }
        return null;
    }

    public boolean verifyPresetSignature() {
        return true;
    }

    public void deleteConfig(String string, String string2) {
        try {
            this.core_.deleteConfig(string, string2);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public StrVector getAvailableConfigGroups() {
        return this.core_.getAvailableConfigGroups();
    }

    @Override
    public int getRowCount() {
        return this.propListVisible_.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames_.length;
    }

    public boolean isEditingGroup() {
        return true;
    }

    @Override
    public PropertyItem getPropertyItem(int n) {
        return this.propListVisible_.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PropertyItem propertyItem = this.propListVisible_.get(n);
        if (n2 == this.PropertyNameColumn_) {
            return propertyItem.device + "-" + propertyItem.name;
        }
        if (n2 == this.PropertyValueColumn_) {
            return propertyItem.value;
        }
        if (n2 == this.PropertyUsedColumn_) {
            return new Boolean(propertyItem.confInclude);
        }
        return null;
    }

    public void setValueInCore(PropertyItem propertyItem, Object object) {
        ReportingUtils.logMessage(propertyItem.device + "/" + propertyItem.name + ":" + object);
        try {
            if (propertyItem.isInteger()) {
                this.core_.setProperty(propertyItem.device, propertyItem.name, NumberUtils.intStringDisplayToCore(object));
            } else if (propertyItem.isFloat()) {
                this.core_.setProperty(propertyItem.device, propertyItem.name, NumberUtils.doubleStringDisplayToCore(object));
            } else {
                this.core_.setProperty(propertyItem.device, propertyItem.name, object.toString());
            }
            propertyItem.value = object.toString();
            this.core_.waitForDevice(propertyItem.device);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        PropertyItem propertyItem = this.propListVisible_.get(n);
        ReportingUtils.logMessage("Setting value " + object + " at row " + n);
        if (n2 == this.PropertyValueColumn_) {
            if (propertyItem.confInclude) {
                this.setValueInCore(propertyItem, object);
                this.refresh();
                this.gui_.refreshGUI();
            }
        } else if (n2 == this.PropertyUsedColumn_) {
            propertyItem.confInclude = (Boolean)object;
        }
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames_[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == this.PropertyValueColumn_) {
            if (n2 == 2) {
                return false;
            }
            return !this.propListVisible_.get((int)n).readOnly;
        }
        if (n2 == this.PropertyUsedColumn_) {
            return this.isEditingGroup();
        }
        return false;
    }

    StrVector getAvailableConfigs(String string) {
        return this.core_.getAvailableConfigs(string);
    }

    public void refresh() {
        try {
            this.update();
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void update() {
        this.update(this.flags_, this.groupName_, this.presetName_);
    }

    public void setShowReadOnly(boolean bl) {
        this.showReadOnly_ = bl;
    }

    public void update(ShowFlags showFlags, String string, String string2) {
        try {
            StrVector strVector = this.core_.getLoadedDevices();
            this.propList_.clear();
            Configuration configuration = this.core_.getConfigGroupState(string);
            boolean bl = this.gui_.isLiveModeOn();
            this.gui_.enableLiveMode(false);
            this.setUpdating(true);
            int n = 0;
            while ((long)n < strVector.size()) {
                if (this.showDevice(showFlags, strVector.get(n)).booleanValue()) {
                    StrVector strVector2 = this.core_.getDevicePropertyNames(strVector.get(n));
                    int n2 = 0;
                    while ((long)n2 < strVector2.size()) {
                        PropertyItem propertyItem = new PropertyItem();
                        if (!this.groupOnly_ || configuration.isPropertyIncluded(strVector.get(n), strVector2.get(n2))) {
                            propertyItem.readFromCore(this.core_, strVector.get(n), strVector2.get(n2));
                            if (!(propertyItem.readOnly && !this.showReadOnly_ || propertyItem.preInit)) {
                                if (configuration.isPropertyIncluded(propertyItem.device, propertyItem.name)) {
                                    propertyItem.confInclude = true;
                                    propertyItem.setValueFromCoreString(configuration.getSetting(propertyItem.device, propertyItem.name).getPropertyValue());
                                } else {
                                    propertyItem.confInclude = false;
                                    propertyItem.setValueFromCoreString(this.core_.getProperty(strVector.get(n), strVector2.get(n2)));
                                }
                                this.propList_.add(propertyItem);
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            this.setUpdating(false);
            this.updateRowVisibility(showFlags);
            this.gui_.enableLiveMode(bl);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        this.fireTableStructureChanged();
    }

    public void updateRowVisibility(ShowFlags showFlags) {
        this.propListVisible_.clear();
        for (PropertyItem propertyItem : this.propList_) {
            boolean bl = this.showDevice(showFlags, propertyItem.device);
            if (!this.showUnused_ && !propertyItem.confInclude) {
                bl = false;
            }
            if (!bl) continue;
            this.propListVisible_.add(propertyItem);
        }
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    public Boolean showDevice(ShowFlags showFlags, String string) {
        DeviceType deviceType = null;
        try {
            deviceType = this.core_.getDeviceType(string);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
        Boolean bl = false;
        bl = deviceType == DeviceType.SerialDevice ? Boolean.valueOf(false) : (deviceType == DeviceType.CameraDevice ? Boolean.valueOf(showFlags.cameras_) : (deviceType == DeviceType.ShutterDevice ? Boolean.valueOf(showFlags.shutters_) : (deviceType == DeviceType.StageDevice ? Boolean.valueOf(showFlags.stages_) : (deviceType == DeviceType.XYStageDevice ? Boolean.valueOf(showFlags.stages_) : (deviceType == DeviceType.StateDevice ? Boolean.valueOf(showFlags.state_) : Boolean.valueOf(showFlags.other_))))));
        return bl;
    }

    public void setColumnNames(String string, String string2, String string3) {
        this.columnNames_[0] = string;
        this.columnNames_[1] = string2;
        this.columnNames_[2] = string3;
    }

    private void handleException(Exception exception) {
        ReportingUtils.showError(exception);
    }

    public void setGUI(ScriptInterface scriptInterface) {
        this.gui_ = scriptInterface;
    }

    public void setFlags(ShowFlags showFlags) {
        this.flags_ = showFlags;
    }

    public void setShowUnused(boolean bl) {
        this.showUnused_ = bl;
    }

    public ArrayList<PropertyItem> getPropList() {
        return this.propList_;
    }

    public void setUpdating(boolean bl) {
        this.updating_ = bl;
    }

    public boolean updating() {
        return this.updating_;
    }
}

