/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.Arrays;
import mmcorej.CMMCore;
import mmcorej.PropertyType;
import mmcorej.StrVector;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SortFunctionObjects;

public class PropertyItem {
    public String device;
    public String name;
    public String value;
    public boolean readOnly = false;
    public boolean preInit = false;
    public String[] allowed;
    public boolean confInclude = false;
    public boolean hasRange = false;
    public double lowerLimit = 0.0;
    public double upperLimit = 0.0;
    public PropertyType type;

    public PropertyItem() {
        this.device = new String();
        this.name = "Undefined";
        this.value = new String();
        this.allowed = new String[0];
    }

    public PropertyItem(String string, String string2) {
        this.name = string;
        this.value = string2;
        this.allowed = new String[0];
    }

    public PropertyItem(String string, String string2, boolean bl) {
        this.name = string;
        this.value = string2;
        this.allowed = new String[0];
        this.preInit = bl;
    }

    public void dump() {
        ReportingUtils.logMessage("Property : " + this.name);
        ReportingUtils.logMessage("Property : " + this.value);
        ReportingUtils.logMessage("   allowed :");
        for (int i = 0; i < this.allowed.length; ++i) {
            ReportingUtils.logMessage("   " + this.allowed[i]);
        }
    }

    public void setValueFromCoreString(String string) {
        try {
            this.value = this.isInteger() ? NumberUtils.intStringCoreToDisplay(string) : (this.isFloat() ? NumberUtils.doubleStringCoreToDisplay(string) : string);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            this.value = string;
        }
    }

    public String getValueInCoreFormat() {
        try {
            if (this.isInteger()) {
                return NumberUtils.intStringDisplayToCore(this.value);
            }
            if (this.isFloat()) {
                return NumberUtils.doubleStringDisplayToCore(this.value);
            }
            return this.value;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return this.value;
        }
    }

    public void readFromCore(CMMCore cMMCore, String string, String string2) {
        this.device = string;
        this.name = string2;
        try {
            this.readOnly = cMMCore.isPropertyReadOnly(string, string2);
            this.preInit = cMMCore.isPropertyPreInit(string, string2);
            this.hasRange = cMMCore.hasPropertyLimits(string, string2);
            this.lowerLimit = cMMCore.getPropertyLowerLimit(string, string2);
            this.upperLimit = cMMCore.getPropertyUpperLimit(string, string2);
            this.type = cMMCore.getPropertyType(string, string2);
            StrVector strVector = cMMCore.getAllowedPropertyValues(string, string2);
            this.allowed = new String[(int)strVector.size()];
            int n = 0;
            while ((long)n < strVector.size()) {
                this.allowed[n] = strVector.get(n);
                ++n;
            }
            this.sort();
            String string3 = cMMCore.getProperty(string, string2);
            this.setValueFromCoreString(string3);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    public void sort() {
        try {
            if (this.allowed.length > 0) {
                if (PropertyType.Float == this.type) {
                    Arrays.sort(this.allowed, new SortFunctionObjects.DoubleStringComp());
                } else if (PropertyType.Integer == this.type) {
                    Arrays.sort(this.allowed, new SortFunctionObjects.IntStringComp());
                } else if (PropertyType.String == this.type) {
                    boolean bl = true;
                    for (int i = 0; i < this.allowed.length; ++i) {
                        if (null != this.allowed[i]) {
                            if (0 < this.allowed[i].length()) {
                                if (Character.isDigit(this.allowed[i].charAt(0))) continue;
                                bl = false;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    if (bl) {
                        Arrays.sort(this.allowed, new SortFunctionObjects.NumericPrefixStringComp());
                    }
                }
            }
        }
        catch (Exception exception) {
            ReportingUtils.logMessage("error sorting " + this.device + "." + this.name);
        }
    }

    public boolean isInteger() {
        return this.type == PropertyType.Integer;
    }

    public boolean isFloat() {
        return this.type == PropertyType.Float;
    }

    public boolean isString() {
        return this.type == PropertyType.String;
    }

    public boolean isUndefined() {
        return this.type == PropertyType.Undef;
    }
}

