/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class NumberUtils {
    private static final NumberFormat format_ = NumberFormat.getInstance();
    private static final DecimalFormat coreDoubleFormat_;
    private static final DecimalFormat coreIntegerFormat_;

    public static String intToDisplayString(int n) {
        return format_.format(n);
    }

    public static String doubleToDisplayString(double d) {
        return format_.format(d);
    }

    public static int displayStringToInt(Object object) throws ParseException {
        return format_.parse((String)object).intValue();
    }

    public static double displayStringToDouble(Object object) throws ParseException {
        return format_.parse((String)object).doubleValue();
    }

    public static String intToCoreString(long l) {
        return coreIntegerFormat_.format(l);
    }

    public static String longToCoreString(long l) {
        return coreIntegerFormat_.format(l);
    }

    public static String doubleToCoreString(double d) {
        return coreDoubleFormat_.format(d);
    }

    public static int coreStringToInt(Object object) throws ParseException {
        return coreIntegerFormat_.parse((String)object).intValue();
    }

    public static long coreStringToLong(Object object) throws ParseException {
        return coreIntegerFormat_.parse((String)object).longValue();
    }

    public static double coreStringToDouble(Object object) throws ParseException {
        return coreDoubleFormat_.parse((String)object).doubleValue();
    }

    public static String doubleStringDisplayToCore(Object object) throws ParseException {
        return NumberUtils.doubleToCoreString(NumberUtils.displayStringToDouble(object));
    }

    public static String doubleStringCoreToDisplay(Object object) throws ParseException {
        return NumberUtils.doubleToDisplayString(NumberUtils.coreStringToDouble(object));
    }

    public static String intStringDisplayToCore(Object object) throws ParseException {
        return NumberUtils.intToCoreString(NumberUtils.displayStringToInt(object));
    }

    public static String intStringCoreToDisplay(Object object) throws ParseException {
        return NumberUtils.intToDisplayString(NumberUtils.coreStringToInt(object));
    }

    static {
        format_.setMaximumFractionDigits(4);
        coreDoubleFormat_ = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        coreDoubleFormat_.applyPattern("0.0000");
        coreIntegerFormat_ = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        coreIntegerFormat_.applyPattern("0");
    }
}

