/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Point;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;

public class ImageUtils {
    private static Class storageClass_ = TaggedImageStorageDiskDefault.class;

    public static int BppToImageType(long l) {
        int n = (int)l;
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    public static int getImageProcessorType(ImageProcessor imageProcessor) {
        if (imageProcessor instanceof ByteProcessor) {
            return 0;
        }
        if (imageProcessor instanceof ShortProcessor) {
            return 1;
        }
        if (imageProcessor instanceof ColorProcessor) {
            return 4;
        }
        return -1;
    }

    public static ImageProcessor makeProcessor(CMMCore cMMCore) {
        return ImageUtils.makeProcessor(cMMCore, null);
    }

    public static ImageProcessor makeProcessor(CMMCore cMMCore, Object object) {
        int n;
        int n2 = (int)cMMCore.getImageWidth();
        int n3 = (int)cMMCore.getImageHeight();
        int n4 = (int)cMMCore.getBytesPerPixel();
        switch (n4) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            default: {
                n = 0;
            }
        }
        return ImageUtils.makeProcessor(n, n2, n3, object);
    }

    public static ImageProcessor makeProcessor(int n, int n2, int n3, Object object) {
        if (object == null) {
            return ImageUtils.makeProcessor(n, n2, n3);
        }
        switch (n) {
            case 0: {
                return new ByteProcessor(n2, n3, (byte[])object, null);
            }
            case 1: {
                return new ShortProcessor(n2, n3, (short[])object, null);
            }
            case 2: {
                return new FloatProcessor(n2, n3, (float[])object, null);
            }
            case 4: {
                return new ColorProcessor(n2, n3, (int[])object);
            }
        }
        return null;
    }

    public static ImageProcessor makeProcessor(TaggedImage taggedImage) {
        JSONObject jSONObject = taggedImage.tags;
        try {
            return ImageUtils.makeProcessor(MDUtils.getIJType(jSONObject), MDUtils.getWidth(jSONObject), MDUtils.getHeight(jSONObject), taggedImage.pix);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    public static ImageProcessor makeProcessor(int n, int n2, int n3) {
        if (n == 0) {
            return new ByteProcessor(n2, n3);
        }
        if (n == 1) {
            return new ShortProcessor(n2, n3);
        }
        if (n == 2) {
            return new FloatProcessor(n2, n3);
        }
        if (n == 4) {
            return new ColorProcessor(n2, n3);
        }
        return null;
    }

    public static Point findMaxPixel(ImagePlus imagePlus) {
        int n;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        float[] fArray = (float[])imageProcessor.getPixels();
        int n2 = imagePlus.getWidth();
        double d = 0.0;
        int n3 = -1;
        for (n = 0; n < fArray.length; ++n) {
            if (!((double)fArray[n] > d)) continue;
            d = fArray[n];
            n3 = n;
        }
        n = n3 / n2;
        int n4 = n3 % n2;
        return new Point(n4, n);
    }

    public static Point findMaxPixel(ImageProcessor imageProcessor) {
        int n = imageProcessor.getWidth();
        int n2 = ImageUtils.findArrayMax(imageProcessor.getPixels());
        int n3 = n2 / n;
        int n4 = n2 % n;
        return new Point(n4, n3);
    }

    public static byte[] get8BitData(Object object) {
        return (byte[])object;
    }

    public static short[] get16BitData(Object object) {
        return (short[])object;
    }

    public static int[] get32BitData(Object object) {
        return (int[])object;
    }

    public static int findArrayMax(Object object) {
        if (object instanceof byte[]) {
            return ImageUtils.findArrayMax((byte[])object);
        }
        if (object instanceof int[]) {
            return ImageUtils.findArrayMax((int[])object);
        }
        if (object instanceof short[]) {
            return ImageUtils.findArrayMax((short[])object);
        }
        if (object instanceof float[]) {
            return ImageUtils.findArrayMax((float[])object);
        }
        return -1;
    }

    public static int findArrayMax(float[] fArray) {
        int n = -1;
        float f = Float.MIN_VALUE;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i];
            if (!(f2 > f)) continue;
            f = f2;
            n = i;
        }
        return n;
    }

    public static int findArrayMax(short[] sArray) {
        int n = -1;
        short s = Short.MIN_VALUE;
        for (int i = 0; i < sArray.length; ++i) {
            short s2 = sArray[i];
            if (s2 <= s) continue;
            s = s2;
            n = i;
        }
        return n;
    }

    public static int findArrayMax(byte[] byArray) {
        int n = -1;
        byte by = -128;
        for (int i = 0; i < byArray.length; ++i) {
            byte by2 = byArray[i];
            if (by2 <= by) continue;
            by = by2;
            n = i;
        }
        return n;
    }

    public static int findArrayMax(int[] nArray) {
        int n = -1;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (n3 <= n2) continue;
            n2 = n3;
            n = i;
        }
        return n;
    }

    public static byte[] convertRGB32IntToBytes(int[] nArray) {
        byte[] byArray = new byte[nArray.length * 4];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            byArray[n++] = (byte)(nArray[i] & 0xFF);
            byArray[n++] = (byte)(nArray[i] >> 8 & 0xFF);
            byArray[n++] = (byte)(nArray[i] >> 16 & 0xFF);
            byArray[n++] = 0;
        }
        return byArray;
    }

    public static byte[] getRGB32PixelsFromColorPanes(byte[][] byArray) {
        int n = 0;
        byte[] byArray2 = new byte[byArray.length * 4];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[n++] = byArray[2][i];
            byArray2[n++] = byArray[1][i];
            byArray2[n++] = byArray[0][i];
            byArray2[n++] = 0;
        }
        return byArray2;
    }

    public static short[] getRGB64PixelsFromColorPlanes(short[][] sArray) {
        int n = -1;
        short[] sArray2 = new short[sArray[0].length * 4];
        for (int i = 0; i < sArray[0].length; ++i) {
            sArray2[++n] = sArray[2][i];
            sArray2[++n] = sArray[1][i];
            sArray2[++n] = sArray[0][i];
            sArray2[++n] = 0;
        }
        return sArray2;
    }

    public static byte[][] getColorPlanesFromRGB32(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 4];
        byte[] byArray3 = new byte[byArray.length / 4];
        byte[] byArray4 = new byte[byArray.length / 4];
        int n = 0;
        for (int i = 0; i < byArray.length / 4; ++i) {
            byArray4[i] = byArray[n++];
            byArray3[i] = byArray[n++];
            byArray2[i] = byArray[n++];
            ++n;
        }
        byte[][] byArrayArray = new byte[][]{byArray2, byArray3, byArray4};
        return byArrayArray;
    }

    public static short[][] getColorPlanesFromRGB64(short[] sArray) {
        short[] sArray2 = new short[sArray.length / 4];
        short[] sArray3 = new short[sArray.length / 4];
        short[] sArray4 = new short[sArray.length / 4];
        int n = 0;
        for (int i = 0; i < sArray.length / 4; ++i) {
            sArray4[i] = sArray[n++];
            sArray3[i] = sArray[n++];
            sArray2[i] = sArray[n++];
            ++n;
        }
        short[][] sArrayArray = new short[][]{sArray2, sArray3, sArray4};
        return sArrayArray;
    }

    public static byte[] singleChannelFromRGB32(byte[] byArray, int n) {
        if (n != 0 && n != 1 && n != 2) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length / 4];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[2 - n + 4 * i];
        }
        return byArray2;
    }

    public static short[] singleChannelFromRGB64(short[] sArray, int n) {
        if (n != 0 && n != 1 && n != 2) {
            return null;
        }
        short[] sArray2 = new short[sArray.length / 4];
        for (int i = 0; i < sArray2.length; ++i) {
            sArray2[i] = sArray[2 - n + 4 * i];
        }
        return sArray2;
    }

    public static LUT makeLUT(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 256;
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        for (int i = 0; i < n4; ++i) {
            double d2 = (double)i / (double)(n4 - 1);
            double d3 = Math.pow(d2, d);
            byArray[i] = (byte)(d3 * (double)n);
            byArray2[i] = (byte)(d3 * (double)n2);
            byArray3[i] = (byte)(d3 * (double)n3);
        }
        return new LUT(8, n4, byArray, byArray2, byArray3);
    }

    public static void setImageStorageClass(Class clazz) {
        storageClass_ = clazz;
    }

    public static Class getImageStorageClass() {
        return storageClass_;
    }

    public static TaggedImageStorage newImageStorageInstance(String string, boolean bl, JSONObject jSONObject) {
        try {
            return (TaggedImageStorage)storageClass_.getConstructor(String.class, Boolean.class, JSONObject.class).newInstance(string, new Boolean(bl), jSONObject);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    private static int unsignedValue(byte by) {
        return (256 + by) % 256;
    }

    private static int unsignedValue(short s) {
        return (65536 + s) % 65536;
    }

    public static int getMin(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int n = Integer.MAX_VALUE;
            for (int i = 0; i < byArray.length; ++i) {
                n = Math.min(n, ImageUtils.unsignedValue(byArray[i]));
            }
            return n;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int n = Integer.MAX_VALUE;
            for (int i = 0; i < sArray.length; ++i) {
                n = Math.min(n, ImageUtils.unsignedValue(sArray[i]));
            }
            return n;
        }
        return -1;
    }

    public static int getMax(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int n = Integer.MIN_VALUE;
            for (int i = 0; i < byArray.length; ++i) {
                n = Math.max(n, ImageUtils.unsignedValue(byArray[i]));
            }
            return n;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            int n = Integer.MIN_VALUE;
            for (int i = 0; i < sArray.length; ++i) {
                n = Math.max(n, ImageUtils.unsignedValue(sArray[i]));
            }
            return n;
        }
        return -1;
    }

    public static int[] getMinMax(Object object) {
        int[] nArray = new int[2];
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length; ++i) {
                n = Math.max(n, ImageUtils.unsignedValue(byArray[i]));
                n2 = Math.min(n2, ImageUtils.unsignedValue(byArray[i]));
            }
            nArray[0] = n2;
            nArray[1] = n;
            return nArray;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length; ++i) {
                n2 = Math.min(n2, ImageUtils.unsignedValue(sArray[i]));
                n = Math.max(n, ImageUtils.unsignedValue(sArray[i]));
            }
            nArray[0] = n2;
            nArray[1] = n;
            return nArray;
        }
        return null;
    }

    public static TaggedImage makeTaggedImage(ImageProcessor imageProcessor) {
        JSONObject jSONObject = new JSONObject();
        try {
            MDUtils.setChannelIndex(jSONObject, 0);
            MDUtils.setSliceIndex(jSONObject, 0);
            MDUtils.setPositionIndex(jSONObject, 0);
            MDUtils.setFrameIndex(jSONObject, 0);
            MDUtils.setWidth(jSONObject, imageProcessor.getWidth());
            MDUtils.setHeight(jSONObject, imageProcessor.getHeight());
            MDUtils.setPixelType(jSONObject, ImageUtils.getImageProcessorType(imageProcessor));
        }
        catch (Exception exception) {
            return null;
        }
        return new TaggedImage(imageProcessor.getPixels(), jSONObject);
    }

    public static TaggedImage makeTaggedImage(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        JSONObject jSONObject = new JSONObject();
        try {
            MDUtils.setChannelIndex(jSONObject, n);
            MDUtils.setSliceIndex(jSONObject, n2);
            MDUtils.setPositionIndex(jSONObject, n3);
            MDUtils.setFrameIndex(jSONObject, n4);
            MDUtils.setWidth(jSONObject, n5);
            MDUtils.setHeight(jSONObject, n6);
            MDUtils.setPixelTypeFromByteDepth(jSONObject, n7);
        }
        catch (Exception exception) {
            return null;
        }
        return new TaggedImage(object, jSONObject);
    }

    public class MinAndMax {
        int min;
        int max;
    }
}

