/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import org.jdesktop.layout.GroupLayout;
import org.micromanager.ScriptPanel;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.HotKeyAction;
import org.micromanager.utils.HotKeys;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

public final class HotKeysDialog
extends MMDialog {
    private ShortCutTableModel sctModel_ = new ShortCutTableModel();
    private JComboBox combo_ = new JComboBox();
    private Integer lastTypedKey_ = 0;
    private KeyEvtHandler keh_;
    private ArrayList<Integer> keys_ = new ArrayList();
    private ArrayList<HotKeyAction> actions_ = new ArrayList();
    private ArrayList<HotKeyAction> possibleActions_ = new ArrayList();
    private String[] possibleActionsAsString_;
    private Font ourFont_ = new Font("Lucida Grande", 0, 10);
    private Preferences prefs_;
    public static FileDialogs.FileType MM_HOTKEYS = new FileDialogs.FileType("MM_HOTKEYS", "Micro-Manager HotKeys", System.getProperty("user.home") + "/MMHotKeys", false, null);
    private JButton addButton_;
    private JTable hotKeyTable_;
    private JScrollPane jScrollPane1_;
    private JButton loadButton_;
    private JButton removeButton_;
    private JButton saveButton_;

    public HotKeysDialog(Color color) {
        this.initComponents();
        this.setBackground(color);
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.prefs_ = preferences.node(preferences.absolutePath() + "/HotKeyFrame");
        this.setPrefsNode(this.prefs_);
        this.loadPosition(0, 0, 377, 378);
        this.readKeys();
        HotKeys.active_ = false;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HotKeysDialog.this.hotKeyTable_.getColumnModel().getColumn(0).getCellEditor().stopCellEditing();
                HotKeysDialog.this.hotKeyTable_.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
                HotKeysDialog.this.generateKeys();
                HotKeys.active_ = true;
                HotKeysDialog.this.savePosition();
            }
        });
        this.updateComboBox();
        this.hotKeyTable_.setRowSelectionAllowed(false);
        this.hotKeyTable_.setSelectionBackground(Color.white);
        this.hotKeyTable_.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.combo_));
        this.hotKeyTable_.getColumnModel().getColumn(1).setCellEditor(new HotKeyCol1Editor());
        this.hotKeyTable_.getColumnModel().getColumn(0).setCellRenderer(new ActionCollRenderer());
        this.hotKeyTable_.getColumnModel().getColumn(1).setCellRenderer(new HotKeyCol1Renderer());
        this.keh_ = new KeyEvtHandler();
        this.hotKeyTable_.addKeyListener(this.keh_);
        this.setModal(true);
        this.setVisible(true);
    }

    private void generateKeys() {
        HotKeys.keys_.clear();
        for (int i = 0; i < this.keys_.size(); ++i) {
            HotKeys.keys_.put(this.keys_.get(i), this.actions_.get(i));
        }
    }

    private void readKeys() {
        this.keys_.clear();
        this.actions_.clear();
        for (Map.Entry<Integer, HotKeyAction> entry : HotKeys.keys_.entrySet()) {
            this.keys_.add(entry.getKey());
            this.actions_.add(entry.getValue());
        }
    }

    public void updateComboBox() {
        int n;
        int n2 = 0;
        ArrayList<File> arrayList = ScriptPanel.getScriptList();
        if (arrayList != null) {
            n2 = arrayList.size();
        }
        this.possibleActionsAsString_ = new String[HotKeyAction.NRGUICOMMANDS + n2];
        System.arraycopy(HotKeyAction.guiItems_, 0, this.possibleActionsAsString_, 0, HotKeyAction.guiItems_.length);
        for (n = 0; n < HotKeyAction.NRGUICOMMANDS; ++n) {
            this.possibleActions_.add(n, new HotKeyAction(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.possibleActions_.add(n + HotKeyAction.NRGUICOMMANDS, new HotKeyAction(arrayList.get(n)));
            this.possibleActionsAsString_[n + HotKeyAction.NRGUICOMMANDS] = arrayList.get(n).getName();
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(this.possibleActionsAsString_);
        this.combo_.setModel(defaultComboBoxModel);
        this.combo_.setFont(this.ourFont_);
    }

    private void initComponents() {
        this.jScrollPane1_ = new JScrollPane();
        this.hotKeyTable_ = new JTable();
        this.addButton_ = new JButton();
        this.removeButton_ = new JButton();
        this.loadButton_ = new JButton();
        this.saveButton_ = new JButton();
        this.setDefaultCloseOperation(2);
        this.jScrollPane1_.setMinimumSize(new Dimension(23, 15));
        this.jScrollPane1_.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.hotKeyTable_.setFont(new Font("Lucida Grande", 0, 10));
        this.hotKeyTable_.setModel(this.sctModel_);
        this.jScrollPane1_.setViewportView(this.hotKeyTable_);
        this.addButton_.setFont(new Font("Lucida Grande", 0, 10));
        this.addButton_.setText("Add");
        this.addButton_.setMinimumSize(new Dimension(75, 20));
        this.addButton_.setPreferredSize(new Dimension(75, 20));
        this.addButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HotKeysDialog.this.addButton_ActionPerformed(actionEvent);
            }
        });
        this.removeButton_.setFont(new Font("Lucida Grande", 0, 10));
        this.removeButton_.setText("Remove");
        this.removeButton_.setMinimumSize(new Dimension(75, 20));
        this.removeButton_.setPreferredSize(new Dimension(75, 20));
        this.removeButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HotKeysDialog.this.removeButton_ActionPerformed(actionEvent);
            }
        });
        this.loadButton_.setFont(new Font("Lucida Grande", 0, 10));
        this.loadButton_.setText("Load");
        this.loadButton_.setMinimumSize(new Dimension(75, 20));
        this.loadButton_.setPreferredSize(new Dimension(75, 20));
        this.loadButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HotKeysDialog.this.loadButton_ActionPerformed(actionEvent);
            }
        });
        this.saveButton_.setFont(new Font("Lucida Grande", 0, 10));
        this.saveButton_.setText("Save");
        this.saveButton_.setMinimumSize(new Dimension(75, 20));
        this.saveButton_.setPreferredSize(new Dimension(75, 20));
        this.saveButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HotKeysDialog.this.saveButton_ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton_, -2, -1, -2).addPreferredGap(0).add((Component)this.removeButton_, -2, -1, -2).addPreferredGap(0, 69, Short.MAX_VALUE).add((Component)this.loadButton_, -2, -1, -2).addPreferredGap(0).add((Component)this.saveButton_, -2, -1, -2)).add((Component)this.jScrollPane1_, -1, 377, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.addButton_, -2, 20, -2).add((Component)this.removeButton_, -2, 20, -2).add((Component)this.saveButton_, -2, 20, -2).add((Component)this.loadButton_, -2, 20, -2)).addPreferredGap(0).add((Component)this.jScrollPane1_, -1, -1, Short.MAX_VALUE).add(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    private void addButton_ActionPerformed(ActionEvent actionEvent) {
        this.keys_.add(32);
        this.actions_.add(new HotKeyAction(0));
        this.sctModel_.fireTableRowsInserted(this.keys_.size() - 1, this.keys_.size());
        this.sctModel_.fireTableDataChanged();
    }

    private void removeButton_ActionPerformed(ActionEvent actionEvent) {
        this.hotKeyTable_.getColumnModel().getColumn(0).getCellEditor().stopCellEditing();
        this.hotKeyTable_.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
        int[] nArray = this.hotKeyTable_.getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.keys_.remove(nArray[i]);
            this.actions_.remove(nArray[i]);
        }
        this.sctModel_.fireTableRowsDeleted(nArray[0], nArray[nArray.length - 1]);
        this.sctModel_.fireTableDataChanged();
    }

    private void loadButton_ActionPerformed(ActionEvent actionEvent) {
        File file = FileDialogs.openFile(this, "Load ShortCuts", MM_HOTKEYS);
        if (file != null && file.canRead()) {
            try {
                HotKeys.load(file);
                this.readKeys();
                this.sctModel_.fireTableDataChanged();
            }
            catch (FileNotFoundException fileNotFoundException) {
                ReportingUtils.showError("Could not find the file");
            }
        }
    }

    private void saveButton_ActionPerformed(ActionEvent actionEvent) {
        this.generateKeys();
        try {
            File file = FileDialogs.save(this, "Save Shortcuts", MM_HOTKEYS);
            if (file == null) {
                return;
            }
            file.createNewFile();
            try {
                HotKeys.save(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ReportingUtils.showError("File not found");
            }
        }
        catch (IOException iOException) {
            ReportingUtils.showError("Failed to create file");
        }
    }

    public class HotKeyCol1Editor
    extends AbstractCellEditor
    implements TableCellEditor {
        JLabel keyLabel = new JLabel();

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object != null) {
                this.keyLabel.setText((String)object);
            } else {
                this.keyLabel.setText("m");
            }
            this.keyLabel.setForeground(Color.red);
            this.keyLabel.setFocusable(true);
            this.keyLabel.setFont(HotKeysDialog.this.ourFont_);
            HotKeysDialog.this.lastTypedKey_ = (Integer)HotKeysDialog.this.keys_.get(n);
            HotKeysDialog.this.keh_.setLabel(this.keyLabel);
            return this.keyLabel;
        }

        public Object getCellEditorValue() {
            return HotKeysDialog.this.lastTypedKey_;
        }
    }

    public class KeyEvtHandler
    implements KeyListener {
        JLabel label_;

        public void setLabel(JLabel jLabel) {
            this.label_ = jLabel;
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Integer n = keyEvent.getKeyCode();
            if (!HotKeysDialog.this.keys_.contains(n) || n == HotKeysDialog.this.keys_.get(HotKeysDialog.this.hotKeyTable_.getSelectedRow())) {
                HotKeysDialog.this.lastTypedKey_ = n;
                if (this.label_ != null) {
                    this.label_.setText(KeyEvent.getKeyText(HotKeysDialog.this.lastTypedKey_));
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class HotKeyCol1Renderer
    extends DefaultTableCellRenderer {
        public void SetValue(Object object) {
            this.setText(KeyEvent.getKeyText((Integer)object));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setBackground(Color.white);
            component.setForeground(Color.black);
            return component;
        }
    }

    public class ActionCollRenderer
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setBackground(Color.white);
            component.setForeground(Color.black);
            return component;
        }
    }

    public class ShortCutTableModel
    extends AbstractTableModel {
        private static final int columnCount_ = 2;

        public int getRowCount() {
            if (HotKeysDialog.this.keys_ != null) {
                return HotKeysDialog.this.keys_.size();
            }
            return 0;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Action";
            }
            return "HotKey";
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                if (n > HotKeysDialog.this.actions_.size()) {
                    return null;
                }
                HotKeyAction hotKeyAction = (HotKeyAction)HotKeysDialog.this.actions_.get(n);
                if (hotKeyAction != null) {
                    if (hotKeyAction.type_ == 0) {
                        return HotKeyAction.guiItems_[hotKeyAction.guiCommand_];
                    }
                    return hotKeyAction.beanShellScript_.getName();
                }
            }
            if (n2 == 1) {
                if (n > HotKeysDialog.this.keys_.size()) {
                    return null;
                }
                return KeyEvent.getKeyText((Integer)HotKeysDialog.this.keys_.get(n));
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public void setValueAt(Object object, int n, int n2) {
            boolean bl = false;
            if (n2 == 0) {
                for (int i = 0; i < HotKeysDialog.this.possibleActionsAsString_.length && !bl; ++i) {
                    if (!HotKeysDialog.this.possibleActionsAsString_[i].equals(object)) continue;
                    bl = true;
                    HotKeysDialog.this.actions_.set(n, HotKeysDialog.this.possibleActions_.get(i));
                }
            }
            if (n2 == 1 && !HotKeysDialog.this.keys_.contains((Integer)object)) {
                HotKeysDialog.this.keys_.set(n, (Integer)object);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }
}

