/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.text.ParseException;
import java.util.Hashtable;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class GammaSliderCalculator {
    final double c0_ = 0.1;
    final double c1_ = 0.02714285;
    final double c2_ = 0.014857150000000001;
    final double c3_ = 0.003142855;
    double min_ = 0.1;
    double max_ = 5.0;
    int low_ = 0;
    int high_ = 100;
    Hashtable<Integer, Double> gammas_;
    Hashtable<Double, Integer> values_;

    public GammaSliderCalculator(int n, int n2) {
        this.gammas_ = new Hashtable(n2 - n + 1, 1.0f);
        this.values_ = new Hashtable(n2 - n + 1, 1.0f);
        for (int i = n; i <= n2; ++i) {
            try {
                double d = NumberUtils.displayStringToDouble(NumberUtils.doubleToDisplayString(this.calculateGamma(i)));
                this.gammas_.put(new Integer(i), d);
                this.values_.put(d, new Integer(i));
                continue;
            }
            catch (ParseException parseException) {
                ReportingUtils.logMessage("Caught ParseException");
            }
        }
        this.low_ = n;
        this.high_ = n2;
        this.min_ = this.gammas_.get(n);
        this.max_ = this.gammas_.get(n2);
    }

    public double sliderToGamma(int n) {
        return this.gammas_.get(n);
    }

    public int gammaToSlider(double d) {
        if (d < this.min_) {
            d = this.min_;
        }
        if (d > this.max_) {
            d = this.max_;
        }
        try {
            d = NumberUtils.displayStringToDouble(NumberUtils.doubleToDisplayString(d));
            Integer n = this.values_.get(d);
            if (n != null) {
                return n;
            }
        }
        catch (ParseException parseException) {
            ReportingUtils.logMessage("Caught ParseException");
        }
        int n = (this.low_ + this.high_) / 2;
        int n2 = this.low_;
        int n3 = n;
        for (int i = 0; n3 > 1 && i < 10; ++i) {
            n3 = Math.abs(n - n2);
            n2 = n;
            if (d > this.gammas_.get(n)) {
                n += n3 / 2;
                continue;
            }
            n -= n3 / 2;
        }
        return n;
    }

    private double calculateGamma(int n) {
        double d = (double)n / 10.0;
        return this.calculateGamma10(d);
    }

    private double calculateGamma10(double d) {
        return 0.1 + 0.02714285 * d + 0.014857150000000001 * d * d + 0.003142855 * d * d * d;
    }

    private int calculateSlider(double d) {
        double d2 = 5.0;
        for (int i = 0; Math.abs(this.calculateGamma10(d2) - d) > 0.002 && i < 5; ++i) {
            double d3 = 0.009428565 * d2 * d2 + 0.029714300000000003 * d2 + 0.02714285;
            d2 -= (this.calculateGamma10(d2) - d) / d3;
        }
        return (int)(10.0 * d2);
    }
}

