/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

import java.util.Vector;
import mmcorej.CMMCore;
import mmcorej.StrVector;
import org.micromanager.api.Autofocus;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMException;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

public class CoreAutofocus
implements Autofocus {
    private CMMCore core_;
    private String devName_;

    public void focus(double d, int n, double d2, int n2) throws MMException {
        throw new MMException("Obsolete command. Use setProperty() to specify parameters.");
    }

    public double fullFocus() throws MMException {
        if (this.core_ == null) {
            return 0.0;
        }
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            this.core_.fullFocus();
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
        try {
            return this.core_.getLastFocusScore();
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return 0.0;
        }
    }

    public String getVerboseStatus() {
        return new String("No message at this time!");
    }

    public double incrementalFocus() throws MMException {
        if (this.core_ == null) {
            return 0.0;
        }
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            this.core_.incrementalFocus();
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
        try {
            return this.core_.getLastFocusScore();
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return 0.0;
        }
    }

    public String[] getPropertyNames() {
        Vector<String> vector = new Vector<String>();
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            StrVector strVector = this.core_.getDevicePropertyNames(this.devName_);
            int n = 0;
            while ((long)n < strVector.size()) {
                if (!this.core_.isPropertyReadOnly(this.devName_, strVector.get(n)) && !this.core_.isPropertyPreInit(this.devName_, strVector.get(n))) {
                    vector.add(strVector.get(n));
                }
                ++n;
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        return (String[])vector.toArray();
    }

    public PropertyItem[] getProperties() {
        Vector<PropertyItem> vector = new Vector<PropertyItem>();
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            StrVector strVector = this.core_.getDevicePropertyNames(this.devName_);
            int n = 0;
            while ((long)n < strVector.size()) {
                PropertyItem propertyItem = new PropertyItem();
                propertyItem.device = this.devName_;
                propertyItem.name = strVector.get(n);
                propertyItem.value = this.core_.getProperty(this.devName_, propertyItem.name);
                propertyItem.readOnly = this.core_.isPropertyReadOnly(this.devName_, propertyItem.name);
                if (this.core_.hasPropertyLimits(this.devName_, propertyItem.name)) {
                    propertyItem.lowerLimit = this.core_.getPropertyLowerLimit(this.devName_, propertyItem.name);
                    propertyItem.upperLimit = this.core_.getPropertyUpperLimit(this.devName_, propertyItem.name);
                }
                StrVector strVector2 = this.core_.getAllowedPropertyValues(this.devName_, propertyItem.name);
                propertyItem.allowed = new String[(int)strVector2.size()];
                int n2 = 0;
                while ((long)n2 < strVector2.size()) {
                    propertyItem.allowed[n2] = strVector2.get(n2);
                    ++n2;
                }
                vector.add(propertyItem);
                ++n;
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        return vector.toArray(new PropertyItem[0]);
    }

    public String getPropertyValue(String string) throws MMException {
        try {
            return this.core_.getProperty(this.devName_, string);
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }

    public PropertyItem getProperty(String string) throws MMException {
        try {
            if (this.core_.hasProperty(this.devName_, string)) {
                PropertyItem propertyItem = new PropertyItem();
                propertyItem.device = this.devName_;
                propertyItem.name = string;
                propertyItem.value = this.core_.getProperty(this.devName_, propertyItem.name);
                propertyItem.readOnly = this.core_.isPropertyReadOnly(this.devName_, propertyItem.name);
                if (this.core_.hasPropertyLimits(this.devName_, propertyItem.name)) {
                    propertyItem.lowerLimit = this.core_.getPropertyLowerLimit(this.devName_, propertyItem.name);
                    propertyItem.upperLimit = this.core_.getPropertyUpperLimit(this.devName_, propertyItem.name);
                }
                StrVector strVector = this.core_.getAllowedPropertyValues(this.devName_, propertyItem.name);
                propertyItem.allowed = new String[(int)strVector.size()];
                int n = 0;
                while ((long)n < strVector.size()) {
                    propertyItem.allowed[n] = strVector.get(n);
                    ++n;
                }
                return propertyItem;
            }
            throw new MMException("Unknown property: " + string);
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }

    public void setPropertyValue(String string, String string2) throws MMException {
        try {
            this.core_.setProperty(this.devName_, string, string2);
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }

    public double getCurrentFocusScore() {
        try {
            this.core_.setAutoFocusDevice(this.devName_);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return 0.0;
        }
        return this.core_.getCurrentFocusScore();
    }

    public void applySettings() {
    }

    public void saveSettings() {
    }

    public int getNumberOfImages() {
        return this.core_.getRemainingImageCount();
    }

    public String getDeviceName() {
        return this.devName_;
    }

    public void setProperty(PropertyItem propertyItem) throws MMException {
        try {
            this.core_.setProperty(this.devName_, propertyItem.name, propertyItem.value);
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }

    public void enableContinuousFocus(boolean bl) throws MMException {
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            this.core_.enableContinuousFocus(bl);
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }

    public boolean isContinuousFocusEnabled() throws MMException {
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            return this.core_.isContinuousFocusEnabled();
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }

    public boolean isContinuousFocusLocked() throws MMException {
        try {
            this.core_.setAutoFocusDevice(this.devName_);
            return this.core_.isContinuousFocusLocked();
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }

    public void setApp(ScriptInterface scriptInterface) {
        this.core_ = scriptInterface.getMMCore();
        this.devName_ = this.core_.getAutoFocusDevice();
    }
}

