/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.utils;

public class AcqOrderMode {
    public static final int TIME_POS_CHANNEL_SLICE = 0;
    public static final int TIME_POS_SLICE_CHANNEL = 1;
    public static final int POS_TIME_CHANNEL_SLICE = 2;
    public static final int POS_TIME_SLICE_CHANNEL = 3;
    private int id_;
    private boolean timeEnabled_;
    private boolean posEnabled_;
    private boolean sliceEnabled_;
    private boolean channelEnabled_;

    public AcqOrderMode(int n) {
        this.id_ = n;
        this.timeEnabled_ = true;
        this.posEnabled_ = true;
        this.sliceEnabled_ = true;
        this.channelEnabled_ = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.timeEnabled_ && this.posEnabled_) {
            if (this.id_ == 0 || this.id_ == 1) {
                stringBuffer.append("Time, Position");
            } else {
                stringBuffer.append("Position, Time");
            }
        } else if (this.timeEnabled_) {
            stringBuffer.append("Time");
        } else if (this.posEnabled_) {
            stringBuffer.append("Position");
        }
        if ((this.timeEnabled_ || this.posEnabled_) && (this.channelEnabled_ || this.sliceEnabled_)) {
            stringBuffer.append(", ");
        }
        if (this.channelEnabled_ && this.sliceEnabled_) {
            if (this.id_ == 0 || this.id_ == 2) {
                stringBuffer.append("Channel, Slice");
            } else {
                stringBuffer.append("Slice, Channel");
            }
        } else if (this.channelEnabled_) {
            stringBuffer.append("Channel");
        } else if (this.sliceEnabled_) {
            stringBuffer.append("Slice");
        }
        return stringBuffer.toString();
    }

    public void setEnabled(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.timeEnabled_ = bl;
        this.posEnabled_ = bl2;
        this.sliceEnabled_ = bl3;
        this.channelEnabled_ = bl4;
    }

    public int getID() {
        return this.id_;
    }
}

