/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.navigation.MultiStagePosition;
import org.micromanager.navigation.StagePosition;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMSerializationException;

public class PositionList {
    private ArrayList<MultiStagePosition> positions_ = new ArrayList();
    private static final String ID = "Micro-Manager XY-position list";
    private static final String ID_KEY = "ID";
    private static final int VERSION = 3;
    private static final String VERSION_KEY = "VERSION";
    private static final String LABEL_KEY = "LABEL";
    private static final String DEVICE_KEY = "DEVICE";
    private static final String X_KEY = "X";
    private static final String Y_KEY = "Y";
    private static final String Z_KEY = "Z";
    private static final String NUMAXES_KEY = "AXES";
    private static final String POSARRAY_KEY = "POSITIONS";
    private static final String DEVARRAY_KEY = "DEVICES";
    private static final String GRID_ROW_KEY = "GRID_ROW";
    private static final String GRID_COL_KEY = "GRID_COL";
    private static final String PROPERTIES_KEY = "PROPERTIES";
    private static final String DEFAULT_XY_STAGE = "DEFAULT_XY_STAGE";
    private static final String DEFAULT_Z_STAGE = "DEFAULT_Z_STAGE";
    public static final String AF_KEY = "AUTOFOCUS";
    public static final String AF_VALUE_FULL = "full";
    public static final String AF_VALUE_INCREMENTAL = "incremental";
    public static final String AF_VALUE_NONE = "none";

    public static PositionList newInstance(PositionList positionList) {
        PositionList positionList2 = new PositionList();
        Iterator<MultiStagePosition> iterator = positionList.positions_.iterator();
        while (iterator.hasNext()) {
            positionList2.addPosition(MultiStagePosition.newInstance(iterator.next()));
        }
        return positionList2;
    }

    public MultiStagePosition getPosition(int n) {
        if (n < 0 || n >= this.positions_.size()) {
            return null;
        }
        return this.positions_.get(n);
    }

    public MultiStagePosition getPositionCopy(int n) {
        if (n < 0 || n >= this.positions_.size()) {
            return null;
        }
        return MultiStagePosition.newInstance(this.positions_.get(n));
    }

    public int getPositionIndex(String string) {
        for (int i = 0; i < this.positions_.size(); ++i) {
            if (this.positions_.get(i).getLabel().compareTo(string) != 0) continue;
            return i;
        }
        return -1;
    }

    public void addPosition(MultiStagePosition multiStagePosition) {
        this.positions_.add(multiStagePosition);
    }

    public void addPosition(int n, MultiStagePosition multiStagePosition) {
        this.positions_.add(n, multiStagePosition);
    }

    public void replacePosition(int n, MultiStagePosition multiStagePosition) {
        if (n >= 0 && n < this.positions_.size()) {
            this.positions_.set(n, multiStagePosition);
        }
    }

    public int getNumberOfPositions() {
        return this.positions_.size();
    }

    public void clearAllPositions() {
        this.positions_.clear();
    }

    public void removePosition(int n) {
        if (n >= 0 && n < this.positions_.size()) {
            this.positions_.remove(n);
        }
    }

    public void setPositions(MultiStagePosition[] multiStagePositionArray) {
        this.positions_.clear();
        for (int i = 0; i < multiStagePositionArray.length; ++i) {
            this.positions_.add(multiStagePositionArray[i]);
        }
    }

    public MultiStagePosition[] getPositions() {
        MultiStagePosition[] multiStagePositionArray = new MultiStagePosition[this.positions_.size()];
        for (int i = 0; i < this.positions_.size(); ++i) {
            multiStagePositionArray[i] = this.positions_.get(i);
        }
        return multiStagePositionArray;
    }

    public void setLabel(int n, String string) {
        if (n < 0 || n >= this.positions_.size()) {
            return;
        }
        this.positions_.get(n).setLabel(string);
    }

    public String serialize() throws MMSerializationException {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(ID_KEY, ID);
            jSONObject.put(VERSION_KEY, 3);
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < this.positions_.size(); ++i) {
                String[] stringArray;
                MultiStagePosition multiStagePosition = this.positions_.get(i);
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put(LABEL_KEY, this.positions_.get(i).getLabel());
                jSONObject2.put(GRID_ROW_KEY, multiStagePosition.getGridRow());
                jSONObject2.put(GRID_COL_KEY, multiStagePosition.getGridColumn());
                jSONObject2.put(DEFAULT_XY_STAGE, multiStagePosition.getDefaultXYStage());
                jSONObject2.put(DEFAULT_Z_STAGE, multiStagePosition.getDefaultZStage());
                JSONArray jSONArray2 = new JSONArray();
                for (int j = 0; j < multiStagePosition.size(); ++j) {
                    stringArray = multiStagePosition.get(j);
                    JSONObject jSONObject3 = new JSONObject();
                    jSONObject3.put(X_KEY, stringArray.x);
                    jSONObject3.put(Y_KEY, stringArray.y);
                    jSONObject3.put(Z_KEY, stringArray.z);
                    jSONObject3.put(NUMAXES_KEY, stringArray.numAxes);
                    jSONObject3.put(DEVICE_KEY, stringArray.stageName);
                    jSONArray2.put(j, jSONObject3);
                }
                jSONObject2.put(DEVARRAY_KEY, jSONArray2);
                JSONObject jSONObject4 = new JSONObject();
                stringArray = multiStagePosition.getPropertyNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = multiStagePosition.getProperty(stringArray[j]);
                    jSONObject4.put(stringArray[j], string);
                }
                jSONObject2.put(PROPERTIES_KEY, jSONObject4);
                jSONArray.put(i, jSONObject2);
            }
            jSONObject.put(POSARRAY_KEY, jSONArray);
            return jSONObject.toString(3);
        }
        catch (JSONException jSONException) {
            throw new MMSerializationException("Unable to serialize XY positition data into formatted string.");
        }
    }

    public void restore(String string) throws MMSerializationException {
        try {
            JSONObject jSONObject = new JSONObject(string);
            JSONArray jSONArray = jSONObject.getJSONArray(POSARRAY_KEY);
            int n = jSONObject.getInt(VERSION_KEY);
            this.positions_.clear();
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object;
                Object object2;
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                MultiStagePosition multiStagePosition = new MultiStagePosition();
                multiStagePosition.setLabel(jSONObject2.getString(LABEL_KEY));
                if (n >= 2) {
                    multiStagePosition.setGridCoordinates(jSONObject2.getInt(GRID_ROW_KEY), jSONObject2.getInt(GRID_COL_KEY));
                }
                if (n >= 3) {
                    multiStagePosition.setDefaultXYStage(jSONObject2.getString(DEFAULT_XY_STAGE));
                    multiStagePosition.setDefaultZStage(jSONObject2.getString(DEFAULT_Z_STAGE));
                }
                JSONArray jSONArray2 = jSONObject2.getJSONArray(DEVARRAY_KEY);
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    object2 = jSONArray2.getJSONObject(j);
                    object = new StagePosition();
                    ((StagePosition)object).x = ((JSONObject)object2).getDouble(X_KEY);
                    ((StagePosition)object).y = ((JSONObject)object2).getDouble(Y_KEY);
                    ((StagePosition)object).z = ((JSONObject)object2).getDouble(Z_KEY);
                    ((StagePosition)object).stageName = ((JSONObject)object2).getString(DEVICE_KEY);
                    ((StagePosition)object).numAxes = ((JSONObject)object2).getInt(NUMAXES_KEY);
                    multiStagePosition.add((StagePosition)object);
                }
                JSONObject jSONObject3 = jSONObject2.getJSONObject(PROPERTIES_KEY);
                object2 = jSONObject3.keys();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    multiStagePosition.setProperty((String)object, jSONObject3.getString((String)object));
                }
                this.positions_.add(multiStagePosition);
            }
        }
        catch (JSONException jSONException) {
            throw new MMSerializationException("Invalid or corrupted serialization data.");
        }
    }

    public String generateLabel() {
        String string = new String("Pos" + this.positions_.size());
        int n = 1;
        while (!this.isLabelUnique(string)) {
            string = new String("Pos" + (this.positions_.size() + n++));
        }
        return string;
    }

    public boolean isLabelUnique(String string) {
        for (int i = 0; i < this.positions_.size(); ++i) {
            if (this.positions_.get(i).getLabel().compareTo(string) != 0) continue;
            return false;
        }
        return true;
    }

    public void save(String string) throws MMException {
        File file = new File(string);
        try {
            String string2 = this.serialize();
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }

    public void load(String string) throws MMException {
        File file = new File(string);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(System.getProperty("line.separator"));
            }
            this.restore(stringBuffer.toString());
        }
        catch (Exception exception) {
            throw new MMException(exception.getMessage());
        }
    }
}

