/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import mmcorej.CMMCore;
import org.micromanager.navigation.StagePosition;

public class MultiStagePosition {
    private ArrayList<StagePosition> stagePosList_ = new ArrayList();
    private String label_ = new String("Undefined");
    private String defaultZStage_ = new String("");
    private String defaultXYStage_ = new String("");
    private int gridRow_ = 0;
    private int gridCol_ = 0;
    private Hashtable<String, String> properties_ = new Hashtable();

    public MultiStagePosition() {
    }

    public MultiStagePosition(String string, double d, double d2, String string2, double d3) {
        this();
        StagePosition stagePosition = new StagePosition();
        stagePosition.numAxes = 2;
        stagePosition.stageName = string;
        stagePosition.x = d;
        stagePosition.y = d2;
        this.defaultXYStage_ = string;
        this.add(stagePosition);
        StagePosition stagePosition2 = new StagePosition();
        stagePosition2.numAxes = 1;
        stagePosition2.stageName = string2;
        stagePosition2.x = d3;
        this.defaultZStage_ = string2;
        this.add(stagePosition2);
    }

    public static MultiStagePosition newInstance(MultiStagePosition multiStagePosition) {
        MultiStagePosition multiStagePosition2 = new MultiStagePosition();
        multiStagePosition2.label_ = new String(multiStagePosition.label_);
        multiStagePosition2.defaultXYStage_ = new String(multiStagePosition.defaultXYStage_);
        multiStagePosition2.defaultZStage_ = new String(multiStagePosition.defaultZStage_);
        Object object = multiStagePosition.properties_.keys();
        while (object.hasMoreElements()) {
            String string = object.nextElement();
            String string2 = new String(multiStagePosition.properties_.get(string));
            multiStagePosition2.properties_.put(string, string2);
        }
        object = multiStagePosition.stagePosList_.iterator();
        while (object.hasNext()) {
            multiStagePosition2.add(StagePosition.newInstance((StagePosition)object.next()));
        }
        return multiStagePosition2;
    }

    public void add(StagePosition stagePosition) {
        this.stagePosList_.add(stagePosition);
    }

    public int size() {
        return this.stagePosList_.size();
    }

    public StagePosition get(int n) {
        return this.stagePosList_.get(n);
    }

    public void setProperty(String string, String string2) {
        this.properties_.put(string, string2);
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[this.properties_.size()];
        int n = 0;
        Enumeration<String> enumeration = this.properties_.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = enumeration.nextElement();
        }
        return stringArray;
    }

    public boolean hasProperty(String string) {
        return this.properties_.containsKey(string);
    }

    public String getProperty(String string) {
        if (this.properties_.containsKey(string)) {
            return this.properties_.get(string);
        }
        return null;
    }

    public StagePosition get(String string) {
        for (int i = 0; i < this.stagePosList_.size(); ++i) {
            StagePosition stagePosition = this.stagePosList_.get(i);
            if (stagePosition.stageName.compareTo(string) != 0) continue;
            return stagePosition;
        }
        return null;
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String string) {
        this.label_ = string;
    }

    public void setDefaultZStage(String string) {
        this.defaultZStage_ = string;
    }

    public String getDefaultZStage() {
        return this.defaultZStage_;
    }

    public String getDefaultXYStage() {
        return this.defaultXYStage_;
    }

    public void setDefaultXYStage(String string) {
        this.defaultXYStage_ = string;
    }

    public static void goToPosition(MultiStagePosition multiStagePosition, CMMCore cMMCore) throws Exception {
        for (int i = 0; i < multiStagePosition.size(); ++i) {
            try {
                StagePosition stagePosition = multiStagePosition.get(i);
                if (stagePosition.numAxes == 1) {
                    cMMCore.setPosition(stagePosition.stageName, stagePosition.x);
                } else if (stagePosition.numAxes == 2) {
                    cMMCore.setXYPosition(stagePosition.stageName, stagePosition.x, stagePosition.y);
                }
                cMMCore.waitForDevice(stagePosition.stageName);
                continue;
            }
            catch (Exception exception) {
                throw new Exception("XY stage error");
            }
        }
    }

    public double getX() {
        for (int i = 0; i < this.stagePosList_.size(); ++i) {
            StagePosition stagePosition = this.stagePosList_.get(i);
            if (stagePosition.numAxes != 2 || stagePosition.stageName.compareTo(this.defaultXYStage_) != 0) continue;
            return stagePosition.x;
        }
        return 0.0;
    }

    public double getY() {
        for (int i = 0; i < this.stagePosList_.size(); ++i) {
            StagePosition stagePosition = this.stagePosList_.get(i);
            if (stagePosition.numAxes != 2 || stagePosition.stageName.compareTo(this.defaultXYStage_) != 0) continue;
            return stagePosition.y;
        }
        return 0.0;
    }

    public double getZ() {
        for (int i = 0; i < this.stagePosList_.size(); ++i) {
            StagePosition stagePosition = this.stagePosList_.get(i);
            if (stagePosition.numAxes != 1 || stagePosition.stageName.compareTo(this.defaultZStage_) != 0) continue;
            return stagePosition.x;
        }
        return 0.0;
    }

    public void setGridCoordinates(int n, int n2) {
        this.gridRow_ = n;
        this.gridCol_ = n2;
    }

    public int getGridRow() {
        return this.gridRow_;
    }

    public int getGridColumn() {
        return this.gridCol_;
    }
}

