/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.navigation;

import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Toolbar;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.utils.ReportingUtils;

public class CenterAndDragListener
implements MouseListener,
MouseMotionListener {
    private CMMCore core_;
    private MMStudioMainFrame gui_;
    private ImageCanvas canvas_;
    private static boolean isRunning_ = false;
    private boolean mirrorX_;
    private boolean mirrorY_;
    private boolean transposeXY_;
    private boolean correction_;
    private int lastX_;
    private int lastY_;

    public CenterAndDragListener(CMMCore cMMCore, MMStudioMainFrame mMStudioMainFrame) {
        this.core_ = cMMCore;
        this.gui_ = mMStudioMainFrame;
    }

    public void start() {
        if (isRunning_) {
            return;
        }
        isRunning_ = true;
        this.attach(this.gui_.getImageWin());
    }

    public void stop() {
        if (this.canvas_ != null) {
            this.canvas_.removeMouseListener((MouseListener)this);
            this.canvas_.removeMouseMotionListener((MouseMotionListener)this);
        }
        isRunning_ = false;
    }

    public boolean isRunning() {
        return isRunning_;
    }

    public void attach(ImageWindow imageWindow) {
        if (imageWindow == null) {
            return;
        }
        if (!isRunning_) {
            return;
        }
        this.canvas_ = imageWindow.getCanvas();
        this.canvas_.addMouseListener((MouseListener)this);
        this.canvas_.addMouseMotionListener((MouseMotionListener)this);
        if (Toolbar.getInstance() != null) {
            Toolbar.getInstance().setTool(12);
        }
        this.getOrientation();
    }

    public void getOrientation() {
        String string = this.core_.getCameraDevice();
        if (string == null) {
            JOptionPane.showMessageDialog(null, "This function does not work without a camera");
            return;
        }
        try {
            String string2 = this.core_.getProperty(string, "TransposeCorrection");
            this.correction_ = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_MirrorX());
            this.mirrorX_ = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_MirrorY());
            this.mirrorY_ = !string2.equals("0");
            string2 = this.core_.getProperty(string, MMCoreJ.getG_Keyword_Transpose_SwapXY());
            this.transposeXY_ = !string2.equals("0");
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        if ((mouseEvent.getModifiers() & 4) != 0 || n < 2) {
            return;
        }
        this.getOrientation();
        String string = this.core_.getXYStageDevice();
        if (string == null) {
            return;
        }
        double d = this.core_.getPixelSizeUm();
        if (!(d > 0.0)) {
            JOptionPane.showMessageDialog(null, "Please provide pixel size calibration data before using this function");
            return;
        }
        int n2 = (int)this.core_.getImageWidth();
        int n3 = (int)this.core_.getImageHeight();
        int n4 = mouseEvent.getX();
        int n5 = mouseEvent.getY();
        int n6 = this.canvas_.offScreenX(n4);
        int n7 = this.canvas_.offScreenY(n5);
        double d2 = (0.5 * (double)n2 - (double)n6) * d;
        double d3 = (0.5 * (double)n3 - (double)n7) * d;
        double d4 = d2;
        double d5 = d3;
        if (!this.correction_) {
            if (this.transposeXY_) {
                d4 = d3;
                d5 = d2;
            }
            if (this.mirrorX_) {
                d4 = -d4;
            }
            if (this.mirrorY_) {
                d5 = -d5;
            }
        }
        try {
            this.core_.setRelativeXYPosition(string, d4, d5);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
        this.gui_.updateXYStagePosition();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.lastX_ = this.canvas_.offScreenX(n);
        this.lastY_ = this.canvas_.offScreenY(n2);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            return;
        }
        if (Toolbar.getInstance() != null && Toolbar.getToolId() != 12) {
            return;
        }
        this.getOrientation();
        String string = this.core_.getXYStageDevice();
        if (string == null) {
            return;
        }
        try {
            if (this.core_.deviceBusy(string)) {
                return;
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
        double d = this.core_.getPixelSizeUm();
        if (!(d > 0.0)) {
            JOptionPane.showMessageDialog(null, "Please provide pixel size calibration data before using this function");
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.canvas_.offScreenX(n);
        int n4 = this.canvas_.offScreenY(n2);
        double d2 = n3 - this.lastX_;
        double d3 = n4 - this.lastY_;
        double d4 = d2 *= d;
        double d5 = d3 *= d;
        if (!this.correction_) {
            if (this.transposeXY_) {
                d4 = d3;
                d5 = d2;
            }
            if (this.mirrorX_) {
                d4 = -d4;
            }
            if (this.mirrorY_) {
                d5 = -d5;
            }
        }
        try {
            this.core_.setRelativeXYPosition(string, d4, d5);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
        this.lastX_ = n3;
        this.lastY_ = n4;
        this.gui_.updateXYPosRelative(d4, d5);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

