/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import ij.CompositeImage;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.ImageCache;
import org.micromanager.graph.ChannelControlPanel;
import org.micromanager.internalinterfaces.Histograms;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;

public class MultiChannelHistograms
extends JPanel
implements Histograms {
    private static final int SLOW_HIST_UPDATE_INTERVAL_MS = 1000;
    private long lastUpdateTime_;
    private ArrayList<ChannelControlPanel> ccpList_;
    private VirtualAcquisitionDisplay display_;
    private ImageCache cache_;
    private CompositeImage img_;
    private boolean updatingCombos_ = false;

    public MultiChannelHistograms(VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        this.display_ = virtualAcquisitionDisplay;
        this.img_ = (CompositeImage)virtualAcquisitionDisplay.getImagePlus();
        this.cache_ = virtualAcquisitionDisplay.getImageCache();
        this.setupChannelControls(this.cache_);
    }

    public synchronized void setupChannelControls(ImageCache imageCache) {
        boolean bl;
        this.removeAll();
        this.invalidate();
        try {
            bl = MDUtils.isRGB(imageCache.getSummaryMetadata());
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            bl = false;
        }
        int n = bl ? 3 : imageCache.getNumChannels();
        GridLayout gridLayout = new GridLayout(n, 1);
        this.setLayout(gridLayout);
        this.setMinimumSize(new Dimension(ChannelControlPanel.MINIMUM_SIZE.width, n * ChannelControlPanel.MINIMUM_SIZE.height));
        this.ccpList_ = new ArrayList();
        for (int i = 0; i < n; ++i) {
            ChannelControlPanel channelControlPanel = new ChannelControlPanel(i, this, this.display_);
            this.add(channelControlPanel);
            this.ccpList_.add(channelControlPanel);
        }
        this.validate();
    }

    public void updateChannelNamesAndColors() {
        if (this.ccpList_ == null) {
            return;
        }
        for (ChannelControlPanel channelControlPanel : this.ccpList_) {
            channelControlPanel.updateChannelNameAndColorFromCache();
        }
    }

    public void fullScaleChannels() {
        if (this.ccpList_ == null) {
            return;
        }
        for (ChannelControlPanel channelControlPanel : this.ccpList_) {
            channelControlPanel.setFullScale();
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    public void applyContrastToAllChannels(int n, int n2, double d) {
        if (this.ccpList_ == null) {
            return;
        }
        for (ChannelControlPanel channelControlPanel : this.ccpList_) {
            channelControlPanel.setContrast(n, n2, d);
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    public ContrastSettings getChannelContrastSettings(int n) {
        if (this.ccpList_ == null || this.ccpList_.size() - 1 > n) {
            return null;
        }
        return new ContrastSettings(this.ccpList_.get(n).getContrastMin(), this.ccpList_.get(n).getContrastMax(), this.ccpList_.get(n).getContrastGamma());
    }

    public void updateOtherDisplayCombos(int n) {
        if (this.updatingCombos_) {
            return;
        }
        this.updatingCombos_ = true;
        for (int i = 0; i < this.ccpList_.size(); ++i) {
            this.ccpList_.get(i).setDisplayComboIndex(n);
        }
        this.updatingCombos_ = false;
    }

    public void setChannelDisplayModeFromFirst() {
        if (this.ccpList_ == null || this.ccpList_.size() <= 1) {
            return;
        }
        int n = this.ccpList_.get(0).getDisplayComboIndex();
        this.ccpList_.get(0).setDisplayComboIndex(n);
    }

    public void setChannelContrastFromFirst() {
        if (this.ccpList_ == null || this.ccpList_.size() <= 1) {
            return;
        }
        int n = this.ccpList_.get(0).getContrastMin();
        int n2 = this.ccpList_.get(0).getContrastMax();
        double d = this.ccpList_.get(0).getContrastGamma();
        for (int i = 1; i < this.ccpList_.size(); ++i) {
            this.ccpList_.get(i).setContrast(n, n2, d);
        }
        this.applyLUTToImage();
        this.display_.drawWithoutUpdate();
    }

    public void setChannelHistogramDisplayMax(int n, int n2) {
        if (this.ccpList_ == null || this.ccpList_.size() <= n) {
            return;
        }
        int n3 = (int)(n2 == -1 ? 0.0 : Math.ceil(Math.log(n2) / Math.log(2.0)) - 3.0);
        this.ccpList_.get(n).setDisplayComboIndex(n3);
    }

    public void applyLUTToImage() {
        if (this.ccpList_ == null) {
            return;
        }
        for (ChannelControlPanel channelControlPanel : this.ccpList_) {
            channelControlPanel.applyChannelLUTToImage();
        }
    }

    public void imageChanged() {
        boolean bl = true;
        if ((this.display_.acquisitionIsRunning() || MMStudioMainFrame.getInstance().isLiveModeOn() && this.display_.isSimpleDisplay()) && this.display_.getHistogramControlsState().slowHist) {
            long l = System.currentTimeMillis();
            if (l - this.lastUpdateTime_ < 1000L) {
                bl = false;
            } else {
                this.lastUpdateTime_ = l;
            }
        }
        this.updateActiveChannels();
        if (bl) {
            for (ChannelControlPanel channelControlPanel : this.ccpList_) {
                channelControlPanel.calcAndDisplayHistAndStats(this.display_.isActiveDisplay());
                if (this.display_.getHistogramControlsState().autostretch) {
                    channelControlPanel.autostretch();
                }
                channelControlPanel.applyChannelLUTToImage();
            }
        }
    }

    private void updateActiveChannels() {
        int n = this.img_.getChannel() - 1;
        boolean[] blArray = this.img_.getActiveChannels();
        if (this.img_.getMode() != 1) {
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = n == i;
            }
        }
    }

    public void setChannelContrast(int n, int n2, int n3, double d) {
        if (n >= this.ccpList_.size()) {
            return;
        }
        this.ccpList_.get(n).setContrast(n2, n3, d);
    }

    public void autoscaleAllChannels() {
        if (this.ccpList_ != null && this.ccpList_.size() > 0) {
            for (ChannelControlPanel channelControlPanel : this.ccpList_) {
                channelControlPanel.autoButtonAction();
            }
        }
    }

    public void rejectOutliersChangeAction() {
        if (this.ccpList_ != null && this.ccpList_.size() > 0) {
            for (ChannelControlPanel channelControlPanel : this.ccpList_) {
                channelControlPanel.calcAndDisplayHistAndStats(true);
                channelControlPanel.autoButtonAction();
            }
        }
    }

    public void calcAndDisplayHistAndStats(boolean bl) {
        if (this.ccpList_ != null) {
            for (ChannelControlPanel channelControlPanel : this.ccpList_) {
                channelControlPanel.calcAndDisplayHistAndStats(bl);
            }
        }
    }

    public void autostretch() {
        if (this.ccpList_ != null) {
            for (ChannelControlPanel channelControlPanel : this.ccpList_) {
                channelControlPanel.autostretch();
            }
        }
    }
}

