/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.GraphPanel;

public class HistogramPanel
extends GraphPanel {
    private static final long serialVersionUID = -1789623844214721902L;
    private int xMin_ = 0;
    private int xMax_ = 255;
    private int currentHandle;
    private ArrayList<CursorListener> cursorListeners_ = new ArrayList();
    private Point2D.Float ptDevBottom_;
    private Point2D.Float ptDevTop_;
    private Point2D.Float ptDevTopUnclippedX_;

    public HistogramPanel() {
        this.setupMouseListeners();
    }

    private GeneralPath generateGammaCurvePath(Point2D.Float float_, Point2D.Float float_2, double d) {
        int n = (int)(float_.x - float_2.x) + 1;
        int n2 = (int)(float_2.y - float_.y);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(float_2.x, float_2.y);
        for (int i = 0; i < n; i += 3) {
            double d2 = (double)i / (double)n;
            double d3 = Math.pow(d2, d);
            int n3 = i + (int)float_2.x;
            int n4 = (int)((1.0 - d3) * (double)n2 + (double)float_.y);
            generalPath.lineTo(n3, n4);
        }
        generalPath.lineTo(float_.x, float_.y);
        return generalPath;
    }

    private void updateBounds() {
    }

    public void setAutoScale() {
        this.setAutoBounds();
        this.updateBounds();
    }

    public void setDataSource(GraphData graphData) {
        this.setData(graphData);
        this.refresh();
    }

    public void drawCursor(Graphics2D graphics2D, Rectangle rectangle, float f) {
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 0.0) {
            return;
        }
        f2 = (float)((double)rectangle.width / this.bounds_.getRangeX());
        f3 = (float)((double)rectangle.height / this.bounds_.getRangeY());
        Point2D.Float float_ = new Point2D.Float(f, (float)this.bounds_.yMax);
        Point2D.Float float_2 = this.getDevicePoint(float_, rectangle, f2, f3);
        Point2D.Float float_3 = new Point2D.Float(f, (float)this.bounds_.yMin);
        Point2D.Float float_4 = this.getDevicePoint(float_3, rectangle, f2, f3);
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(new Color(120, 120, 120));
        float[] fArray = new float[]{3.0f};
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, fArray, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(new Line2D.Float(float_2, float_4));
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    public void drawMapping(Graphics2D graphics2D, Rectangle rectangle, float f, float f2, double d) {
        float f3 = 1.0f;
        float f4 = 1.0f;
        if (this.bounds_.getRangeY() == 0.0) {
            if (this.bounds_.yMax > 0.0) {
                this.bounds_.yMin = 0.0;
            } else if (this.bounds_.yMax < 0.0) {
                this.bounds_.yMax = 0.0;
            }
        }
        if (this.bounds_.getRangeX() <= 0.0 || this.bounds_.getRangeY() <= 1.0E-10) {
            return;
        }
        f3 = (float)((double)rectangle.width / this.bounds_.getRangeX());
        f4 = (float)((double)rectangle.height / this.bounds_.getRangeY());
        Point2D.Float float_ = new Point2D.Float(f, (float)this.bounds_.yMin);
        this.ptDevBottom_ = this.getDevicePoint(float_, rectangle, f3, f4);
        Point2D.Float float_2 = new Point2D.Float(f2, (float)this.bounds_.yMax);
        this.ptDevTop_ = this.getDevicePoint(float_2, rectangle, f3, f4);
        this.ptDevTopUnclippedX_ = this.getDevicePointUnclippedXMax(float_2, rectangle, f3, f4);
        GeneralPath generalPath = this.generateGammaCurvePath(this.ptDevTopUnclippedX_, this.ptDevBottom_, d);
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(new Color(120, 120, 120));
        BasicStroke basicStroke = new BasicStroke(2.0f, 0, 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(generalPath);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
        HistogramPanel.drawLUTHandles(graphics2D, (int)this.ptDevBottom_.x, (int)this.ptDevBottom_.y, (int)this.ptDevTop_.x, (int)this.ptDevTop_.y);
    }

    static void drawLUTHandles(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        HistogramPanel.drawTriangle(graphics2D, n, n2, false, Color.black);
        HistogramPanel.drawTriangle(graphics2D, n3, n4, true, Color.white);
    }

    static void drawTriangle(Graphics2D graphics2D, int n, int n2, boolean bl, Color color) {
        int n3 = 7;
        if (bl) {
            n3 = -n3;
        }
        int[] nArray = new int[]{n, n - n3, n + n3};
        int[] nArray2 = new int[]{n2, n2 + n3, n2 + n3};
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(color);
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.setColor(Color.black);
        graphics2D.drawPolygon(nArray, nArray2, 3);
        graphics2D.setStroke(stroke);
    }

    public void refresh() {
        GraphData.Bounds bounds = this.getGraphBounds();
        bounds.xMin = this.xMin_;
        bounds.xMax = this.xMax_;
        this.setBounds(bounds);
        this.repaint();
    }

    public void addCursorListener(CursorListener cursorListener) {
        this.cursorListeners_.add(cursorListener);
    }

    public void removeCursorListeners(CursorListener cursorListener) {
        this.cursorListeners_.remove(cursorListener);
    }

    public CursorListener[] getCursorListeners() {
        return (CursorListener[])this.cursorListeners_.toArray();
    }

    private void notifyCursorLeft(double d) {
        for (CursorListener cursorListener : this.cursorListeners_) {
            cursorListener.onLeftCursor(d);
        }
    }

    private void notifyCursorRight(double d) {
        for (CursorListener cursorListener : this.cursorListeners_) {
            cursorListener.onRightCursor(d);
        }
    }

    private void notifyGammaMouse(double d) {
        for (CursorListener cursorListener : this.cursorListeners_) {
            cursorListener.onGammaCurve(d);
        }
    }

    private void setupMouseListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                HistogramPanel.this.currentHandle = HistogramPanel.this.getClickBand(mouseEvent.getX(), mouseEvent.getY());
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (HistogramPanel.this.currentHandle != 0) {
                    double d;
                    Point2D.Float float_ = HistogramPanel.this.getPositionPoint(n, n2);
                    if (HistogramPanel.this.currentHandle == 1) {
                        HistogramPanel.this.notifyCursorLeft(float_.x);
                    }
                    if (HistogramPanel.this.currentHandle == 2) {
                        HistogramPanel.this.notifyCursorRight(float_.x);
                    }
                    if (HistogramPanel.this.currentHandle == 3 && Math.abs((HistogramPanel.this.gamma_ - (d = HistogramPanel.this.getGammaFromMousePosition(n, n2))) / HistogramPanel.this.gamma_) < 0.2) {
                        HistogramPanel.this.notifyGammaMouse(HistogramPanel.this.getGammaFromMousePosition(n, n2));
                        HistogramPanel.this.currentHandle = 4;
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                HistogramPanel.this.currentHandle = 0;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (HistogramPanel.this.currentHandle == 0) {
                    return;
                }
                Point2D.Float float_ = HistogramPanel.this.getPositionPoint(mouseEvent.getX(), mouseEvent.getY());
                if (HistogramPanel.this.currentHandle == 1) {
                    HistogramPanel.this.notifyCursorLeft(float_.x);
                }
                if (HistogramPanel.this.currentHandle == 2) {
                    HistogramPanel.this.notifyCursorRight(float_.x);
                }
                if (HistogramPanel.this.currentHandle == 4) {
                    HistogramPanel.this.notifyGammaMouse(HistogramPanel.this.getGammaFromMousePosition(mouseEvent.getX(), mouseEvent.getY()));
                }
            }
        });
    }

    private double getGammaFromMousePosition(int n, int n2) {
        if (this.ptDevTopUnclippedX_ == null || this.ptDevBottom_ == null) {
            return 0.0;
        }
        double d = this.ptDevTopUnclippedX_.x - this.ptDevBottom_.x;
        double d2 = this.ptDevBottom_.y - this.ptDevTopUnclippedX_.y;
        double d3 = (double)((float)n - this.ptDevBottom_.x) / d;
        double d4 = (double)(this.ptDevBottom_.y - (float)n2) / d2;
        double d5 = d3 > 0.05 && d3 < 0.95 && d4 > 0.05 && d4 < 0.95 ? Math.log(d4) / Math.log(d3) : 0.0;
        return d5;
    }

    static int clipVal(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n, n3));
    }

    int getClickBand(int n, int n2) {
        Rectangle rectangle = this.getBox();
        int n3 = rectangle.y + rectangle.height;
        int n4 = rectangle.y;
        float f = (float)((double)rectangle.width / this.bounds_.getRangeX());
        float f2 = this.getDevicePoint((Point2D.Float)new Point2D.Float((float)this.cursorLoPos_, (float)0.0f), (Rectangle)rectangle, (float)f, (float)1.0f).x;
        float f3 = this.getDevicePoint((Point2D.Float)new Point2D.Float((float)this.cursorHiPos_, (float)0.0f), (Rectangle)rectangle, (float)f, (float)1.0f).x;
        if (n2 < n3 + 10 && n2 >= n3) {
            return 1;
        }
        if (n2 <= n4 && n2 > n4 - 10) {
            return 2;
        }
        if ((float)n > f2 - 5.0f && (float)n < f2 + 5.0f) {
            return 1;
        }
        if ((float)n > f3 - 5.0f && (float)n < f3 + 5.0f) {
            return 2;
        }
        if (n2 > n4 && n2 < n3) {
            return 3;
        }
        return 0;
    }

    protected void drawGraph(Graphics2D graphics2D, Rectangle rectangle) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.black);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.setColor(color);
        super.drawGraph(graphics2D, rectangle);
    }

    public static interface CursorListener {
        public void onLeftCursor(double var1);

        public void onRightCursor(double var1);

        public void onGammaCurve(double var1);
    }
}

