/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.GraphPanel;
import org.micromanager.utils.MMFrame;
import org.micromanager.utils.ReportingUtils;

public class GraphFrame
extends MMFrame {
    private static final long serialVersionUID = -4969643705861534777L;
    private JTextField fldYMax;
    private JTextField fldYMin;
    private JTextField fldXMax;
    private JTextField fldXMin;
    private SpringLayout springLayout;
    private GraphPanel panel_;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            GraphFrame graphFrame = new GraphFrame();
            graphFrame.setVisible(true);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    private void updateBounds() {
        GraphData.Bounds bounds = this.panel_.getGraphBounds();
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        this.fldXMin.setText(decimalFormat.format(bounds.xMin));
        this.fldXMax.setText(decimalFormat.format(bounds.xMax));
        this.fldYMin.setText(decimalFormat.format(bounds.yMin));
        this.fldYMax.setText(decimalFormat.format(bounds.yMax));
    }

    public void setAutoScale() {
        this.panel_.setAutoBounds();
        this.updateBounds();
        this.refresh();
    }

    public void setData(GraphData graphData) {
        this.panel_.setData(graphData);
        this.refresh();
    }

    public void refresh() {
        GraphData.Bounds bounds = this.panel_.getGraphBounds();
        if (this.fldXMin.getText().length() > 0 && this.fldYMin.getText().length() > 0 && this.fldXMax.getText().length() > 0 && this.fldYMax.getText().length() > 0) {
            bounds.xMin = Double.parseDouble(this.fldXMin.getText());
            bounds.xMax = Double.parseDouble(this.fldXMax.getText());
            bounds.yMin = Double.parseDouble(this.fldYMin.getText());
            bounds.yMax = Double.parseDouble(this.fldYMax.getText());
        }
        this.panel_.setBounds(bounds);
        this.panel_.repaint();
    }

    public void SetXLimits(double d, double d2) {
        GraphData.Bounds bounds = this.panel_.getGraphBounds();
        if (this.fldXMin.getText().length() > 0 && this.fldYMin.getText().length() > 0 && this.fldXMax.getText().length() > 0 && this.fldYMax.getText().length() > 0) {
            bounds.xMin = d;
            bounds.xMax = d2;
            bounds.yMin = Double.parseDouble(this.fldYMin.getText());
            bounds.yMax = Double.parseDouble(this.fldYMax.getText());
        }
        this.panel_.setBounds(bounds);
        this.panel_.repaint();
    }

    public GraphFrame() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.setPrefsNode(preferences.node(preferences.absolutePath() + "/GraphFrame"));
        this.setFont(new Font("Arial", 0, 10));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphFrame.this.savePosition();
            }
        });
        this.setTitle("Graph");
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.loadPosition(100, 100, 542, 298);
        this.setDefaultCloseOperation(2);
        this.panel_ = new GraphPanel();
        this.panel_.setBorder(new LineBorder(Color.black, 1, false));
        this.getContentPane().add(this.panel_);
        this.springLayout.putConstraint("South", (Component)this.panel_, -9, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.panel_, -9, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.panel_, 10, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.panel_, 120, "West", (Component)this.getContentPane());
        JLabel jLabel = new JLabel();
        jLabel.setFont(new Font("Arial", 0, 10));
        jLabel.setText("X Min");
        this.getContentPane().add(jLabel);
        this.springLayout.putConstraint("East", (Component)jLabel, 44, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel, 9, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jLabel, 15, "North", (Component)this.getContentPane());
        this.fldXMin = new JTextField();
        this.getContentPane().add(this.fldXMin);
        this.springLayout.putConstraint("South", (Component)this.fldXMin, 32, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.fldXMin, -5, "West", (Component)this.panel_);
        this.springLayout.putConstraint("North", (Component)this.fldXMin, 15, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)this.fldXMin, 50, "West", (Component)this.getContentPane());
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("Arial", 0, 10));
        jLabel2.setText("X Max");
        this.getContentPane().add(jLabel2);
        this.springLayout.putConstraint("South", (Component)jLabel2, 50, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jLabel2, 36, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jLabel2, 49, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel2, 9, "West", (Component)this.getContentPane());
        this.fldXMax = new JTextField();
        this.getContentPane().add(this.fldXMax);
        this.springLayout.putConstraint("South", (Component)this.fldXMax, 53, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.fldXMax, 36, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.fldXMax, 0, "East", (Component)this.fldXMin);
        this.springLayout.putConstraint("West", (Component)this.fldXMax, 50, "West", (Component)this.getContentPane());
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font("Arial", 0, 10));
        jLabel3.setText("Y Min");
        this.getContentPane().add(jLabel3);
        this.springLayout.putConstraint("South", (Component)jLabel3, 79, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jLabel3, 65, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jLabel3, 49, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel3, 9, "West", (Component)this.getContentPane());
        this.fldYMin = new JTextField();
        this.getContentPane().add(this.fldYMin);
        this.springLayout.putConstraint("South", (Component)this.fldYMin, 82, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.fldYMin, 65, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.fldYMin, 0, "East", (Component)this.fldXMax);
        this.springLayout.putConstraint("West", (Component)this.fldYMin, 50, "West", (Component)this.getContentPane());
        this.fldYMax = new JTextField();
        this.getContentPane().add(this.fldYMax);
        this.springLayout.putConstraint("South", (Component)this.fldYMax, 103, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)this.fldYMax, 86, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)this.fldYMax, 0, "East", (Component)this.fldYMin);
        this.springLayout.putConstraint("West", (Component)this.fldYMax, 50, "West", (Component)this.getContentPane());
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(new Font("Arial", 0, 10));
        jLabel4.setText("Y Max");
        this.getContentPane().add(jLabel4);
        this.springLayout.putConstraint("South", (Component)jLabel4, 100, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jLabel4, 86, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jLabel4, 55, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jLabel4, 9, "West", (Component)this.getContentPane());
        JButton jButton = new JButton();
        jButton.setFont(new Font("Arial", 0, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GraphFrame.this.setAutoScale();
            }
        });
        jButton.setText("Autoscale");
        this.getContentPane().add(jButton);
        this.springLayout.putConstraint("East", (Component)jButton, 116, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jButton, 115, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton, 25, "West", (Component)this.getContentPane());
        JButton jButton2 = new JButton();
        jButton2.setFont(new Font("Arial", 0, 10));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MMStudioMainFrame.getInstance().updateLineProfile();
            }
        });
        jButton2.setText("Refresh");
        this.getContentPane().add(jButton2);
        this.springLayout.putConstraint("North", (Component)jButton2, 137, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton2, 116, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton2, 25, "West", (Component)this.getContentPane());
    }
}

