/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.graph;

import com.swtdesigner.SwingResourceManager;
import ij.CompositeImage;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import mmcorej.CMMCore;
import org.json.JSONArray;
import org.json.JSONObject;
import org.micromanager.AcqControlDlg;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.ImageCache;
import org.micromanager.graph.GraphData;
import org.micromanager.graph.HistogramPanel;
import org.micromanager.graph.MultiChannelHistograms;
import org.micromanager.utils.HistogramUtils;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class ChannelControlPanel
extends JPanel
implements HistogramPanel.CursorListener {
    private static final Dimension CONTROLS_SIZE = new Dimension(130, 115);
    public static final Dimension MINIMUM_SIZE = new Dimension(400, ChannelControlPanel.CONTROLS_SIZE.height);
    private static final int NUM_BINS = 256;
    private final int channelIndex_;
    private HistogramPanel hp_;
    private MultiChannelHistograms mcHistograms_;
    private VirtualAcquisitionDisplay display_;
    private ImageCache cache_;
    private CompositeImage img_;
    private JButton autoButton_;
    private JButton zoomInButton_;
    private JButton zoomOutButton_;
    private JCheckBox channelNameCheckbox_;
    private JLabel colorPickerLabel_;
    private JButton fullButton_;
    private JPanel histogramPanelHolder_;
    private JLabel minMaxLabel_;
    private JComboBox histRangeComboBox_;
    private double binSize_;
    private int height_;
    private String histMaxLabel_;
    private int histMax_;
    private JPanel controls_;
    private JPanel controlsHolderPanel_;
    private int contrastMin_;
    private int contrastMax_;
    private double gamma_ = 1.0;
    private int minAfterRejectingOutliers_;
    private int maxAfterRejectingOutliers_;
    private int pixelMin_ = 0;
    private int pixelMax_ = 255;
    private final int maxIntensity_;
    private final int bitDepth_;
    private Color color_;
    private String name_;

    public ChannelControlPanel(int n, MultiChannelHistograms multiChannelHistograms, VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        this.display_ = virtualAcquisitionDisplay;
        this.img_ = (CompositeImage)virtualAcquisitionDisplay.getHyperImage();
        this.cache_ = virtualAcquisitionDisplay.getImageCache();
        this.color_ = this.cache_.getChannelColor(n);
        this.name_ = this.cache_.getChannelName(n);
        this.bitDepth_ = this.cache_.getBitDepth();
        this.maxIntensity_ = (int)Math.pow(2.0, this.bitDepth_) - 1;
        this.histMax_ = this.maxIntensity_ + 1;
        this.binSize_ = this.histMax_ / 256;
        this.histMaxLabel_ = "" + this.histMax_;
        this.mcHistograms_ = multiChannelHistograms;
        this.channelIndex_ = n;
        this.initComponents();
        this.loadDisplaySettings(this.cache_);
        this.updateHistogram();
    }

    private void initComponents() {
        this.fullButton_ = new JButton();
        this.autoButton_ = new JButton();
        this.colorPickerLabel_ = new JLabel();
        this.channelNameCheckbox_ = new JCheckBox();
        this.histogramPanelHolder_ = new JPanel();
        this.minMaxLabel_ = new JLabel();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(250, this.height_));
        this.fullButton_.setFont(this.fullButton_.getFont().deriveFont(9.0f));
        this.fullButton_.setText("Full");
        this.fullButton_.setToolTipText("Stretch the display gamma curve over the full pixel range");
        this.fullButton_.setMargin(new Insets(2, 4, 2, 4));
        this.fullButton_.setPreferredSize(new Dimension(75, 30));
        this.fullButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChannelControlPanel.this.fullButtonAction();
            }
        });
        this.autoButton_.setFont(this.autoButton_.getFont().deriveFont(9.0f));
        this.autoButton_.setText("Auto");
        this.autoButton_.setToolTipText("Align the display gamma curve with minimum and maximum measured intensity values");
        this.autoButton_.setHorizontalTextPosition(0);
        this.autoButton_.setIconTextGap(0);
        this.autoButton_.setMargin(new Insets(2, 4, 2, 4));
        this.autoButton_.setMaximumSize(new Dimension(75, 30));
        this.autoButton_.setMinimumSize(new Dimension(75, 30));
        this.autoButton_.setPreferredSize(new Dimension(75, 30));
        this.autoButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChannelControlPanel.this.autoButtonAction();
            }
        });
        this.colorPickerLabel_.setBackground(this.color_);
        this.colorPickerLabel_.setToolTipText("Change the color for displaying this channel");
        this.colorPickerLabel_.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.colorPickerLabel_.setOpaque(true);
        this.colorPickerLabel_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ChannelControlPanel.this.colorPickerLabelMouseClicked();
            }
        });
        this.channelNameCheckbox_.setText(this.name_);
        this.channelNameCheckbox_.setToolTipText("Show/hide this channel in the multi-dimensional viewer");
        this.channelNameCheckbox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChannelControlPanel.this.channelNameCheckboxAction();
            }
        });
        this.histogramPanelHolder_.setToolTipText("Adjust the brightness and contrast by dragging triangles at top and bottom. Change the gamma by dragging the curve. (These controls only change display, and do not edit the image data.)");
        this.histogramPanelHolder_.setAlignmentX(0.3f);
        this.histogramPanelHolder_.setPreferredSize(new Dimension(0, 100));
        this.histogramPanelHolder_.setLayout(new BorderLayout());
        this.minMaxLabel_.setFont(new Font("Lucida Grande", 0, 10));
        this.minMaxLabel_.setText("Min:   Max:");
        this.histRangeComboBox_ = new JComboBox();
        this.histRangeComboBox_.setFont(new Font("", 0, 10));
        this.histRangeComboBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((ChannelControlPanel)ChannelControlPanel.this).display_.getHistogramControlsState().syncChannels) {
                    ChannelControlPanel.this.mcHistograms_.updateOtherDisplayCombos(ChannelControlPanel.this.histRangeComboBox_.getSelectedIndex());
                }
                ChannelControlPanel.this.displayComboAction();
            }
        });
        this.histRangeComboBox_.setModel(new DefaultComboBoxModel<String>(new String[]{"Camera Depth", "4bit (0-15)", "5bit (0-31)", "6bit (0-63)", "7bit (0-127)", "8bit (0-255)", "9bit (0-511)", "10bit (0-1023)", "11bit (0-2047)", "12bit (0-4095)", "13bit (0-8191)", "14bit (0-16383)", "15bit (0-32767)", "16bit (0-65535)"}));
        this.zoomInButton_ = new JButton();
        this.zoomInButton_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/zoom_in.png"));
        this.zoomOutButton_ = new JButton();
        this.zoomOutButton_.setIcon(SwingResourceManager.getIcon(MMStudioMainFrame.class, "/org/micromanager/icons/zoom_out.png"));
        this.zoomInButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChannelControlPanel.this.zoomInAction();
            }
        });
        this.zoomOutButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChannelControlPanel.this.zoomOutAction();
            }
        });
        this.setMinimumSize(MINIMUM_SIZE);
        this.setPreferredSize(MINIMUM_SIZE);
        this.hp_ = this.addHistogramPanel();
        this.setLayout(new BorderLayout());
        this.controlsHolderPanel_ = new JPanel(new BorderLayout());
        this.controlsHolderPanel_.setPreferredSize(CONTROLS_SIZE);
        this.controls_ = new JPanel();
        this.add((Component)this.controlsHolderPanel_, "Before");
        this.add((Component)this.histogramPanelHolder_, "Center");
        this.controlsHolderPanel_.add((Component)this.controls_, "First");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.controls_.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Hist. range:");
        jLabel.setFont(new Font("Lucida Grande", 0, 11));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        this.controls_.add((Component)this.channelNameCheckbox_, gridBagConstraints);
        this.fullButton_.setPreferredSize(new Dimension(45, 20));
        this.autoButton_.setPreferredSize(new Dimension(45, 20));
        this.colorPickerLabel_.setPreferredSize(new Dimension(18, 18));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(4);
        flowLayout.setVgap(0);
        JPanel jPanel = new JPanel(flowLayout);
        jPanel.setPreferredSize(CONTROLS_SIZE);
        jPanel.add(this.fullButton_);
        jPanel.add(this.autoButton_);
        jPanel.add(this.colorPickerLabel_);
        jPanel.setPreferredSize(new Dimension(ChannelControlPanel.CONTROLS_SIZE.width, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        this.controls_.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        this.controls_.add((Component)jLabel, gridBagConstraints);
        this.zoomInButton_.setPreferredSize(new Dimension(22, 22));
        this.zoomOutButton_.setPreferredSize(new Dimension(22, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        this.controls_.add((Component)this.zoomInButton_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        this.controls_.add((Component)this.zoomOutButton_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        this.controls_.add((Component)this.histRangeComboBox_, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        this.controls_.add((Component)this.minMaxLabel_, gridBagConstraints);
        this.controls_.setPreferredSize(this.controls_.getMinimumSize());
    }

    public void setDisplayComboIndex(int n) {
        this.histRangeComboBox_.setSelectedIndex(n);
    }

    public int getDisplayComboIndex() {
        return this.histRangeComboBox_.getSelectedIndex();
    }

    private void zoomInAction() {
        int n = this.histRangeComboBox_.getSelectedIndex();
        if (n == 0) {
            n = this.bitDepth_ - 3;
        }
        if (n != 1) {
            --n;
        }
        this.histRangeComboBox_.setSelectedIndex(n);
    }

    private void zoomOutAction() {
        int n = this.histRangeComboBox_.getSelectedIndex();
        if (n == 0) {
            n = this.bitDepth_ - 3;
        }
        if (n < this.histRangeComboBox_.getModel().getSize() - 1) {
            ++n;
        }
        this.histRangeComboBox_.setSelectedIndex(n);
    }

    public void displayComboAction() {
        int n = this.histRangeComboBox_.getSelectedIndex() + 3;
        this.histMax_ = n == 3 ? this.maxIntensity_ : (int)(Math.pow(2.0, n) - 1.0);
        this.binSize_ = (double)(this.histMax_ + 1) / 256.0;
        this.histMaxLabel_ = this.histMax_ + "";
        this.updateHistogram();
        this.calcAndDisplayHistAndStats(true);
        this.storeDisplaySettings();
    }

    private void updateHistogram() {
        this.hp_.setCursors((double)this.contrastMin_ / this.binSize_, (double)(this.contrastMax_ + 1) / this.binSize_, this.gamma_);
        this.hp_.repaint();
    }

    private void fullButtonAction() {
        if (this.display_.getHistogramControlsState().syncChannels) {
            this.mcHistograms_.fullScaleChannels();
        } else {
            this.setFullScale();
            this.mcHistograms_.applyLUTToImage();
            this.display_.drawWithoutUpdate();
        }
    }

    public void autoButtonAction() {
        if (this.display_.getHistogramControlsState().syncChannels) {
            this.autostretch();
            this.mcHistograms_.applyContrastToAllChannels(this.contrastMin_, this.contrastMax_, this.gamma_);
        } else {
            this.autostretch();
            this.mcHistograms_.applyLUTToImage();
            this.display_.drawWithoutUpdate();
        }
    }

    private void colorPickerLabelMouseClicked() {
        Color color;
        String string = "selected";
        if (this.cache_.getChannelName(this.channelIndex_) != null) {
            string = this.cache_.getChannelName(this.channelIndex_);
        }
        if ((color = JColorChooser.showDialog(this, "Choose a color for the " + string + " channel", this.cache_.getChannelColor(this.channelIndex_))) != null) {
            this.cache_.setChannelColor(this.channelIndex_, color.getRGB());
        }
        this.updateChannelNameAndColorFromCache();
        this.saveColorPreference(this.cache_, color.getRGB());
    }

    private void saveColorPreference(ImageCache imageCache, int n) {
        CMMCore cMMCore = MMStudioMainFrame.getInstance().getCore();
        JSONObject jSONObject = imageCache.getSummaryMetadata();
        if (cMMCore == null || jSONObject == null) {
            return;
        }
        int n2 = (int)cMMCore.getNumberOfCameraChannels();
        int n3 = -1;
        JSONArray jSONArray = null;
        String[] stringArray = new String[n2];
        try {
            int n4;
            n3 = MDUtils.getNumChannels(jSONObject);
            jSONArray = jSONObject.getJSONArray("ChNames");
            for (n4 = 0; n4 < n2; ++n4) {
                stringArray[n4] = cMMCore.getCameraChannelName(n4);
            }
            if (n2 > 1 && n3 == n2 && stringArray.length == jSONArray.length()) {
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    if (stringArray[n4].equals(jSONArray.getString(n4))) continue;
                    return;
                }
                Preferences preferences = Preferences.userNodeForPackage(AcqControlDlg.class);
                Preferences preferences2 = preferences.node(preferences.absolutePath() + "/" + "ColorSettings");
                preferences2.putInt("Color_Camera_" + stringArray[this.channelIndex_], n);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void channelNameCheckboxAction() {
        boolean[] blArray = this.img_.getActiveChannels();
        if (this.img_.getMode() != 1) {
            if (blArray[this.channelIndex_]) {
                this.channelNameCheckbox_.setSelected(true);
                return;
            }
            this.img_.setPosition(this.channelIndex_ + 1, this.img_.getSlice(), this.img_.getFrame());
        } else {
            this.img_.getActiveChannels()[this.channelIndex_] = this.channelNameCheckbox_.isSelected();
        }
        this.img_.getActiveChannels()[this.channelIndex_] = this.channelNameCheckbox_.isSelected();
        this.img_.updateAndDraw();
    }

    public void setFullScale() {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = 0;
        this.contrastMax_ = this.histMax_;
    }

    public void autostretch() {
        this.contrastMin_ = this.pixelMin_;
        this.contrastMax_ = this.pixelMax_;
        if (this.pixelMin_ == this.pixelMax_) {
            if (this.pixelMax_ > 0) {
                --this.contrastMin_;
            } else {
                ++this.contrastMax_;
            }
        }
        if (this.display_.getHistogramControlsState().ignoreOutliers) {
            if (this.contrastMin_ < this.minAfterRejectingOutliers_ && 0 < this.minAfterRejectingOutliers_) {
                this.contrastMin_ = this.minAfterRejectingOutliers_;
            }
            if (this.maxAfterRejectingOutliers_ < this.contrastMax_) {
                this.contrastMax_ = this.maxAfterRejectingOutliers_;
            }
            if (this.contrastMax_ <= this.contrastMin_) {
                if (this.contrastMax_ > 0) {
                    this.contrastMin_ = this.contrastMax_ - 1;
                } else {
                    this.contrastMax_ = this.contrastMin_ + 1;
                }
            }
        }
    }

    private void loadDisplaySettings(ImageCache imageCache) {
        this.contrastMax_ = imageCache.getChannelMax(this.channelIndex_);
        if (this.contrastMax_ < 0) {
            this.contrastMax_ = this.maxIntensity_;
        }
        this.contrastMin_ = imageCache.getChannelMin(this.channelIndex_);
        this.gamma_ = imageCache.getChannelGamma(this.channelIndex_);
        int n = imageCache.getChannelHistogramMax(this.channelIndex_);
        if (n != -1) {
            int n2 = (int)(Math.ceil(Math.log(n) / Math.log(2.0)) - 3.0);
            this.histRangeComboBox_.setSelectedIndex(n2);
        }
    }

    private HistogramPanel addHistogramPanel() {
        HistogramPanel histogramPanel = new HistogramPanel(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.setColor(Color.black);
                graphics.setFont(new Font("Lucida Grande", 0, 10));
                graphics.drawString(ChannelControlPanel.this.histMaxLabel_, this.getSize().width - 7 * ChannelControlPanel.this.histMaxLabel_.length(), this.getSize().height);
            }
        };
        histogramPanel.setMargins(8.0f, 12.0f);
        histogramPanel.setTextVisible(false);
        histogramPanel.setGridVisible(false);
        histogramPanel.setTraceStyle(true, this.color_);
        histogramPanel.setToolTipText("Click and drag curve to adjust gamma");
        this.histogramPanelHolder_.add((Component)histogramPanel, "Center");
        histogramPanel.addCursorListener(this);
        return histogramPanel;
    }

    public void updateChannelNameAndColorFromCache() {
        this.color_ = this.cache_.getChannelColor(this.channelIndex_);
        this.colorPickerLabel_.setBackground(this.color_);
        this.hp_.setTraceStyle(true, this.color_);
        String string = this.cache_.getChannelName(this.channelIndex_);
        if (string.length() > 11) {
            string = string.substring(0, 9) + "...";
        }
        this.channelNameCheckbox_.setText(string);
        this.calcAndDisplayHistAndStats(true);
        this.mcHistograms_.applyLUTToImage();
        this.display_.drawWithoutUpdate();
        this.repaint();
    }

    public int getContrastMin() {
        return this.contrastMin_;
    }

    public int getContrastMax() {
        return this.contrastMax_;
    }

    public double getContrastGamma() {
        return this.gamma_;
    }

    public void setContrast(int n, int n2) {
        this.contrastMin_ = n;
        this.contrastMax_ = n2;
    }

    public void setContrast(int n, int n2, double d) {
        this.contrastMin_ = n;
        this.contrastMax_ = n2;
        this.gamma_ = d;
    }

    public void applyChannelLUTToImage() {
        Runnable runnable = new Runnable(){

            public void run() {
                Color color = ChannelControlPanel.this.cache_.getChannelColor(ChannelControlPanel.this.channelIndex_);
                LUT lUT = ImageUtils.makeLUT(color, ChannelControlPanel.this.gamma_);
                lUT.min = ChannelControlPanel.this.contrastMin_;
                lUT.max = ChannelControlPanel.this.contrastMax_;
                ChannelControlPanel.this.img_.setChannelLut(lUT, ChannelControlPanel.this.channelIndex_ + 1);
                try {
                    JavaUtils.setRestrictedFieldValue(ChannelControlPanel.this.img_, CompositeImage.class, "currentChannel", -1);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    ReportingUtils.logError(noSuchFieldException);
                }
                if (ChannelControlPanel.this.img_.getChannel() == ChannelControlPanel.this.channelIndex_ + 1) {
                    LUT lUT2 = ImageUtils.makeLUT(Color.white, ChannelControlPanel.this.gamma_);
                    ChannelControlPanel.this.img_.getProcessor().setColorModel((ColorModel)lUT2);
                    ChannelControlPanel.this.img_.getProcessor().setMinAndMax((double)ChannelControlPanel.this.contrastMin_, (double)ChannelControlPanel.this.contrastMax_);
                    if (ChannelControlPanel.this.img_.getMode() == 3) {
                        ChannelControlPanel.this.img_.updateImage();
                    }
                }
                ChannelControlPanel.this.storeDisplaySettings();
                ChannelControlPanel.this.updateHistogram();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void storeDisplaySettings() {
        int n = this.histRangeComboBox_.getSelectedIndex() == 0 ? -1 : this.histMax_;
        this.cache_.storeChannelDisplaySettings(this.channelIndex_, this.contrastMin_, this.contrastMax_, this.gamma_, n);
    }

    public int getChannelIndex() {
        return this.channelIndex_;
    }

    public void calcAndDisplayHistAndStats(boolean bl) {
        int n;
        int n2;
        int n3;
        Object object;
        if (this.img_ == null || this.img_.getProcessor() == null) {
            return;
        }
        ImageProcessor imageProcessor = null;
        if (this.img_.getMode() == 1) {
            imageProcessor = this.img_.getProcessor(this.channelIndex_ + 1);
            if (imageProcessor != null) {
                imageProcessor.setRoi(this.img_.getRoi());
            }
        } else {
            object = (VirtualAcquisitionDisplay.MMCompositeImage)this.img_;
            n3 = 1 + this.channelIndex_ + (this.img_.getSlice() - 1) * ((VirtualAcquisitionDisplay.MMCompositeImage)object).getNChannelsUnverified() + (this.img_.getFrame() - 1) * ((VirtualAcquisitionDisplay.MMCompositeImage)object).getNSlicesUnverified() * ((VirtualAcquisitionDisplay.MMCompositeImage)object).getNChannelsUnverified();
            imageProcessor = this.img_.getStack().getProcessor(n3);
        }
        if (((VirtualAcquisitionDisplay.MMCompositeImage)this.img_).getNChannelsUnverified() <= 7) {
            boolean bl2 = this.img_.getActiveChannels()[this.channelIndex_];
            this.channelNameCheckbox_.setSelected(bl2);
            if (!bl2) {
                bl = false;
            }
        }
        if (((VirtualAcquisitionDisplay.MMCompositeImage)this.img_).getMode() != 1 && this.img_.getChannel() - 1 != this.channelIndex_) {
            bl = false;
        }
        if (imageProcessor == null) {
            return;
        }
        object = imageProcessor.getHistogram();
        if (object[0] == (n3 = this.img_.getWidth()) * (n2 = this.img_.getHeight())) {
            return;
        }
        if (this.display_.getHistogramControlsState().ignoreOutliers) {
            this.maxAfterRejectingOutliers_ = ((Object)object).length;
            int n4 = n2 * n3;
            HistogramUtils histogramUtils = new HistogramUtils((int[])object, n4, 0.01 * this.display_.getHistogramControlsState().percentToIgnore);
            this.minAfterRejectingOutliers_ = histogramUtils.getMinAfterRejectingOutliers();
            this.maxAfterRejectingOutliers_ = histogramUtils.getMaxAfterRejectingOutliers();
        }
        GraphData graphData = new GraphData();
        this.pixelMin_ = -1;
        this.pixelMax_ = 0;
        int n5 = (int)Math.min((double)((Object)object).length / this.binSize_, 256.0);
        int[] nArray = new int[256];
        int n6 = 0;
        for (n = 0; n < n5; ++n) {
            nArray[n] = 0;
            int n7 = 0;
            while ((double)n7 < this.binSize_) {
                int n8 = (int)((double)n * this.binSize_ + (double)n7);
                Object object2 = object[n8];
                int n9 = n;
                nArray[n9] = nArray[n9] + object2;
                if (object2 > 0) {
                    this.pixelMax_ = n8;
                    if (this.pixelMin_ == -1) {
                        this.pixelMin_ = n8;
                    }
                }
                ++n7;
            }
            n6 += nArray[n];
            if (!this.display_.getHistogramControlsState().logHist) continue;
            nArray[n] = nArray[n] > 0 ? (int)(1000.0 * Math.log(nArray[n])) : 0;
        }
        if (this.histRangeComboBox_.getSelectedIndex() != -1) {
            this.pixelMin_ = ((Object)object).length - 1;
            for (n = ((Object)object).length - 1; n > 0; --n) {
                if (object[n] > 0 && n > this.pixelMax_) {
                    this.pixelMax_ = n;
                }
                if (object[n] <= 0 || n >= this.pixelMin_) continue;
                this.pixelMin_ = n;
            }
        }
        if (n6 == 0) {
            if (this.img_.getProcessor().getMin() == 0.0) {
                nArray[0] = n3 * n2;
            } else {
                nArray[n5 - 1] = n3 * n2;
            }
        }
        if (bl) {
            this.hp_.setVisible(true);
            graphData.setData(nArray);
            this.hp_.setData(graphData);
            this.hp_.setAutoScale();
            this.hp_.repaint();
            this.minMaxLabel_.setText("Min: " + NumberUtils.intToDisplayString(this.pixelMin_) + "   " + "Max: " + NumberUtils.intToDisplayString(this.pixelMax_));
        } else {
            this.hp_.setVisible(false);
        }
    }

    public void onLeftCursor(double d) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMin_ = (int)(Math.max(0.0, d) * this.binSize_);
        if (this.contrastMin_ >= this.maxIntensity_) {
            this.contrastMin_ = this.maxIntensity_ - 1;
        }
        if (this.contrastMax_ < this.contrastMin_) {
            this.contrastMax_ = this.contrastMin_ + 1;
        }
        if (this.display_.getHistogramControlsState().syncChannels) {
            this.mcHistograms_.applyContrastToAllChannels(this.contrastMin_, this.contrastMax_, this.gamma_);
        } else {
            this.mcHistograms_.applyLUTToImage();
            this.display_.drawWithoutUpdate();
        }
    }

    public void onRightCursor(double d) {
        this.display_.disableAutoStretchCheckBox();
        this.contrastMax_ = (int)(Math.min(255.0, d) * this.binSize_);
        if (this.contrastMin_ > this.contrastMax_) {
            this.contrastMin_ = this.contrastMax_;
        }
        if (this.display_.getHistogramControlsState().syncChannels) {
            this.mcHistograms_.applyContrastToAllChannels(this.contrastMin_, this.contrastMax_, this.gamma_);
        } else {
            this.mcHistograms_.applyLUTToImage();
            this.display_.drawWithoutUpdate();
        }
    }

    public void onGammaCurve(double d) {
        if (d != 0.0) {
            this.gamma_ = d > 0.9 & d < 1.1 ? 1.0 : d;
            if (this.display_.getHistogramControlsState().syncChannels) {
                this.mcHistograms_.applyContrastToAllChannels(this.contrastMin_, this.contrastMax_, this.gamma_);
            } else {
                this.mcHistograms_.applyLUTToImage();
                this.display_.drawWithoutUpdate();
            }
        }
    }
}

