/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import mmcorej.CMMCore;
import mmcorej.MMCoreJ;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.utils.MMDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeripheralSetupDlg
extends MMDialog {
    private static final long serialVersionUID = 1L;
    private static final int NAMECOLUMN = 0;
    private static final int ADAPTERCOLUMN = 1;
    private static final int DESCRIPTIONCOLUMN = 2;
    private static final int SELECTIONCOLUMN = 3;
    private JTable deviceTable_;
    private JScrollPane scrollPane_;
    private MicroscopeModel model_;
    private String hub_;
    private final JPanel contentPanel = new JPanel();
    private Vector<Device> peripherals_;

    public PeripheralSetupDlg(MicroscopeModel microscopeModel, CMMCore cMMCore, String string, Vector<Device> vector) {
        this.setTitle("Peripheral Devices Setup");
        this.setBounds(100, 100, 479, 353);
        this.loadPosition(100, 100);
        this.setModal(true);
        this.setResizable(false);
        this.hub_ = string;
        this.model_ = microscopeModel;
        this.peripherals_ = vector;
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        this.scrollPane_ = new JScrollPane();
        this.scrollPane_.setBounds(10, 36, 453, 236);
        this.contentPanel.add(this.scrollPane_);
        this.deviceTable_ = new JTable();
        this.deviceTable_.setSelectionMode(0);
        this.scrollPane_.setViewportView(this.deviceTable_);
        JLabel jLabel = new JLabel("HUB (parent device):");
        jLabel.setBounds(10, 11, 111, 14);
        this.contentPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(this.hub_);
        jLabel2.setBounds(131, 11, 332, 14);
        this.contentPanel.add(jLabel2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)jPanel, "South");
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PeripheralSetupDlg.this.onOK();
            }
        });
        jButton.setActionCommand("OK");
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PeripheralSetupDlg.this.onCancel();
            }
        });
        jButton.setActionCommand("Cancel");
        jPanel.add(jButton);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PeripheralSetupDlg.this.savePosition();
            }
        });
        this.rebuildTable();
    }

    public void handleError(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    protected void removeDevice() {
        int n = this.deviceTable_.getSelectedRow();
        if (n < 0) {
            return;
        }
        String string = (String)this.deviceTable_.getValueAt(n, 0);
        if (string.contentEquals(new StringBuffer().append(MMCoreJ.getG_Keyword_CoreDevice()))) {
            this.handleError(MMCoreJ.getG_Keyword_CoreDevice() + " device can't be removed!");
            return;
        }
        this.model_.removeDevice(string);
        this.rebuildTable();
    }

    public void rebuildTable() {
        DeviceTable_TableModel deviceTable_TableModel = new DeviceTable_TableModel();
        this.deviceTable_.setModel(deviceTable_TableModel);
        deviceTable_TableModel.fireTableStructureChanged();
        deviceTable_TableModel.fireTableDataChanged();
    }

    public void refresh() {
        this.rebuildTable();
    }

    public void onOK() {
        this.savePosition();
        this.dispose();
    }

    public void onCancel() {
        this.savePosition();
        this.dispose();
    }

    public Device[] getSelectedPeripherals() {
        DeviceTable_TableModel deviceTable_TableModel = (DeviceTable_TableModel)this.deviceTable_.getModel();
        Vector<Device> vector = new Vector<Device>();
        Vector<Boolean> vector2 = deviceTable_TableModel.getSelected();
        for (int i = 0; i < this.peripherals_.size(); ++i) {
            if (!vector2.get(i).booleanValue()) continue;
            vector.add(this.peripherals_.get(i));
        }
        return vector.toArray(new Device[vector.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeviceTable_TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Name", "Adapter/Library", "Description", "Selected"};
        Vector<Boolean> selected_ = new Vector();

        public DeviceTable_TableModel() {
            for (int i = 0; i < PeripheralSetupDlg.this.peripherals_.size(); ++i) {
                this.selected_.add(false);
            }
        }

        @Override
        public int getRowCount() {
            return PeripheralSetupDlg.this.peripherals_.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Class getColumnClass(int n) {
            Class clazz = String.class;
            if (3 == n) {
                clazz = Boolean.class;
            }
            return clazz;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((Device)PeripheralSetupDlg.this.peripherals_.get(n)).getName();
            }
            if (n2 == 1) {
                return new String(((Device)PeripheralSetupDlg.this.peripherals_.get(n)).getAdapterName() + "/" + ((Device)PeripheralSetupDlg.this.peripherals_.get(n)).getLibrary());
            }
            if (n2 == 2) {
                return ((Device)PeripheralSetupDlg.this.peripherals_.get(n)).getDescription();
            }
            if (3 == n2) {
                return this.selected_.get(n);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    String string = (String)object;
                    String string2 = ((Device)PeripheralSetupDlg.this.peripherals_.get(n)).getName();
                    ((Device)PeripheralSetupDlg.this.peripherals_.get(n)).setName(string);
                    try {
                        this.fireTableCellUpdated(n, n2);
                    }
                    catch (Exception exception) {
                        PeripheralSetupDlg.this.handleError(exception.getMessage());
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.selected_.set(n, (Boolean)object);
                }
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            switch (n2) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    bl = true;
                }
            }
            return bl;
        }

        public void refresh() {
            this.fireTableDataChanged();
        }

        Vector<Boolean> getSelected() {
            return this.selected_;
        }
    }
}

