/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.DevicesPage;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.PagePanel;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.ReportingUtils;

public class DelayPage
extends PagePanel {
    private static final long serialVersionUID = 1L;
    private JTable deviceTable_;

    public DelayPage(Preferences preferences) {
        this.title_ = "Set delays for devices without synchronization capabilities";
        this.helpText_ = "Some devices can't signal when they are done with the command, so that we have to guess by manually setting the delay. This means that the device will signal to be busy for the specified delay time after extecuting each command. Devices that may require setting the delay manually are mostly shutters or filter wheels. \n\nIf device has normal synchronization capabilities, or you are not sure about it, leave this parameter at 0.";
        this.setHelpFileName("conf_delays_page.html");
        this.prefs_ = preferences;
        this.setLayout(null);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(22, 21, 517, 337);
        this.add(jScrollPane);
        this.deviceTable_ = new JTable();
        this.deviceTable_.setSelectionMode(0);
        InputMap inputMap = this.deviceTable_.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "none");
        jScrollPane.setViewportView(this.deviceTable_);
        GUIUtils.setClickCountToStartEditing(this.deviceTable_, 1);
        GUIUtils.stopEditingOnLosingFocus(this.deviceTable_);
    }

    public boolean enterPage(boolean bl) {
        this.rebuildTable();
        return true;
    }

    public boolean exitPage(boolean bl) {
        block3: {
            TableCellEditor tableCellEditor = this.deviceTable_.getCellEditor();
            if (tableCellEditor != null) {
                this.deviceTable_.getCellEditor().stopCellEditing();
            }
            try {
                this.model_.applyDelaysToHardware(this.core_);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
                if (!bl) break block3;
                return false;
            }
        }
        return true;
    }

    private void rebuildTable() {
        DelayTableModel delayTableModel;
        TableModel tableModel = this.deviceTable_.getModel();
        if (tableModel instanceof DevicesPage.DeviceTable_TableModel) {
            delayTableModel = (DelayTableModel)this.deviceTable_.getModel();
            delayTableModel.refresh();
        } else {
            delayTableModel = new DelayTableModel(this.model_);
            this.deviceTable_.setModel(delayTableModel);
        }
        delayTableModel.fireTableStructureChanged();
        delayTableModel.fireTableDataChanged();
    }

    public void refresh() {
        this.rebuildTable();
    }

    public void loadSettings() {
    }

    public void saveSettings() {
    }

    class DelayTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Name", "Adapter", "Delay [ms]"};
        MicroscopeModel model_;
        ArrayList<Device> devices_ = new ArrayList();

        public DelayTableModel(MicroscopeModel microscopeModel) {
            Device[] deviceArray = microscopeModel.getDevices();
            for (int i = 0; i < deviceArray.length; ++i) {
                if (!deviceArray[i].usesDelay()) continue;
                this.devices_.add(deviceArray[i]);
            }
            this.model_ = microscopeModel;
        }

        public void setMicroscopeModel(MicroscopeModel microscopeModel) {
            Device[] deviceArray = microscopeModel.getDevices();
            for (int i = 0; i < deviceArray.length; ++i) {
                if (!deviceArray[i].usesDelay()) continue;
                this.devices_.add(deviceArray[i]);
            }
            this.model_ = microscopeModel;
        }

        public int getRowCount() {
            return this.devices_.size();
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.devices_.get(n).getName();
            }
            if (n2 == 1) {
                return this.devices_.get(n).getAdapterName();
            }
            return new Double(this.devices_.get(n).getDelay());
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 2) {
                try {
                    this.devices_.get(n).setDelay(Double.parseDouble((String)object));
                    this.fireTableCellUpdated(n, n2);
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        public void refresh() {
            Device[] deviceArray = this.model_.getDevices();
            for (int i = 0; i < deviceArray.length; ++i) {
                if (!deviceArray[i].usesDelay()) continue;
                this.devices_.add(deviceArray[i]);
            }
            this.fireTableDataChanged();
        }
    }
}

