/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.conf2;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.micromanager.conf2.Device;
import org.micromanager.conf2.MMConfigFileException;
import org.micromanager.conf2.MicroscopeModel;
import org.micromanager.conf2.Setting;
import org.micromanager.utils.MMPropertyTableModel;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.ReportingUtils;

class ComPropTableModel
extends AbstractTableModel
implements MMPropertyTableModel {
    private static final long serialVersionUID = 1L;
    public final String[] COLUMN_NAMES = new String[]{"Device", "Property", "Value"};
    MicroscopeModel model_;
    Device dev_;
    PropertyItem[] props_;

    public ComPropTableModel(MicroscopeModel microscopeModel, Device device) {
        this.updateValues(microscopeModel, device);
    }

    public void updateValues(MicroscopeModel microscopeModel, Device device) {
        int n;
        this.model_ = microscopeModel;
        this.dev_ = device;
        try {
            System.out.println("InitPort " + this.dev_.getPropertyValue("BaudRate"));
        }
        catch (MMConfigFileException mMConfigFileException) {
            mMConfigFileException.printStackTrace();
        }
        if (!device.isSerialPort()) {
            return;
        }
        this.model_.dumpComPortsSetupProps();
        ArrayList<PropertyItem> arrayList = new ArrayList<PropertyItem>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < this.dev_.getNumberOfProperties(); ++n) {
            PropertyItem propertyItem = this.dev_.getProperty(n);
            if (propertyItem.readOnly) continue;
            arrayList.add(propertyItem);
            arrayList2.add(this.dev_.getName());
            PropertyItem propertyItem2 = this.dev_.findSetupProperty(propertyItem.name);
            if (propertyItem2 == null) continue;
            propertyItem.value = propertyItem2.value;
        }
        this.props_ = new PropertyItem[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.props_[n] = (PropertyItem)arrayList.get(n);
        }
    }

    public int getRowCount() {
        return this.props_.length;
    }

    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    public String getColumnName(int n) {
        return this.COLUMN_NAMES[n];
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.dev_.getName();
        }
        if (n2 == 1) {
            return this.props_[n].name;
        }
        return this.props_[n].value;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 2) {
            try {
                this.props_[n].value = (String)object;
                this.dev_.setPropertyValue(this.props_[n].name, this.props_[n].value);
                this.fireTableCellUpdated(n, n2);
                System.out.println("setVal " + this.dev_.getPropertyValue("BaudRate"));
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception.getMessage());
            }
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 2 && !this.props_[n].readOnly;
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    public PropertyItem getPropertyItem(int n) {
        return this.props_[n];
    }

    public Setting getSetting(int n) {
        return new Setting(this.dev_.getName(), this.props_[n].name, this.props_[n].value);
    }

    public PropertyItem getProperty(Setting setting) {
        if (this.dev_.getName().compareTo(setting.deviceName_) == 0) {
            return this.dev_.findSetupProperty(setting.propertyName_);
        }
        return null;
    }

    public Device getPortDevice() {
        return this.dev_;
    }
}

