/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.ScrollbarWithLabel;
import ij.gui.StackWindow;
import ij.gui.Toolbar;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.frame.ContrastAdjuster;
import ij.process.LUT;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.AcquisitionVirtualStack;
import org.micromanager.acquisition.HyperstackControls;
import org.micromanager.acquisition.MetadataPanel;
import org.micromanager.acquisition.ScrollbarIcon;
import org.micromanager.acquisition.SimpleWindowControls;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.api.AcquisitionDisplay;
import org.micromanager.api.AcquisitionEngine;
import org.micromanager.api.ImageCache;
import org.micromanager.api.ImageCacheListener;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.graph.HistogramControlsState;
import org.micromanager.graph.MultiChannelHistograms;
import org.micromanager.graph.SingleChannelHistogram;
import org.micromanager.internalinterfaces.DisplayControls;
import org.micromanager.internalinterfaces.Histograms;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIUpdater;
import org.micromanager.utils.GUIUtils;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VirtualAcquisitionDisplay
implements AcquisitionDisplay,
ImageCacheListener {
    static final Color[] rgb = new Color[]{Color.red, Color.green, Color.blue};
    static final String[] rgbNames = new String[]{"Red", "Blue", "Green"};
    final ImageCache imageCache_;
    final Preferences prefs_ = Preferences.userNodeForPackage(this.getClass());
    private static final String SIMPLE_WIN_X = "simple_x";
    private static final String SIMPLE_WIN_Y = "simple_y";
    private AcquisitionEngine eng_;
    private boolean finished_ = false;
    private boolean promptToSave_ = true;
    private String name_;
    private long lastDisplayTime_;
    private int lastFrameShown_ = 0;
    private int lastSliceShown_ = 0;
    private int lastPositionShown_ = 0;
    private boolean updating_ = false;
    private int preferredSlice_ = -1;
    private int preferredPosition_ = -1;
    private int preferredChannel_ = -1;
    private javax.swing.Timer preferredPositionTimer_;
    private int numComponents_;
    private ImagePlus hyperImage_;
    private ScrollbarWithLabel pSelector_;
    private ScrollbarWithLabel tSelector_;
    private ScrollbarWithLabel zSelector_;
    private ScrollbarWithLabel cSelector_;
    private DisplayControls controls_;
    public AcquisitionVirtualStack virtualStack_;
    private boolean simple_ = false;
    private boolean mda_ = false;
    private MetadataPanel mdPanel_;
    private boolean newDisplay_ = true;
    private double framesPerSec_ = 7.0;
    private Timer zAnimationTimer_ = new Timer();
    private Timer tAnimationTimer_ = new Timer();
    private boolean zAnimated_ = false;
    private boolean tAnimated_ = false;
    private int animatedSliceIndex_ = -1;
    private Component zIcon_;
    private Component pIcon_;
    private Component tIcon_;
    private Component cIcon_;
    private HashMap<Integer, Integer> zStackMins_;
    private HashMap<Integer, Integer> zStackMaxes_;
    private Histograms histograms_;
    private HistogramControlsState histogramControlsState_;
    private boolean albumSaved_ = false;
    private boolean[] channelContrastInitialized_;
    private static double snapWinMag_ = -1.0;
    private JPopupMenu saveTypePopup_;

    public static VirtualAcquisitionDisplay getDisplay(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        if (imageStack instanceof AcquisitionVirtualStack) {
            return ((AcquisitionVirtualStack)imageStack).getVirtualAcquisitionDisplay();
        }
        return null;
    }

    public VirtualAcquisitionDisplay(ImageCache imageCache, AcquisitionEngine acquisitionEngine) {
        this(imageCache, acquisitionEngine, WindowManager.getUniqueName((String)"Untitled"));
    }

    public VirtualAcquisitionDisplay(ImageCache imageCache, AcquisitionEngine acquisitionEngine, String string) {
        this.name_ = string;
        this.imageCache_ = imageCache;
        this.eng_ = acquisitionEngine;
        this.pSelector_ = this.createPositionScrollbar();
        this.mda_ = acquisitionEngine != null;
        this.zStackMins_ = new HashMap();
        this.zStackMaxes_ = new HashMap();
        this.albumSaved_ = imageCache.isFinished();
    }

    public VirtualAcquisitionDisplay(ImageCache imageCache, String string) throws MMScriptException {
        this.simple_ = true;
        this.imageCache_ = imageCache;
        this.name_ = string;
        this.mda_ = false;
        this.albumSaved_ = imageCache.isFinished();
    }

    private void startup(JSONObject jSONObject) {
        this.mdPanel_ = MMStudioMainFrame.getInstance().getMetadataPanel();
        JSONObject jSONObject2 = this.getSummaryMetadata();
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        try {
            int n8;
            if (jSONObject != null) {
                n5 = MDUtils.getWidth(jSONObject);
                n6 = MDUtils.getHeight(jSONObject);
            } else {
                n5 = MDUtils.getWidth(jSONObject2);
                n6 = MDUtils.getHeight(jSONObject2);
            }
            n = Math.max(jSONObject2.getInt("Slices"), 1);
            n2 = Math.max(jSONObject2.getInt("Frames"), 1);
            try {
                n8 = MDUtils.getChannelIndex(jSONObject);
            }
            catch (Exception exception) {
                n8 = -1;
            }
            n3 = Math.max(1 + n8, Math.max(jSONObject2.getInt("Channels"), 1));
            n4 = Math.max(jSONObject2.getInt("Positions"), 1);
            n7 = Math.max(MDUtils.getNumberOfComponents(jSONObject2), 1);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
        this.numComponents_ = n7;
        int n9 = this.numComponents_ * n3;
        if (this.imageCache_.getDisplayAndComments() == null || this.imageCache_.getDisplayAndComments().isNull("Channels")) {
            this.imageCache_.setDisplayAndComments(VirtualAcquisitionDisplay.getDisplaySettingsFromSummary(jSONObject2));
        }
        int n10 = 0;
        try {
            n10 = jSONObject != null ? MDUtils.getSingleChannelType(jSONObject) : MDUtils.getSingleChannelType(jSONObject2);
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception, "Unable to determine acquisition type.");
        }
        this.virtualStack_ = new AcquisitionVirtualStack(n5, n6, n10, null, this.imageCache_, n9 * n * n2, this);
        if (jSONObject2.has("PositionIndex")) {
            try {
                this.virtualStack_.setPositionIndex(MDUtils.getPositionIndex(jSONObject2));
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        this.controls_ = this.simple_ ? new SimpleWindowControls(this) : new HyperstackControls(this);
        this.hyperImage_ = this.createHyperImage(this.createMMImagePlus(this.virtualStack_), n9, n, n2, this.virtualStack_, this.controls_);
        this.applyPixelSizeCalibration(this.hyperImage_);
        this.histogramControlsState_ = this.mdPanel_.getContrastPanel().createDefaultControlsState();
        this.makeHistograms();
        this.createWindow();
        this.windowToFront();
        this.cSelector_ = this.getSelector("c");
        if (!this.simple_) {
            this.tSelector_ = this.getSelector("t");
            this.zSelector_ = this.getSelector("z");
            if (this.zSelector_ != null) {
                this.zSelector_.addAdjustmentListener(new AdjustmentListener(){

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        VirtualAcquisitionDisplay.this.preferredSlice_ = VirtualAcquisitionDisplay.this.zSelector_.getValue();
                    }
                });
            }
            if (this.cSelector_ != null) {
                this.cSelector_.addAdjustmentListener(new AdjustmentListener(){

                    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                        VirtualAcquisitionDisplay.this.preferredChannel_ = VirtualAcquisitionDisplay.this.cSelector_.getValue();
                    }
                });
            }
            if (this.imageCache_.lastAcquiredFrame() > 1) {
                this.setNumFrames(1 + this.imageCache_.lastAcquiredFrame());
            } else {
                this.setNumFrames(1);
            }
            this.configureAnimationControls();
            this.setNumPositions(n4);
        }
        if (this.imageCache_.isFinished()) {
            // empty if block
        }
        this.updateAndDraw(false);
        this.updateWindowTitleAndStatus();
        this.forcePainting();
    }

    public void setDisplayMode(int n) {
        this.mdPanel_.getContrastPanel().setDisplayMode(n);
    }

    private void forcePainting() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (VirtualAcquisitionDisplay.this.zIcon_ != null) {
                    VirtualAcquisitionDisplay.this.zIcon_.paint(VirtualAcquisitionDisplay.this.zIcon_.getGraphics());
                }
                if (VirtualAcquisitionDisplay.this.tIcon_ != null) {
                    VirtualAcquisitionDisplay.this.tIcon_.paint(VirtualAcquisitionDisplay.this.tIcon_.getGraphics());
                }
                if (VirtualAcquisitionDisplay.this.cIcon_ != null) {
                    VirtualAcquisitionDisplay.this.cIcon_.paint(VirtualAcquisitionDisplay.this.cIcon_.getGraphics());
                }
                if (VirtualAcquisitionDisplay.this.controls_ != null) {
                    VirtualAcquisitionDisplay.this.controls_.paint(VirtualAcquisitionDisplay.this.controls_.getGraphics());
                }
                if (VirtualAcquisitionDisplay.this.pIcon_ != null && VirtualAcquisitionDisplay.this.pIcon_.isValid()) {
                    VirtualAcquisitionDisplay.this.pIcon_.paint(VirtualAcquisitionDisplay.this.pIcon_.getGraphics());
                }
            }
        };
        try {
            GUIUtils.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private void animateSlices(boolean bl) {
        int n;
        if (!bl) {
            this.zAnimationTimer_.cancel();
            this.zAnimated_ = false;
            this.refreshAnimationIcons();
            return;
        }
        this.zAnimationTimer_ = new Timer();
        this.animateFrames(false);
        long l = (long)(1000.0 / this.framesPerSec_);
        if (l < 33L) {
            l = 33L;
            n = (int)Math.round(this.framesPerSec_ * 33.0 / 1000.0);
        } else {
            n = 1;
        }
        TimerTask timerTask = new TimerTask(){

            public void run() {
                int n2 = VirtualAcquisitionDisplay.this.hyperImage_.getSlice();
                if (n2 >= VirtualAcquisitionDisplay.this.zSelector_.getMaximum() - 1) {
                    VirtualAcquisitionDisplay.this.hyperImage_.setPosition(VirtualAcquisitionDisplay.this.hyperImage_.getChannel(), 1, VirtualAcquisitionDisplay.this.hyperImage_.getFrame());
                } else {
                    VirtualAcquisitionDisplay.this.hyperImage_.setPosition(VirtualAcquisitionDisplay.this.hyperImage_.getChannel(), n2 + n, VirtualAcquisitionDisplay.this.hyperImage_.getFrame());
                }
            }
        };
        this.zAnimationTimer_.schedule(timerTask, 0L, l);
        this.zAnimated_ = true;
        this.refreshAnimationIcons();
    }

    private void animateFrames(boolean bl) {
        int n;
        if (!bl) {
            this.tAnimationTimer_.cancel();
            this.tAnimated_ = false;
            this.refreshAnimationIcons();
            return;
        }
        this.tAnimationTimer_ = new Timer();
        this.animateSlices(false);
        long l = (long)(1000.0 / this.framesPerSec_);
        if (l < 33L) {
            l = 33L;
            n = (int)Math.round(this.framesPerSec_ * 33.0 / 1000.0);
        } else {
            n = 1;
        }
        TimerTask timerTask = new TimerTask(){

            public void run() {
                int n2 = VirtualAcquisitionDisplay.this.hyperImage_.getFrame();
                if (n2 >= VirtualAcquisitionDisplay.this.tSelector_.getMaximum() - 1) {
                    VirtualAcquisitionDisplay.this.hyperImage_.setPosition(VirtualAcquisitionDisplay.this.hyperImage_.getChannel(), VirtualAcquisitionDisplay.this.hyperImage_.getSlice(), 1);
                } else {
                    VirtualAcquisitionDisplay.this.hyperImage_.setPosition(VirtualAcquisitionDisplay.this.hyperImage_.getChannel(), VirtualAcquisitionDisplay.this.hyperImage_.getSlice(), n2 + n);
                }
            }
        };
        this.tAnimationTimer_.schedule(timerTask, 0L, l);
        this.tAnimated_ = true;
        this.refreshAnimationIcons();
    }

    private void refreshAnimationIcons() {
        if (this.zIcon_ != null) {
            this.zIcon_.repaint();
        }
        if (this.tIcon_ != null) {
            this.tIcon_.repaint();
        }
    }

    private void configureAnimationControls() {
        if (this.zIcon_ != null) {
            this.zIcon_.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent mouseEvent) {
                    VirtualAcquisitionDisplay.this.animateSlices(!VirtualAcquisitionDisplay.this.zAnimated_);
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
        }
        if (this.tIcon_ != null) {
            this.tIcon_.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent mouseEvent) {
                    VirtualAcquisitionDisplay.this.animateFrames(!VirtualAcquisitionDisplay.this.tAnimated_);
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
        }
    }

    public void promptToSave(boolean bl) {
        this.promptToSave_ = bl;
    }

    @Override
    public void imageReceived(TaggedImage taggedImage) {
        this.updateDisplay(taggedImage, false);
    }

    @Override
    public void imagingFinished(String string) {
        this.updateDisplay(null, true);
        this.updateAndDraw();
        if (this.eng_ == null || !this.eng_.abortRequested()) {
            this.updateWindowTitleAndStatus();
        }
    }

    private void updateDisplay(TaggedImage taggedImage, boolean bl) {
        try {
            boolean bl2;
            long l = System.currentTimeMillis();
            JSONObject jSONObject = taggedImage != null ? taggedImage.tags : this.imageCache_.getLastImageTags();
            if (jSONObject == null) {
                return;
            }
            int n = MDUtils.getFrameIndex(jSONObject);
            int n2 = MDUtils.getChannelIndex(jSONObject);
            int n3 = MDUtils.getSliceIndex(jSONObject);
            int n4 = MDUtils.getPositionIndex(jSONObject);
            boolean bl3 = bl2 = bl || n == 0 || Math.abs(l - this.lastDisplayTime_) > 30L || n2 == this.getNumChannels() - 1 && this.lastFrameShown_ == n && this.lastSliceShown_ == n3 && this.lastPositionShown_ == n4 || n3 == this.getNumSlices() - 1 && n == 0 && n4 == 0 && n2 == this.getNumChannels() - 1;
            if (bl2) {
                this.showImage(jSONObject, true);
                this.lastFrameShown_ = n;
                this.lastSliceShown_ = n3;
                this.lastPositionShown_ = n4;
                this.lastDisplayTime_ = l;
                this.forceImagePaint();
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private void forceImagePaint() {
        this.hyperImage_.getWindow().getCanvas().paint(this.hyperImage_.getWindow().getCanvas().getGraphics());
    }

    public int rgbToGrayChannel(int n) {
        try {
            if (MDUtils.getNumberOfComponents(this.imageCache_.getSummaryMetadata()) == 3) {
                return n * 3;
            }
            return n;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return 0;
        }
    }

    public int grayToRGBChannel(int n) {
        try {
            if (this.imageCache_ != null && this.imageCache_.getSummaryMetadata() != null && MDUtils.getNumberOfComponents(this.imageCache_.getSummaryMetadata()) == 3) {
                return n / 3;
            }
            return n;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return 0;
        }
    }

    public static JSONObject getDisplaySettingsFromSummary(JSONObject jSONObject) {
        try {
            int n;
            JSONArray jSONArray;
            int n2;
            JSONArray jSONArray2;
            JSONObject jSONObject2 = new JSONObject();
            JSONArray jSONArray3 = MDUtils.getJSONArrayMember(jSONObject, "ChColors");
            JSONArray jSONArray4 = MDUtils.getJSONArrayMember(jSONObject, "ChNames");
            if (jSONObject.has("ChContrastMin")) {
                jSONArray2 = MDUtils.getJSONArrayMember(jSONObject, "ChContrastMin");
            } else {
                jSONArray2 = new JSONArray();
                for (n2 = 0; n2 < jSONArray4.length(); ++n2) {
                    jSONArray2.put(0);
                }
            }
            if (jSONObject.has("ChContrastMax")) {
                jSONArray = MDUtils.getJSONArrayMember(jSONObject, "ChContrastMax");
            } else {
                n2 = 65536;
                if (jSONObject.has("BitDepth")) {
                    n2 = (int)(Math.pow(2.0, jSONObject.getInt("BitDepth")) - 1.0);
                }
                jSONArray = new JSONArray();
                for (int i = 0; i < jSONArray4.length(); ++i) {
                    jSONArray.put(n2);
                }
            }
            n2 = MDUtils.getNumberOfComponents(jSONObject);
            JSONArray jSONArray5 = new JSONArray();
            if (n2 > 1) {
                n = jSONObject.getString("PixelType").endsWith("32") ? 8 : 16;
                for (int i = 0; i < 3; ++i) {
                    JSONObject jSONObject3 = new JSONObject();
                    jSONObject3.put("Color", rgb[i].getRGB());
                    jSONObject3.put("Name", rgbNames[i]);
                    jSONObject3.put("Gamma", 1.0);
                    jSONObject3.put("Min", 0);
                    jSONObject3.put("Max", Math.pow(2.0, n) - 1.0);
                    jSONArray5.put(jSONObject3);
                }
            } else {
                for (n = 0; n < jSONArray4.length(); ++n) {
                    String string = (String)jSONArray4.get(n);
                    int n3 = 0;
                    if (n < jSONArray3.length()) {
                        n3 = jSONArray3.getInt(n);
                    }
                    int n4 = 0;
                    if (n < jSONArray2.length()) {
                        n4 = jSONArray2.getInt(n);
                    }
                    int n5 = jSONArray.getInt(0);
                    if (n < jSONArray.length()) {
                        n5 = jSONArray.getInt(n);
                    }
                    JSONObject jSONObject4 = new JSONObject();
                    jSONObject4.put("Color", n3);
                    jSONObject4.put("Name", string);
                    jSONObject4.put("Gamma", 1.0);
                    jSONObject4.put("Min", n4);
                    jSONObject4.put("Max", n5);
                    jSONArray5.put(jSONObject4);
                }
            }
            jSONObject2.put("Channels", jSONArray5);
            JSONObject jSONObject5 = new JSONObject();
            String string = "";
            try {
                string = jSONObject.getString("Comment");
            }
            catch (JSONException jSONException) {
                jSONObject.put("Comment", "");
            }
            jSONObject5.put("Summary", string);
            jSONObject2.put("Comments", jSONObject5);
            return jSONObject2;
        }
        catch (Exception exception) {
            ReportingUtils.showError("Summary metadata not found or corrupt.  Is this a Micro-Manager dataset?");
            return null;
        }
    }

    private void applyPixelSizeCalibration(ImagePlus imagePlus) {
        try {
            JSONObject jSONObject = this.getSummaryMetadata();
            double d = jSONObject.getDouble("PixelSize_um");
            if (d > 0.0) {
                String string;
                Calibration calibration = new Calibration();
                calibration.setUnit("um");
                calibration.pixelWidth = d;
                calibration.pixelHeight = d;
                String string2 = "Interval_ms";
                if (jSONObject.has(string2)) {
                    calibration.frameInterval = jSONObject.getDouble(string2) / 1000.0;
                }
                if (jSONObject.has(string = "z-step_um")) {
                    calibration.pixelDepth = jSONObject.getDouble(string);
                }
                imagePlus.setCalibration(calibration);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void setNumPositions(int n) {
        if (this.simple_) {
            return;
        }
        this.pSelector_.setMinimum(0);
        this.pSelector_.setMaximum(n);
        ImageWindow imageWindow = this.hyperImage_.getWindow();
        if (n > 1 && this.pSelector_.getParent() == null) {
            imageWindow.add((Component)this.pSelector_, imageWindow.getComponentCount() - 1);
        } else if (n <= 1 && this.pSelector_.getParent() != null) {
            imageWindow.remove((Component)this.pSelector_);
        }
        imageWindow.pack();
    }

    private void setNumFrames(int n) {
        if (this.simple_) {
            return;
        }
        if (this.tSelector_ != null) {
            ((IMMImagePlus)this.hyperImage_).setNFramesUnverified(n);
            this.tSelector_.setMaximum(n + 1);
        }
    }

    private void setNumSlices(int n) {
        if (this.simple_) {
            return;
        }
        if (this.zSelector_ != null) {
            ((IMMImagePlus)this.hyperImage_).setNSlicesUnverified(n);
            this.zSelector_.setMaximum(n + 1);
        }
    }

    private void setNumChannels(int n) {
        if (this.cSelector_ != null) {
            ((IMMImagePlus)this.hyperImage_).setNChannelsUnverified(n);
            this.cSelector_.setMaximum(n);
        }
    }

    public ImagePlus getHyperImage() {
        return this.hyperImage_;
    }

    public int getStackSize() {
        if (this.hyperImage_ == null) {
            return -1;
        }
        int n = this.hyperImage_.getNSlices();
        int n2 = this.hyperImage_.getNChannels();
        int n3 = this.hyperImage_.getNFrames();
        if (n > 1 && n2 > 1 || n2 > 1 && n3 > 1 || n3 > 1 && n > 1) {
            return n * n2 * n3;
        }
        return Math.max(Math.max(n, n2), n3);
    }

    private void imageChangedWindowUpdate() {
        TaggedImage taggedImage;
        if (this.hyperImage_ != null && this.hyperImage_.isVisible() && (taggedImage = this.virtualStack_.getTaggedImage(this.hyperImage_.getCurrentSlice())) != null) {
            this.controls_.newImageUpdate(taggedImage.tags);
        }
    }

    public void updateAndDraw() {
        this.updateAndDraw(true);
    }

    public void updateAndDraw(boolean bl) {
        if (this.hyperImage_ != null && this.hyperImage_.isVisible()) {
            if (!bl) {
                ((IMMImagePlus)this.hyperImage_).updateAndDrawWithoutGUIUpdater();
            } else {
                this.hyperImage_.updateAndDraw();
            }
        }
    }

    public void updateWindowTitleAndStatus() {
        String string;
        if (this.simple_) {
            int n = (int)(100.0 * this.hyperImage_.getCanvas().getMagnification());
            String string2 = this.hyperImage_.getTitle() + " (" + n + "%)";
            this.hyperImage_.getWindow().setTitle(string2);
            return;
        }
        if (this.controls_ == null) {
            return;
        }
        String string3 = "";
        AcquisitionEngine acquisitionEngine = this.eng_;
        if (acquisitionEngine != null) {
            if (this.acquisitionIsRunning()) {
                if (!this.abortRequested()) {
                    this.controls_.acquiringImagesUpdate(true);
                    string3 = this.isPaused() ? "paused" : "running";
                } else {
                    this.controls_.acquiringImagesUpdate(false);
                    string3 = "interrupted";
                }
            } else {
                this.controls_.acquiringImagesUpdate(false);
                if (!string3.contentEquals("interrupted") && acquisitionEngine.isFinished()) {
                    string3 = "finished";
                    this.eng_ = null;
                }
            }
            string3 = string3 + ", ";
            if (acquisitionEngine.isFinished()) {
                this.eng_ = null;
                this.finished_ = true;
            }
        } else {
            if (this.finished_) {
                string3 = "finished, ";
            }
            this.controls_.acquiringImagesUpdate(false);
        }
        string3 = this.isDiskCached() || this.albumSaved_ ? string3 + "on disk" : string3 + "not yet saved";
        this.controls_.imagesOnDiskUpdate(this.imageCache_.getDiskLocation() != null);
        String string4 = string = this.isDiskCached() ? new File(this.imageCache_.getDiskLocation()).getName() : this.name_;
        if (this.hyperImage_.isVisible()) {
            int n = (int)(100.0 * this.hyperImage_.getCanvas().getMagnification());
            this.hyperImage_.getWindow().setTitle(string + " (" + string3 + ") (" + n + "%)");
        }
    }

    private void windowToFront() {
        if (this.hyperImage_ == null || this.hyperImage_.getWindow() == null) {
            return;
        }
        this.hyperImage_.getWindow().toFront();
    }

    public void showImage(TaggedImage taggedImage) throws Exception {
        this.showImage(taggedImage, true);
    }

    public void showImage(TaggedImage taggedImage, boolean bl) throws InterruptedException, InvocationTargetException {
        this.showImage(taggedImage.tags, bl);
    }

    public void showImage(final JSONObject jSONObject, boolean bl) throws InterruptedException, InvocationTargetException {
        this.updateWindowTitleAndStatus();
        if (jSONObject == null) {
            return;
        }
        if (this.hyperImage_ == null) {
            GUIUtils.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        VirtualAcquisitionDisplay.this.startup(jSONObject);
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(exception);
                    }
                }
            });
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            n2 = MDUtils.getFrameIndex(jSONObject);
            n3 = MDUtils.getSliceIndex(jSONObject);
            n = MDUtils.getChannelIndex(jSONObject);
            n4 = MDUtils.getPositionIndex(jSONObject);
            n5 = this.rgbToGrayChannel(MDUtils.getChannelIndex(jSONObject));
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        boolean bl2 = this.isTAnimated();
        boolean bl3 = this.isZAnimated();
        int n6 = this.hyperImage_.getFrame();
        if (n3 == 0) {
            this.animatedSliceIndex_ = this.hyperImage_.getSlice();
        }
        if (bl2 || bl3) {
            this.animateFrames(false);
            this.animateSlices(false);
        }
        if (this.hyperImage_ != null && n2 == 0) {
            IMMImagePlus iMMImagePlus = (IMMImagePlus)this.hyperImage_;
            if (iMMImagePlus.getNChannelsUnverified() == 1) {
                if (iMMImagePlus.getNSlicesUnverified() == 1) {
                    this.hyperImage_.getProcessor().setPixels(this.virtualStack_.getPixels(1));
                }
            } else if (this.hyperImage_ instanceof MMCompositeImage) {
                MMCompositeImage mMCompositeImage = (MMCompositeImage)this.hyperImage_;
                mMCompositeImage.reset();
                mMCompositeImage.getProcessor().setPixels(this.virtualStack_.getPixels(mMCompositeImage.getCurrentSlice()));
            }
        } else if (this.hyperImage_ instanceof MMCompositeImage) {
            MMCompositeImage mMCompositeImage = (MMCompositeImage)this.hyperImage_;
            mMCompositeImage.reset();
        }
        if (this.cSelector_ != null && this.cSelector_.getMaximum() <= 1 + n5) {
            this.setNumChannels(1 + n5);
            ((CompositeImage)this.hyperImage_).reset();
            if (this.histograms_ != null) {
                this.histograms_.setupChannelControls(this.imageCache_);
            }
        }
        this.initializeContrast(n, n3);
        if (!this.simple_) {
            if (this.tSelector_ != null && this.tSelector_.getMaximum() <= 1 + n2) {
                this.setNumFrames(1 + n2);
            }
            if (n4 + 1 >= this.getNumPositions()) {
                this.setNumPositions(n4 + 1);
            }
            this.setPosition(n4);
            this.hyperImage_.setPosition(1 + n5, 1 + n3, 1 + n2);
        }
        this.updateAndDraw(this.simple_ || n2 != 0);
        this.restartAnimationAfterShowing(n6, this.animatedSliceIndex_, bl2, bl3);
        if (this.eng_ != null) {
            this.setPreferredScrollbarPositions();
        }
    }

    private void restartAnimationAfterShowing(int n, int n2, boolean bl, boolean bl2) {
        if (bl) {
            this.hyperImage_.setPosition(this.hyperImage_.getChannel(), this.hyperImage_.getSlice(), n + 1);
            this.animateFrames(true);
        } else if (bl2) {
            this.hyperImage_.setPosition(this.hyperImage_.getChannel(), n2 + 1, this.hyperImage_.getFrame());
            this.animateSlices(true);
        }
    }

    private void initializeContrast(final int n, final int n2) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (!VirtualAcquisitionDisplay.this.newDisplay_) {
                    return;
                }
                if (VirtualAcquisitionDisplay.this.simple_) {
                    if (VirtualAcquisitionDisplay.this.hyperImage_ instanceof MMCompositeImage && ((MMCompositeImage)VirtualAcquisitionDisplay.this.hyperImage_).getNChannelsUnverified() - 1 != n) {
                        return;
                    }
                    VirtualAcquisitionDisplay.this.loadSimpleWinContrastWithoutDraw();
                } else if (VirtualAcquisitionDisplay.this.mda_) {
                    IMMImagePlus iMMImagePlus = (IMMImagePlus)VirtualAcquisitionDisplay.this.hyperImage_;
                    if (iMMImagePlus.getNSlicesUnverified() > 1) {
                        VirtualAcquisitionDisplay.this.autoscaleOverStackWithoutDraw(VirtualAcquisitionDisplay.this.hyperImage_, n, n2, VirtualAcquisitionDisplay.this.zStackMins_, VirtualAcquisitionDisplay.this.zStackMaxes_);
                        if (n != iMMImagePlus.getNChannelsUnverified() - 1 || n2 != iMMImagePlus.getNSlicesUnverified() - 1) {
                            return;
                        }
                    } else {
                        if (n + 1 != VirtualAcquisitionDisplay.this.getNumChannels()) {
                            return;
                        }
                        VirtualAcquisitionDisplay.this.autoscaleWithoutDraw();
                    }
                } else if (VirtualAcquisitionDisplay.this.hyperImage_ instanceof MMCompositeImage) {
                    if (((MMCompositeImage)VirtualAcquisitionDisplay.this.hyperImage_).getNChannelsUnverified() - 1 != n) {
                        return;
                    }
                    VirtualAcquisitionDisplay.this.autoscaleWithoutDraw();
                } else {
                    VirtualAcquisitionDisplay.this.autoscaleWithoutDraw();
                }
                VirtualAcquisitionDisplay.this.newDisplay_ = false;
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private void loadSimpleWinContrastWithoutDraw() {
        int n = this.getImageCache().getNumChannels();
        for (int i = 0; i < n; ++i) {
            ContrastSettings contrastSettings = MMStudioMainFrame.getInstance().loadSimpleContrastSettigns(this.getImageCache().getPixelType(), i);
            this.histograms_.setChannelContrast(i, contrastSettings.min, contrastSettings.max, contrastSettings.gamma);
        }
        this.histograms_.applyLUTToImage();
    }

    private void autoscaleWithoutDraw() {
        if (this.histograms_ != null) {
            this.histograms_.calcAndDisplayHistAndStats(true);
            this.histograms_.autostretch();
            this.histograms_.applyLUTToImage();
        }
    }

    private void autoscaleOverStackWithoutDraw(ImagePlus imagePlus, int n, int n2, HashMap<Integer, Integer> hashMap, HashMap<Integer, Integer> hashMap2) {
        int n3;
        int n4;
        int n5 = ((IMMImagePlus)imagePlus).getNChannelsUnverified();
        int n6 = imagePlus.getBytesPerPixel();
        if (hashMap.containsKey(n)) {
            n4 = hashMap.get(n);
            n3 = hashMap2.get(n);
        } else {
            n3 = 0;
            n4 = (int)(Math.pow(2.0, 8 * n6) - 1.0);
        }
        int n7 = 1 + n + n2 * n5;
        if (n6 == 2) {
            short[] sArray;
            for (int n8 : sArray = (short[])imagePlus.getStack().getPixels(n7)) {
                if (n8 < n4) {
                    n4 = n8;
                }
                if (n8 <= n3) continue;
                n3 = n8;
            }
        } else if (n6 == 1) {
            byte[] byArray;
            for (int n9 : byArray = (byte[])imagePlus.getStack().getPixels(n7)) {
                if (n9 < n4) {
                    n4 = n9;
                }
                if (n9 <= n3) continue;
                n3 = n9;
            }
        }
        this.histograms_.setChannelContrast(n, n4, n3, 1.0);
        this.histograms_.applyLUTToImage();
        hashMap.put(n, n4);
        hashMap2.put(n, n3);
    }

    private void setPreferredScrollbarPositions() {
        if (this.preferredPositionTimer_ == null) {
            this.preferredPositionTimer_ = new javax.swing.Timer(250, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = VirtualAcquisitionDisplay.this.preferredChannel_ == -1 ? VirtualAcquisitionDisplay.this.hyperImage_.getChannel() : VirtualAcquisitionDisplay.this.preferredChannel_;
                    int n2 = VirtualAcquisitionDisplay.this.preferredSlice_ == -1 ? VirtualAcquisitionDisplay.this.hyperImage_.getSlice() : VirtualAcquisitionDisplay.this.preferredSlice_;
                    VirtualAcquisitionDisplay.this.hyperImage_.setPosition(n, VirtualAcquisitionDisplay.this.zAnimated_ ? VirtualAcquisitionDisplay.this.hyperImage_.getSlice() : n2, VirtualAcquisitionDisplay.this.hyperImage_.getFrame());
                    if (VirtualAcquisitionDisplay.this.pSelector_ != null && VirtualAcquisitionDisplay.this.preferredPosition_ > -1 && VirtualAcquisitionDisplay.this.eng_.getAcqOrderMode() != 2 && VirtualAcquisitionDisplay.this.eng_.getAcqOrderMode() != 3) {
                        VirtualAcquisitionDisplay.this.setPosition(VirtualAcquisitionDisplay.this.preferredPosition_);
                    }
                    VirtualAcquisitionDisplay.this.preferredPositionTimer_.stop();
                }
            });
        }
        if (this.preferredPositionTimer_.isRunning()) {
            this.preferredPositionTimer_.restart();
        } else {
            this.preferredPositionTimer_.start();
        }
    }

    private void updatePosition(int n) {
        if (this.simple_) {
            return;
        }
        this.virtualStack_.setPositionIndex(n);
        if (!this.hyperImage_.isComposite()) {
            Object object = this.virtualStack_.getPixels(this.hyperImage_.getCurrentSlice());
            this.hyperImage_.getProcessor().setPixels(object);
        } else {
            CompositeImage compositeImage = (CompositeImage)this.hyperImage_;
            if (compositeImage.getMode() == 1) {
                for (int i = 0; i < ((MMCompositeImage)compositeImage).getNChannelsUnverified(); ++i) {
                    if (compositeImage.getProcessor(i + 1) == null) continue;
                    compositeImage.getProcessor(i + 1).setPixels(this.virtualStack_.getPixels(compositeImage.getCurrentSlice() - compositeImage.getChannel() + i + 1));
                }
            }
            compositeImage.getProcessor().setPixels(this.virtualStack_.getPixels(this.hyperImage_.getCurrentSlice()));
        }
        this.imageChangedUpdate();
        this.updateAndDraw();
    }

    public void setPosition(int n) {
        if (this.simple_) {
            return;
        }
        this.pSelector_.setValue(n);
    }

    public void setSliceIndex(int n) {
        if (this.simple_) {
            return;
        }
        int n2 = this.hyperImage_.getFrame();
        int n3 = this.hyperImage_.getChannel();
        this.hyperImage_.setPosition(n3, n + 1, n2);
    }

    public int getSliceIndex() {
        return this.hyperImage_.getSlice() - 1;
    }

    boolean pause() {
        if (this.eng_ != null) {
            if (this.eng_.isPaused()) {
                this.eng_.setPause(false);
            } else {
                this.eng_.setPause(true);
            }
            this.updateWindowTitleAndStatus();
            return this.eng_.isPaused();
        }
        return false;
    }

    boolean abort() {
        if (this.eng_ != null && this.eng_.abortRequest()) {
            this.updateWindowTitleAndStatus();
            return true;
        }
        return false;
    }

    public boolean acquisitionIsRunning() {
        if (this.eng_ != null) {
            return this.eng_.isAcquisitionRunning();
        }
        return false;
    }

    public long getNextWakeTime() {
        return this.eng_.getNextWakeTime();
    }

    public boolean abortRequested() {
        if (this.eng_ != null) {
            return this.eng_.abortRequested();
        }
        return false;
    }

    private boolean isPaused() {
        if (this.eng_ != null) {
            return this.eng_.isPaused();
        }
        return false;
    }

    public void albumChanged() {
        this.albumSaved_ = false;
    }

    private Class createSaveTypePopup() {
        JPopupMenu jPopupMenu;
        if (this.saveTypePopup_ != null) {
            this.saveTypePopup_.setVisible(false);
            this.saveTypePopup_ = null;
        }
        this.saveTypePopup_ = jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save as single-image files");
        JMenuItem jMenuItem2 = new JMenuItem("Save as multi-image files");
        JMenuItem jMenuItem3 = new JMenuItem("Cancel");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem3);
        final AtomicInteger atomicInteger = new AtomicInteger(-1);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                atomicInteger.set(0);
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                atomicInteger.set(1);
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                atomicInteger.set(2);
            }
        });
        MouseListener mouseListener = new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                ((JMenuItem)mouseEvent.getComponent()).setArmed(true);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ((JMenuItem)mouseEvent.getComponent()).setArmed(false);
            }
        };
        jMenuItem.addMouseListener(mouseListener);
        jMenuItem2.addMouseListener(mouseListener);
        jMenuItem3.addMouseListener(mouseListener);
        Point point = MouseInfo.getPointerInfo().getLocation();
        jPopupMenu.show(null, point.x, point.y);
        while (atomicInteger.get() == -1) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (jPopupMenu.isVisible()) continue;
            return null;
        }
        jPopupMenu.setVisible(false);
        this.saveTypePopup_ = null;
        if (atomicInteger.get() == 0) {
            return null;
        }
        if (atomicInteger.get() == 1) {
            return TaggedImageStorageDiskDefault.class;
        }
        return TaggedImageStorageMultipageTiff.class;
    }

    boolean saveAs() {
        return this.saveAs(null, true);
    }

    private boolean saveAs(Class clazz, boolean bl) {
        String string;
        String string2;
        Object object;
        if (this.eng_ != null && this.eng_.isAcquisitionRunning()) {
            JOptionPane.showMessageDialog(null, "Data can not be saved while acquisition is running.");
            return false;
        }
        if (clazz == null) {
            clazz = this.createSaveTypePopup();
        }
        if (clazz == null) {
            return false;
        }
        while (true) {
            if ((object = FileDialogs.save((Window)this.hyperImage_.getWindow(), "Please choose a location for the data set", MMStudioMainFrame.MM_DATA_SET)) == null) {
                return false;
            }
            string2 = ((File)object).getName();
            string = new File(((File)object).getParent()).getAbsolutePath();
            if (!((File)object).exists()) break;
            ReportingUtils.showMessage(string2 + " is write only! Please choose another name.");
        }
        try {
            object = (TaggedImageStorage)clazz.getConstructor(String.class, Boolean.class, JSONObject.class).newInstance(string + "/" + string2, true, this.getSummaryMetadata());
            if (bl) {
                this.albumSaved_ = true;
            }
            this.imageCache_.saveAs((TaggedImageStorage)object, bl);
        }
        catch (Exception exception) {
            ReportingUtils.showError("Failed to save file");
        }
        MMStudioMainFrame.getInstance().setAcqDirectory(string);
        this.updateWindowTitleAndStatus();
        return true;
    }

    public final MMImagePlus createMMImagePlus(AcquisitionVirtualStack acquisitionVirtualStack) {
        MMImagePlus mMImagePlus = new MMImagePlus(this.imageCache_.getDiskLocation(), (ImageStack)acquisitionVirtualStack, this);
        FileInfo fileInfo = new FileInfo();
        fileInfo.width = acquisitionVirtualStack.getWidth();
        fileInfo.height = acquisitionVirtualStack.getHeight();
        fileInfo.fileName = acquisitionVirtualStack.getDirectory();
        fileInfo.url = null;
        mMImagePlus.setFileInfo(fileInfo);
        return mMImagePlus;
    }

    public final ImagePlus createHyperImage(MMImagePlus mMImagePlus, int n, int n2, int n3, AcquisitionVirtualStack acquisitionVirtualStack, DisplayControls displayControls) {
        IMMImagePlus iMMImagePlus;
        mMImagePlus.setNChannelsUnverified(n);
        mMImagePlus.setNFramesUnverified(n3);
        mMImagePlus.setNSlicesUnverified(n2);
        if (n > 1) {
            iMMImagePlus = new MMCompositeImage(mMImagePlus, 1);
            iMMImagePlus.setOpenAsHyperStack(true);
        } else {
            iMMImagePlus = mMImagePlus;
            mMImagePlus.setOpenAsHyperStack(true);
        }
        return iMMImagePlus;
    }

    public void liveModeEnabled(boolean bl) {
        if (this.simple_) {
            this.controls_.acquiringImagesUpdate(bl);
        }
    }

    private void createWindow() {
        final DisplayWindow displayWindow = new DisplayWindow(this.hyperImage_);
        displayWindow.getCanvas().addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (Toolbar.getToolId() == 11) {
                    VirtualAcquisitionDisplay.this.storeWindowSizeAfterZoom((ImageWindow)displayWindow);
                }
                VirtualAcquisitionDisplay.this.updateWindowTitleAndStatus();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                VirtualAcquisitionDisplay.this.hyperImage_.updateAndDraw();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        displayWindow.setBackground(MMStudioMainFrame.getInstance().getBackgroundColor());
        MMStudioMainFrame.getInstance().addMMBackgroundListener((Component)((Object)displayWindow));
        displayWindow.add(this.controls_);
        displayWindow.pack();
        if (this.simple_) {
            displayWindow.setLocation(this.prefs_.getInt(SIMPLE_WIN_X, 0), this.prefs_.getInt(SIMPLE_WIN_Y, 0));
        }
        this.zoomToPreferredSize(displayWindow);
        this.mdPanel_.displayChanged((ImageWindow)displayWindow);
        this.imageChangedUpdate();
    }

    private int getWinLength(ImageWindow imageWindow) {
        return (int)Math.sqrt(imageWindow.getSize().width * imageWindow.getSize().height);
    }

    public void storeWindowSizeAfterZoom(ImageWindow imageWindow) {
        if (this.simple_) {
            snapWinMag_ = imageWindow.getCanvas().getMagnification();
        }
    }

    private void zoomToPreferredSize(DisplayWindow displayWindow) {
        Point point = displayWindow.getLocation();
        displayWindow.setLocation(new Point(0, 0));
        double d = this.simple_ && snapWinMag_ != -1.0 ? snapWinMag_ : MMStudioMainFrame.getInstance().getPreferredWindowMag();
        ImageCanvas imageCanvas = displayWindow.getCanvas();
        if (d < imageCanvas.getMagnification()) {
            while (d < imageCanvas.getMagnification()) {
                imageCanvas.zoomOut(imageCanvas.getWidth() / 2, imageCanvas.getHeight() / 2);
            }
        } else if (d > imageCanvas.getMagnification()) {
            while (d > imageCanvas.getMagnification()) {
                imageCanvas.zoomIn(imageCanvas.getWidth() / 2, imageCanvas.getHeight() / 2);
            }
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Point point2 = new Point(point.x, point.y);
        if (point2.x + displayWindow.getWidth() > dimension.width && displayWindow.getWidth() < dimension.width) {
            point2.x = dimension.width - displayWindow.getWidth();
        }
        if (point2.y + displayWindow.getHeight() > dimension.height && displayWindow.getHeight() < dimension.height) {
            point2.y = dimension.height - displayWindow.getHeight();
        }
        displayWindow.setLocation(point2);
    }

    private ScrollbarWithLabel getSelector(String string) {
        ScrollbarWithLabel scrollbarWithLabel = null;
        ImageWindow imageWindow = this.hyperImage_.getWindow();
        int n = ((IMMImagePlus)this.hyperImage_).getNSlicesUnverified();
        int n2 = ((IMMImagePlus)this.hyperImage_).getNFramesUnverified();
        int n3 = ((IMMImagePlus)this.hyperImage_).getNChannelsUnverified();
        if (imageWindow instanceof StackWindow) {
            try {
                scrollbarWithLabel = n2 > 1 && n == 1 && n3 == 1 && string.equals("t") ? (ScrollbarWithLabel)JavaUtils.getRestrictedFieldValue((StackWindow)imageWindow, StackWindow.class, "zSelector") : (ScrollbarWithLabel)JavaUtils.getRestrictedFieldValue((StackWindow)imageWindow, StackWindow.class, string + "Selector");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                scrollbarWithLabel = null;
                ReportingUtils.logError(noSuchFieldException);
            }
        }
        if (scrollbarWithLabel != null) {
            Component component;
            try {
                component = (Component)JavaUtils.getRestrictedFieldValue(scrollbarWithLabel, ScrollbarWithLabel.class, "icon");
                scrollbarWithLabel.remove(component);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                ReportingUtils.logError(noSuchFieldException);
            }
            component = new ScrollbarIcon(string.charAt(0), this);
            if (string.equals("z")) {
                this.zIcon_ = component;
            } else if (string.equals("t")) {
                this.tIcon_ = component;
            } else if (string.equals("c")) {
                this.cIcon_ = component;
            }
            scrollbarWithLabel.add(component, (Object)"West");
            scrollbarWithLabel.invalidate();
            scrollbarWithLabel.validate();
        }
        return scrollbarWithLabel;
    }

    private ScrollbarWithLabel createPositionScrollbar() {
        final ScrollbarWithLabel scrollbarWithLabel = new ScrollbarWithLabel(null, 1, 1, 1, 2, 'p'){

            public void setValue(int n) {
                if (this.getValue() != n) {
                    super.setValue(n);
                    VirtualAcquisitionDisplay.this.updatePosition(n);
                }
            }
        };
        scrollbarWithLabel.setFocusable(false);
        scrollbarWithLabel.setUnitIncrement(1);
        scrollbarWithLabel.setBlockIncrement(1);
        scrollbarWithLabel.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                VirtualAcquisitionDisplay.this.updatePosition(scrollbarWithLabel.getValue());
                VirtualAcquisitionDisplay.this.preferredPosition_ = VirtualAcquisitionDisplay.this.pSelector_.getValue();
            }
        });
        if (scrollbarWithLabel != null) {
            try {
                Component component = (Component)JavaUtils.getRestrictedFieldValue(scrollbarWithLabel, ScrollbarWithLabel.class, "icon");
                scrollbarWithLabel.remove(component);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                ReportingUtils.logError(noSuchFieldException);
            }
            this.pIcon_ = new ScrollbarIcon('p', this);
            scrollbarWithLabel.add(this.pIcon_, (Object)"West");
            scrollbarWithLabel.invalidate();
            scrollbarWithLabel.validate();
        }
        return scrollbarWithLabel;
    }

    public JSONObject getCurrentMetadata() {
        try {
            if (this.hyperImage_ != null) {
                TaggedImage taggedImage = this.virtualStack_.getTaggedImage(this.hyperImage_.getCurrentSlice());
                if (taggedImage != null) {
                    return taggedImage.tags;
                }
                return null;
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getCurrentPosition() {
        return this.virtualStack_.getPositionIndex();
    }

    public int getNumSlices() {
        if (this.simple_) {
            return 1;
        }
        return ((IMMImagePlus)this.hyperImage_).getNSlicesUnverified();
    }

    public int getNumFrames() {
        if (this.simple_) {
            return 1;
        }
        return ((IMMImagePlus)this.hyperImage_).getNFramesUnverified();
    }

    public int getNumPositions() {
        if (this.simple_) {
            return 1;
        }
        return this.pSelector_.getMaximum();
    }

    public ImagePlus getImagePlus() {
        return this.hyperImage_;
    }

    public ImageCache getImageCache() {
        return this.imageCache_;
    }

    public ImagePlus getImagePlus(int n) {
        ImagePlus imagePlus = new ImagePlus();
        imagePlus.setStack((ImageStack)this.virtualStack_);
        imagePlus.setDimensions(this.numComponents_ * this.getNumChannels(), this.getNumSlices(), this.getNumFrames());
        imagePlus.setFileInfo(this.hyperImage_.getFileInfo());
        return imagePlus;
    }

    public void setComment(String string) throws MMScriptException {
        try {
            this.getSummaryMetadata().put("Comment", string);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    public final JSONObject getSummaryMetadata() {
        return this.imageCache_.getSummaryMetadata();
    }

    public void close() {
        if (this.hyperImage_ != null) {
            this.hyperImage_.getWindow().windowClosing(null);
            this.hyperImage_.close();
        }
    }

    public synchronized boolean windowClosed() {
        if (this.hyperImage_ != null) {
            ImageWindow imageWindow = this.hyperImage_.getWindow();
            return imageWindow == null || imageWindow.isClosed();
        }
        return true;
    }

    public void showFolder() {
        if (this.isDiskCached()) {
            try {
                File file = new File(this.imageCache_.getDiskLocation());
                if (JavaUtils.isWindows()) {
                    Runtime.getRuntime().exec("Explorer /n,/select," + file.getAbsolutePath());
                } else if (JavaUtils.isMac()) {
                    if (!file.isDirectory()) {
                        file = file.getParentFile();
                    }
                    Runtime.getRuntime().exec("open " + file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                ReportingUtils.logError(iOException);
            }
        }
    }

    public void setPlaybackFPS(double d) {
        this.framesPerSec_ = d;
        if (this.zAnimated_) {
            this.animateSlices(false);
            this.animateSlices(true);
        } else if (this.tAnimated_) {
            this.animateFrames(false);
            this.animateFrames(true);
        }
    }

    public double getPlaybackFPS() {
        return this.framesPerSec_;
    }

    public boolean isZAnimated() {
        return this.zAnimated_;
    }

    public boolean isTAnimated() {
        return this.tAnimated_;
    }

    public boolean isAnimated() {
        return this.isTAnimated() || this.isZAnimated();
    }

    public String getSummaryComment() {
        return this.imageCache_.getComment();
    }

    public void setSummaryComment(String string) {
        this.imageCache_.setComment(string);
    }

    void setImageComment(String string) {
        this.imageCache_.setImageComment(string, this.getCurrentMetadata());
    }

    String getImageComment() {
        try {
            return this.imageCache_.getImageComment(this.getCurrentMetadata());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public boolean isDiskCached() {
        ImageCache imageCache = this.imageCache_;
        if (imageCache == null) {
            return false;
        }
        return imageCache.getDiskLocation() != null;
    }

    public void show() {
        if (this.hyperImage_ == null) {
            try {
                GUIUtils.invokeAndWait(new Runnable(){

                    public void run() {
                        VirtualAcquisitionDisplay.this.startup(null);
                    }
                });
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        this.hyperImage_.show();
        this.hyperImage_.getWindow().toFront();
    }

    public int getNumChannels() {
        return ((IMMImagePlus)this.hyperImage_).getNChannelsUnverified();
    }

    public int getNumGrayChannels() {
        return this.getNumChannels();
    }

    public void setWindowTitle(String string) {
        this.name_ = string;
        this.updateWindowTitleAndStatus();
    }

    public boolean isSimpleDisplay() {
        return this.simple_;
    }

    public void displayStatusLine(String string) {
        this.controls_.setStatusLabel(string);
    }

    public void setChannelContrast(int n, int n2, int n3, double d) {
        this.histograms_.setChannelContrast(n, n2, n3, d);
        this.histograms_.applyLUTToImage();
        this.drawWithoutUpdate();
    }

    public void updateChannelNamesAndColors() {
        if (this.histograms_ != null && this.histograms_ instanceof MultiChannelHistograms) {
            ((MultiChannelHistograms)this.histograms_).updateChannelNamesAndColors();
        }
    }

    public void setChannelHistogramDisplayMax(int n, int n2) {
        this.histograms_.setChannelHistogramDisplayMax(n, n2);
    }

    private void imageChangedUpdate() {
        if (this.histograms_ != null) {
            this.histograms_.imageChanged();
        }
        if (this.isActiveDisplay()) {
            this.mdPanel_.imageChangedUpdate(this);
        }
        this.imageChangedWindowUpdate();
    }

    public boolean isActiveDisplay() {
        if (this.hyperImage_ == null || this.hyperImage_.getWindow() == null) {
            return false;
        }
        return this.hyperImage_.getWindow() == this.mdPanel_.getCurrentWindow();
    }

    public void drawWithoutUpdate() {
        if (this.hyperImage_ != null) {
            ((IMMImagePlus)this.hyperImage_).drawWithoutUpdate();
        }
    }

    private void makeHistograms() {
        this.histograms_ = this.getNumChannels() == 1 ? new SingleChannelHistogram(this) : new MultiChannelHistograms(this);
    }

    public Histograms getHistograms() {
        return this.histograms_;
    }

    public HistogramControlsState getHistogramControlsState() {
        return this.histogramControlsState_;
    }

    public void disableAutoStretchCheckBox() {
        if (this.isActiveDisplay()) {
            this.mdPanel_.getContrastPanel().disableAutostretch();
        } else {
            this.histogramControlsState_.autostretch = false;
        }
    }

    private void saveSimpleWinSettings() {
        ImageCache imageCache = this.getImageCache();
        String string = imageCache.getPixelType();
        int n = imageCache.getNumChannels();
        for (int i = 0; i < n; ++i) {
            int n2 = imageCache.getChannelMin(i);
            int n3 = imageCache.getChannelMax(i);
            double d = imageCache.getChannelGamma(i);
            MMStudioMainFrame.getInstance().saveSimpleContrastSettings(new ContrastSettings(n2, n3, d), i, string);
        }
    }

    public ContrastSettings getChannelContrastSettings(int n) {
        return this.histograms_.getChannelContrastSettings(n);
    }

    public class DisplayWindow
    extends StackWindow {
        private boolean windowClosingDone_;
        private boolean closed_;

        public DisplayWindow(ImagePlus imagePlus) {
            super(imagePlus);
            this.windowClosingDone_ = false;
            this.closed_ = false;
        }

        public boolean close() {
            this.windowClosing(null);
            return this.closed_;
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object[] objectArray;
            int n;
            if (this.windowClosingDone_) {
                return;
            }
            if (VirtualAcquisitionDisplay.this.eng_ != null && VirtualAcquisitionDisplay.this.eng_.isAcquisitionRunning() && !VirtualAcquisitionDisplay.this.abort()) {
                return;
            }
            if (VirtualAcquisitionDisplay.this.imageCache_.getDiskLocation() == null && VirtualAcquisitionDisplay.this.promptToSave_ && !VirtualAcquisitionDisplay.this.albumSaved_ && ((n = JOptionPane.showOptionDialog((Component)((Object)this), "This data set has not yet been saved.  Do you want to save it?\nData can be saved as single-image files or multi-image files.", "Micro-Manager", -1, 3, null, objectArray = new String[]{"Save single", "Save multi", "No", "Cancel"}, objectArray[0])) == 0 ? !VirtualAcquisitionDisplay.this.saveAs(TaggedImageStorageDiskDefault.class, true) : (n == 1 ? !VirtualAcquisitionDisplay.this.saveAs(TaggedImageStorageMultipageTiff.class, true) : n == 3))) {
                return;
            }
            if (VirtualAcquisitionDisplay.this.simple_ && VirtualAcquisitionDisplay.this.hyperImage_ != null && VirtualAcquisitionDisplay.this.hyperImage_.getWindow() != null && VirtualAcquisitionDisplay.this.hyperImage_.getWindow().getLocation() != null) {
                objectArray = VirtualAcquisitionDisplay.this.hyperImage_.getWindow().getLocation();
                VirtualAcquisitionDisplay.this.prefs_.putInt(VirtualAcquisitionDisplay.SIMPLE_WIN_X, objectArray.x);
                VirtualAcquisitionDisplay.this.prefs_.putInt(VirtualAcquisitionDisplay.SIMPLE_WIN_Y, objectArray.y);
                VirtualAcquisitionDisplay.this.saveSimpleWinSettings();
            }
            if (VirtualAcquisitionDisplay.this.imageCache_ != null) {
                VirtualAcquisitionDisplay.this.imageCache_.close();
            }
            if (!this.closed_) {
                try {
                    super.close();
                }
                catch (NullPointerException nullPointerException) {
                    ReportingUtils.showError(nullPointerException, "Null pointer error in ImageJ code while closing window");
                }
            }
            VirtualAcquisitionDisplay.this.mdPanel_.displayChanged(null);
            super.windowClosing(windowEvent);
            MMStudioMainFrame.getInstance().removeMMBackgroundListener((Component)((Object)this));
            this.windowClosingDone_ = true;
            this.closed_ = true;
        }

        public void windowClosed(WindowEvent windowEvent) {
            try {
                super.windowClosed(windowEvent);
            }
            catch (NullPointerException nullPointerException) {
                ReportingUtils.showError(nullPointerException, "Null pointer error in ImageJ code while closing window");
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (!this.isClosed()) {
                super.windowActivated(windowEvent);
            }
        }

        public void setAnimate(boolean bl) {
            if (((IMMImagePlus)VirtualAcquisitionDisplay.this.hyperImage_).getNFramesUnverified() > 1) {
                VirtualAcquisitionDisplay.this.animateFrames(bl);
            } else {
                VirtualAcquisitionDisplay.this.animateSlices(bl);
            }
        }

        public boolean getAnimate() {
            return VirtualAcquisitionDisplay.this.isAnimated();
        }
    }

    public class MMImagePlus
    extends ImagePlus
    implements IMMImagePlus {
        private GUIUpdater updater1;
        private GUIUpdater updater2;
        public VirtualAcquisitionDisplay display_;

        MMImagePlus(String string, ImageStack imageStack, VirtualAcquisitionDisplay virtualAcquisitionDisplay2) {
            super(string, imageStack);
            this.updater1 = new GUIUpdater();
            this.updater2 = new GUIUpdater();
            this.display_ = virtualAcquisitionDisplay2;
        }

        public String getTitle() {
            return VirtualAcquisitionDisplay.this.name_;
        }

        public int getImageStackSize() {
            return this.nChannels * this.nSlices * this.nFrames;
        }

        public int getStackSize() {
            return this.getImageStackSize();
        }

        public int getNChannelsUnverified() {
            return this.nChannels;
        }

        public int getNSlicesUnverified() {
            return this.nSlices;
        }

        public int getNFramesUnverified() {
            return this.nFrames;
        }

        public void setNChannelsUnverified(int n) {
            this.nChannels = n;
        }

        public void setNSlicesUnverified(int n) {
            this.nSlices = n;
        }

        public void setNFramesUnverified(int n) {
            this.nFrames = n;
        }

        private void superDraw() {
            if (this.win != null) {
                super.getCanvas().paint(super.getCanvas().getGraphics());
            }
        }

        private Runnable drawRunnable() {
            return new Runnable(){

                public void run() {
                    VirtualAcquisitionDisplay.this.imageChangedUpdate();
                    MMImagePlus.this.superDraw();
                }
            };
        }

        public void updateAndDrawWithoutGUIUpdater() {
            try {
                GUIUtils.invokeLater(this.drawRunnable());
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }

        public void draw() {
            this.updater1.post(this.drawRunnable());
        }

        public void drawWithoutUpdate() {
            Runnable runnable = new Runnable(){

                public void run() {
                    MMImagePlus.this.getWindow().getCanvas().setImageUpdated();
                    MMImagePlus.this.superDraw();
                }
            };
            this.updater2.post(runnable);
        }
    }

    public class MMCompositeImage
    extends CompositeImage
    implements IMMImagePlus {
        private GUIUpdater updater1;
        private GUIUpdater updater2;
        private GUIUpdater updater3;

        MMCompositeImage(ImagePlus imagePlus, int n) {
            super(imagePlus, n);
            this.updater1 = new GUIUpdater();
            this.updater2 = new GUIUpdater();
            this.updater3 = new GUIUpdater();
        }

        public String getTitle() {
            return VirtualAcquisitionDisplay.this.name_;
        }

        public int getImageStackSize() {
            return this.nChannels * this.nSlices * this.nFrames;
        }

        public int getStackSize() {
            return this.getImageStackSize();
        }

        public int getNChannelsUnverified() {
            return this.nChannels;
        }

        public int getNSlicesUnverified() {
            return this.nSlices;
        }

        public int getNFramesUnverified() {
            return this.nFrames;
        }

        public void setNChannelsUnverified(int n) {
            this.nChannels = n;
        }

        public void setNSlicesUnverified(int n) {
            this.nSlices = n;
        }

        public void setNFramesUnverified(int n) {
            this.nFrames = n;
        }

        private void superReset() {
            super.reset();
        }

        public void reset() {
            if (SwingUtilities.isEventDispatchThread()) {
                super.reset();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MMCompositeImage.this.superReset();
                    }
                });
            }
        }

        public synchronized void setMode(int n) {
            this.superSetMode(n);
        }

        private void superSetMode(int n) {
            super.setMode(n);
        }

        public synchronized void setChannelLut(LUT lUT) {
            this.superSetLut(lUT);
        }

        private void superSetLut(LUT lUT) {
            super.setChannelLut(lUT);
        }

        public synchronized void updateImage() {
            this.superUpdateImage();
        }

        private void superUpdateImage() {
            ContrastAdjuster contrastAdjuster = (ContrastAdjuster)WindowManager.getFrame((String)"B&C");
            if (contrastAdjuster != null) {
                try {
                    JavaUtils.setRestrictedFieldValue(contrastAdjuster, ContrastAdjuster.class, "instance", null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    ReportingUtils.logError("ImageJ ContrastAdjuster doesn't have field named instance");
                }
            }
            super.updateImage();
        }

        private Runnable updateAndDrawRunnable() {
            return new Runnable(){

                public void run() {
                    MMCompositeImage.this.superUpdateImage();
                    VirtualAcquisitionDisplay.this.imageChangedUpdate();
                    try {
                        GUIUtils.invokeLater(new Runnable(){

                            public void run() {
                                try {
                                    JavaUtils.invokeRestrictedMethod((Object)this, ImagePlus.class, "notifyListeners", 2);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                MMCompositeImage.this.superDraw();
                            }
                        });
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(exception);
                    }
                }
            };
        }

        public void updateAndDrawWithoutGUIUpdater() {
            try {
                GUIUtils.invokeLater(this.updateAndDrawRunnable());
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }

        public void updateAndDraw() {
            this.updater1.post(this.updateAndDrawRunnable());
        }

        private void superDraw() {
            if (this.win != null) {
                super.getCanvas().paint(super.getCanvas().getGraphics());
            }
        }

        public void draw() {
            Runnable runnable = new Runnable(){

                public void run() {
                    VirtualAcquisitionDisplay.this.imageChangedUpdate();
                    MMCompositeImage.this.superDraw();
                }
            };
            this.updater2.post(runnable);
        }

        public void drawWithoutUpdate() {
            Runnable runnable = new Runnable(){

                public void run() {
                    MMCompositeImage.this.getWindow().getCanvas().setImageUpdated();
                    MMCompositeImage.this.superDraw();
                }
            };
            this.updater3.post(runnable);
        }
    }

    public static interface IMMImagePlus {
        public int getNChannelsUnverified();

        public int getNSlicesUnverified();

        public int getNFramesUnverified();

        public void setNChannelsUnverified(int var1);

        public void setNSlicesUnverified(int var1);

        public void setNFramesUnverified(int var1);

        public void drawWithoutUpdate();

        public void updateAndDrawWithoutGUIUpdater();
    }
}

