/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.MultipageTiffReader;
import org.micromanager.acquisition.MultipageTiffWriter;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedImageStorageMultipageTiff
implements TaggedImageStorage {
    private JSONObject summaryMetadata_;
    private JSONObject displayAndComments_;
    private boolean newDataSet_;
    private String directory_;
    private Thread shutdownHook_;
    private int lastFrame_ = -1;
    private int numPositions_;
    private CachedImages cached_;
    private HashMap<Integer, Integer> numFiles_;
    private HashMap<Integer, MultipageTiffWriter> tiffWritersByPosition_;
    private HashMap<Integer, MultipageTiffReader> tiffReadersByPosition_;
    private HashMap<String, MultipageTiffReader> tiffReadersByLabel_;

    public TaggedImageStorageMultipageTiff(String string, Boolean bl, JSONObject jSONObject) {
        this.summaryMetadata_ = jSONObject;
        this.newDataSet_ = bl;
        this.directory_ = string;
        this.tiffReadersByLabel_ = new HashMap();
        this.cached_ = new CachedImages();
        System.out.println("MP Start: " + System.currentTimeMillis());
        if (this.summaryMetadata_ != null) {
            this.displayAndComments_ = VirtualAcquisitionDisplay.getDisplaySettingsFromSummary(jSONObject);
            try {
                this.numPositions_ = MDUtils.getNumPositions(jSONObject);
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError(jSONException);
            }
        }
        if (!this.newDataSet_) {
            this.openExistingDataSet();
        }
        this.shutdownHook_ = new Thread(){

            public void run() {
                TaggedImageStorageMultipageTiff.this.writeDisplaySettings();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook_);
    }

    private void openExistingDataSet() {
        MultipageTiffReader multipageTiffReader = null;
        File file = new File(this.directory_);
        for (File file2 : file.listFiles()) {
            if (!file2.getName().endsWith(".tif")) continue;
            multipageTiffReader = new MultipageTiffReader(file2);
            Set<String> set = multipageTiffReader.getIndexKeys();
            for (String string : set) {
                this.tiffReadersByLabel_.put(string, multipageTiffReader);
                int n = Integer.parseInt(string.split("_")[2]);
                this.lastFrame_ = Math.max(n, this.lastFrame_);
            }
        }
        try {
            this.summaryMetadata_ = multipageTiffReader.getSummaryMetadata();
            this.numPositions_ = MDUtils.getNumPositions(this.summaryMetadata_);
            this.displayAndComments_ = multipageTiffReader.getDisplayAndComments();
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
    }

    @Override
    public TaggedImage getImage(int n, int n2, int n3, int n4) {
        String string = MDUtils.generateLabel(n, n2, n3, n4);
        TaggedImage taggedImage = this.cached_.get(string);
        if (taggedImage != null) {
            return taggedImage;
        }
        if (!this.tiffReadersByLabel_.containsKey(string)) {
            return null;
        }
        return this.tiffReadersByLabel_.get(string).readImage(string);
    }

    @Override
    public JSONObject getImageTags(int n, int n2, int n3, int n4) {
        String string = MDUtils.generateLabel(n, n2, n3, n4);
        TaggedImage taggedImage = this.cached_.get(string);
        if (taggedImage != null) {
            return taggedImage.tags;
        }
        if (!this.tiffReadersByLabel_.containsKey(string)) {
            return null;
        }
        return this.tiffReadersByLabel_.get((Object)string).readImage((String)string).tags;
    }

    private String createFilename(int n, int n2) {
        String string = "";
        try {
            String string2 = this.summaryMetadata_.getString("Prefix");
            string = string2.length() == 0 ? "images" : string2 + "_images";
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError("Can't find Prefix in summary metadata");
            string = "images";
        }
        if (this.numPositions_ > 0) {
            string = string + "_" + n;
        }
        if (n2 > 0) {
            string = string + "_" + n2;
        }
        string = string + ".tif";
        return string;
    }

    @Override
    public void putImage(TaggedImage taggedImage) throws MMException {
        int n;
        Object object;
        if (!this.newDataSet_) {
            throw new MMException("This ImageFileManager is read-only.");
        }
        int n2 = 0;
        try {
            n2 = MDUtils.getPositionIndex(taggedImage.tags);
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
        String string = MDUtils.getLabel(taggedImage.tags);
        if (this.tiffWritersByPosition_ == null) {
            try {
                this.tiffWritersByPosition_ = new HashMap();
                this.tiffReadersByPosition_ = new HashMap();
                this.numFiles_ = new HashMap();
                JavaUtils.createDirectory(this.directory_);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        if (this.tiffWritersByPosition_.get(n2) != null && !this.tiffWritersByPosition_.get(n2).hasSpaceToWrite(taggedImage)) {
            try {
                this.tiffWritersByPosition_.get(n2).close();
                this.tiffReadersByPosition_.get(n2).finishedWriting();
            }
            catch (IOException iOException) {
                ReportingUtils.logError(iOException);
            }
        }
        int n3 = 0;
        if (this.tiffWritersByPosition_.containsKey(n2) && this.tiffWritersByPosition_.get(n2).isClosed()) {
            n3 = this.numFiles_.get(n2) + 1;
        }
        if (this.tiffWritersByPosition_.get(n2) == null || this.tiffWritersByPosition_.get(n2).isClosed()) {
            this.numFiles_.put(n2, n3);
            String string2 = this.createFilename(n2, n3);
            File file = new File(this.directory_ + "/" + string2);
            object = new MultipageTiffWriter(file, this.summaryMetadata_, taggedImage);
            this.tiffWritersByPosition_.put(n2, (MultipageTiffWriter)object);
            this.tiffReadersByPosition_.put(n2, new MultipageTiffReader(this.summaryMetadata_, (MultipageTiffWriter)object));
        }
        try {
            long l = this.tiffWritersByPosition_.get(n2).writeImage(taggedImage);
            object = this.tiffReadersByPosition_.get(n2);
            ((MultipageTiffReader)object).addToIndexMap(taggedImage, l);
            this.tiffReadersByLabel_.put(string, (MultipageTiffReader)object);
        }
        catch (IOException iOException) {
            ReportingUtils.logError(iOException);
        }
        try {
            n = MDUtils.getFrameIndex(taggedImage.tags);
        }
        catch (JSONException jSONException) {
            n = 0;
        }
        this.cached_.add(taggedImage, string);
        this.lastFrame_ = Math.max(this.lastFrame_, n);
    }

    @Override
    public Set<String> imageKeys() {
        return this.tiffReadersByLabel_.keySet();
    }

    @Override
    public void finished() {
        this.newDataSet_ = false;
        try {
            if (this.tiffWritersByPosition_ != null) {
                for (Integer n : this.tiffWritersByPosition_.keySet()) {
                    MultipageTiffWriter multipageTiffWriter = this.tiffWritersByPosition_.get(n);
                    if (multipageTiffWriter.isClosed()) continue;
                    multipageTiffWriter.close();
                    this.tiffReadersByPosition_.get(n).finishedWriting();
                }
            }
            System.out.println("MP End: " + System.currentTimeMillis());
        }
        catch (IOException iOException) {
            ReportingUtils.logError(iOException);
        }
    }

    @Override
    public boolean isFinished() {
        return !this.newDataSet_;
    }

    @Override
    public void setSummaryMetadata(JSONObject jSONObject) {
        this.summaryMetadata_ = jSONObject;
        this.displayAndComments_ = VirtualAcquisitionDisplay.getDisplaySettingsFromSummary(this.summaryMetadata_);
        try {
            this.numPositions_ = MDUtils.getNumPositions(jSONObject);
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    @Override
    public JSONObject getDisplayAndComments() {
        return this.displayAndComments_;
    }

    @Override
    public void setDisplayAndComments(JSONObject jSONObject) {
        this.displayAndComments_ = jSONObject;
    }

    @Override
    public void writeDisplaySettings() {
        for (MultipageTiffReader multipageTiffReader : new HashSet<MultipageTiffReader>(this.tiffReadersByLabel_.values())) {
            try {
                multipageTiffReader.rewriteDisplaySettings(this.displayAndComments_.getJSONArray("Channels"));
                multipageTiffReader.rewriteComments(this.displayAndComments_.getJSONObject("Comments"));
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("Error writing display settings");
            }
            catch (IOException iOException) {
                ReportingUtils.logError(iOException);
            }
        }
    }

    @Override
    public void close() {
        this.shutdownHook_.run();
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook_);
        for (MultipageTiffReader multipageTiffReader : new HashSet<MultipageTiffReader>(this.tiffReadersByLabel_.values())) {
            try {
                multipageTiffReader.close();
            }
            catch (IOException iOException) {
                ReportingUtils.logError(iOException);
            }
        }
    }

    @Override
    public String getDiskLocation() {
        return this.directory_;
    }

    @Override
    public int lastAcquiredFrame() {
        return this.lastFrame_;
    }

    @Override
    public long getDataSetSize() {
        File file = new File(this.directory_);
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                for (File file3 : file2.listFiles()) {
                    linkedList.add(file2);
                }
                continue;
            }
            linkedList.add(file2);
        }
        long l = 0L;
        for (File file2 : linkedList) {
            l += file2.length();
        }
        return l;
    }

    private class CachedImages {
        private static final int NUM_TO_CACHE = 10;
        private LinkedList<TaggedImage> images = new LinkedList();
        private LinkedList<String> labels = new LinkedList();

        public void add(TaggedImage taggedImage, String string) {
            this.images.addFirst(taggedImage);
            this.labels.addFirst(string);
            while (this.images.size() > 10) {
                this.images.removeLast();
                this.labels.removeLast();
            }
        }

        public TaggedImage get(String string) {
            int n = this.labels.indexOf(string);
            return n == -1 ? null : this.images.get(n);
        }
    }
}

