/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;

public class ScrollbarIcon
extends Canvas
implements MouseListener {
    private static final int WIDTH = 24;
    private static final int HEIGHT = 14;
    private BasicStroke stroke = new BasicStroke(2.0f);
    private char type;
    private VirtualAcquisitionDisplay virtAcq_;

    public ScrollbarIcon(char c, VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        this.virtAcq_ = virtualAcquisitionDisplay;
        this.addMouseListener(this);
        this.setSize(24, 14);
        this.type = c;
    }

    public Dimension getPreferredSize() {
        return new Dimension(24, 14);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 24, 14);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.type == 'z' || this.type == 't') {
            this.drawPlayPauseButton(graphics2D);
            this.drawLetter(graphics);
        } else {
            this.drawCenteredLetter(graphics);
        }
    }

    private void drawCenteredLetter(Graphics graphics) {
        graphics.setFont(new Font("SansSerif", 0, 14));
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf(this.type), 8, 12);
    }

    private void drawLetter(Graphics graphics) {
        graphics.setFont(new Font("SansSerif", 0, 14));
        graphics.setColor(Color.black);
        graphics.drawString(String.valueOf(this.type), 4, 12);
    }

    private void drawPlayPauseButton(Graphics2D graphics2D) {
        if (this.type == 't' && this.virtAcq_.isTAnimated() || this.type == 'z' && this.virtAcq_.isZAnimated()) {
            graphics2D.setColor(Color.red);
            graphics2D.setStroke(this.stroke);
            graphics2D.drawLine(15, 3, 15, 11);
            graphics2D.drawLine(20, 3, 20, 11);
        } else {
            graphics2D.setColor(new Color(0, 150, 0));
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(15.0f, 2.0f);
            generalPath.lineTo(22.0f, 7.0f);
            generalPath.lineTo(15.0f, 12.0f);
            generalPath.lineTo(15.0f, 2.0f);
            graphics2D.fill(generalPath);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

