/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.micromanager.api.DataProcessor;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorStack<E> {
    private final List<DataProcessor<E>> processors_;
    private final BlockingQueue<E> input_;
    private final BlockingQueue<E> output_;

    public ProcessorStack(BlockingQueue<E> blockingQueue, List<DataProcessor<E>> list) {
        BlockingQueue<E> blockingQueue2;
        this.processors_ = list;
        BlockingQueue<E> blockingQueue3 = blockingQueue2 = (this.input_ = blockingQueue);
        if (this.processors_ != null) {
            for (DataProcessor<E> dataProcessor : this.processors_) {
                blockingQueue3 = new LinkedBlockingQueue(1);
                dataProcessor.setInput(blockingQueue2);
                dataProcessor.setOutput(blockingQueue3);
                blockingQueue2 = blockingQueue3;
            }
        }
        this.output_ = blockingQueue3;
    }

    public BlockingQueue<E> begin() {
        this.start();
        return this.output_;
    }

    public void start() {
        for (DataProcessor<E> dataProcessor : this.processors_) {
            if (dataProcessor.isAlive()) continue;
            if (dataProcessor.isStarted()) {
                ReportingUtils.showError("Processor: " + dataProcessor.getName() + " is no longer running. Remove and re-insert to get it to go again");
                continue;
            }
            dataProcessor.start();
        }
    }
}

