/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.LinkedList;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipageTiffWriter {
    private static final long BYTES_PER_GIG = 0x40000000L;
    private static final long MAX_FILE_SIZE = 0x100000000L;
    public static final char ENTRIES_PER_IFD = '\r';
    public static final char WIDTH = '\u0100';
    public static final char HEIGHT = '\u0101';
    public static final char BITS_PER_SAMPLE = '\u0102';
    public static final char COMPRESSION = '\u0103';
    public static final char PHOTOMETRIC_INTERPRETATION = '\u0106';
    public static final char IMAGE_DESCRIPTION = '\u010e';
    public static final char STRIP_OFFSETS = '\u0111';
    public static final char SAMPLES_PER_PIXEL = '\u0115';
    public static final char ROWS_PER_STRIP = '\u0116';
    public static final char STRIP_BYTE_COUNTS = '\u0117';
    public static final char X_RESOLUTION = '\u011a';
    public static final char Y_RESOLUTION = '\u011b';
    public static final char RESOLUTION_UNIT = '\u0128';
    public static final char MM_METADATA = '\uc7b3';
    public static final int DISPLAY_SETTINGS_BYTES_PER_CHANNEL = 256;
    private static final long SPACE_FOR_COMMENTS = 0x100000L;
    public static final int INDEX_MAP_OFFSET_HEADER = 54773648;
    public static final int INDEX_MAP_HEADER = 3453623;
    public static final int SUMMARY_MD_HEADER = 2355492;
    public static final int DISPLAY_SETTINGS_OFFSET_HEADER = 483765892;
    public static final int DISPLAY_SETTINGS_HEADER = 347834724;
    public static final int COMMENTS_OFFSET_HEADER = 99384722;
    public static final int COMMENTS_HEADER = 84720485;
    public static final ByteOrder BYTE_ORDER = ByteOrder.BIG_ENDIAN;
    private RandomAccessFile raFile_;
    private FileChannel fileChannel_;
    private long filePosition_ = 0L;
    private int numChannels_ = 1;
    private int numFrames_ = 1;
    private int numSlices_ = 1;
    private HashMap<String, Long> indexMap_;
    private long nextIFDOffsetLocation_ = -1L;
    private JSONObject displayAndComments_;
    private boolean rgb_ = false;
    private int byteDepth_;
    private int imageWidth_;
    private int imageHeight_;
    private int bytesPerImagePixels_;
    private LinkedList<ByteBuffer> buffers_;

    public MultipageTiffWriter(File file, JSONObject jSONObject, TaggedImage taggedImage) {
        try {
            this.readSummaryMD(jSONObject);
            this.displayAndComments_ = VirtualAcquisitionDisplay.getDisplaySettingsFromSummary(jSONObject);
        }
        catch (MMScriptException mMScriptException) {
            ReportingUtils.logError(mMScriptException);
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError(jSONException);
        }
        long l = Math.min(0x100000000L, (long)(jSONObject.toString().length() + 2000000) + (long)(this.numFrames_ * this.numChannels_ * this.numSlices_) * ((long)this.bytesPerImagePixels_ + 2000L));
        try {
            file.createNewFile();
            this.raFile_ = new RandomAccessFile(file, "rw");
            this.raFile_.setLength(l);
            this.fileChannel_ = this.raFile_.getChannel();
            this.indexMap_ = new HashMap();
            this.buffers_ = new LinkedList();
            this.writeMMHeaderAndSummaryMD(jSONObject);
        }
        catch (IOException iOException) {
            ReportingUtils.logError(iOException);
        }
    }

    public FileChannel getFileChannel() {
        return this.fileChannel_;
    }

    public HashMap<String, Long> getIndexMap() {
        return this.indexMap_;
    }

    private void writeMMHeaderAndSummaryMD(JSONObject jSONObject) throws IOException {
        if (jSONObject.has("Comment")) {
            jSONObject.remove("Comment");
        }
        String string = jSONObject.toString();
        int n = string.length();
        ByteBuffer byteBuffer = ByteBuffer.allocate(40).order(BYTE_ORDER);
        if (BYTE_ORDER.equals(ByteOrder.BIG_ENDIAN)) {
            byteBuffer.asCharBuffer().put(0, '\u4d4d');
        } else {
            byteBuffer.asCharBuffer().put(0, '\u4949');
        }
        byteBuffer.asCharBuffer().put(1, '*');
        byteBuffer.putInt(4, 40 + n);
        byteBuffer.putInt(32, 2355492);
        byteBuffer.putInt(36, n);
        ByteBuffer[] byteBufferArray = new ByteBuffer[]{byteBuffer, ByteBuffer.wrap(this.getBytesFromString(string))};
        this.fileChannel_.write(byteBufferArray);
        this.filePosition_ += (long)(byteBuffer.position() + n);
    }

    public void close() throws IOException {
        this.writeNullOffsetAfterLastImage();
        this.writeIndexMap();
        this.writeDisplaySettings();
        this.writeComments();
        this.raFile_.setLength(this.filePosition_ + 8L);
        this.fileChannel_ = null;
        this.raFile_ = null;
    }

    public boolean hasSpaceToWrite(TaggedImage taggedImage) {
        int n;
        int n2;
        int n3;
        int n4 = taggedImage.tags.toString().length();
        long l = (long)(n4 + (n3 = this.indexMap_.size() * 20 + 8) + (n2 = 176) + this.bytesPerImagePixels_) + 0x100000L + (long)(this.numChannels_ * 256) + (long)(n = 1000000) + this.filePosition_;
        return l < 0x100000000L;
    }

    public boolean isClosed() {
        return this.raFile_ == null;
    }

    public long writeImage(TaggedImage taggedImage) throws IOException {
        long l = this.filePosition_;
        this.writeIFD(taggedImage);
        this.updateIndexMap(taggedImage.tags, l);
        this.writeBuffers();
        return l;
    }

    private void writeBuffers() throws IOException {
        ByteBuffer[] byteBufferArray = new ByteBuffer[this.buffers_.size()];
        for (int i = 0; i < byteBufferArray.length; ++i) {
            byteBufferArray[i] = this.buffers_.removeFirst();
        }
        this.fileChannel_.write(byteBufferArray);
    }

    private void updateIndexMap(JSONObject jSONObject, long l) {
        String string = MDUtils.getLabel(jSONObject);
        this.indexMap_.put(string, l);
    }

    private void writeIFD(TaggedImage taggedImage) throws IOException {
        char c = '\r';
        if (taggedImage.tags.has("Summary")) {
            taggedImage.tags.remove("Summary");
        }
        String string = taggedImage.tags.toString() + " ";
        int n = 2 + c * 12 + 4 + (this.rgb_ ? 6 : 0) + 16 + string.length() + this.bytesPerImagePixels_;
        int n2 = 2 + c * 12 + 4 + (this.rgb_ ? 6 : 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2).order(BYTE_ORDER);
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        long l = this.filePosition_ + 2L + (long)(c * 12) + 4L;
        this.nextIFDOffsetLocation_ = this.filePosition_ + 2L + (long)(c * 12);
        charBuffer.put(0, c);
        this.writeIFDEntry(2, byteBuffer, charBuffer, '\u0100', '\u0004', 1L, this.imageWidth_);
        this.writeIFDEntry(14, byteBuffer, charBuffer, '\u0101', '\u0004', 1L, this.imageHeight_);
        this.writeIFDEntry(26, byteBuffer, charBuffer, '\u0102', '\u0003', this.rgb_ ? 3L : 1L, this.rgb_ ? l : (long)(this.byteDepth_ * 8));
        if (this.rgb_) {
            l += 6L;
        }
        this.writeIFDEntry(38, byteBuffer, charBuffer, '\u0103', '\u0003', 1L, 1L);
        this.writeIFDEntry(50, byteBuffer, charBuffer, '\u0106', '\u0003', 1L, this.rgb_ ? 2L : 1L);
        this.writeIFDEntry(62, byteBuffer, charBuffer, '\u0111', '\u0004', 1L, l);
        this.writeIFDEntry(74, byteBuffer, charBuffer, '\u0115', '\u0003', 1L, this.rgb_ ? 3 : 1);
        this.writeIFDEntry(86, byteBuffer, charBuffer, '\u0116', '\u0003', 1L, this.imageHeight_);
        this.writeIFDEntry(98, byteBuffer, charBuffer, '\u0117', '\u0004', 1L, this.bytesPerImagePixels_);
        this.writeIFDEntry(110, byteBuffer, charBuffer, '\u011a', '\u0005', 1L, l += (long)this.bytesPerImagePixels_);
        this.writeIFDEntry(122, byteBuffer, charBuffer, '\u011b', '\u0005', 1L, l += 8L);
        this.writeIFDEntry(134, byteBuffer, charBuffer, '\u0128', '\u0003', 1L, 3L);
        this.writeIFDEntry(146, byteBuffer, charBuffer, '\uc7b3', '\u0002', string.length(), l += 8L);
        byteBuffer.putInt(158, (int)(l += (long)string.length()));
        if (this.rgb_) {
            charBuffer.put(81, (char)(this.byteDepth_ * 8));
            charBuffer.put(82, (char)(this.byteDepth_ * 8));
            charBuffer.put(83, (char)(this.byteDepth_ * 8));
        }
        this.buffers_.add(byteBuffer);
        this.buffers_.add(this.getPixelBuffer(taggedImage));
        this.buffers_.add(this.getResolutionValuesBuffer(taggedImage));
        this.buffers_.add(ByteBuffer.wrap(this.getBytesFromString(string)));
        this.filePosition_ += (long)n;
    }

    private void writeIFDEntry(int n, ByteBuffer byteBuffer, CharBuffer charBuffer, char c, char c2, long l, long l2) throws IOException {
        charBuffer.put(n / 2, c);
        charBuffer.put(n / 2 + 1, c2);
        byteBuffer.putInt(n + 4, (int)l);
        if (c2 == '\u0003' && l == 1L) {
            charBuffer.put(n / 2 + 4, (char)l2);
            charBuffer.put(n / 2 + 5, '\u0000');
        } else {
            byteBuffer.putInt(n + 8, (int)l2);
        }
    }

    private ByteBuffer getResolutionValuesBuffer(TaggedImage taggedImage) throws IOException {
        long l = 1L;
        long l2 = 1L;
        if (taggedImage.tags.has("PixelSizeUm")) {
            double d = 1.0E-4;
            try {
                d = 1.0E-4 * taggedImage.tags.getDouble("PixelSizeUm");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            double d2 = Math.log10(d);
            if (d2 >= 0.0) {
                l2 = (long)d;
                l = 1L;
            } else {
                l = (long)(1.0 / d);
                l2 = 1L;
            }
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(16).order(BYTE_ORDER);
        byteBuffer.putInt(0, (int)l);
        byteBuffer.putInt(4, (int)l2);
        byteBuffer.putInt(8, (int)l);
        byteBuffer.putInt(12, (int)l2);
        return byteBuffer;
    }

    private void writeNullOffsetAfterLastImage() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(BYTE_ORDER);
        byteBuffer.putInt(0, 0);
        this.fileChannel_.write(byteBuffer, this.nextIFDOffsetLocation_);
    }

    private ByteBuffer getPixelBuffer(TaggedImage taggedImage) throws IOException {
        if (this.rgb_) {
            if (this.byteDepth_ == 1) {
                byte[] byArray = (byte[])taggedImage.pix;
                byte[] byArray2 = new byte[byArray.length * 3 / 4];
                int n = 0;
                for (int i = 0; i < byArray.length; ++i) {
                    if ((i + 1) % 4 == 0) continue;
                    byArray2[n] = byArray[i];
                    ++n;
                }
                return ByteBuffer.wrap(byArray2);
            }
            short[] sArray = (short[])taggedImage.pix;
            short[] sArray2 = new short[sArray.length * 3 / 4];
            int n = 0;
            for (int i = 0; i < sArray.length; ++i) {
                if ((i + 1) % 4 == 0) continue;
                sArray2[n] = sArray[i];
                ++n;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(sArray2.length * 2).order(BYTE_ORDER);
            byteBuffer.asShortBuffer().put(sArray2);
            return byteBuffer;
        }
        if (this.byteDepth_ == 1) {
            return ByteBuffer.wrap((byte[])taggedImage.pix);
        }
        short[] sArray = (short[])taggedImage.pix;
        ByteBuffer byteBuffer = ByteBuffer.allocate(sArray.length * 2).order(BYTE_ORDER);
        byteBuffer.asShortBuffer().put(sArray);
        return byteBuffer;
    }

    private byte[] getBytesFromString(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ReportingUtils.logError("Error encoding String to bytes");
            return null;
        }
    }

    private void writeComments() throws IOException {
        JSONObject jSONObject;
        long l = this.filePosition_;
        try {
            jSONObject = this.displayAndComments_.getJSONObject("Comments");
        }
        catch (JSONException jSONException) {
            jSONObject = new JSONObject();
        }
        String string = jSONObject.toString();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer.putInt(0, 84720485);
        byteBuffer.putInt(4, string.length());
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.getBytesFromString(string));
        this.fileChannel_.write(byteBuffer, this.filePosition_);
        this.fileChannel_.write(byteBuffer2, this.filePosition_ + 8L);
        this.filePosition_ += (long)(8 + string.length());
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer3.putInt(0, 99384722);
        byteBuffer3.putInt(4, (int)l);
        this.fileChannel_.write(byteBuffer3, 24L);
    }

    private void writeDisplaySettings() throws IOException {
        JSONArray jSONArray;
        long l = this.filePosition_;
        try {
            jSONArray = this.displayAndComments_.getJSONArray("Channels");
        }
        catch (JSONException jSONException) {
            jSONArray = new JSONArray();
        }
        int n = this.numChannels_ * 256;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(BYTE_ORDER);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.getBytesFromString(jSONArray.toString()));
        byteBuffer.putInt(0, 347834724);
        byteBuffer.putInt(4, n);
        this.fileChannel_.write(byteBuffer, this.filePosition_);
        this.fileChannel_.write(byteBuffer2, this.filePosition_ + 8L);
        this.filePosition_ += (long)(n + 8);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer3.putInt(0, 483765892);
        byteBuffer3.putInt(4, (int)l);
        this.fileChannel_.write(byteBuffer3, 16L);
    }

    private void writeIndexMap() throws IOException {
        int n = this.indexMap_.size();
        long l = this.filePosition_;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + 20 * n).order(BYTE_ORDER);
        byteBuffer.putInt(0, 3453623);
        byteBuffer.putInt(4, n);
        int n2 = 2;
        for (String string : this.indexMap_.keySet()) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("_")) {
                byteBuffer.putInt(4 * n2, Integer.parseInt(string2));
                ++n2;
            }
            byteBuffer.putInt(4 * n2, this.indexMap_.get(string).intValue());
            ++n2;
        }
        this.fileChannel_.write(byteBuffer, this.filePosition_);
        this.filePosition_ += (long)byteBuffer.capacity();
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8).order(BYTE_ORDER);
        byteBuffer2.putInt(0, 54773648);
        byteBuffer2.putInt(4, (int)l);
        this.fileChannel_.write(byteBuffer2, 8L);
    }

    private void readSummaryMD(JSONObject jSONObject) throws MMScriptException, JSONException {
        this.rgb_ = MDUtils.isRGB(jSONObject);
        this.numChannels_ = MDUtils.getNumChannels(jSONObject);
        this.numFrames_ = MDUtils.getNumFrames(jSONObject);
        this.numSlices_ = MDUtils.getNumSlices(jSONObject);
        this.imageWidth_ = MDUtils.getWidth(jSONObject);
        this.imageHeight_ = MDUtils.getHeight(jSONObject);
        String string = MDUtils.getPixelType(jSONObject);
        this.byteDepth_ = string.equals("GRAY8") || string.equals("RGB32") || string.equals("RGB24") ? 1 : (string.equals("GRAY16") || string.equals("RGB64") ? 2 : (string.equals("GRAY32") ? 3 : 2));
        this.bytesPerImagePixels_ = this.imageHeight_ * this.imageWidth_ * this.byteDepth_ * (this.rgb_ ? 3 : 1);
    }

    private String getIJDescriptionString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("ImageJ=1.46e\n");
        stringBuffer.append("images=" + this.numFrames_ * this.numChannels_ * this.numSlices_ + "\n");
        if (this.numChannels_ > 1) {
            stringBuffer.append("channels=" + this.numChannels_ + "\n");
        }
        if (this.numSlices_ > 1) {
            stringBuffer.append("slices=" + this.numSlices_ + "\n");
        }
        if (this.numFrames_ > 1) {
            stringBuffer.append("frames=" + this.numFrames_ + "\n");
        }
        if (this.numFrames_ > 1 || this.numSlices_ > 1 || this.numChannels_ > 1) {
            stringBuffer.append("hyperstack=true\n");
        }
        if (this.numChannels_ > 1) {
            stringBuffer.append("mode=composite\n");
        }
        stringBuffer.append("unit=um\n");
        if (this.numFrames_ * this.numChannels_ * this.numSlices_ > 1) {
            stringBuffer.append("loop=false\n");
        }
        try {
            JSONObject jSONObject = this.displayAndComments_.getJSONArray("Channels").getJSONObject(0);
            double d = jSONObject.getInt("Min");
            double d2 = jSONObject.getInt("Max");
            stringBuffer.append("min=" + d + "\n");
            stringBuffer.append("max=" + d2 + "\n");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        stringBuffer.append('\u0000');
        return new String(stringBuffer);
    }
}

