/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mmcorej.TaggedImage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.MultipageTiffWriter;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.ProgressBar;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipageTiffReader {
    private static final long BIGGEST_INT_BIT = (long)Math.pow(2.0, 31.0);
    public static final char BITS_PER_SAMPLE = '\u0102';
    public static final char STRIP_OFFSETS = '\u0111';
    public static final char SAMPLES_PER_PIXEL = '\u0115';
    public static final char STRIP_BYTE_COUNTS = '\u0117';
    public static final char MM_METADATA = '\uc7b3';
    private ByteOrder byteOrder_;
    private RandomAccessFile raFile_;
    private FileChannel fileChannel_;
    private JSONObject displayAndComments_;
    private JSONObject summaryMetadata_;
    private int byteDepth_;
    private boolean rgb_;
    private boolean writingFinished_;
    private HashMap<String, Long> indexMap_;

    public MultipageTiffReader(JSONObject jSONObject, MultipageTiffWriter multipageTiffWriter) {
        this.displayAndComments_ = new JSONObject();
        this.fileChannel_ = multipageTiffWriter.getFileChannel();
        this.summaryMetadata_ = jSONObject;
        this.indexMap_ = multipageTiffWriter.getIndexMap();
        this.byteOrder_ = MultipageTiffWriter.BYTE_ORDER;
        this.getRGBAndByteDepth();
        this.writingFinished_ = false;
    }

    public MultipageTiffReader(File file) {
        try {
            this.displayAndComments_ = new JSONObject();
            this.createFileChannel(file);
            this.writingFinished_ = true;
            long l = this.readHeader();
            try {
                this.readIndexMap();
                this.displayAndComments_.put("Channels", this.readDisplaySettings());
                this.displayAndComments_.put("Comments", this.readComments());
                this.summaryMetadata_ = this.readSummaryMD();
            }
            catch (Exception exception) {
                this.fixInterruptedFile(l);
            }
            this.getRGBAndByteDepth();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fixInterruptedFile(long l) throws IOException, JSONException {
        Object object;
        int n = JOptionPane.showConfirmDialog(null, "This dataset cannot be opened bcause it appears to have \nbeen improperly saved.  Would you like Micro-Manger to attempt to fix it?", "Micro-Manager", 0);
        if (n == 1) {
            return;
        }
        this.summaryMetadata_ = this.readSummaryMD();
        long l2 = l;
        this.indexMap_ = new HashMap();
        final ProgressBar progressBar = new ProgressBar("Fixing dataset", 0, (int)(this.fileChannel_.size() / 2L));
        progressBar.setRange(0, (int)(this.fileChannel_.size() / 2L));
        progressBar.setProgress(0);
        progressBar.setVisible(true);
        while (l2 > 0L) {
            try {
                IFDData iFDData = this.readIFD(l2);
                TaggedImage taggedImage = this.readTaggedImage(iFDData);
                object = null;
                object = MDUtils.getLabel(taggedImage.tags);
                if (object == null) break;
                this.indexMap_.put((String)object, l2);
                final int n2 = (int)(l2 / 2L);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressBar.setProgress(n2);
                    }
                });
                l2 = iFDData.nextIFD;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        progressBar.setVisible(false);
        long l3 = this.writeIndexMap(l2);
        object = VirtualAcquisitionDisplay.getDisplaySettingsFromSummary(this.summaryMetadata_);
        JSONArray jSONArray = ((JSONObject)object).getJSONArray("Channels");
        JSONObject jSONObject = ((JSONObject)object).getJSONObject("Comments");
        l3 = this.writeDisplaySettings(l3, jSONArray);
        this.writeComments(l3, jSONObject);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isMMMultipageTiff(String string) throws IOException {
        void var7_13;
        RandomAccessFile randomAccessFile;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        File file2 = null;
        for (File object2 : fileArray) {
            if (object2.isDirectory()) {
                File file3;
                int n = 0;
                File[] fileArray2 = object2.listFiles();
                File[] fileArray3 = fileArray2;
                int n2 = fileArray3.length;
                if (n >= n2 || !(file3 = fileArray3[n]).getName().endsWith(".tif")) continue;
                file2 = file3;
                continue;
            }
            if (!object2.getName().endsWith(".tif")) continue;
            file2 = object2;
            break;
        }
        if (file2 == null) {
            throw new IOException("Unexpected file structure: is this an MM dataset?");
        }
        try {
            randomAccessFile = new RandomAccessFile(file2, "r");
        }
        catch (FileNotFoundException fileNotFoundException) {
            ReportingUtils.logError(fileNotFoundException);
            return false;
        }
        FileChannel fileChannel = randomAccessFile.getChannel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(36);
        fileChannel.read(byteBuffer, 0L);
        char c = byteBuffer.getChar(0);
        if (c == '\u4949') {
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else if (c == '\u4d4d') {
            ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        } else {
            throw new IOException("Error reading Tiff header");
        }
        byteBuffer.order((ByteOrder)var7_13);
        int n = byteBuffer.getInt(32);
        fileChannel.close();
        randomAccessFile.close();
        return n == 2355492;
    }

    public void finishedWriting() {
        this.writingFinished_ = true;
    }

    private void getRGBAndByteDepth() {
        try {
            String string = MDUtils.getPixelType(this.summaryMetadata_);
            this.rgb_ = string.startsWith("RGB");
            this.byteDepth_ = string.equals("RGB32") || string.equals("GRAY8") ? 1 : 2;
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
        }
    }

    public void addToIndexMap(TaggedImage taggedImage, long l) {
        this.indexMap_.put(MDUtils.getLabel(taggedImage.tags), l);
    }

    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    public JSONObject getDisplayAndComments() {
        return this.displayAndComments_;
    }

    public TaggedImage readImage(String string) {
        if (this.indexMap_.containsKey(string)) {
            try {
                long l = this.indexMap_.get(string);
                IFDData iFDData = this.readIFD(l);
                return this.readTaggedImage(iFDData);
            }
            catch (IOException iOException) {
                ReportingUtils.logError(iOException);
                return null;
            }
        }
        return null;
    }

    public Set<String> getIndexKeys() {
        if (this.indexMap_ == null) {
            return null;
        }
        return this.indexMap_.keySet();
    }

    private JSONObject readSummaryMD() throws IOException, JSONException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(this.byteOrder_);
        this.fileChannel_.read(byteBuffer, 32L);
        int n = byteBuffer.getInt(0);
        int n2 = byteBuffer.getInt(4);
        if (n != 2355492) {
            ReportingUtils.logError("Summary Metadata Header Incorrect");
            return null;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
        this.fileChannel_.read(byteBuffer2, 40L);
        JSONObject jSONObject = new JSONObject(this.getString(byteBuffer2));
        if (this.displayAndComments_ != null && this.displayAndComments_.has("Comments") && this.displayAndComments_.getJSONObject("Comments").has("Summary")) {
            jSONObject.put("Comment", this.displayAndComments_.getJSONObject("Comments").getString("Summary"));
        }
        return jSONObject;
    }

    private JSONObject readComments() throws IOException, JSONException, MMException {
        long l = this.readOffsetHeaderAndOffset(99384722, 24);
        ByteBuffer byteBuffer = this.readIntoBuffer(l, 8);
        if (byteBuffer.getInt(0) != 84720485) {
            throw new MMException("Error reading comments header");
        }
        ByteBuffer byteBuffer2 = this.readIntoBuffer(l + 8L, byteBuffer.getInt(4));
        return new JSONObject(this.getString(byteBuffer2));
    }

    public void rewriteComments(JSONObject jSONObject) throws IOException, JSONException {
        if (this.writingFinished_) {
            byte[] byArray = this.getBytesFromString(jSONObject.toString());
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[4]).order(this.byteOrder_).putInt(0, byArray.length);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            long l = this.readOffsetHeaderAndOffset(99384722, 24);
            this.fileChannel_.write(byteBuffer, l + 4L);
            this.fileChannel_.write(byteBuffer2, l + 8L);
        }
        this.displayAndComments_.put("Comments", jSONObject);
    }

    public void rewriteDisplaySettings(JSONArray jSONArray) throws IOException, JSONException {
        if (this.writingFinished_) {
            long l = this.readOffsetHeaderAndOffset(483765892, 16);
            int n = this.readIntoBuffer(l + 4L, 4).getInt(0);
            byte[] byArray = new byte[n];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = 0;
            }
            this.fileChannel_.write(ByteBuffer.wrap(byArray), l + 8L);
            byte[] byArray2 = this.getBytesFromString(jSONArray.toString());
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            this.fileChannel_.write(byteBuffer, l + 8L);
        }
        this.displayAndComments_.put("Channels", jSONArray);
    }

    private JSONArray readDisplaySettings() throws IOException, JSONException, MMException {
        long l = this.readOffsetHeaderAndOffset(483765892, 16);
        ByteBuffer byteBuffer = this.readIntoBuffer(l, 8);
        if (byteBuffer.getInt(0) != 347834724) {
            throw new MMException("Error reading display settings header");
        }
        ByteBuffer byteBuffer2 = this.readIntoBuffer(l + 8L, byteBuffer.getInt(4));
        return new JSONArray(this.getString(byteBuffer2));
    }

    private ByteBuffer readIntoBuffer(long l, int n) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n).order(this.byteOrder_);
        this.fileChannel_.read(byteBuffer, l);
        return byteBuffer;
    }

    private long readOffsetHeaderAndOffset(int n, int n2) throws IOException {
        ByteBuffer byteBuffer = this.readIntoBuffer(n2, 8);
        int n3 = byteBuffer.getInt(0);
        if (n3 != n) {
            throw new IOException("Offset header incorrect, expected: " + n + "   found: " + n3);
        }
        return this.unsignInt(byteBuffer.getInt(4));
    }

    private void readIndexMap() throws IOException, MMException {
        long l = this.readOffsetHeaderAndOffset(54773648, 8);
        ByteBuffer byteBuffer = this.readIntoBuffer(l, 8);
        if (byteBuffer.getInt(0) != 3453623) {
            throw new MMException("Error reading index map header");
        }
        int n = byteBuffer.getInt(4);
        this.indexMap_ = new HashMap();
        ByteBuffer byteBuffer2 = this.readIntoBuffer(l + 8L, 20 * n);
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer2.getInt(i * 20);
            int n3 = byteBuffer2.getInt(i * 20 + 4);
            int n4 = byteBuffer2.getInt(i * 20 + 8);
            int n5 = byteBuffer2.getInt(i * 20 + 12);
            long l2 = this.unsignInt(byteBuffer2.getInt(i * 20 + 16));
            this.indexMap_.put(MDUtils.generateLabel(n2, n3, n4, n5), l2);
        }
    }

    private IFDData readIFD(long l) throws IOException {
        ByteBuffer byteBuffer = this.readIntoBuffer(l, 2);
        int n = byteBuffer.getChar(0);
        ByteBuffer byteBuffer2 = this.readIntoBuffer(l + 2L, n * 12 + 4).order(this.byteOrder_);
        IFDData iFDData = new IFDData();
        for (int i = 0; i < n; ++i) {
            IFDEntry iFDEntry = this.readDirectoryEntry(i * 12, byteBuffer2);
            if (iFDEntry.tag == '\uc7b3') {
                iFDData.mdOffset = iFDEntry.value;
                iFDData.mdLength = iFDEntry.count;
                continue;
            }
            if (iFDEntry.tag == '\u0111') {
                iFDData.pixelOffset = iFDEntry.value;
                continue;
            }
            if (iFDEntry.tag != '\u0117') continue;
            iFDData.bytesPerImage = iFDEntry.value;
        }
        iFDData.nextIFD = this.unsignInt(byteBuffer2.getInt(n * 12));
        return iFDData;
    }

    private String getString(ByteBuffer byteBuffer) {
        try {
            return new String(byteBuffer.array(), "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ReportingUtils.logError(unsupportedEncodingException);
            return "";
        }
    }

    private TaggedImage readTaggedImage(IFDData iFDData) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)iFDData.bytesPerImage);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate((int)iFDData.mdLength);
        this.fileChannel_.read(byteBuffer, iFDData.pixelOffset);
        this.fileChannel_.read(byteBuffer2, iFDData.mdOffset);
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject(this.getString(byteBuffer2));
        }
        catch (JSONException jSONException) {
            ReportingUtils.logError("Error reading image metadata from file");
        }
        if (this.rgb_) {
            if (this.byteDepth_ == 1) {
                byte[] byArray = new byte[(int)(4L * iFDData.bytesPerImage / 3L)];
                int n = 0;
                byte[] byArray2 = byteBuffer.array();
                int n2 = byArray2.length;
                for (int i = 0; i < n2; ++i) {
                    byte by;
                    byArray[n] = by = byArray2[i];
                    if ((++n + 1) % 4 != 0) continue;
                    byArray[n] = 0;
                    ++n;
                }
                return new TaggedImage(byArray, jSONObject);
            }
            short[] sArray = new short[(int)(2L * (iFDData.bytesPerImage / 3L))];
            int n = 0;
            while (n < sArray.length) {
                sArray[n] = byteBuffer.getShort(2 * (n / 4 * 3 + n % 4));
                if ((++n + 1) % 4 != 0) continue;
                sArray[n] = 0;
                ++n;
            }
            return new TaggedImage(sArray, jSONObject);
        }
        if (this.byteDepth_ == 1) {
            return new TaggedImage(byteBuffer.array(), jSONObject);
        }
        short[] sArray = new short[byteBuffer.capacity() / 2];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = byteBuffer.getShort(i * 2);
        }
        return new TaggedImage(sArray, jSONObject);
    }

    private IFDEntry readDirectoryEntry(int n, ByteBuffer byteBuffer) throws IOException {
        char c = byteBuffer.getChar(n);
        char c2 = byteBuffer.getChar(n + 2);
        long l = this.unsignInt(byteBuffer.getInt(n + 4));
        long l2 = c2 == '\u0003' && l == 1L ? (long)byteBuffer.getChar(n + 8) : this.unsignInt(byteBuffer.getInt(n + 8));
        return new IFDEntry(c, c2, l, l2);
    }

    private long readHeader() throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        this.fileChannel_.read(byteBuffer, 0L);
        char c = byteBuffer.getChar(0);
        if (c == '\u4949') {
            this.byteOrder_ = ByteOrder.LITTLE_ENDIAN;
        } else if (c == '\u4d4d') {
            this.byteOrder_ = ByteOrder.BIG_ENDIAN;
        } else {
            throw new IOException("Error reading Tiff header");
        }
        byteBuffer.order(this.byteOrder_);
        short s = byteBuffer.getShort(2);
        if (s != 42) {
            throw new IOException("Tiff identifier code incorrect");
        }
        return this.unsignInt(byteBuffer.getInt(4));
    }

    private byte[] getBytesFromString(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ReportingUtils.logError("Error encoding String to bytes");
            return null;
        }
    }

    private void createFileChannel(File file) throws FileNotFoundException, IOException {
        this.raFile_ = new RandomAccessFile(file, "rw");
        this.fileChannel_ = this.raFile_.getChannel();
    }

    public void close() throws IOException {
        if (this.fileChannel_ != null) {
            this.fileChannel_.close();
            this.fileChannel_ = null;
        }
        if (this.raFile_ != null) {
            this.raFile_.close();
            this.raFile_ = null;
        }
    }

    private long writeIndexMap(long l) throws IOException {
        int n = this.indexMap_.size();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 + 20 * n).order(this.byteOrder_);
        byteBuffer.putInt(0, 3453623);
        byteBuffer.putInt(4, n);
        int n2 = 2;
        for (String string : this.indexMap_.keySet()) {
            String[] stringArray;
            for (String string2 : stringArray = string.split("_")) {
                byteBuffer.putInt(4 * n2, Integer.parseInt(string2));
                ++n2;
            }
            byteBuffer.putInt(4 * n2, this.indexMap_.get(string).intValue());
            ++n2;
        }
        this.fileChannel_.write(byteBuffer, l);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(8).order(this.byteOrder_);
        byteBuffer2.putInt(0, 54773648);
        byteBuffer2.putInt(4, (int)l);
        this.fileChannel_.write(byteBuffer2, 8L);
        return l + (long)(20 * this.indexMap_.keySet().size());
    }

    private long writeDisplaySettings(long l, JSONArray jSONArray) throws IOException, JSONException {
        int n;
        try {
            n = MDUtils.getNumChannels(this.summaryMetadata_);
        }
        catch (Exception exception) {
            n = 7;
        }
        int n2 = n * 256;
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(this.byteOrder_);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.getBytesFromString(jSONArray.toString()));
        byteBuffer.putInt(0, 347834724);
        byteBuffer.putInt(4, n2);
        this.fileChannel_.write(byteBuffer, l);
        this.fileChannel_.write(byteBuffer2, l + 8L);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(8).order(this.byteOrder_);
        byteBuffer3.putInt(0, 483765892);
        byteBuffer3.putInt(4, (int)l);
        this.fileChannel_.write(byteBuffer3, 16L);
        return l + (long)n2 + 8L;
    }

    private void writeComments(long l, JSONObject jSONObject) throws IOException {
        String string = jSONObject.toString();
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(this.byteOrder_);
        byteBuffer.putInt(0, 84720485);
        byteBuffer.putInt(4, string.length());
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(this.getBytesFromString(string));
        this.fileChannel_.write(byteBuffer, l);
        this.fileChannel_.write(byteBuffer2, l + 8L);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(8).order(this.byteOrder_);
        byteBuffer3.putInt(0, 99384722);
        byteBuffer3.putInt(4, (int)l);
        this.fileChannel_.write(byteBuffer3, 24L);
    }

    private long unsignInt(int n) {
        long l = Integer.MAX_VALUE & n;
        if (n < 0) {
            l += BIGGEST_INT_BIT;
        }
        return l;
    }

    private class IFDEntry {
        public char tag;
        public char type;
        public long count;
        public long value;

        public IFDEntry(char c, char c2, long l, long l2) {
            this.tag = c;
            this.type = c2;
            this.count = l;
            this.value = l2;
        }
    }

    private class IFDData {
        public long pixelOffset;
        public long bytesPerImage;
        public long mdOffset;
        public long mdLength;
        public long nextIFD;
    }
}

