/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.IJ;
import java.text.NumberFormat;
import java.util.Timer;
import java.util.TimerTask;
import mmcorej.CMMCore;
import mmcorej.TaggedImage;
import org.json.JSONException;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;

public class LiveModeTimer {
    private static final String CCHANNELINDEX = "CameraChannelIndex";
    private static final String ACQ_NAME = "Snap/Live Window";
    private VirtualAcquisitionDisplay win_;
    private CMMCore core_;
    private MMStudioMainFrame gui_ = MMStudioMainFrame.getInstance();
    private long multiChannelCameraNrCh_;
    private long fpsTimer_;
    private long fpsCounter_;
    private long imageNumber_;
    private long lastImageNumber_;
    private long fpsInterval_ = 5000L;
    private final NumberFormat format_;
    private boolean running_ = false;
    private Timer timer_;
    private TimerTask task_;

    public LiveModeTimer() {
        this.core_ = this.gui_.getCore();
        this.format_ = NumberFormat.getInstance();
        this.format_.setMaximumFractionDigits(1);
    }

    private long getInterval() {
        double d = 20.0;
        try {
            d = Math.max(this.core_.getExposure(), d);
        }
        catch (Exception exception) {
            ReportingUtils.logError("Unable to get exposure from core");
        }
        this.fpsInterval_ = (long)(20.0 * d);
        if (this.fpsInterval_ < 1000L) {
            this.fpsInterval_ = 1000L;
        }
        return (int)d;
    }

    private void setType() {
        this.multiChannelCameraNrCh_ = this.core_.getNumberOfCameraChannels();
        this.task_ = this.multiChannelCameraNrCh_ == 1L ? this.singleCameraLiveTask() : this.multiCamLiveTask();
    }

    public boolean isRunning() {
        return this.running_;
    }

    public void begin() throws Exception {
        long l;
        if (this.running_) {
            return;
        }
        this.timer_ = new Timer("Live mode timer");
        this.core_.clearCircularBuffer();
        this.core_.startContinuousSequenceAcquisition(0.0);
        this.setType();
        long l2 = this.getInterval();
        long l3 = l = System.currentTimeMillis();
        long l4 = Math.min(10000L, l2 * 150L);
        while (this.core_.getRemainingImageCount() == 0 && l3 - l < l4) {
            l3 = System.currentTimeMillis();
            Thread.sleep(5L);
        }
        if (l3 - l >= l4) {
            throw new Exception("Camera did not send image within a reasonable time");
        }
        TaggedImage taggedImage = this.core_.getLastTaggedImage();
        this.gui_.checkSimpleAcquisition();
        this.win_ = MMStudioMainFrame.getSimpleDisplay();
        this.fpsCounter_ = 0L;
        this.fpsTimer_ = System.currentTimeMillis();
        this.imageNumber_ = taggedImage.tags.getLong("ImageNumber");
        this.lastImageNumber_ = this.imageNumber_ - 1L;
        this.timer_.schedule(this.task_, 0L, l2);
        this.win_.liveModeEnabled(true);
        this.win_.getImagePlus().getWindow().toFront();
        this.running_ = true;
    }

    public void stop() {
        this.stop(true);
    }

    private void stop(boolean bl) {
        block3: {
            this.timer_.cancel();
            try {
                this.core_.stopSequenceAcquisition();
                if (this.win_ != null) {
                    this.win_.liveModeEnabled(false);
                }
                this.running_ = false;
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
                if (!bl) break block3;
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    public void run() {
                        LiveModeTimer.this.stop(false);
                    }
                }, 1000L);
            }
        }
    }

    private void updateFPS(long l) {
        try {
            ++this.fpsCounter_;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - this.fpsTimer_;
            if (l3 > this.fpsInterval_) {
                double d = (double)l3 / 1000.0;
                double d2 = (double)this.fpsCounter_ / d;
                double d3 = (double)(l - this.imageNumber_) / d;
                IJ.showStatus((String)("fps: " + this.format_.format(d3) + ", display fps: " + this.format_.format(d2)));
                this.fpsCounter_ = 0L;
                this.fpsTimer_ = l2;
                this.imageNumber_ = l;
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    private TimerTask singleCameraLiveTask() {
        return new TimerTask(){

            public void run() {
                if (LiveModeTimer.this.core_.getRemainingImageCount() == 0) {
                    return;
                }
                if (LiveModeTimer.this.win_.windowClosed()) {
                    LiveModeTimer.this.gui_.enableLiveMode(false);
                } else {
                    try {
                        TaggedImage taggedImage = LiveModeTimer.this.core_.getLastTaggedImage();
                        long l = taggedImage.tags.getLong("ImageNumber");
                        if (l == LiveModeTimer.this.lastImageNumber_) {
                            return;
                        }
                        LiveModeTimer.this.lastImageNumber_ = l;
                        LiveModeTimer.this.addTags(taggedImage, 0);
                        LiveModeTimer.this.gui_.addImage(LiveModeTimer.ACQ_NAME, taggedImage, true, true);
                        LiveModeTimer.this.gui_.updateLineProfile();
                        LiveModeTimer.this.updateFPS(taggedImage.tags.getLong("ImageNumber"));
                    }
                    catch (MMScriptException mMScriptException) {
                        ReportingUtils.showError(mMScriptException);
                        LiveModeTimer.this.gui_.enableLiveMode(false);
                    }
                    catch (JSONException jSONException) {
                        ReportingUtils.showError(jSONException, "Problem with image tags");
                        LiveModeTimer.this.gui_.enableLiveMode(false);
                    }
                    catch (Exception exception) {
                        ReportingUtils.showError("Couldn't get tagged image from core");
                        LiveModeTimer.this.gui_.enableLiveMode(false);
                    }
                }
            }
        };
    }

    private TimerTask multiCamLiveTask() {
        return new TimerTask(){

            public void run() {
                if (LiveModeTimer.this.core_.getRemainingImageCount() == 0) {
                    return;
                }
                if (LiveModeTimer.this.win_.windowClosed() || !LiveModeTimer.this.gui_.acquisitionExists(LiveModeTimer.ACQ_NAME).booleanValue()) {
                    LiveModeTimer.this.gui_.enableLiveMode(false);
                } else {
                    try {
                        TaggedImage[] taggedImageArray = new TaggedImage[(int)LiveModeTimer.this.multiChannelCameraNrCh_];
                        String string = LiveModeTimer.this.core_.getCameraDevice();
                        TaggedImage taggedImage = LiveModeTimer.this.core_.getLastTaggedImage();
                        long l = taggedImage.tags.getLong("ImageNumber");
                        if (l == LiveModeTimer.this.lastImageNumber_) {
                            return;
                        }
                        LiveModeTimer.this.lastImageNumber_ = l;
                        int n = taggedImage.tags.getInt(string + "-" + LiveModeTimer.CCHANNELINDEX);
                        taggedImageArray[n] = taggedImage;
                        int n2 = 1;
                        for (int i = 1; n2 < taggedImageArray.length && i <= 2 * taggedImageArray.length; ++i) {
                            try {
                                taggedImage = LiveModeTimer.this.core_.getNBeforeLastTaggedImage(i);
                                n = taggedImage.tags.getInt(string + "-" + LiveModeTimer.CCHANNELINDEX);
                            }
                            catch (Exception exception) {
                                break;
                            }
                            if (taggedImageArray[n] == null) {
                                ++n2;
                            }
                            taggedImageArray[n] = taggedImage;
                        }
                        if (n2 == taggedImageArray.length) {
                            for (n = 0; n < taggedImageArray.length; ++n) {
                                taggedImage = taggedImageArray[n];
                                taggedImage.tags.put("Channel", LiveModeTimer.this.core_.getCameraChannelName(n));
                                LiveModeTimer.this.addTags(taggedImage, n);
                            }
                            int n3 = LiveModeTimer.this.win_.getHyperImage().getChannel() - 1;
                            for (int i = 0; i < taggedImageArray.length; ++i) {
                                if (i == n3) continue;
                                LiveModeTimer.this.gui_.addImage(LiveModeTimer.ACQ_NAME, taggedImageArray[i], false, true);
                            }
                            LiveModeTimer.this.gui_.addImage(LiveModeTimer.ACQ_NAME, taggedImageArray[n3], true, true);
                            LiveModeTimer.this.gui_.updateLineProfile();
                            LiveModeTimer.this.updateFPS(taggedImage.tags.getLong("ImageNumber"));
                        }
                    }
                    catch (MMScriptException mMScriptException) {
                        LiveModeTimer.this.gui_.enableLiveMode(false);
                        ReportingUtils.showError(mMScriptException);
                    }
                    catch (JSONException jSONException) {
                        LiveModeTimer.this.gui_.enableLiveMode(false);
                        ReportingUtils.showError(jSONException, "Problem with image tags");
                    }
                    catch (Exception exception) {
                        LiveModeTimer.this.gui_.enableLiveMode(false);
                        ReportingUtils.showError("Couldn't get tagged image from core");
                    }
                }
            }
        };
    }

    private void addTags(TaggedImage taggedImage, int n) throws JSONException {
        MDUtils.setChannelIndex(taggedImage.tags, n);
        MDUtils.setFrameIndex(taggedImage.tags, 0);
        MDUtils.setPositionIndex(taggedImage.tags, 0);
        MDUtils.setSliceIndex(taggedImage.tags, 0);
        try {
            taggedImage.tags.put("Summary", MMStudioMainFrame.getInstance().getAcquisition(ACQ_NAME).getSummaryMetadata());
        }
        catch (MMScriptException mMScriptException) {
            ReportingUtils.logError("Error adding summary metadata to tags");
        }
        this.gui_.addStagePositionToTags(taggedImage);
    }
}

