/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.layout.GroupLayout;
import org.json.JSONException;
import org.json.JSONObject;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.internalinterfaces.DisplayControls;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

public class HyperstackControls
extends DisplayControls {
    private final VirtualAcquisitionDisplay acq_;
    private JButton abortButton;
    private JTextField fpsField;
    private JLabel fpsLabel;
    private JToggleButton pauseAndResumeToggleButton;
    private JButton saveButton;
    private JButton showFolderButton;
    private JLabel statusLineLabel;

    public HyperstackControls(VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        this.initComponents();
        this.acq_ = virtualAcquisitionDisplay;
        this.fpsField.setText(NumberUtils.doubleToDisplayString(this.acq_.getPlaybackFPS()));
    }

    private void initComponents() {
        this.showFolderButton = new JButton();
        this.saveButton = new JButton();
        this.fpsField = new JTextField();
        this.fpsLabel = new JLabel();
        this.abortButton = new JButton();
        this.statusLineLabel = new JLabel();
        this.pauseAndResumeToggleButton = new JToggleButton();
        this.setPreferredSize(new Dimension(512, 30));
        this.showFolderButton.setBackground(new Color(255, 255, 255));
        this.showFolderButton.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/folder.png")));
        this.showFolderButton.setToolTipText("Show containing folder");
        this.showFolderButton.setFocusable(false);
        this.showFolderButton.setHorizontalTextPosition(0);
        this.showFolderButton.setMaximumSize(new Dimension(30, 28));
        this.showFolderButton.setMinimumSize(new Dimension(30, 28));
        this.showFolderButton.setPreferredSize(new Dimension(30, 28));
        this.showFolderButton.setVerticalTextPosition(3);
        this.showFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HyperstackControls.this.showFolderButtonActionPerformed(actionEvent);
            }
        });
        this.saveButton.setBackground(new Color(255, 255, 255));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/disk.png")));
        this.saveButton.setToolTipText("Save as...");
        this.saveButton.setFocusable(false);
        this.saveButton.setHorizontalTextPosition(0);
        this.saveButton.setMaximumSize(new Dimension(30, 28));
        this.saveButton.setMinimumSize(new Dimension(30, 28));
        this.saveButton.setPreferredSize(new Dimension(30, 28));
        this.saveButton.setVerticalTextPosition(3);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HyperstackControls.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.fpsField.setToolTipText("Set the speed at which the acquisition is played back.");
        this.fpsField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                HyperstackControls.this.fpsFieldFocusLost(focusEvent);
            }
        });
        this.fpsField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                HyperstackControls.this.fpsFieldKeyReleased(keyEvent);
            }
        });
        this.fpsLabel.setText("playback fps:");
        this.fpsLabel.setFocusable(false);
        this.abortButton.setBackground(new Color(255, 255, 255));
        this.abortButton.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/cancel.png")));
        this.abortButton.setToolTipText("Stop acquisition");
        this.abortButton.setFocusable(false);
        this.abortButton.setHorizontalTextPosition(0);
        this.abortButton.setMaximumSize(new Dimension(30, 28));
        this.abortButton.setMinimumSize(new Dimension(30, 28));
        this.abortButton.setPreferredSize(new Dimension(30, 28));
        this.abortButton.setVerticalTextPosition(3);
        this.abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HyperstackControls.this.abortButtonActionPerformed(actionEvent);
            }
        });
        this.statusLineLabel.setFont(new Font("Lucida Grande", 0, 10));
        this.statusLineLabel.setHorizontalTextPosition(2);
        this.pauseAndResumeToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/control_pause.png")));
        this.pauseAndResumeToggleButton.setToolTipText("Pause acquisition");
        this.pauseAndResumeToggleButton.setFocusable(false);
        this.pauseAndResumeToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.pauseAndResumeToggleButton.setMaximumSize(new Dimension(30, 28));
        this.pauseAndResumeToggleButton.setMinimumSize(new Dimension(30, 28));
        this.pauseAndResumeToggleButton.setPreferredSize(new Dimension(30, 28));
        this.pauseAndResumeToggleButton.setPressedIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/resultset_next.png")));
        this.pauseAndResumeToggleButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/org/micromanager/icons/resultset_next.png")));
        this.pauseAndResumeToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HyperstackControls.this.pauseAndResumeToggleButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.showFolderButton, -2, -1, -2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(30, 30, 30).add((Component)this.saveButton, -2, -1, -2))).addPreferredGap(0).add((Component)this.abortButton, -2, -1, -2).add(0, 0, 0).add((Component)this.pauseAndResumeToggleButton, -2, -1, -2).addPreferredGap(0).add((Component)this.fpsLabel).addPreferredGap(0).add((Component)this.fpsField, -2, 34, -2).addPreferredGap(0).add((Component)this.statusLineLabel, -2, 303, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.statusLineLabel, -1, 28, Short.MAX_VALUE).add((Component)this.showFolderButton, -1, -1, Short.MAX_VALUE).add((Component)this.saveButton, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fpsLabel).add((Component)this.fpsField)).add((Component)this.abortButton, -1, -1, Short.MAX_VALUE).add((Component)this.pauseAndResumeToggleButton, -1, -1, Short.MAX_VALUE));
    }

    private void showFolderButtonActionPerformed(ActionEvent actionEvent) {
        this.acq_.showFolder();
    }

    private void fpsFieldFocusLost(FocusEvent focusEvent) {
        this.updateFPS();
    }

    private void fpsFieldKeyReleased(KeyEvent keyEvent) {
        this.updateFPS();
    }

    private void abortButtonActionPerformed(ActionEvent actionEvent) {
        this.acq_.abort();
    }

    private void pauseAndResumeToggleButtonActionPerformed(ActionEvent actionEvent) {
        this.acq_.pause();
    }

    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        new Thread(){

            public void run() {
                HyperstackControls.this.acq_.saveAs();
            }
        }.start();
    }

    private void updateFPS() {
        try {
            double d = NumberUtils.displayStringToDouble(this.fpsField.getText());
            this.acq_.setPlaybackFPS(d);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public synchronized void setStatusLabel(String string) {
        this.statusLineLabel.setText(string);
    }

    private void updateStatusLine(JSONObject jSONObject) {
        String string = "";
        try {
            String string2;
            try {
                String string3 = jSONObject.getString("PositionName");
                if (string3 != null && !string3.contentEquals("null")) {
                    string = string + string3 + ", ";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string2 = NumberUtils.doubleToDisplayString(jSONObject.getDouble("ElapsedTime-ms") / 1000.0);
                string = string + string2 + " s";
            }
            catch (JSONException jSONException) {
                ReportingUtils.logError("MetaData did not contain ElapsedTime-ms field");
            }
            try {
                string2 = NumberUtils.doubleStringCoreToDisplay(jSONObject.getString("ZPositionUm"));
                string = string + ", z: " + string2 + " um";
            }
            catch (Exception exception) {
                try {
                    string2 = NumberUtils.doubleStringCoreToDisplay(jSONObject.getString("Z-um"));
                    string = string + ", z: " + string2 + " um";
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            try {
                String string4 = MDUtils.getChannelName(jSONObject);
                if (string4 != null && !string4.contentEquals("null")) {
                    string = string + ", " + string4;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setStatusLabel(string);
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    public void newImageUpdate(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        this.updateStatusLine(jSONObject);
        try {
            if (this.acq_.acquisitionIsRunning() && this.acq_.getNextWakeTime() > 0L) {
                final long l = this.acq_.getNextWakeTime();
                if (System.nanoTime() / 1000000L < l) {
                    final Timer timer = new Timer();
                    TimerTask timerTask = new TimerTask(){

                        public void run() {
                            double d = (l - System.nanoTime() / 1000000L) / 1000L;
                            if (d > 0.0 && HyperstackControls.this.acq_.acquisitionIsRunning()) {
                                HyperstackControls.this.setStatusLabel("Next frame: " + NumberUtils.doubleToDisplayString(1.0 + d) + " s");
                            } else {
                                timer.cancel();
                                HyperstackControls.this.setStatusLabel("");
                            }
                        }
                    };
                    timer.schedule(timerTask, 2000L, 100L);
                }
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
    }

    public void acquiringImagesUpdate(boolean bl) {
        this.abortButton.setEnabled(bl);
        this.pauseAndResumeToggleButton.setEnabled(bl);
    }

    public void imagesOnDiskUpdate(boolean bl) {
        this.showFolderButton.setEnabled(bl);
    }
}

