/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.acquisition.LiveAcq;
import org.micromanager.acquisition.MMAcquisition;
import org.micromanager.acquisition.ProcessorStack;
import org.micromanager.acquisition.SequenceSettings;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.IAcquisitionEngine2010;
import org.micromanager.api.ImageCache;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMScriptException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaggedImagePipeline {
    final String acqName_;
    final JSONObject summaryMetadata_;
    final ImageCache imageCache_;
    final VirtualAcquisitionDisplay display_;

    public DefaultTaggedImagePipeline(IAcquisitionEngine2010 iAcquisitionEngine2010, SequenceSettings sequenceSettings, List<DataProcessor<TaggedImage>> list, ScriptInterface scriptInterface, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MMScriptException {
        BlockingQueue<TaggedImage> blockingQueue = iAcquisitionEngine2010.run(sequenceSettings);
        this.summaryMetadata_ = iAcquisitionEngine2010.getSummaryMetadata();
        ProcessorStack<TaggedImage> processorStack = new ProcessorStack<TaggedImage>(blockingQueue, list);
        BlockingQueue<TaggedImage> blockingQueue2 = processorStack.begin();
        this.acqName_ = scriptInterface.createAcquisition(this.summaryMetadata_, bl);
        MMAcquisition mMAcquisition = scriptInterface.getAcquisition(this.acqName_);
        this.display_ = mMAcquisition.getAcquisitionWindow();
        this.imageCache_ = mMAcquisition.getImageCache();
        LiveAcq liveAcq = new LiveAcq(blockingQueue2, this.imageCache_);
        liveAcq.start();
    }
}

