/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.PropertySetting;
import mmcorej.StrVector;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.DefaultTaggedImagePipeline;
import org.micromanager.acquisition.SequenceSettings;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.AcquisitionDisplay;
import org.micromanager.api.AcquisitionEngine;
import org.micromanager.api.DataProcessor;
import org.micromanager.api.IAcquisitionEngine2010;
import org.micromanager.api.ImageCache;
import org.micromanager.api.ScriptInterface;
import org.micromanager.navigation.PositionList;
import org.micromanager.utils.AutofocusManager;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.MMException;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquisitionWrapperEngine
implements AcquisitionEngine {
    private CMMCore core_;
    protected MMStudioMainFrame gui_;
    private PositionList posList_;
    private String zstage_;
    private double sliceZStepUm_;
    private double sliceZBottomUm_;
    private double sliceZTopUm_;
    private boolean useSlices_;
    private boolean useFrames_;
    private boolean useChannels_;
    private boolean useMultiPosition_;
    private boolean keepShutterOpenForStack_;
    private boolean keepShutterOpenForChannels_;
    private ArrayList<ChannelSpec> channels_ = new ArrayList();
    private String rootName_;
    private String dirName_;
    private int numFrames_;
    private double interval_;
    private VirtualAcquisitionDisplay display_;
    private double minZStepUm_;
    private String comment_;
    private boolean saveFiles_;
    private int acqOrderMode_;
    private boolean useAutoFocus_;
    private int afSkipInterval_;
    protected List<DataProcessor<TaggedImage>> taggedImageProcessors_;
    private List<Class> imageRequestProcessors_ = new ArrayList<Class>();
    private boolean absoluteZ_;
    private IAcquisitionEngine2010 acquisitionEngine2010;
    private ArrayList<Double> customTimeIntervalsMs_;
    private boolean useCustomIntervals_ = false;
    protected JSONObject summaryMetadata_;
    protected ImageCache imageCache_;

    public AcquisitionWrapperEngine() {
        this.taggedImageProcessors_ = new ArrayList<DataProcessor<TaggedImage>>();
    }

    @Override
    public String acquire() throws MMException {
        MMStudioMainFrame.seriousErrorReported_.set(false);
        return this.runAcquisition(this.getSequenceSettings());
    }

    public IAcquisitionEngine2010 getAcquisitionEngine2010() {
        if (this.acquisitionEngine2010 == null) {
            this.acquisitionEngine2010 = this.gui_.getAcquisitionEngine2010();
        }
        return this.acquisitionEngine2010;
    }

    public String runAcquisition(SequenceSettings sequenceSettings) {
        try {
            DefaultTaggedImagePipeline defaultTaggedImagePipeline = new DefaultTaggedImagePipeline(this.getAcquisitionEngine2010(), sequenceSettings, this.taggedImageProcessors_, this.gui_, sequenceSettings.save);
            this.summaryMetadata_ = defaultTaggedImagePipeline.summaryMetadata_;
            this.imageCache_ = defaultTaggedImagePipeline.imageCache_;
            this.display_ = defaultTaggedImagePipeline.display_;
            return defaultTaggedImagePipeline.acqName_;
        }
        catch (Throwable throwable) {
            ReportingUtils.showError(throwable);
            return null;
        }
    }

    private void updateChannelCameras() {
        for (ChannelSpec channelSpec : this.channels_) {
            channelSpec.camera_ = this.getSource(channelSpec);
        }
    }

    @Override
    public void attachRunnable(int n, int n2, int n3, int n4, Runnable runnable) {
        this.getAcquisitionEngine2010().attachRunnable(n, n2, n3, n4, runnable);
    }

    @Override
    public void clearRunnables() {
        this.getAcquisitionEngine2010().clearRunnables();
    }

    private String getSource(ChannelSpec channelSpec) {
        try {
            Configuration configuration = this.core_.getConfigGroupState(channelSpec.config_);
            if (configuration.isPropertyIncluded("Core", "Camera")) {
                return configuration.getSetting("Core", "Camera").getPropertyValue();
            }
            return "";
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return "";
        }
    }

    @Override
    public void addImageProcessor(Class clazz) {
        try {
            this.taggedImageProcessors_.add((DataProcessor)clazz.newInstance());
        }
        catch (InstantiationException instantiationException) {
            ReportingUtils.logError(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ReportingUtils.logError(illegalAccessException);
        }
    }

    @Override
    public void removeImageProcessor(Class clazz) {
        for (DataProcessor<TaggedImage> dataProcessor : this.taggedImageProcessors_) {
            if (dataProcessor.getClass() != clazz) continue;
            this.taggedImageProcessors_.remove(dataProcessor);
        }
    }

    @Override
    public void addImageProcessor(DataProcessor<TaggedImage> dataProcessor) {
        this.taggedImageProcessors_.add(dataProcessor);
    }

    @Override
    public void removeImageProcessor(DataProcessor<TaggedImage> dataProcessor) {
        this.taggedImageProcessors_.remove(dataProcessor);
    }

    public SequenceSettings getSequenceSettings() {
        SequenceSettings sequenceSettings = new SequenceSettings();
        this.updateChannelCameras();
        if (this.useFrames_) {
            if (this.useCustomIntervals_) {
                sequenceSettings.customIntervalsMs = this.customTimeIntervalsMs_;
                sequenceSettings.numFrames = sequenceSettings.customIntervalsMs.size();
            } else {
                sequenceSettings.numFrames = this.numFrames_;
                sequenceSettings.intervalMs = this.interval_;
            }
        } else {
            sequenceSettings.numFrames = 0;
        }
        if (this.useSlices_) {
            double d;
            if (this.sliceZTopUm_ > this.sliceZBottomUm_) {
                for (d = this.sliceZBottomUm_; d <= this.sliceZTopUm_; d += this.sliceZStepUm_) {
                    sequenceSettings.slices.add(d);
                }
            } else {
                for (d = this.sliceZBottomUm_; d >= this.sliceZTopUm_; d -= this.sliceZStepUm_) {
                    sequenceSettings.slices.add(d);
                }
            }
        }
        sequenceSettings.relativeZSlice = !this.absoluteZ_;
        try {
            String string = this.core_.getFocusDevice();
            sequenceSettings.zReference = string.length() > 0 ? this.core_.getPosition(this.core_.getFocusDevice()) : 0.0;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        if (this.useChannels_) {
            for (ChannelSpec channelSpec : this.channels_) {
                if (!channelSpec.useChannel_) continue;
                sequenceSettings.channels.add(channelSpec);
            }
        }
        if (this.useMultiPosition_) {
            sequenceSettings.positions.addAll(Arrays.asList(this.posList_.getPositions()));
        }
        sequenceSettings.timeFirst = this.acqOrderMode_ == 2 || this.acqOrderMode_ == 3;
        sequenceSettings.slicesFirst = this.acqOrderMode_ == 2 || this.acqOrderMode_ == 0;
        sequenceSettings.useAutofocus = this.useAutoFocus_;
        sequenceSettings.skipAutofocusCount = this.afSkipInterval_;
        sequenceSettings.keepShutterOpenChannels = this.keepShutterOpenForChannels_;
        sequenceSettings.keepShutterOpenSlices = this.keepShutterOpenForStack_;
        sequenceSettings.save = this.saveFiles_;
        if (this.saveFiles_) {
            sequenceSettings.root = this.rootName_;
            sequenceSettings.prefix = this.dirName_;
        }
        sequenceSettings.comment = this.comment_;
        return sequenceSettings;
    }

    @Override
    public void stop(boolean bl) {
        try {
            if (this.acquisitionEngine2010 != null) {
                this.acquisitionEngine2010.stop();
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception, "Acquisition engine stop request failed");
        }
    }

    @Override
    public boolean abortRequest() {
        int n;
        if (this.isAcquisitionRunning() && (n = JOptionPane.showConfirmDialog(null, "Abort current acquisition task?", "Micro-Manager", 0, 1)) == 0) {
            this.stop(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean abortRequested() {
        return this.acquisitionEngine2010.stopHasBeenRequested();
    }

    @Override
    public void shutdown() {
        this.stop(true);
    }

    @Override
    public void setPause(boolean bl) {
        if (bl) {
            this.acquisitionEngine2010.pause();
        } else {
            this.acquisitionEngine2010.resume();
        }
    }

    @Override
    public boolean isAcquisitionRunning() {
        if (this.acquisitionEngine2010 != null) {
            return this.acquisitionEngine2010.isRunning();
        }
        return false;
    }

    @Override
    public boolean isFinished() {
        if (this.acquisitionEngine2010 != null) {
            return this.acquisitionEngine2010.isFinished();
        }
        return false;
    }

    @Override
    public boolean isMultiFieldRunning() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getNextWakeTime() {
        return this.acquisitionEngine2010.nextWakeTime();
    }

    @Override
    public void setCore(CMMCore cMMCore, AutofocusManager autofocusManager) {
        this.core_ = cMMCore;
    }

    @Override
    public void setPositionList(PositionList positionList) {
        this.posList_ = positionList;
    }

    @Override
    public void setParentGUI(ScriptInterface scriptInterface) {
        this.gui_ = (MMStudioMainFrame)scriptInterface;
    }

    @Override
    public void setZStageDevice(String string) {
        this.zstage_ = string;
    }

    @Override
    public void setUpdateLiveWindow(boolean bl) {
    }

    @Override
    public void setFinished() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getCurrentFrameCount() {
        return 0;
    }

    @Override
    public double getFrameIntervalMs() {
        return this.interval_;
    }

    @Override
    public double getSliceZStepUm() {
        return this.sliceZStepUm_;
    }

    @Override
    public double getSliceZBottomUm() {
        return this.sliceZBottomUm_;
    }

    @Override
    public void setChannel(int n, ChannelSpec channelSpec) {
        this.channels_.set(n, channelSpec);
    }

    @Override
    public String getFirstConfigGroup() {
        if (this.core_ == null) {
            return new String("");
        }
        String[] stringArray = this.getAvailableGroups();
        if (stringArray == null || stringArray.length < 1) {
            return new String("");
        }
        return this.getAvailableGroups()[0];
    }

    @Override
    public String[] getChannelConfigs() {
        if (this.core_ == null) {
            return new String[0];
        }
        return this.core_.getAvailableConfigs(this.core_.getChannelGroup()).toArray();
    }

    @Override
    public int getNumFrames() {
        return this.numFrames_;
    }

    @Override
    public String getChannelGroup() {
        return this.core_.getChannelGroup();
    }

    @Override
    public boolean setChannelGroup(String string) {
        if (this.groupIsEligibleChannel(string)) {
            try {
                this.core_.setChannelGroup(string);
            }
            catch (Exception exception) {
                try {
                    this.core_.setChannelGroup("");
                }
                catch (Exception exception2) {
                    ReportingUtils.showError(exception);
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.channels_ != null) {
            this.channels_.clear();
        }
        this.numFrames_ = 0;
    }

    @Override
    public void setFrames(int n, double d) {
        this.numFrames_ = n;
        this.interval_ = d;
    }

    @Override
    public double getMinZStepUm() {
        return this.minZStepUm_;
    }

    @Override
    public void setSlices(double d, double d2, double d3, boolean bl) {
        this.sliceZBottomUm_ = d;
        this.sliceZTopUm_ = d2;
        this.sliceZStepUm_ = d3;
        this.absoluteZ_ = bl;
    }

    @Override
    public boolean isFramesSettingEnabled() {
        return this.useFrames_;
    }

    @Override
    public void enableFramesSetting(boolean bl) {
        this.useFrames_ = bl;
    }

    @Override
    public boolean isChannelsSettingEnabled() {
        return this.useChannels_;
    }

    @Override
    public void enableChannelsSetting(boolean bl) {
        this.useChannels_ = bl;
    }

    @Override
    public boolean isZSliceSettingEnabled() {
        return this.useSlices_;
    }

    @Override
    public double getZTopUm() {
        return this.sliceZTopUm_;
    }

    @Override
    public void keepShutterOpenForStack(boolean bl) {
        this.keepShutterOpenForStack_ = bl;
    }

    @Override
    public boolean isShutterOpenForStack() {
        return this.keepShutterOpenForStack_;
    }

    @Override
    public void keepShutterOpenForChannels(boolean bl) {
        this.keepShutterOpenForChannels_ = bl;
    }

    @Override
    public boolean isShutterOpenForChannels() {
        return this.keepShutterOpenForChannels_;
    }

    @Override
    public void enableZSliceSetting(boolean bl) {
        this.useSlices_ = bl;
    }

    @Override
    public void enableMultiPosition(boolean bl) {
        this.useMultiPosition_ = bl;
    }

    @Override
    public boolean isMultiPositionEnabled() {
        return this.useMultiPosition_;
    }

    @Override
    public ArrayList<ChannelSpec> getChannels() {
        return this.channels_;
    }

    @Override
    public void setChannels(ArrayList<ChannelSpec> arrayList) {
        this.channels_ = arrayList;
    }

    @Override
    public String getRootName() {
        return this.rootName_;
    }

    @Override
    public void setRootName(String string) {
        this.rootName_ = string;
    }

    @Override
    public void setCameraConfig(String string) {
    }

    @Override
    public void setDirName(String string) {
        this.dirName_ = string;
    }

    @Override
    public void setComment(String string) {
        this.comment_ = string;
    }

    @Override
    public boolean addChannel(String string, double d, Boolean bl, double d2, ContrastSettings contrastSettings, ContrastSettings contrastSettings2, int n, Color color, boolean bl2) {
        return this.addChannel(string, d, bl, d2, contrastSettings, n, color, bl2);
    }

    @Override
    public boolean addChannel(String string, double d, Boolean bl, double d2, ContrastSettings contrastSettings, int n, Color color, boolean bl2) {
        if (this.isConfigAvailable(string)) {
            ChannelSpec channelSpec = new ChannelSpec();
            channelSpec.config_ = string;
            channelSpec.useChannel_ = bl2;
            channelSpec.exposure_ = d;
            channelSpec.doZStack_ = bl;
            channelSpec.zOffset_ = d2;
            channelSpec.contrast_ = contrastSettings;
            channelSpec.color_ = color;
            channelSpec.skipFactorFrame_ = n;
            this.channels_.add(channelSpec);
            return true;
        }
        ReportingUtils.logError("\"" + string + "\" is not found in the current Channel group.");
        return false;
    }

    @Override
    public boolean addChannel(String string, double d, double d2, ContrastSettings contrastSettings, ContrastSettings contrastSettings2, int n, Color color) {
        return this.addChannel(string, d, true, d2, contrastSettings2, n, color, true);
    }

    @Override
    public void setSaveFiles(boolean bl) {
        this.saveFiles_ = bl;
    }

    @Override
    public boolean getSaveFiles() {
        return this.saveFiles_;
    }

    @Override
    public void setDisplayMode(int n) {
    }

    @Override
    public int getAcqOrderMode() {
        return this.acqOrderMode_;
    }

    @Override
    public int getDisplayMode() {
        return 0;
    }

    @Override
    public void setAcqOrderMode(int n) {
        this.acqOrderMode_ = n;
    }

    @Override
    public void enableAutoFocus(boolean bl) {
        this.useAutoFocus_ = bl;
    }

    @Override
    public boolean isAutoFocusEnabled() {
        return this.useAutoFocus_;
    }

    @Override
    public int getAfSkipInterval() {
        return this.afSkipInterval_;
    }

    @Override
    public void setAfSkipInterval(int n) {
        this.afSkipInterval_ = n;
    }

    public void setParameterPreferences(Preferences preferences) {
    }

    @Override
    public void setSingleFrame(boolean bl) {
    }

    @Override
    public void setSingleWindow(boolean bl) {
    }

    @Override
    public String installAutofocusPlugin(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getVerboseSummary() {
        int n;
        int n2 = this.numFrames_;
        if (!this.useFrames_) {
            n2 = 1;
        }
        int n3 = n = this.useSlices_ ? (int)(1.0 + Math.abs(this.sliceZTopUm_ - this.sliceZBottomUm_) / this.sliceZStepUm_) : 1;
        if (!this.useSlices_) {
            n = 1;
        }
        int n4 = Math.max(1, this.posList_.getNumberOfPositions());
        if (!this.useMultiPosition_) {
            n4 = 1;
        }
        int n5 = 0;
        if (this.useChannels_) {
            for (ChannelSpec channelSpec : this.channels_) {
                if (!channelSpec.useChannel_) continue;
                ++n5;
            }
        } else {
            n5 = 1;
        }
        int n6 = n2 * n * n5 * n4;
        double d = 0.0;
        if (!this.useCustomIntervals_) {
            d = this.interval_ * (double)n2 / 1000.0;
        } else {
            for (Double d2 : this.customTimeIntervalsMs_) {
                d += d2 / 1000.0;
            }
        }
        int n7 = (int)(d / 3600.0);
        double d3 = d - (double)(n7 * 3600);
        int n8 = (int)(d3 / 60.0);
        d3 -= (double)(n8 * 60);
        CMMCore cMMCore = this.gui_.getCore();
        long l = cMMCore.getImageWidth();
        long l2 = cMMCore.getImageHeight();
        long l3 = cMMCore.getBytesPerPixel();
        long l4 = l * l2 * l3 * (long)n6 / 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        String string = "Number of time points: " + (!this.useCustomIntervals_ ? n2 : this.customTimeIntervalsMs_.size()) + "\nNumber of positions: " + n4 + "\nNumber of slices: " + n + "\nNumber of channels: " + n5 + "\nTotal images: " + n6 + "\nTotal memory: " + (l4 <= 1024L ? l4 + " MB" : NumberUtils.doubleToDisplayString((double)l4 / 1024.0) + " GB") + "\nDuration: " + n7 + "h " + n8 + "m " + NumberUtils.doubleToDisplayString(d3) + "s";
        if (this.useFrames_ || this.useMultiPosition_ || this.useChannels_ || this.useSlices_) {
            StringBuffer stringBuffer = new StringBuffer("\nOrder: ");
            if (this.useFrames_ && this.useMultiPosition_) {
                if (this.acqOrderMode_ == 0 || this.acqOrderMode_ == 1) {
                    stringBuffer.append("Time, Position");
                } else {
                    stringBuffer.append("Position, Time");
                }
            } else if (this.useFrames_) {
                stringBuffer.append("Time");
            } else if (this.useMultiPosition_) {
                stringBuffer.append("Position");
            }
            if ((this.useFrames_ || this.useMultiPosition_) && (this.useChannels_ || this.useSlices_)) {
                stringBuffer.append(", ");
            }
            if (this.useChannels_ && this.useSlices_) {
                if (this.acqOrderMode_ == 0 || this.acqOrderMode_ == 2) {
                    stringBuffer.append("Channel, Slice");
                } else {
                    stringBuffer.append("Slice, Channel");
                }
            } else if (this.useChannels_) {
                stringBuffer.append("Channel");
            } else if (this.useSlices_) {
                stringBuffer.append("Slice");
            }
            return string + stringBuffer.toString();
        }
        return string;
    }

    @Override
    public boolean isConfigAvailable(String string) {
        StrVector strVector = this.core_.getAvailableConfigs(this.core_.getChannelGroup());
        int n = 0;
        while ((long)n < strVector.size()) {
            if (string.compareTo(strVector.get(n)) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public String[] getCameraConfigs() {
        if (this.core_ == null) {
            return new String[0];
        }
        return this.core_.getAvailableConfigs("Camera").toArray();
    }

    @Override
    public String[] getAvailableGroups() {
        StrVector strVector;
        try {
            strVector = this.core_.getAllowedPropertyValues("Core", "ChannelGroup");
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : strVector) {
            if (!this.groupIsEligibleChannel(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public double getCurrentZPos() {
        if (this.isFocusStageAvailable()) {
            double d = 0.0;
            try {
                d = this.core_.getPosition(this.core_.getFocusDevice());
            }
            catch (Exception exception) {
                ReportingUtils.showError(exception);
            }
            return d;
        }
        return 0.0;
    }

    @Override
    public boolean isPaused() {
        return this.acquisitionEngine2010.isPaused();
    }

    public void restoreSystem() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected boolean isFocusStageAvailable() {
        return this.zstage_ != null && this.zstage_.length() > 0;
    }

    private boolean groupIsEligibleChannel(String string) {
        StrVector strVector = this.core_.getAvailableConfigs(string);
        if (strVector.size() == 1L) {
            try {
                String string2;
                PropertySetting propertySetting;
                String string3;
                Configuration configuration = this.core_.getConfigData(string, strVector.get(0));
                if (configuration.size() == 1L && this.core_.hasPropertyLimits(string3 = (propertySetting = configuration.getSetting(0L)).getDeviceLabel(), string2 = propertySetting.getPropertyName())) {
                    return false;
                }
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
                return false;
            }
        }
        return true;
    }

    public List<DataProcessor<TaggedImage>> getTaggedImageProcessors() {
        return this.taggedImageProcessors_;
    }

    @Override
    public void setCustomTimeIntervals(double[] dArray) {
        if (dArray == null || dArray.length == 0) {
            this.customTimeIntervalsMs_ = null;
            this.enableCustomTimeIntervals(false);
        } else {
            this.enableCustomTimeIntervals(true);
            this.customTimeIntervalsMs_ = new ArrayList();
            for (double d : dArray) {
                this.customTimeIntervalsMs_.add(d);
            }
        }
    }

    @Override
    public double[] getCustomTimeIntervals() {
        if (this.customTimeIntervalsMs_ == null) {
            return null;
        }
        double[] dArray = new double[this.customTimeIntervalsMs_.size()];
        for (int i = 0; i < this.customTimeIntervalsMs_.size(); ++i) {
            dArray[i] = this.customTimeIntervalsMs_.get(i);
        }
        return dArray;
    }

    @Override
    public void enableCustomTimeIntervals(boolean bl) {
        this.useCustomIntervals_ = bl;
    }

    @Override
    public boolean customTimeIntervalsEnabled() {
        return this.useCustomIntervals_;
    }

    @Override
    public JSONObject getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    @Override
    public ImageCache getImageCache() {
        return this.imageCache_;
    }

    @Override
    public AcquisitionDisplay getDisplay() {
        return this.display_;
    }
}

