/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.acquisition;

import ij.ImagePlus;
import ij.VirtualStack;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.acquisition.VirtualAcquisitionDisplay;
import org.micromanager.api.TaggedImageStorage;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.MDUtils;
import org.micromanager.utils.ReportingUtils;

public class AcquisitionVirtualStack
extends VirtualStack {
    private final TaggedImageStorage imageCache_;
    private final VirtualAcquisitionDisplay acq_;
    protected final int width_;
    protected final int height_;
    protected final int type_;
    private int nSlices_;
    private int positionIndex_ = 0;

    public AcquisitionVirtualStack(int n, int n2, int n3, ColorModel colorModel, TaggedImageStorage taggedImageStorage, int n4, VirtualAcquisitionDisplay virtualAcquisitionDisplay) {
        super(n, n2, colorModel, "");
        this.imageCache_ = taggedImageStorage;
        this.width_ = n;
        this.height_ = n2;
        this.nSlices_ = n4;
        this.acq_ = virtualAcquisitionDisplay;
        this.type_ = n3;
    }

    public void setPositionIndex(int n) {
        this.positionIndex_ = n;
    }

    public int getPositionIndex() {
        return this.positionIndex_;
    }

    public VirtualAcquisitionDisplay getVirtualAcquisitionDisplay() {
        return this.acq_;
    }

    public void setSize(int n) {
        this.nSlices_ = n;
    }

    public TaggedImageStorage getCache() {
        return this.imageCache_;
    }

    public TaggedImage getTaggedImage(int n) {
        try {
            int n2;
            int[] nArray;
            ImagePlus imagePlus = this.acq_.getImagePlus();
            if (imagePlus == null) {
                nArray = new int[]{1, 1, 1};
                n2 = 1;
            } else {
                nArray = imagePlus.convertIndexToPosition(n);
                n2 = imagePlus.getNSlices();
            }
            int n3 = this.acq_.grayToRGBChannel(nArray[0] - 1);
            int n4 = nArray[2] - 1;
            int n5 = nArray[1] - 1;
            TaggedImage taggedImage = this.imageCache_.getImage(n3, n5, n4, this.positionIndex_);
            int n6 = n5 - 1;
            int n7 = n5 + 1;
            int n8 = n4;
            while (taggedImage == null && (taggedImage = this.imageCache_.getImage(n3, n5, n8, this.positionIndex_)) == null) {
                if (n6 >= 0) {
                    taggedImage = this.imageCache_.getImage(n3, n6, n8, this.positionIndex_);
                    if (taggedImage != null) break;
                    --n6;
                }
                if (n7 < n2) {
                    taggedImage = this.imageCache_.getImage(n3, n7, n8, this.positionIndex_);
                    if (taggedImage != null) break;
                    ++n7;
                }
                if (n6 >= 0 || n7 < n2) continue;
                n6 = n5 - 1;
                n7 = n5 + 1;
                if (--n8 >= 0) continue;
            }
            return taggedImage;
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
            return null;
        }
    }

    public Object getPixels(int n) {
        Object object = null;
        try {
            TaggedImage taggedImage = this.getTaggedImage(n);
            if (taggedImage == null) {
                object = ImageUtils.makeProcessor(this.type_, this.width_, this.height_).getPixels();
            } else if (MDUtils.isGRAY(taggedImage)) {
                object = taggedImage.pix;
            } else if (MDUtils.isRGB32(taggedImage)) {
                object = ImageUtils.singleChannelFromRGB32((byte[])taggedImage.pix, (n - 1) % 3);
            } else if (MDUtils.isRGB64(taggedImage)) {
                object = ImageUtils.singleChannelFromRGB64((short[])taggedImage.pix, (n - 1) % 3);
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        return object;
    }

    public ImageProcessor getProcessor(int n) {
        return ImageUtils.makeProcessor(this.type_, this.width_, this.height_, this.getPixels(n));
    }

    public int getSize() {
        int n = this.acq_.getStackSize();
        if (n == -1) {
            return this.nSlices_;
        }
        return n;
    }

    public String getSliceLabel(int n) {
        TaggedImage taggedImage = this.getTaggedImage(n);
        if (taggedImage == null) {
            return "";
        }
        JSONObject jSONObject = taggedImage.tags;
        try {
            return jSONObject.get("Acquisition-PixelSizeUm") + " um/px";
        }
        catch (Exception exception) {
            return "";
        }
    }
}

