/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import bsh.ConsoleInterface;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.util.JConsole;
import com.swtdesigner.SwingResourceManager;
import ij.plugin.BrowserLauncher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import mmcorej.CMMCore;
import org.jeditsyntax.JEditTextArea;
import org.jeditsyntax.JavaTokenMarker;
import org.micromanager.MMOptions;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.PropertyEditor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.script.BeanshellEngine;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.HotKeysDialog;
import org.micromanager.utils.MMFrame;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.ScriptingEngine;
import org.micromanager.utils.ScriptingGUI;
import org.micromanager.utils.TooltipTextMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptPanel
extends MMFrame
implements MouseListener,
ScriptingGUI {
    private static final long serialVersionUID = 1L;
    private static final int HISTORYSIZE = 100;
    private JTable scriptTable_;
    private static ScriptTableModel model_;
    private final JEditTextArea scriptPane_;
    private boolean scriptPaneSaved_;
    private File scriptFile_;
    private JTextField immediatePane_;
    private JSplitPane rightSplitPane_;
    private JSplitPane splitPane_;
    private Vector<String> immediatePaneHistory_ = new Vector(100);
    private int immediatePaneHistoryIndex_ = 0;
    private Preferences prefs_;
    private static ScriptingEngine interp_;
    private ScriptInterface parentGUI_;
    private JTextPane messagePane_;
    private StyleContext sc_;
    private Interpreter beanshellREPLint_;
    private JConsole cons_;
    private static final FileDialogs.FileType BSH_FILE;
    private static final String SCRIPT_DIRECTORY = "script_directory";
    private static final String SCRIPT_FILE = "script_file_";
    private static final String RIGHT_DIVIDER_LOCATION = "right_divider_location";
    private static final String DIVIDER_LOCATION = "divider_location";
    private static final String EXT_POS = "bsh";
    private static final String EXT_ACQ = "xml";
    private static final String APP_NAME = "MMScriptPanel";
    private static final String blackStyleName_ = "blackStyle";
    private static final String redStyleName_ = "Red";
    private final MMStudioMainFrame gui_;

    public final void createBeanshellREPL() {
        this.cons_ = new JConsole();
        if (this.gui_.defaultScriptFont_ != null) {
            this.cons_.setFont(this.gui_.defaultScriptFont_);
        }
        this.beanshellREPLint_ = new Interpreter((ConsoleInterface)this.cons_);
        new Thread((Runnable)this.beanshellREPLint_, "Beanshell interpreter").start();
        try {
            File file = new File("scripts/mm_beanshell_startup.bsh");
            if (file.exists()) {
                this.beanshellREPLint_.source("scripts/mm_beanshell_startup.bsh");
            } else {
                file = new File("../scripts/mm_beanshell_startup.bsh");
                if (file.exists()) {
                    this.beanshellREPLint_.source("../scripts/mm_beanshell_startup.bsh");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ReportingUtils.showError(fileNotFoundException);
        }
        catch (IOException iOException) {
            ReportingUtils.showError(iOException);
        }
        catch (EvalError evalError) {
            ReportingUtils.showError(evalError);
        }
        this.beanshellREPLint_.setShowResults(true);
    }

    public JConsole getREPLCons() {
        return this.cons_;
    }

    public ScriptPanel(CMMCore cMMCore, MMOptions mMOptions, MMStudioMainFrame mMStudioMainFrame) {
        this.gui_ = mMStudioMainFrame;
        this.createBeanshellREPL();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!ScriptPanel.this.promptToSave(-1)) {
                    return;
                }
                ScriptPanel.this.prefs_.putInt(ScriptPanel.RIGHT_DIVIDER_LOCATION, ScriptPanel.this.rightSplitPane_.getDividerLocation());
                ScriptPanel.this.prefs_.putInt(ScriptPanel.DIVIDER_LOCATION, ScriptPanel.this.splitPane_.getDividerLocation());
                ScriptPanel.this.saveScriptsToPrefs();
                ScriptPanel.this.savePosition();
                ScriptPanel.this.setVisible(false);
            }
        });
        this.setVisible(false);
        interp_ = new BeanshellEngine(this);
        interp_.setInterpreter(this.beanshellREPLint_);
        this.setTitle("Script Panel");
        this.setIconImage(SwingResourceManager.getImage(PropertyEditor.class, "icons/microscope.gif"));
        this.setBounds(100, 100, 550, 495);
        int n = 15;
        Dimension dimension = new Dimension(80, n);
        int n2 = 5;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.prefs_ = preferences.node(preferences.absolutePath() + "/ScriptPanel");
        this.setPrefsNode(this.prefs_);
        Rectangle rectangle = this.getBounds();
        this.loadPosition(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        JPanel jPanel = new JPanel();
        SpringLayout springLayout = new SpringLayout();
        jPanel.setLayout(springLayout);
        JPanel jPanel2 = new JPanel();
        SpringLayout springLayout2 = new SpringLayout();
        jPanel2.setLayout(springLayout2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBackground(Color.white);
        JButton jButton = new JButton();
        jButton.setFont(new Font("", 0, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.addScript();
            }
        });
        jButton.setText("Add");
        jButton.setToolTipText("Add shortcut to beanshell script in file system");
        jButton.setPreferredSize(dimension);
        springLayout.putConstraint("North", (Component)jButton, n2, "North", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jButton, n2, "West", (Component)jPanel);
        jPanel.add(jButton);
        JButton jButton2 = new JButton();
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.setFont(new Font("", 0, 10));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.removeScript();
            }
        });
        jButton2.setText("Remove");
        jButton2.setToolTipText("Remove currently selected shortcut");
        jButton2.setPreferredSize(dimension);
        springLayout.putConstraint("North", (Component)jButton2, n2, "North", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jButton2, n2, "East", (Component)jButton);
        jPanel.add(jButton2);
        JButton jButton3 = new JButton();
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        jButton3.setFont(new Font("", 0, 10));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HotKeysDialog hotKeysDialog = new HotKeysDialog(ScriptPanel.this.getBackground());
            }
        });
        jButton3.setText("ShortCuts");
        jButton3.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Opens shortcuts manager window.  Allows the creation of keyboard shortcuts to automatically run scripts"));
        jButton3.setPreferredSize(dimension);
        springLayout.putConstraint("North", (Component)jButton3, n2, "North", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jButton3, n2, "East", (Component)jButton2);
        jPanel.add(jButton3);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add(jScrollPane);
        springLayout.putConstraint("East", (Component)jScrollPane, 0, "East", (Component)jPanel);
        springLayout.putConstraint("South", (Component)jScrollPane, -n2, "South", (Component)jPanel);
        springLayout.putConstraint("West", (Component)jScrollPane, n2, "West", (Component)jPanel);
        springLayout.putConstraint("North", (Component)jScrollPane, n2, "South", (Component)jButton2);
        this.scriptPane_ = new JEditTextArea();
        this.scriptPane_.setTokenMarker(new JavaTokenMarker());
        if (this.gui_.defaultScriptFont_ != null) {
            this.scriptPane_.getPainter().setFont(this.gui_.defaultScriptFont_);
        }
        this.scriptPane_.getDocument().putProperty("tabSize", 3);
        this.scriptPane_.setBackground(Color.WHITE);
        this.scriptPane_.getDocument().addDocumentListener(new MyDocumentListener());
        this.scriptPane_.setMinimumSize(new Dimension(300, 300));
        this.scriptPane_.setMaximumSize(new Dimension(800, 800));
        this.scriptPane_.setPreferredSize(new Dimension(800, 300));
        this.scriptPaneSaved_ = true;
        this.scriptPane_.setFocusTraversalKeysEnabled(false);
        springLayout2.putConstraint("East", (Component)this.scriptPane_, 0, "East", (Component)jPanel2);
        springLayout2.putConstraint("South", (Component)this.scriptPane_, 0, "South", (Component)jPanel2);
        springLayout2.putConstraint("West", (Component)this.scriptPane_, 0, "West", (Component)jPanel2);
        springLayout2.putConstraint("North", (Component)this.scriptPane_, n + 2 * n2, "North", (Component)jPanel2);
        jPanel2.add(this.scriptPane_);
        jPanel3.add((Component)this.cons_);
        this.immediatePane_ = new JTextField();
        this.immediatePane_.setFont(new Font("Courier New", 0, 12));
        this.immediatePane_.setBackground(Color.WHITE);
        this.immediatePane_.addActionListener(new immediatePaneListener());
        this.immediatePane_.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 224 || keyEvent.getKeyCode() == 38) {
                    ScriptPanel.this.doImmediatePaneHistoryUp();
                } else if (keyEvent.getKeyCode() == 225 || keyEvent.getKeyCode() == 40) {
                    ScriptPanel.this.doImmediatePaneHistoryDown();
                }
            }
        });
        this.immediatePane_.setMinimumSize(new Dimension(100, 15));
        this.immediatePane_.setMaximumSize(new Dimension(2000, 15));
        this.messagePane_ = new JTextPane();
        this.messagePane_.setFont(new Font("Courier New", 0, 12));
        this.messagePane_.setBackground(Color.WHITE);
        JScrollPane jScrollPane2 = new JScrollPane(this.messagePane_);
        jScrollPane2.setMinimumSize(new Dimension(100, 30));
        jScrollPane2.setMaximumSize(new Dimension(2000, 2000));
        this.sc_ = new StyleContext();
        Style style = this.messagePane_.getLogicalStyle();
        style = this.sc_.addStyle(blackStyleName_, style);
        StyleConstants.setForeground(style, Color.black);
        Style style2 = this.sc_.addStyle(redStyleName_, null);
        StyleConstants.setForeground(style2, Color.red);
        this.messagePane_.setKeymap(null);
        this.scriptTable_ = new JTable();
        this.scriptTable_.setFont(new Font("", 0, 12));
        model_ = new ScriptTableModel();
        this.scriptTable_.setModel(model_);
        this.scriptTable_.setCellSelectionEnabled(true);
        this.scriptTable_.setSelectionMode(0);
        SelectionListener selectionListener = new SelectionListener(this.scriptTable_);
        this.scriptTable_.getSelectionModel().addListSelectionListener(selectionListener);
        this.scriptTable_.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        InputMap inputMap = this.scriptTable_.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "none");
        jScrollPane.setViewportView(this.scriptTable_);
        this.scriptTable_.addMouseListener(this);
        JButton jButton4 = new JButton();
        jPanel2.add(jButton4);
        jButton4.setFont(new Font("", 0, 10));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.runPane();
            }
        });
        jButton4.setText("Run");
        jButton4.setPreferredSize(dimension);
        springLayout2.putConstraint("North", (Component)jButton4, n2, "North", (Component)jPanel2);
        springLayout2.putConstraint("West", (Component)jButton4, n2, "West", (Component)jPanel2);
        JButton jButton5 = new JButton();
        jPanel2.add(jButton5);
        jButton5.setFont(new Font("", 0, 10));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.stopScript();
            }
        });
        jButton5.setText("Stop");
        jButton5.setPreferredSize(dimension);
        springLayout2.putConstraint("North", (Component)jButton5, n2, "North", (Component)jPanel2);
        springLayout2.putConstraint("West", (Component)jButton5, n2, "East", (Component)jButton4);
        JButton jButton6 = new JButton();
        jPanel2.add(jButton6);
        jButton6.setFont(new Font("", 0, 10));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.newPane();
            }
        });
        jButton6.setText("New");
        jButton6.setPreferredSize(dimension);
        springLayout2.putConstraint("North", (Component)jButton6, n2, "North", (Component)jPanel2);
        springLayout2.putConstraint("West", (Component)jButton6, n2, "East", (Component)jButton5);
        JButton jButton7 = new JButton();
        jPanel2.add(jButton7);
        jButton7.setFont(new Font("", 0, 10));
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.openScriptInPane();
            }
        });
        jButton7.setText("Open");
        jButton7.setPreferredSize(dimension);
        springLayout2.putConstraint("North", (Component)jButton7, n2, "North", (Component)jPanel2);
        springLayout2.putConstraint("West", (Component)jButton7, n2, "East", (Component)jButton6);
        JButton jButton8 = new JButton();
        jPanel2.add(jButton8);
        jButton8.setFont(new Font("", 0, 10));
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.saveScript(-1);
            }
        });
        jButton8.setText("Save");
        jButton8.setPreferredSize(dimension);
        springLayout2.putConstraint("North", (Component)jButton8, n2, "North", (Component)jPanel2);
        springLayout2.putConstraint("West", (Component)jButton8, n2, "East", (Component)jButton7);
        JButton jButton9 = new JButton();
        jButton9.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(jButton9);
        jButton9.setFont(new Font("", 0, 10));
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScriptPanel.this.saveScriptAs();
            }
        });
        jButton9.setText("Save As");
        jButton9.setPreferredSize(dimension);
        springLayout2.putConstraint("North", (Component)jButton9, n2, "North", (Component)jPanel2);
        springLayout2.putConstraint("West", (Component)jButton9, n2, "East", (Component)jButton8);
        JButton jButton10 = new JButton();
        jButton10.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(jButton10);
        jButton10.setFont(new Font("", 0, 10));
        jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BrowserLauncher.openURL((String)"https://valelab.ucsf.edu/~MM/MMwiki/index.php/Script_Panel_GUI");
                }
                catch (IOException iOException) {
                    ReportingUtils.showError(iOException);
                }
            }
        });
        jButton10.setText("Help");
        jButton10.setPreferredSize(dimension);
        springLayout2.putConstraint("North", (Component)jButton10, n2, "North", (Component)jPanel2);
        springLayout2.putConstraint("West", (Component)jButton10, n2, "East", (Component)jButton9);
        jPanel.setMinimumSize(new Dimension(180, 130));
        this.rightSplitPane_ = new JSplitPane(0, jPanel2, jPanel3);
        this.rightSplitPane_.setOneTouchExpandable(true);
        int n3 = this.prefs_.getInt(RIGHT_DIVIDER_LOCATION, 200);
        this.rightSplitPane_.setDividerLocation(n3);
        this.splitPane_ = new JSplitPane(1, jPanel, this.rightSplitPane_);
        this.splitPane_.setOneTouchExpandable(true);
        int n4 = this.prefs_.getInt(DIVIDER_LOCATION, 200);
        this.splitPane_.setDividerLocation(n4);
        this.splitPane_.setMinimumSize(new Dimension(180, 130));
        this.rightSplitPane_.setResizeWeight(1.0);
        this.splitPane_.setResizeWeight(0.0);
        this.getContentPane().add(this.splitPane_);
        this.getScriptsFromPrefs();
    }

    protected void stopScript() {
        interp_.stopRequest();
    }

    public boolean promptToSave(int n) {
        if (this.scriptPaneSaved_) {
            return true;
        }
        String string = this.scriptFile_ != null ? "Save changes to " + this.scriptFile_.getName() + "?" : "Save script?";
        int n2 = JOptionPane.showConfirmDialog(this, string, APP_NAME, 0, 1);
        switch (n2) {
            case 0: {
                this.saveScript(n);
            }
            case 1: {
                this.scriptPaneSaved_ = true;
            }
        }
        return true;
    }

    private void addScript() {
        if (this.scriptFile_ != null && !model_.HasScriptAlready(this.scriptFile_).booleanValue()) {
            this.addScriptToModel(this.scriptFile_);
        } else if (this.scriptFile_ == null && !this.scriptPaneSaved_) {
            if (!this.promptToSave(-1)) {
                return;
            }
            this.addScriptToModel(this.scriptFile_);
        } else {
            if (!this.promptToSave(-1)) {
                return;
            }
            File file = FileDialogs.openFile(this, "Select a Beanshell script", BSH_FILE);
            if (file != null) {
                this.prefs_.put(SCRIPT_FILE, file.getAbsolutePath());
                this.addScriptToModel(file);
            }
        }
    }

    private void addScriptToModel(File file) {
        model_.AddScript(file);
        model_.fireTableDataChanged();
        int[] nArray = new int[2];
        model_.GetCell(file, nArray);
        this.scriptTable_.changeSelection(nArray[0], nArray[1], false, false);
    }

    private void removeScript() {
        if (!this.promptToSave(-1)) {
            return;
        }
        model_.RemoveScript(this.scriptTable_.getSelectedRow(), this.scriptTable_.getSelectedColumn());
        model_.fireTableDataChanged();
        this.scriptPane_.setText("");
        this.scriptPaneSaved_ = true;
        this.setTitle("");
        this.scriptFile_ = null;
    }

    private void saveScript(int n) {
        if (this.scriptFile_ == null) {
            this.saveScriptAs();
            return;
        }
        if (this.scriptFile_ != null && this.scriptTable_.getSelectedRow() > -1) {
            boolean bl;
            if (n < 0) {
                n = this.scriptTable_.getSelectedRow();
            }
            boolean bl2 = bl = this.scriptFile_.lastModified() != model_.getLastMod(n, 0).longValue();
            if (bl) {
                int n2 = JOptionPane.showConfirmDialog(this, "Script was changed on disk.  Continue saving anyways?", APP_NAME, 0, 1);
                switch (n2) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return;
                    }
                }
            }
        }
        try {
            FileWriter fileWriter = new FileWriter(this.scriptFile_);
            fileWriter.write(this.scriptPane_.getText());
            fileWriter.close();
            this.scriptPaneSaved_ = true;
            int[] nArray = new int[2];
            model_.GetCell(this.scriptFile_, nArray);
            model_.setLastMod(nArray[0], 0, this.scriptFile_.lastModified());
            this.gui_.message("Saved file: " + this.scriptFile_.getName());
        }
        catch (IOException iOException) {
            ReportingUtils.showError(iOException);
        }
        catch (MMScriptException mMScriptException) {
            // empty catch block
        }
    }

    private void saveScriptAs() {
        File file = FileDialogs.save(this, "Save beanshell script", BSH_FILE);
        if (file != null) {
            try {
                String string = file.getName();
                if (string.length() < 5 || string.charAt(string.length() - 4) != '.' && string.charAt(string.length() - 5) != '.') {
                    string = string + ".bsh";
                }
                file = new File(file.getParentFile(), string);
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(this.scriptPane_.getText());
                fileWriter.close();
                this.scriptFile_ = file;
                this.prefs_.put(SCRIPT_FILE, file.getAbsolutePath());
                this.scriptPaneSaved_ = true;
                this.setTitle(file.getName());
            }
            catch (IOException iOException) {
                ReportingUtils.showError(iOException);
            }
        }
    }

    private void injectPane() {
        interp_.setInterpreter(this.beanshellREPLint_);
        this.runPane();
        interp_.resetInterpreter();
    }

    private void runPane() {
        File file = model_.getScript(this.scriptTable_.getSelectedRow(), this.scriptTable_.getSelectedColumn());
        if (file != null) {
            boolean bl;
            boolean bl2 = bl = file.lastModified() != model_.getLastMod(this.scriptTable_.getSelectedRow(), 0).longValue();
            if (bl) {
                int n = JOptionPane.showConfirmDialog(this, "Script was changed on disk.  Re-load from disk?", APP_NAME, 1, 1);
                switch (n) {
                    case 0: {
                        try {
                            FileReader fileReader = new FileReader(file);
                            this.scriptPane_.read(fileReader);
                            fileReader.close();
                            this.scriptFile_ = file;
                            this.scriptPaneSaved_ = true;
                            model_.setLastMod(this.scriptTable_.getSelectedRow(), 0, file.lastModified());
                        }
                        catch (Exception exception) {
                            this.handleException(exception);
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
        }
        try {
            interp_.evaluateAsync(this.scriptPane_.getText());
        }
        catch (MMScriptException mMScriptException) {
            ReportingUtils.logError(mMScriptException);
            this.messageException(mMScriptException.getMessage(), -1);
        }
    }

    public static void runFile(File file) {
        if (file != null) {
            try {
                interp_.evaluateAsync(ScriptPanel.getContents(file));
            }
            catch (MMScriptException mMScriptException) {
                ReportingUtils.logError(mMScriptException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            try {
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                    stringBuilder.append(System.getProperty("line.separator"));
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private void newPane() {
        if (!this.promptToSave(-1)) {
            return;
        }
        int n = this.scriptTable_.getSelectedRow();
        int n2 = this.scriptTable_.getSelectedColumn();
        this.scriptTable_.changeSelection(n, n2, true, false);
        this.scriptPane_.setText("");
        this.scriptPaneSaved_ = true;
        this.scriptFile_ = null;
        this.setTitle("");
        this.scriptPane_.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openScriptInPane() {
        if (!this.promptToSave(-1)) {
            return;
        }
        File file = FileDialogs.openFile(this, "Choose Beanshell script", BSH_FILE);
        if (file != null) {
            try {
                this.prefs_.put(SCRIPT_FILE, file.getAbsolutePath());
                int n = this.scriptTable_.getSelectedRow();
                int n2 = this.scriptTable_.getSelectedColumn();
                this.scriptTable_.changeSelection(n, n2, true, false);
                FileReader fileReader = new FileReader(file);
                this.scriptPane_.read(fileReader);
                fileReader.close();
                this.scriptFile_ = file;
                this.scriptPaneSaved_ = true;
                this.setTitle(file.getName());
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
    }

    public void insertScriptingObject(String string, Object object) {
        try {
            interp_.insertGlobalObject(string, object);
            this.beanshellREPLint_.set(string, object);
        }
        catch (Exception exception) {
            this.handleException(exception);
        }
    }

    public void setParentGUI(ScriptInterface scriptInterface) {
        this.parentGUI_ = scriptInterface;
        this.insertScriptingObject("gui", scriptInterface);
    }

    private void runImmediatePane() {
        try {
            this.immediatePaneHistory_.addElement(this.immediatePane_.getText());
            this.immediatePaneHistoryIndex_ = this.immediatePaneHistory_.size();
            interp_.evaluateAsync(this.immediatePane_.getText());
            this.immediatePane_.setText("");
        }
        catch (MMScriptException mMScriptException) {
            this.messageException(mMScriptException.getMessage(), -1);
        }
    }

    private void doImmediatePaneHistoryUp() {
        if (this.immediatePaneHistoryIndex_ > 0) {
            --this.immediatePaneHistoryIndex_;
        }
        if (this.immediatePaneHistoryIndex_ >= 0 && this.immediatePaneHistoryIndex_ < this.immediatePaneHistory_.size()) {
            this.immediatePane_.setText(this.immediatePaneHistory_.elementAt(this.immediatePaneHistoryIndex_));
        }
    }

    private void doImmediatePaneHistoryDown() {
        if (this.immediatePaneHistoryIndex_ < this.immediatePaneHistory_.size()) {
            ++this.immediatePaneHistoryIndex_;
        }
        if (this.immediatePaneHistoryIndex_ < this.immediatePaneHistory_.size()) {
            this.immediatePane_.setText(this.immediatePaneHistory_.elementAt(this.immediatePaneHistoryIndex_));
        } else {
            this.immediatePane_.setText("");
        }
    }

    public void closePanel() {
        if (!this.promptToSave(-1)) {
            return;
        }
        this.savePosition();
        this.saveScriptsToPrefs();
        this.dispose();
    }

    public void handleException(Exception exception) {
        ReportingUtils.showError(exception);
    }

    public void message(String string) {
        this.messagePane_.setCharacterAttributes(this.sc_.getStyle(blackStyleName_), false);
        this.messagePane_.replaceSelection(string + "\n");
        this.cons_.print((Object)("\n" + string), Color.black);
        this.showPrompt();
    }

    public void Message(String string) {
        this.message(string);
    }

    public void messageException(String string, int n) {
        if (n >= 0) {
            this.scriptPane_.scrollTo(n - 1, 0);
            this.scriptPane_.select(this.scriptPane_.getLineStartOffset(n - 1), this.scriptPane_.getLineEndOffset(n - 1));
        }
        this.messagePane_.setCharacterAttributes(this.sc_.getStyle(redStyleName_), false);
        this.messagePane_.replaceSelection(string + "\n");
        this.cons_.print((Object)("\n" + string), Color.red);
        this.showPrompt();
    }

    private void showPrompt() {
        String string;
        try {
            string = (String)this.beanshellREPLint_.eval("getBshPrompt();");
        }
        catch (EvalError evalError) {
            ReportingUtils.logError(evalError);
            string = "bsh % ";
        }
        this.cons_.print((Object)("\n" + string), Color.darkGray);
    }

    public void clearOutput() {
        boolean bl = true;
        try {
            this.beanshellREPLint_.eval("bsh.console.text");
        }
        catch (EvalError evalError) {
            bl = false;
            try {
                this.beanshellREPLint_.eval("setAccessibility(true);");
            }
            catch (EvalError evalError2) {
                ReportingUtils.showError(evalError2);
            }
        }
        try {
            this.beanshellREPLint_.eval("bsh.console.text.setText(\"\");setAccessibility(" + bl + ");");
        }
        catch (EvalError evalError) {
            ReportingUtils.showError(evalError);
        }
    }

    public void ClearOutput() {
        this.clearOutput();
    }

    public void clear() {
        this.clearOutput();
    }

    public void updateGUI() {
        this.parentGUI_.refreshGUI();
    }

    public void getScriptsFromPrefs() {
        String string;
        int n = 0;
        boolean bl = false;
        do {
            File file;
            if ((string = this.prefs_.get(SCRIPT_FILE + n, null)) != null && !string.equals("") && (file = new File(string)).isFile()) {
                model_.AddScript(file);
                bl = true;
            }
            ++n;
        } while (string != null && !string.equals("") && bl);
    }

    public static ArrayList<File> getScriptList() {
        return model_.getFileArray();
    }

    public void saveScriptsToPrefs() {
        ArrayList<File> arrayList = model_.getFileArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = arrayList.get(i);
            if (file == null) continue;
            this.prefs_.put(SCRIPT_FILE + i, file.getAbsolutePath());
        }
        this.prefs_.put(SCRIPT_FILE + arrayList.size(), "");
    }

    private String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2) {
            this.runPane();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void displayMessage(String string) {
        SwingUtilities.invokeLater(new ExecuteDisplayMessage(string));
        ReportingUtils.logMessage(string);
    }

    @Override
    public void displayError(String string) {
        SwingUtilities.invokeLater(new ExecuteDisplayMessage(string, true));
        ReportingUtils.logError(string);
    }

    @Override
    public void displayError(String string, int n) {
        SwingUtilities.invokeLater(new ExecuteDisplayMessage(string, true, n));
        ReportingUtils.logError(string);
    }

    public boolean stopRequestPending() {
        return interp_.stopRequestPending();
    }

    public void sleep(long l) throws MMScriptException {
        if (l > 0L) {
            interp_.sleep(l);
        }
    }

    static {
        BSH_FILE = new FileDialogs.FileType("BSH_FILE", "Beanshell files", System.getProperty("user.home") + "/MyScript.bsh", true, EXT_POS);
    }

    private class ExecuteDisplayMessage
    implements Runnable {
        String msg_;
        boolean error_ = false;
        int lineNumber_ = -1;

        public ExecuteDisplayMessage(String string, boolean bl, int n) {
            this.msg_ = string;
            this.error_ = bl;
            this.lineNumber_ = n;
        }

        public ExecuteDisplayMessage(String string, boolean bl) {
            this.msg_ = string;
            this.error_ = bl;
        }

        public ExecuteDisplayMessage(String string) {
            this.msg_ = string;
        }

        public void run() {
            if (this.error_) {
                ScriptPanel.this.messageException(this.msg_, this.lineNumber_);
            } else {
                ScriptPanel.this.message(this.msg_);
            }
        }
    }

    class immediatePaneListener
    implements ActionListener {
        immediatePaneListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScriptPanel.this.runImmediatePane();
        }
    }

    protected class MyDocumentListener
    implements DocumentListener {
        protected MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            ScriptPanel.this.scriptPaneSaved_ = false;
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            ScriptPanel.this.scriptPaneSaved_ = false;
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            ScriptPanel.this.scriptPaneSaved_ = false;
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table_;
        int lastRowSelected_ = -1;
        int lastColumnSelected_ = -1;
        boolean multipleStarted_ = false;

        SelectionListener(JTable jTable) {
            this.table_ = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() && !this.multipleStarted_) {
                this.multipleStarted_ = true;
                return;
            }
            this.multipleStarted_ = false;
            int n = this.table_.getSelectedRow();
            int n2 = this.table_.getSelectedColumn();
            if (n >= 0 && model_.isScriptAvailable(n, n2) && (n != this.lastRowSelected_ || n2 != this.lastColumnSelected_)) {
                if (!ScriptPanel.this.promptToSave(this.lastRowSelected_)) {
                    this.table_.changeSelection(this.lastRowSelected_, this.lastColumnSelected_, false, false);
                    return;
                }
                File file = model_.getScript(n, n2);
                if (ScriptPanel.EXT_POS.equals(ScriptPanel.this.getExtension(file))) {
                    try {
                        FileReader fileReader = new FileReader(file);
                        ScriptPanel.this.scriptPane_.read(fileReader);
                        fileReader.close();
                        ScriptPanel.this.scriptFile_ = file;
                        ScriptPanel.this.scriptPaneSaved_ = true;
                        ScriptPanel.this.setTitle(file.getName());
                        model_.setLastMod(this.table_.getSelectedRow(), 0, file.lastModified());
                    }
                    catch (Exception exception) {
                        ReportingUtils.logError(exception);
                    }
                } else if (ScriptPanel.EXT_ACQ.equals(ScriptPanel.this.getExtension(file))) {
                    ScriptPanel.this.scriptPane_.setText("gui.loadAcquisition(\"" + file.getAbsolutePath() + "\");\ngui.startAcquisition();");
                    ScriptPanel.this.scriptPaneSaved_ = true;
                }
            }
            this.lastRowSelected_ = n;
            this.lastColumnSelected_ = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScriptTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int columnCount_ = 1;
        private ArrayList<File> scriptFileArray_ = new ArrayList();
        private ArrayList<Long> lastModArray_ = new ArrayList();

        public Boolean HasScriptAlready(File file) {
            Boolean bl = false;
            for (File file2 : this.scriptFileArray_) {
                if (!file2.getAbsolutePath().equals(file.getAbsolutePath())) continue;
                bl = true;
            }
            return bl;
        }

        public void AddScript(File file) {
            if (!this.HasScriptAlready(file).booleanValue()) {
                this.scriptFileArray_.add(file);
                this.lastModArray_.add(file.lastModified());
            }
        }

        public void GetCell(File file, int[] nArray) {
            int n = this.scriptFileArray_.indexOf(file);
            if (n >= 0) {
                nArray[0] = n / 1;
                nArray[1] = n % 1;
            }
        }

        public void RemoveScript(int n, int n2) {
            if (n >= 0 && this.isScriptAvailable(n, n2)) {
                this.scriptFileArray_.remove(n * 1 + n2);
                this.lastModArray_.remove(n * 1 + n2);
            }
        }

        public File getScript(int n, int n2) {
            if (n >= 0 && n2 >= 0 && this.isScriptAvailable(n, n2)) {
                return this.scriptFileArray_.get(n * 1 + n2);
            }
            return null;
        }

        public Long getLastMod(int n, int n2) {
            if (n >= 0 && n2 >= 0 && this.isScriptAvailable(n, n2)) {
                return this.lastModArray_.get(n * 1 + n2);
            }
            return null;
        }

        public void setLastMod(int n, int n2, Long l) {
            if (n >= 0 && n2 >= 0 && this.isScriptAvailable(n, n2)) {
                this.lastModArray_.set(n * 1 + n2, l);
            }
        }

        public boolean isScriptAvailable(int n, int n2) {
            return n >= 0 && n2 >= 0 && n * 1 + n2 < this.scriptFileArray_.size();
        }

        public ArrayList<File> getFileArray() {
            return this.scriptFileArray_;
        }

        @Override
        public int getRowCount() {
            if (this.scriptFileArray_ != null) {
                return (int)Math.ceil((double)this.scriptFileArray_.size() / 1.0);
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int n) {
            return "Script-Shortcuts";
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= 0 && this.isScriptAvailable(n, n2)) {
                return this.scriptFileArray_.get(n * 1 + n2).getName();
            }
            return null;
        }
    }
}

