/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import mmcorej.CMMCore;
import org.jdesktop.layout.GroupLayout;
import org.micromanager.MMOptions;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.ProblemReportSender;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.ReportingUtils;

public class ReportProblemDialog
extends JDialog {
    String reportPreamble_;
    CMMCore core_;
    private ScriptInterface parent_;
    MMOptions mmoptions_;
    private JButton cancelButton_;
    private JButton clearButton_;
    private JEditorPane descriptionPane_;
    private JTextField emailText_;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField name_;
    private JTextField organization_;
    private JButton sendButton_;
    private JTextPane stepInstructions_;

    public ReportProblemDialog(CMMCore cMMCore, ScriptInterface scriptInterface, MMOptions mMOptions) {
        this.initComponents();
        this.reportPreamble_ = "";
        this.core_ = cMMCore;
        this.parent_ = scriptInterface;
        this.mmoptions_ = mMOptions;
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.descriptionPane_ = new JEditorPane();
        this.cancelButton_ = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.stepInstructions_ = new JTextPane();
        this.jLabel1 = new JLabel();
        this.name_ = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.organization_ = new JTextField();
        this.jLabel4 = new JLabel();
        this.emailText_ = new JTextField();
        this.clearButton_ = new JButton();
        this.sendButton_ = new JButton();
        this.setTitle("Report Problem Dialog");
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ReportProblemDialog.this.formComponentShown(componentEvent);
            }

            public void componentHidden(ComponentEvent componentEvent) {
                ReportProblemDialog.this.formComponentHidden(componentEvent);
            }
        });
        this.descriptionPane_.setFont(new Font("Lucida Sans Unicode", 0, 10));
        this.jScrollPane2.setViewportView(this.descriptionPane_);
        this.cancelButton_.setText("Cancel");
        this.cancelButton_.setToolTipText("Quit the Problem Report procedure.");
        this.cancelButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportProblemDialog.this.cancelButton_ActionPerformed(actionEvent);
            }
        });
        this.stepInstructions_.setBorder(BorderFactory.createBevelBorder(0));
        this.stepInstructions_.setEditable(false);
        this.stepInstructions_.setFont(new Font("Lucida Sans Unicode", 0, 12));
        this.jScrollPane1.setViewportView(this.stepInstructions_);
        this.jLabel1.setText("Problem Description");
        this.name_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportProblemDialog.this.name_ActionPerformed(actionEvent);
            }
        });
        this.name_.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ReportProblemDialog.this.name_PropertyChange(propertyChangeEvent);
            }
        });
        this.jLabel2.setText("Name");
        this.jLabel3.setText("Organization");
        this.organization_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportProblemDialog.this.organization_ActionPerformed(actionEvent);
            }
        });
        this.organization_.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ReportProblemDialog.this.organization_PropertyChange(propertyChangeEvent);
            }
        });
        this.jLabel4.setText("e-mail");
        this.emailText_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportProblemDialog.this.emailText_ActionPerformed(actionEvent);
            }
        });
        this.emailText_.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ReportProblemDialog.this.emailText_PropertyChange(propertyChangeEvent);
            }
        });
        this.clearButton_.setText("Restart Log!");
        this.clearButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportProblemDialog.this.clearButton_ActionPerformed(actionEvent);
            }
        });
        this.sendButton_.setText("Send");
        this.sendButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportProblemDialog.this.sendButton_ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).add(102, 102, 102).add((Component)this.name_, -1, 546, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 684, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.jLabel4)).add(57, 57, 57).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.emailText_, -1, 546, Short.MAX_VALUE).add((Component)this.organization_, -1, 546, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(14, 14, 14).add((Component)this.jScrollPane2, -1, 542, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(88, 88, 88).add((Component)this.cancelButton_, -2, 140, -2).add(52, 52, 52).add((Component)this.clearButton_).add(69, 69, 69).add((Component)this.sendButton_, -2, 145, -2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.name_, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.organization_, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.emailText_, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.jScrollPane2, -2, 153, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(69, 69, 69).add((Component)this.jLabel1))).add(18, 18, 18).add((Component)this.jScrollPane1, -2, 61, -2).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.sendButton_).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cancelButton_).add((Component)this.clearButton_))).addContainerGap()));
        this.pack();
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.InitializeDialog();
    }

    private void BuildAndSendReport() {
        this.reportPreamble_ = "#User Name:" + this.name_.getText();
        this.reportPreamble_ = this.reportPreamble_ + "\n#Organization: " + this.organization_.getText();
        this.reportPreamble_ = this.reportPreamble_ + "\n#User e-mail: " + this.emailText_.getText();
        this.reportPreamble_ = this.reportPreamble_ + "\n#User Description: " + this.descriptionPane_.getText();
        this.descriptionPane_.setEnabled(false);
        this.descriptionPane_.setEditable(false);
        this.sendButton_.setEnabled(false);
        this.stepInstructions_.setText("Sending...");
        ProblemReportSender problemReportSender = new ProblemReportSender(this.reportPreamble_, this.core_);
        String string = problemReportSender.Send();
        if (0 < string.length()) {
            ReportingUtils.logError(string);
            this.stepInstructions_.setText("There was a problem sending the report, please verify your internet connection.");
        } else {
            this.stepInstructions_.setText("The report was successfully submitted to micro-manager.org");
        }
    }

    private void cancelButton_ActionPerformed(ActionEvent actionEvent) {
        this.FinishDialog();
        this.setVisible(false);
    }

    private void name_ActionPerformed(ActionEvent actionEvent) {
    }

    private void name_PropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void clearButton_ActionPerformed(ActionEvent actionEvent) {
        this.core_.clearLog();
        this.core_.logMessage("MM Studio version: " + this.parent_.getVersion());
        this.core_.logMessage(this.core_.getVersionInfo());
        this.core_.logMessage(this.core_.getAPIVersionInfo());
        this.core_.logMessage("Operating System: " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        this.stepInstructions_.setText("The system is now capturing a 'debug' level log file. Operate the system until you've duplicated the problem. When you're successful,  press Send to send your information, problem description, system configuration, and log to micro-manager.org.");
        this.descriptionPane_.setEnabled(true);
        this.descriptionPane_.setEditable(true);
        this.sendButton_.setEnabled(true);
    }

    private void formComponentHidden(ComponentEvent componentEvent) {
        this.FinishDialog();
    }

    private void sendButton_ActionPerformed(ActionEvent actionEvent) {
        String string = "[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?";
        if (this.emailText_.getText().matches(string)) {
            if (0 < this.name_.getText().length()) {
                if (0 < this.organization_.getText().length()) {
                    int n = JOptionPane.showConfirmDialog(null, "Did you restart the log and reproduce the problem?", "Really send?", 0);
                    if (n == 0) {
                        this.BuildAndSendReport();
                    }
                } else {
                    ReportingUtils.showMessage("Please provide your Organization name.");
                    this.organization_.requestFocus();
                }
            } else {
                ReportingUtils.showMessage("Please provide your name.");
                this.name_.requestFocus();
            }
        } else {
            ReportingUtils.showMessage("Please provide a valid e-mail.");
            this.emailText_.requestFocus();
        }
    }

    private void emailText_ActionPerformed(ActionEvent actionEvent) {
    }

    private void organization_ActionPerformed(ActionEvent actionEvent) {
    }

    private void organization_PropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void emailText_PropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    void FinishDialog() {
        this.sendButton_.setEnabled(true);
        this.descriptionPane_.setEnabled(true);
        this.descriptionPane_.setEditable(true);
        this.core_.enableDebugLog(this.mmoptions_.debugLogEnabled_);
    }

    void InitializeDialog() {
        this.setLocation(100, 100);
        this.stepInstructions_.setText("Please press the \"Restart Log!\" button first.  Reproduce the problem, then press \"Send\". \n\n ");
        this.stepInstructions_.setBackground(this.getBackground());
        MMStudioMainFrame.getInstance().addMMBackgroundListener(this.stepInstructions_);
        this.descriptionPane_.setText("");
        this.descriptionPane_.setVisible(true);
        this.descriptionPane_.setEditable(true);
        this.descriptionPane_.setEnabled(true);
        this.descriptionPane_.requestFocus();
        this.core_.enableDebugLog(true);
        this.cancelButton_.setVisible(true);
        this.sendButton_.setEnabled(true);
    }
}

