/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.StrVector;
import org.micromanager.ConfigDialog;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.PropertyTableData;
import org.micromanager.utils.ReportingUtils;

public class PresetEditor
extends ConfigDialog {
    private static final long serialVersionUID = 8281144157746745260L;

    public PresetEditor(String string, String string2, ScriptInterface scriptInterface, CMMCore cMMCore, boolean bl) {
        super(string, string2, scriptInterface, cMMCore, bl);
        this.instructionsText_ = "Here you can specifiy the property values\nin a configuration preset.";
        this.nameFieldLabelText_ = "Preset name:";
        this.initName_ = this.presetName_;
        this.TITLE = "Preset editor for the \"" + string + "\" configuration group";
        this.showUnused_ = false;
        this.showFlagsPanelVisible = false;
        this.scrollPaneTop_ = 70;
        this.numColumns_ = 2;
        this.data_ = new PropertyTableData(this.core_, this.groupName_, this.presetName_, 1, 2, true);
        this.initializeData();
        this.data_.setColumnNames("Property Name", "Preset Value", "");
        this.data_.setShowReadOnly(true);
        this.initialize();
    }

    public void okChosen() {
        String string = this.nameField_.getText();
        if (this.writePreset(this.initName_, string)) {
            this.dispose();
        }
    }

    public boolean writePreset(String string, String string2) {
        if (string2.length() == 0) {
            this.showMessageDialog("Please enter a name for this preset.");
            return false;
        }
        StrVector strVector = this.core_.getAvailableConfigs(this.groupName_);
        int n = 0;
        while ((long)n < strVector.size()) {
            if (strVector.get(n).contentEquals(string2) && !string2.contentEquals(string)) {
                this.showMessageDialog("A preset by this name already exists in the \"" + this.groupName_ + "\" group.\nPlease enter a different name.");
                return false;
            }
            ++n;
        }
        StrVector strVector2 = this.core_.getAvailableConfigs(this.groupName_);
        try {
            int n2 = 0;
            while ((long)n2 < strVector2.size()) {
                boolean bl = true;
                if (this.newItem_ || !strVector2.get(n2).contentEquals(string)) {
                    Configuration configuration = this.core_.getConfigData(this.groupName_, strVector2.get(n2));
                    for (PropertyItem propertyItem : this.data_.getPropList()) {
                        if (!propertyItem.confInclude || !configuration.isPropertyIncluded(propertyItem.device, propertyItem.name) || propertyItem.getValueInCoreFormat().contentEquals(configuration.getSetting(propertyItem.device, propertyItem.name).getPropertyValue())) continue;
                        bl = false;
                    }
                    if (bl) {
                        this.showMessageDialog("This combination of properties is already found in the \"" + strVector2.get(n2) + "\" preset.\nPlease choose unique property values for your new preset.");
                        return false;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        if (!this.newItem_ && !string.contentEquals(string2)) {
            try {
                this.core_.renameConfig(this.groupName_, string, string2);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        for (PropertyItem propertyItem : this.data_.getPropList()) {
            if (!propertyItem.confInclude) continue;
            try {
                this.core_.defineConfig(this.groupName_, string2, propertyItem.device, propertyItem.name, propertyItem.getValueInCoreFormat());
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        this.gui_.setConfigChanged(true);
        return true;
    }
}

