/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import com.swtdesigner.SwingResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.StrVector;
import org.micromanager.MMOptions;
import org.micromanager.TileCreatorDlg;
import org.micromanager.api.ScriptInterface;
import org.micromanager.navigation.MultiStagePosition;
import org.micromanager.navigation.PositionList;
import org.micromanager.navigation.StagePosition;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIColors;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.ReportingUtils;

public class PositionListDlg
extends MMDialog
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private String posListDir_;
    private File curFile_;
    private static FileDialogs.FileType POSITION_LIST_FILE = new FileDialogs.FileType("POSITION_LIST_FILE", "Position list file", System.getProperty("user.home") + "/PositionList.pos", true, "pos");
    private JTable posTable_;
    private JTable axisTable_;
    private SpringLayout springLayout;
    private CMMCore core_;
    private ScriptInterface gui_;
    private MMOptions opts_;
    private Preferences prefs_;
    private TileCreatorDlg tileCreatorDlg_;
    private GUIColors guiColors_;
    private AxisList axisList_;
    private MultiStagePosition curMsp_;
    public JButton markButtonRef;
    private static int lastRowClicked_;

    public PositionListDlg(CMMCore cMMCore, ScriptInterface scriptInterface, PositionList positionList, MMOptions mMOptions) {
        JButton jButton;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PositionListDlg.this.savePosition();
            }
        });
        this.core_ = cMMCore;
        this.gui_ = scriptInterface;
        this.opts_ = mMOptions;
        this.guiColors_ = new GUIColors();
        this.setTitle("Stage-position List");
        this.springLayout = new SpringLayout();
        this.getContentPane().setLayout(this.springLayout);
        this.setBounds(100, 100, 362, 595);
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        this.prefs_ = preferences.node(preferences.absolutePath() + "/XYPositionListDlg");
        this.setPrefsNode(this.prefs_);
        Rectangle rectangle = this.getBounds();
        this.loadPosition(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setBackground(this.gui_.getBackgroundColor());
        this.gui_.addMMBackgroundListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        this.getContentPane().add(jScrollPane);
        JScrollPane jScrollPane2 = new JScrollPane();
        this.getContentPane().add(jScrollPane2);
        final FirstRowRenderer firstRowRenderer = new FirstRowRenderer();
        this.posTable_ = new JTable(){
            private static final long serialVersionUID = -3873504142761785021L;

            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n == 0) {
                    return firstRowRenderer;
                }
                return super.getCellRenderer(n, n2);
            }
        };
        this.posTable_.setFont(new Font("Arial", 0, 10));
        PosTableModel posTableModel = new PosTableModel();
        posTableModel.setData(positionList);
        this.posTable_.setModel(posTableModel);
        CellEditor cellEditor = new CellEditor();
        this.posTable_.setDefaultEditor(Object.class, cellEditor);
        this.posTable_.setSelectionMode(0);
        jScrollPane.setViewportView(this.posTable_);
        this.posTable_.addMouseListener(this);
        this.axisTable_ = new JTable();
        this.axisTable_.setFont(new Font("Arial", 0, 10));
        this.axisList_ = new AxisList();
        AxisTableModel axisTableModel = new AxisTableModel();
        this.axisTable_.setModel(axisTableModel);
        jScrollPane2.setViewportView(this.axisTable_);
        this.axisTable_.addMouseListener(this);
        this.springLayout.putConstraint("South", (Component)jScrollPane2, -10, "South", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jScrollPane, -10, "North", (Component)jScrollPane2);
        this.springLayout.putConstraint("North", (Component)jScrollPane, 10, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("North", (Component)jScrollPane2, -(23 + 23 * axisTableModel.getRowCount()), "South", (Component)this.getContentPane());
        this.markButtonRef = jButton = new JButton();
        jButton.setFont(new Font("Arial", 0, 10));
        jButton.setMaximumSize(new Dimension(0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.markPosition();
                PositionListDlg.this.posTable_.clearSelection();
            }
        });
        jButton.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/flag_green.png"));
        jButton.setText("Mark");
        jButton.setToolTipText("Adds point with coordinates of current stage position");
        this.getContentPane().add(jButton);
        int n = 17;
        this.springLayout.putConstraint("North", (Component)jButton, n, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton, n += 27, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton, -9, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("West", (Component)jButton, -105, "East", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jScrollPane, -9, "West", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jScrollPane, 10, "West", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jScrollPane2, -9, "West", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jScrollPane2, 10, "West", (Component)this.getContentPane());
        this.posTable_.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PositionListDlg.this.updateMarkButtonText();
            }

            public void focusGained(FocusEvent focusEvent) {
                PositionListDlg.this.updateMarkButtonText();
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setFont(new Font("Arial", 0, 10));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.incrementOrderOfSelectedPosition(-1);
            }
        });
        jButton2.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/arrow_up.png"));
        jButton2.setText("");
        jButton2.setToolTipText("Move currently selected position up list (positions higher on list are acquired earlier)");
        this.getContentPane().add(jButton2);
        this.springLayout.putConstraint("North", (Component)jButton2, n, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton2, n + 27, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton2, -48, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton2, 0, "West", (Component)jButton);
        JButton jButton3 = new JButton();
        jButton3.setFont(new Font("Arial", 0, 10));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.incrementOrderOfSelectedPosition(1);
            }
        });
        jButton3.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/arrow_down.png"));
        jButton3.setText("");
        jButton3.setToolTipText("Move currently selected position down list (lower positions on list are acquired later)");
        this.getContentPane().add(jButton3);
        this.springLayout.putConstraint("North", (Component)jButton3, n, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton3, n += 27, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton3, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton3, 48, "West", (Component)jButton);
        JButton jButton4 = new JButton();
        jButton4.setFont(new Font("Arial", 0, 10));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.goToCurrentPosition();
            }
        });
        jButton4.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/resultset_next.png"));
        jButton4.setText("Go to");
        jButton4.setToolTipText("Moves stage to currently selected position");
        this.getContentPane().add(jButton4);
        this.springLayout.putConstraint("North", (Component)jButton4, n, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton4, n += 27, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton4, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton4, 0, "West", (Component)jButton);
        JButton jButton5 = new JButton();
        jButton5.setFont(new Font("Arial", 0, 10));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.refreshCurrentPosition();
            }
        });
        jButton5.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/arrow_refresh.png"));
        jButton5.setText("Refresh");
        this.getContentPane().add(jButton5);
        this.springLayout.putConstraint("North", (Component)jButton5, n, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton5, n += 27, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton5, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton5, 0, "West", (Component)jButton);
        this.refreshCurrentPosition();
        JButton jButton6 = new JButton();
        jButton6.setFont(new Font("Arial", 0, 10));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.removeCurrentPosition();
            }
        });
        jButton6.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/cross.png"));
        jButton6.setText("Remove");
        jButton6.setToolTipText("Removes currently selected position from list");
        this.getContentPane().add(jButton6);
        this.springLayout.putConstraint("North", (Component)jButton6, n, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton6, n += 27, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton6, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton6, 0, "West", (Component)jButton);
        JButton jButton7 = new JButton();
        jButton7.setFont(new Font("Arial", 0, 10));
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.calibrate();
            }
        });
        jButton7.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/empty.png"));
        jButton7.setText("Set Origin");
        jButton7.setToolTipText("Drives X and Y stages back to their original positions and zeros their position values");
        this.getContentPane().add(jButton7);
        this.springLayout.putConstraint("North", (Component)jButton7, n, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton7, n += 27, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton7, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton7, 0, "West", (Component)jButton);
        JButton jButton8 = new JButton();
        jButton8.setFont(new Font("Arial", 0, 10));
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to erase\nall positions from the position list?", "Clear all positions?", 0);
                if (n == 0) {
                    PositionListDlg.this.clearAllPositions();
                }
            }
        });
        jButton8.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/delete.png"));
        jButton8.setText("Clear All");
        jButton8.setToolTipText("Removes all positions from list");
        this.getContentPane().add(jButton8);
        this.springLayout.putConstraint("North", (Component)jButton8, n, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("South", (Component)jButton8, n += 27, "North", (Component)this.getContentPane());
        this.springLayout.putConstraint("East", (Component)jButton8, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton8, 0, "West", (Component)jButton);
        JButton jButton9 = new JButton();
        jButton9.setFont(new Font("Arial", 0, 10));
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.savePosition();
                PositionListDlg.this.dispose();
            }
        });
        jButton9.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/empty.png"));
        jButton9.setText("Close");
        this.getContentPane().add(jButton9);
        this.springLayout.putConstraint("South", (Component)jButton9, 0, "South", (Component)jScrollPane2);
        this.springLayout.putConstraint("North", (Component)jButton9, -27, "South", (Component)jScrollPane2);
        this.springLayout.putConstraint("East", (Component)jButton9, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton9, 0, "West", (Component)jButton);
        JButton jButton10 = new JButton();
        jButton10.setFont(new Font("Arial", 0, 10));
        jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.showCreateTileDlg();
            }
        });
        jButton10.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/empty.png"));
        jButton10.setText("Create Grid");
        jButton10.setToolTipText("Open new window to create grid of equally spaced positions");
        this.getContentPane().add(jButton10);
        this.springLayout.putConstraint("South", (Component)jButton10, -1, "North", (Component)jButton9);
        this.springLayout.putConstraint("North", (Component)jButton10, -27, "North", (Component)jButton9);
        this.springLayout.putConstraint("East", (Component)jButton10, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton10, 0, "West", (Component)jButton);
        JButton jButton11 = new JButton();
        jButton11.setFont(new Font("Arial", 0, 10));
        jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.savePositionListAs();
            }
        });
        jButton11.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/empty.png"));
        jButton11.setText("Save As...");
        jButton11.setToolTipText("Save position list as");
        this.getContentPane().add(jButton11);
        this.springLayout.putConstraint("South", (Component)jButton11, -28, "North", (Component)jButton9);
        this.springLayout.putConstraint("North", (Component)jButton11, -55, "North", (Component)jButton9);
        this.springLayout.putConstraint("East", (Component)jButton11, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton11, 0, "West", (Component)jButton);
        JButton jButton12 = new JButton();
        jButton12.setFont(new Font("Arial", 0, 10));
        jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PositionListDlg.this.loadPositionList();
            }
        });
        jButton12.setIcon(SwingResourceManager.getIcon(PositionListDlg.class, "icons/empty.png"));
        jButton12.setText("Load...");
        jButton12.setToolTipText("Load position list");
        this.getContentPane().add(jButton12);
        this.springLayout.putConstraint("South", (Component)jButton12, -56, "North", (Component)jButton9);
        this.springLayout.putConstraint("North", (Component)jButton12, -83, "North", (Component)jButton9);
        this.springLayout.putConstraint("East", (Component)jButton12, 0, "East", (Component)jButton);
        this.springLayout.putConstraint("West", (Component)jButton12, 0, "West", (Component)jButton);
    }

    protected void updateMarkButtonText() {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        MultiStagePosition multiStagePosition = posTableModel.getPositionList().getPosition(this.posTable_.getSelectedRow() - 1);
        if (null == multiStagePosition) {
            this.markButtonRef.setText("Mark");
        } else {
            this.markButtonRef.setText("Replace");
        }
    }

    public void addPosition(MultiStagePosition multiStagePosition, String string) {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        multiStagePosition.setLabel(string);
        posTableModel.getPositionList().addPosition(multiStagePosition);
        posTableModel.fireTableDataChanged();
    }

    public void addPosition(MultiStagePosition multiStagePosition) {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        multiStagePosition.setLabel(posTableModel.getPositionList().generateLabel());
        posTableModel.getPositionList().addPosition(multiStagePosition);
        posTableModel.fireTableDataChanged();
    }

    protected boolean savePositionListAs() {
        File file = FileDialogs.save(this, "Save the position list", POSITION_LIST_FILE);
        if (file != null) {
            this.curFile_ = file;
            try {
                this.getPositionList().save(this.curFile_.getAbsolutePath());
                this.posListDir_ = this.curFile_.getParent();
            }
            catch (Exception exception) {
                this.handleError(exception);
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadPositionList() {
        File file = FileDialogs.openFile(this, "Load a position list", POSITION_LIST_FILE);
        if (file != null) {
            this.curFile_ = file;
            try {
                this.getPositionList().load(this.curFile_.getAbsolutePath());
                this.posListDir_ = this.curFile_.getParent();
            }
            catch (Exception exception) {
                this.handleError(exception);
            }
            finally {
                this.updatePositionData();
            }
        }
    }

    public void updatePositionData() {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        posTableModel.fireTableDataChanged();
    }

    public void rebuildAxisList() {
        this.axisList_ = new AxisList();
        AxisTableModel axisTableModel = (AxisTableModel)this.axisTable_.getModel();
        axisTableModel.fireTableDataChanged();
    }

    public void setPositionList(PositionList positionList) {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        posTableModel.setData(positionList);
        posTableModel.fireTableDataChanged();
    }

    protected void goToCurrentPosition() {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        MultiStagePosition multiStagePosition = posTableModel.getPositionList().getPosition(this.posTable_.getSelectedRow() - 1);
        if (multiStagePosition == null) {
            return;
        }
        try {
            MultiStagePosition.goToPosition(multiStagePosition, this.core_);
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
        this.refreshCurrentPosition();
    }

    protected void clearAllPositions() {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        posTableModel.getPositionList().clearAllPositions();
        posTableModel.fireTableDataChanged();
    }

    protected void incrementOrderOfSelectedPosition(int n) {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        int n2 = this.posTable_.getSelectedRow() - 1;
        int n3 = -1;
        if (0 <= n2) {
            int n4 = n2 + n;
            if (0 <= n4) {
                if (n4 < this.posTable_.getRowCount()) {
                    PositionList positionList = posTableModel.getPositionList();
                    MultiStagePosition[] multiStagePositionArray = positionList.getPositions();
                    MultiStagePosition multiStagePosition = multiStagePositionArray[n2];
                    positionList.replacePosition(n2, multiStagePositionArray[n4]);
                    positionList.replacePosition(n4, multiStagePosition);
                    posTableModel.setData(positionList);
                    if (n4 + 1 < posTableModel.getRowCount()) {
                        n3 = n4 + 1;
                    }
                } else {
                    n3 = this.posTable_.getRowCount() - 1;
                }
            } else {
                n3 = 1;
            }
        }
        posTableModel.fireTableDataChanged();
        if (-1 < n3) {
            this.posTable_.changeSelection(n3, n3, false, false);
            this.posTable_.requestFocusInWindow();
        }
        this.updateMarkButtonText();
    }

    protected void removeCurrentPosition() {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        posTableModel.getPositionList().removePosition(this.posTable_.getSelectedRow() - 1);
        posTableModel.fireTableDataChanged();
    }

    public void markPosition() {
        this.refreshCurrentPosition();
        MultiStagePosition multiStagePosition = new MultiStagePosition();
        multiStagePosition = this.curMsp_;
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        MultiStagePosition multiStagePosition2 = posTableModel.getPositionList().getPosition(this.posTable_.getSelectedRow() - 1);
        int n = 0;
        if (multiStagePosition2 == null) {
            multiStagePosition.setLabel(posTableModel.getPositionList().generateLabel());
            posTableModel.getPositionList().addPosition(multiStagePosition);
            posTableModel.fireTableDataChanged();
        } else {
            multiStagePosition.setLabel(posTableModel.getPositionList().getPosition(this.posTable_.getSelectedRow() - 1).getLabel());
            n = this.posTable_.getSelectedRow();
            posTableModel.getPositionList().replacePosition(this.posTable_.getSelectedRow() - 1, multiStagePosition);
            posTableModel.fireTableCellUpdated(n, 1);
            this.posTable_.setRowSelectionInterval(n, n);
        }
    }

    private void refreshCurrentPosition() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        MultiStagePosition multiStagePosition = new MultiStagePosition();
        multiStagePosition.setDefaultXYStage(this.core_.getXYStageDevice());
        multiStagePosition.setDefaultZStage(this.core_.getFocusDevice());
        try {
            object = this.core_.getLoadedDevicesOfType(DeviceType.StageDevice);
            int n = 0;
            while ((long)n < ((StrVector)object).size()) {
                if (this.axisList_.use(((StrVector)object).get(n))) {
                    StagePosition stagePosition = new StagePosition();
                    stagePosition.stageName = ((StrVector)object).get(n);
                    stagePosition.numAxes = 1;
                    stagePosition.x = this.core_.getPosition(((StrVector)object).get(n));
                    multiStagePosition.add(stagePosition);
                    stringBuilder.append(stagePosition.getVerbose()).append("\n");
                }
                ++n;
            }
            StrVector strVector = this.core_.getLoadedDevicesOfType(DeviceType.XYStageDevice);
            int n2 = 0;
            while ((long)n2 < strVector.size()) {
                if (this.axisList_.use(strVector.get(n2))) {
                    StagePosition stagePosition = new StagePosition();
                    stagePosition.stageName = strVector.get(n2);
                    stagePosition.numAxes = 2;
                    stagePosition.x = this.core_.getXPosition(strVector.get(n2));
                    stagePosition.y = this.core_.getYPosition(strVector.get(n2));
                    multiStagePosition.add(stagePosition);
                    stringBuilder.append(stagePosition.getVerbose()).append("\n");
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
        this.curMsp_ = multiStagePosition;
        object = (PosTableModel)this.posTable_.getModel();
        int n = this.posTable_.getSelectedRow();
        ((AbstractTableModel)object).fireTableCellUpdated(0, 1);
        if (n > 0) {
            this.posTable_.setRowSelectionInterval(n, n);
        }
    }

    public boolean useDrive(String string) {
        return this.axisList_.use(string);
    }

    protected void showCreateTileDlg() {
        if (this.tileCreatorDlg_ == null) {
            this.tileCreatorDlg_ = new TileCreatorDlg(this.core_, this.opts_, this);
            this.gui_.addMMBackgroundListener(this.tileCreatorDlg_);
        }
        this.tileCreatorDlg_.setBackground(this.guiColors_.background.get(this.opts_.displayBackground_));
        this.tileCreatorDlg_.setVisible(true);
    }

    private PositionList getPositionList() {
        PosTableModel posTableModel = (PosTableModel)this.posTable_.getModel();
        return posTableModel.getPositionList();
    }

    private void handleError(Exception exception) {
        ReportingUtils.showError(exception);
    }

    private void calibrate() {
        JOptionPane.showMessageDialog(this, "ALERT! Please REMOVE objectives! It may damage lens!", "Calibrate the XY stage", 2);
        Object[] objectArray = new Object[]{"Yes", "No"};
        if (0 != JOptionPane.showOptionDialog(this, "Really calibrate your XY stage?", "Are you sure?", -1, 2, null, objectArray, objectArray[1])) {
            return;
        }
        try {
            StrVector strVector = this.core_.getLoadedDevicesOfType(DeviceType.XYStageDevice);
            int n = 0;
            while ((long)n < strVector.size()) {
                String string = strVector.get(n);
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                this.core_.getXYPosition(string, dArray, dArray2);
                StopCalThread stopCalThread = new StopCalThread();
                CalThread calThread = new CalThread();
                stopCalThread.setPara(calThread, this, string, dArray, dArray2);
                calThread.setPara(stopCalThread, this, string, dArray, dArray2);
                stopCalThread.start();
                Thread.sleep(100L);
                calThread.start();
                ++n;
            }
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.posTable_.rowAtPoint(point);
        if (n >= 0) {
            if (n == this.posTable_.getSelectedRow() && n == lastRowClicked_) {
                this.posTable_.clearSelection();
                lastRowClicked_ = -1;
            } else {
                lastRowClicked_ = n;
            }
        }
        this.updateMarkButtonText();
    }

    class BackThread
    extends Thread {
        MMDialog d;

        BackThread() {
        }

        public void setPara(MMDialog mMDialog) {
            this.d = mMDialog;
        }

        public void run() {
            JOptionPane.showMessageDialog(this.d, "Going back to the original position!");
        }
    }

    class CalThread
    extends Thread {
        double[] x1;
        double[] y1;
        String deviceName;
        MMDialog d;
        Thread stopThread;

        CalThread() {
        }

        public void setPara(Thread thread, MMDialog mMDialog, String string, double[] dArray, double[] dArray2) {
            this.stopThread = thread;
            this.d = mMDialog;
            this.deviceName = string;
            this.x1 = dArray;
            this.y1 = dArray2;
        }

        public void run() {
            try {
                PositionListDlg.this.core_.home(this.deviceName);
                boolean bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                int n = 500;
                int n2 = 600000;
                for (int i = 0; bl && i < n2; i += n) {
                    Thread.sleep(n);
                    bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                }
                this.stopThread.interrupt();
                this.stopThread = null;
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                PositionListDlg.this.core_.getXYPosition(this.deviceName, dArray, dArray2);
                PositionListDlg.this.core_.setOriginXY(this.deviceName);
                BackThread backThread = new BackThread();
                backThread.setPara(this.d);
                backThread.start();
                PositionListDlg.this.core_.setXYPosition(this.deviceName, this.x1[0] - dArray[0], this.y1[0] - dArray2[0]);
                bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                if (this.isInterrupted()) {
                    return;
                }
                bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                while (bl) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    Thread.sleep(100L);
                    if (this.isInterrupted()) {
                        return;
                    }
                    bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                }
                backThread.interrupt();
                backThread = null;
            }
            catch (InterruptedException interruptedException) {
                ReportingUtils.logError(interruptedException);
            }
            catch (Exception exception) {
                PositionListDlg.this.handleError(exception);
            }
        }
    }

    class StopCalThread
    extends Thread {
        double[] x1;
        double[] y1;
        String deviceName;
        MMDialog d;
        Thread otherThread;

        StopCalThread() {
        }

        public void setPara(Thread thread, MMDialog mMDialog, String string, double[] dArray, double[] dArray2) {
            this.otherThread = thread;
            this.d = mMDialog;
            this.deviceName = string;
            this.x1 = dArray;
            this.y1 = dArray2;
        }

        public void run() {
            try {
                Object[] objectArray = new Object[]{"Stop"};
                int n = JOptionPane.showOptionDialog(this.d, "Stop calibration?", "Calibration", 2, 3, null, objectArray, objectArray[0]);
                if (n == 0) {
                    this.otherThread.interrupt();
                    this.otherThread = null;
                    if (this.isInterrupted()) {
                        return;
                    }
                    Thread.sleep(50L);
                    PositionListDlg.this.core_.stop(this.deviceName);
                    if (this.isInterrupted()) {
                        return;
                    }
                    boolean bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    while (bl) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        PositionListDlg.this.core_.stop(this.deviceName);
                        if (this.isInterrupted()) {
                            return;
                        }
                        bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    }
                    Object[] objectArray2 = new Object[]{"Yes", "No"};
                    n = JOptionPane.showOptionDialog(this.d, "RESUME calibration?", "Calibration", 0, 3, null, objectArray2, objectArray2[0]);
                    if (n == 1) {
                        return;
                    }
                    PositionListDlg.this.core_.home(this.deviceName);
                    StopCalThread stopCalThread = new StopCalThread();
                    stopCalThread.setPara(this, this.d, this.deviceName, this.x1, this.y1);
                    bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    if (bl) {
                        stopCalThread.start();
                    }
                    if (this.isInterrupted()) {
                        return;
                    }
                    bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    while (bl) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        Thread.sleep(100L);
                        if (this.isInterrupted()) {
                            return;
                        }
                        bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    }
                    stopCalThread.interrupt();
                    stopCalThread = null;
                    double[] dArray = new double[1];
                    double[] dArray2 = new double[1];
                    bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    int n2 = 500;
                    int n3 = 600000;
                    for (int i = 0; bl && i < n3; i += n2) {
                        Thread.sleep(n2);
                        bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    }
                    PositionListDlg.this.core_.getXYPosition(this.deviceName, dArray, dArray2);
                    PositionListDlg.this.core_.setOriginXY(this.deviceName);
                    BackThread backThread = new BackThread();
                    backThread.setPara(this.d);
                    backThread.start();
                    PositionListDlg.this.core_.setXYPosition(this.deviceName, this.x1[0] - dArray[0], this.y1[0] - dArray2[0]);
                    bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    if (this.isInterrupted()) {
                        return;
                    }
                    bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    while (bl) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        Thread.sleep(100L);
                        if (this.isInterrupted()) {
                            return;
                        }
                        bl = PositionListDlg.this.core_.deviceBusy(this.deviceName);
                    }
                    backThread.interrupt();
                    backThread = null;
                }
            }
            catch (InterruptedException interruptedException) {
                ReportingUtils.logError(interruptedException);
            }
            catch (Exception exception) {
                PositionListDlg.this.handleError(exception);
            }
        }
    }

    public class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusListener {
        private static final long serialVersionUID = 3L;
        JTextField text_ = new JTextField();
        int editingCol_;

        public CellEditor() {
            this.text_.addFocusListener(this);
        }

        public void focusLost(FocusEvent focusEvent) {
            this.fireEditingStopped();
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editingCol_ = n2;
            if (n2 == 0) {
                this.text_.setText((String)object);
                return this.text_;
            }
            return null;
        }

        public Object getCellEditorValue() {
            if (this.editingCol_ == 0) {
                return this.text_.getText();
            }
            return null;
        }
    }

    public class FirstRowRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public FirstRowRenderer() {
            this.setFont(new Font("Arial", 0, 10));
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setText((String)object);
            this.setBackground(Color.lightGray);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AxisTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Use", "Axis"};

        private AxisTableModel() {
        }

        @Override
        public int getRowCount() {
            return PositionListDlg.this.axisList_.getNumberOfPositions();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AxisData axisData = PositionListDlg.this.axisList_.get(n);
            if (axisData != null) {
                if (n2 == 0) {
                    return axisData.getUse();
                }
                if (n2 == 1) {
                    return axisData.getAxisName();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                PositionListDlg.this.axisList_.get(n).setUse((Boolean)object);
                PositionListDlg.this.prefs_.putBoolean(PositionListDlg.this.axisList_.get(n).getAxisName(), (Boolean)object);
            }
            this.fireTableCellUpdated(n, n2);
            PositionListDlg.this.axisTable_.clearSelection();
        }
    }

    private class AxisList {
        private Vector<AxisData> axisList_ = new Vector();

        public AxisList() {
            try {
                StrVector strVector = PositionListDlg.this.core_.getLoadedDevicesOfType(DeviceType.StageDevice);
                int n = 0;
                while ((long)n < strVector.size()) {
                    this.axisList_.add(new AxisData(PositionListDlg.this.prefs_.getBoolean(strVector.get(n), true), strVector.get(n)));
                    ++n;
                }
                StrVector strVector2 = PositionListDlg.this.core_.getLoadedDevicesOfType(DeviceType.XYStageDevice);
                int n2 = 0;
                while ((long)n2 < strVector2.size()) {
                    this.axisList_.add(new AxisData(PositionListDlg.this.prefs_.getBoolean(strVector2.get(n2), true), strVector2.get(n2)));
                    ++n2;
                }
            }
            catch (Exception exception) {
                PositionListDlg.this.handleError(exception);
            }
        }

        public AxisData get(int n) {
            if (n >= 0 && n < this.axisList_.size()) {
                return this.axisList_.get(n);
            }
            return null;
        }

        public int getNumberOfPositions() {
            return this.axisList_.size();
        }

        public boolean use(String string) {
            for (int i = 0; i < this.axisList_.size(); ++i) {
                if (!string.equals(this.get(i).getAxisName())) continue;
                return this.get(i).getUse();
            }
            return true;
        }
    }

    private class AxisData {
        private boolean use_;
        private String axisName_;

        public AxisData(boolean bl, String string) {
            this.use_ = bl;
            this.axisName_ = string;
        }

        public boolean getUse() {
            return this.use_;
        }

        public String getAxisName() {
            return this.axisName_;
        }

        public void setUse(boolean bl) {
            this.use_ = bl;
        }
    }

    private class PosTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Label", "Position [um]"};
        private PositionList posList_;

        private PosTableModel() {
        }

        public void setData(PositionList positionList) {
            this.posList_ = positionList;
        }

        public PositionList getPositionList() {
            return this.posList_;
        }

        public int getRowCount() {
            return this.posList_.getNumberOfPositions() + 1;
        }

        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        public Object getValueAt(int n, int n2) {
            MultiStagePosition multiStagePosition = n == 0 ? PositionListDlg.this.curMsp_ : this.posList_.getPosition(n - 1);
            if (n2 == 0) {
                if (n == 0) {
                    return "Current";
                }
                return multiStagePosition.getLabel();
            }
            if (n2 == 1) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < multiStagePosition.size(); ++i) {
                    StagePosition stagePosition = multiStagePosition.get(i);
                    if (i != 0) {
                        stringBuilder.append(";");
                    }
                    stringBuilder.append(stagePosition.getVerbose());
                }
                return stringBuilder.toString();
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n == 0) {
                return false;
            }
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            MultiStagePosition multiStagePosition;
            if (n2 == 0 && (multiStagePosition = this.posList_.getPosition(n - 1)) != null) {
                multiStagePosition.setLabel(((String)object).replaceAll("[^0-9a-zA-Z_]", "-"));
            }
        }
    }
}

