/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.util.Arrays;
import mmcorej.CMMCore;
import mmcorej.Configuration;
import mmcorej.PropertyType;
import mmcorej.StrVector;
import org.micromanager.ConfigDialog;
import org.micromanager.PresetEditor;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.PropertyItem;
import org.micromanager.utils.PropertyTableData;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.SortFunctionObjects;

public class GroupEditor
extends ConfigDialog {
    private static final long serialVersionUID = 8281144157746745260L;

    public GroupEditor(String string, String string2, ScriptInterface scriptInterface, CMMCore cMMCore, boolean bl) {
        super(string, string2, scriptInterface, cMMCore, bl);
        this.instructionsText_ = "Here you can specify the properties included\nin a configuration group.";
        this.nameFieldLabelText_ = "Group name:";
        this.initName_ = this.groupName_;
        this.TITLE = "Group Editor";
        this.showUnused_ = true;
        this.showFlagsPanelVisible = true;
        this.scrollPaneTop_ = 140;
        this.numColumns_ = 3;
        this.data_ = new PropertyTableData(this.core_, this.groupName_, this.presetName_, 2, 1, false);
        this.initializeData();
        this.data_.setColumnNames("Property Name", "Use in Group?", "Current Property Value");
        this.showShowReadonlyCheckBox_ = true;
        this.initialize();
    }

    public void okChosen() {
        String string = this.nameField_.getText();
        if (this.writeGroup(this.initName_, string)) {
            this.groupName_ = string;
            this.dispose();
        }
    }

    public boolean writeGroup(String string, String string2) {
        int n;
        Object object2;
        int n2;
        int n3 = 0;
        for (PropertyItem propertyItem : this.data_.getPropList()) {
            if (!propertyItem.confInclude) continue;
            ++n3;
        }
        if (n3 == 0) {
            this.showMessageDialog("Please select at least one property for this group.");
            return false;
        }
        if (string2.length() == 0) {
            this.showMessageDialog("Please enter a name for this group.");
            return false;
        }
        StrVector strVector = this.core_.getAvailableConfigGroups();
        int n4 = 0;
        while ((long)n4 < strVector.size()) {
            if (strVector.get(n4).contentEquals(string2) && !string2.contentEquals(string)) {
                this.showMessageDialog("A group by this name already exists. Please enter a different name.");
                return false;
            }
            ++n4;
        }
        StrVector strVector2 = this.core_.getAvailableConfigs(string2);
        try {
            if (!this.newItem_) {
                n2 = 0;
                while ((long)n2 < strVector2.size()) {
                    object2 = this.core_.getConfigData(string, strVector2.get(n2));
                    n = n2 + 1;
                    while ((long)n < strVector2.size()) {
                        boolean stringArray = true;
                        Configuration object4 = this.core_.getConfigData(string, strVector2.get(n));
                        for (PropertyItem propertyItem : this.data_.getPropList()) {
                            if (!propertyItem.confInclude || !((Configuration)object2).isPropertyIncluded(propertyItem.device, propertyItem.name) || !object4.isPropertyIncluded(propertyItem.device, propertyItem.name) || ((Configuration)object2).getSetting(propertyItem.device, propertyItem.name).getPropertyValue().contentEquals(object4.getSetting(propertyItem.device, propertyItem.name).getPropertyValue())) continue;
                            stringArray = false;
                        }
                        if (stringArray) {
                            this.showMessageDialog("By removing properties, you would create duplicate presets.\nTo avoid duplicates when you remove properties, you should\nfirst delete some of the presets in this group.");
                            return false;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            ReportingUtils.logError(exception);
        }
        if (!this.newItem_ && !string.contentEquals(string2)) {
            try {
                this.core_.renameConfigGroup(string, string2);
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        if (this.newItem_) {
            try {
                this.core_.defineConfigGroup(string2);
                for (PropertyItem propertyItem : this.data_.getPropList()) {
                    if (!propertyItem.confInclude) continue;
                    if (n3 == 1 && propertyItem.allowed.length > 0) {
                        if (PropertyType.Float == propertyItem.type) {
                            Arrays.sort(propertyItem.allowed, new SortFunctionObjects.DoubleStringComp());
                        } else if (PropertyType.Integer == propertyItem.type) {
                            Arrays.sort(propertyItem.allowed, new SortFunctionObjects.IntStringComp());
                        } else if (PropertyType.String == propertyItem.type) {
                            boolean exception = true;
                            for (n2 = 0; n2 < propertyItem.allowed.length; ++n2) {
                                if (Character.isDigit(propertyItem.allowed[n2].charAt(0))) continue;
                                exception = false;
                                break;
                            }
                            if (exception) {
                                Arrays.sort(propertyItem.allowed, new SortFunctionObjects.NumericPrefixStringComp());
                            } else {
                                Arrays.sort(propertyItem.allowed);
                            }
                        }
                        String[] stringArray = propertyItem.allowed;
                        n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            String string3 = stringArray[n];
                            if (string3.equals("")) continue;
                            String string4 = string3.replaceAll("[/\\*!']", "-");
                            this.core_.defineConfig(string2, string4, propertyItem.device, propertyItem.name, string3);
                        }
                        continue;
                    }
                    this.core_.defineConfig(string2, "NewPreset", propertyItem.device, propertyItem.name, propertyItem.getValueInCoreFormat());
                }
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
            if (n3 > 1) {
                new PresetEditor(string2, "NewPreset", this.gui_, this.core_, false);
            }
        } else {
            object2 = null;
            try {
                Configuration configuration = this.core_.getConfigGroupState(string2);
                for (PropertyItem propertyItem : this.data_.getPropList()) {
                    if (!propertyItem.confInclude && configuration.isPropertyIncluded(propertyItem.device, propertyItem.name)) {
                        n = 0;
                        while ((long)n < strVector2.size()) {
                            object2 = strVector2.get(n);
                            if (this.core_.getConfigData(string2, (String)object2).isPropertyIncluded(propertyItem.device, propertyItem.name)) {
                                this.core_.deleteConfig(string2, (String)object2, propertyItem.device, propertyItem.name);
                            }
                            ++n;
                        }
                        continue;
                    }
                    if (!propertyItem.confInclude || configuration.isPropertyIncluded(propertyItem.device, propertyItem.name)) continue;
                    n = 0;
                    while ((long)n < strVector2.size()) {
                        object2 = strVector2.get(n);
                        if (!this.core_.getConfigData(this.groupName_, (String)object2).isPropertyIncluded(propertyItem.device, propertyItem.name)) {
                            this.core_.defineConfig(string2, (String)object2, propertyItem.device, propertyItem.name, propertyItem.getValueInCoreFormat());
                        }
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                ReportingUtils.logError(exception);
            }
        }
        this.gui_.setConfigChanged(true);
        return true;
    }
}

