/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.micromanager.api.AcquisitionEngine;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.MMDialog;
import org.micromanager.utils.TooltipTextMaker;

public class CustomTimeIntervalsPanel
extends JPanel {
    private AcquisitionEngine acqEng_;
    private JTable timeIntervalTable_;
    private TimeIntervalTableModel intervalTableModel_;
    private JPanel buttonsPanel_;
    private JScrollPane scrollPane_;
    private JPanel infoPanel_;
    private LinearTimeDialog linearTimeDialog_;
    private LogTimeDialog logTimeDialog_;
    private JCheckBox useIntervalsCheckBox_;
    private JTabbedPane window_;

    public CustomTimeIntervalsPanel(AcquisitionEngine acquisitionEngine, JTabbedPane jTabbedPane, ScriptInterface scriptInterface) {
        this.window_ = jTabbedPane;
        this.acqEng_ = acquisitionEngine;
        this.createTable();
        this.createButtons();
        this.createInfoPanel();
        this.configureLayout();
        if (scriptInterface != null) {
            this.setBackground(scriptInterface.getBackgroundColor());
            scriptInterface.addMMBackgroundListener(this);
        }
    }

    private void createInfoPanel() {
        this.infoPanel_ = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("<html>This tab allows you to set custom time intervals between successive frames.  The above table shows the list of time intervals currently supplied to Micromanager, as well as their indices and the expected elapsed time at the start of collection of each frame.  Each time interval represents the minimum delay from the start of the previous frame to the start of the current one.  The interval corresponding to frame 0 is the delay before the start of acquisition, and should be set to 0 ms unless such a delay is desired.  Note that the actual intervals between frames and the actual elapsed times may exceed the values listed here, depending on the speed with which the hardware can acquire images.  Intervals can be typed in manually, or created with the \"Create Logarithmic Intervals\" and \"Create Constant Intervals\" buttons. </html>");
        jLabel.setFont(new Font("Arial", 0, 10));
        this.infoPanel_.add(jLabel);
    }

    private void createTable() {
        this.intervalTableModel_ = new TimeIntervalTableModel();
        this.timeIntervalTable_ = new JTable(this.intervalTableModel_);
        this.timeIntervalTable_.setDefaultRenderer(Object.class, new IntervalTableCellRenderer());
        this.scrollPane_ = new JScrollPane(this.timeIntervalTable_);
    }

    public void closeLinearDialog() {
        this.linearTimeDialog_.setVisible(false);
    }

    public void closeLogDialog() {
        this.logTimeDialog_.setVisible(false);
    }

    private void createButtons() {
        this.buttonsPanel_ = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.buttonsPanel_, 1);
        this.buttonsPanel_.setLayout(boxLayout);
        JButton jButton = new JButton("Remove All");
        jButton.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.removeAll();
            }
        });
        jButton.setMaximumSize(new Dimension(165, 25));
        JButton jButton2 = new JButton("Remove");
        jButton2.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRows();
                if (nArray.length == 0) {
                    JOptionPane.showMessageDialog(CustomTimeIntervalsPanel.this.buttonsPanel_, "Must select row(s) to be removed");
                } else if (nArray.length == 1) {
                    CustomTimeIntervalsPanel.this.intervalTableModel_.removeRow(nArray[0]);
                } else {
                    Arrays.sort(nArray);
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        CustomTimeIntervalsPanel.this.intervalTableModel_.removeRow(nArray[i]);
                    }
                }
            }
        });
        jButton2.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Remove currently selected row(s)"));
        jButton2.setMaximumSize(new Dimension(165, 25));
        JButton jButton3 = new JButton("Add one frame");
        jButton3.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRow();
                if (n == -1) {
                    CustomTimeIntervalsPanel.this.intervalTableModel_.addRow(0.0);
                } else {
                    CustomTimeIntervalsPanel.this.intervalTableModel_.insertRow(0.0, n);
                    CustomTimeIntervalsPanel.this.timeIntervalTable_.addRowSelectionInterval(n + 1, n + 1);
                }
            }
        });
        jButton3.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Add new time point (Inserts above currently selected row(s) or at bottom of list if no row selected)"));
        jButton3.setMaximumSize(new Dimension(165, 25));
        JButton jButton4 = new JButton("Create Constant Intervals");
        jButton4.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(jButton4);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomTimeIntervalsPanel.this.linearTimeDialog_ == null) {
                    CustomTimeIntervalsPanel.this.linearTimeDialog_ = new LinearTimeDialog();
                }
                CustomTimeIntervalsPanel.this.linearTimeDialog_.setVisible(true);
            }
        });
        jButton4.setMaximumSize(new Dimension(165, 25));
        jButton4.setToolTipText("Create series of equally spaced frames");
        JButton jButton5 = new JButton("Create Logarithmic Intervals");
        jButton5.setFont(new Font("Arial", 0, 10));
        this.buttonsPanel_.add(jButton5);
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomTimeIntervalsPanel.this.logTimeDialog_ == null) {
                    CustomTimeIntervalsPanel.this.logTimeDialog_ = new LogTimeDialog();
                }
                CustomTimeIntervalsPanel.this.logTimeDialog_.setVisible(true);
            }
        });
        jButton5.setMaximumSize(new Dimension(165, 25));
        jButton5.setToolTipText("Create series of equally logarithmically spaced frames");
        this.buttonsPanel_.add(new JLabel("      "));
        this.useIntervalsCheckBox_ = new JCheckBox("Use custom intervals");
        this.useIntervalsCheckBox_.setEnabled(this.acqEng_.getCustomTimeIntervals() != null);
        this.useIntervalsCheckBox_.setSelected(this.acqEng_.customTimeIntervalsEnabled());
        this.buttonsPanel_.add(this.useIntervalsCheckBox_);
        this.useIntervalsCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTimeIntervalsPanel.this.acqEng_.enableCustomTimeIntervals(CustomTimeIntervalsPanel.this.useIntervalsCheckBox_.isSelected());
                CustomTimeIntervalsPanel.this.setTabTitle();
            }
        });
    }

    private void setTabTitle() {
        if (this.acqEng_.customTimeIntervalsEnabled()) {
            this.window_.setTitleAt(0, "Custom time intervals (Enabled)");
        } else {
            this.window_.setTitleAt(0, "Custom time intervals (Disabled)");
        }
    }

    private void configureLayout() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.scrollPane_, "Center");
        jPanel.add((Component)this.buttonsPanel_, "After");
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        this.add(jPanel);
        this.add(this.infoPanel_);
    }

    public void syncCheckBoxFromAcqEng() {
        this.useIntervalsCheckBox_.setEnabled(this.acqEng_.getCustomTimeIntervals() != null);
        this.useIntervalsCheckBox_.setSelected(this.acqEng_.customTimeIntervalsEnabled());
        this.setTabTitle();
    }

    public void syncIntervalsFromAcqEng() {
        this.intervalTableModel_.syncIntervalsFromAcqEng();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TimeIntervalTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] COLUMN_NAMES = new String[]{"Frame Index", "Time interval (ms)", "Elapsed time(ms)"};
        private ArrayList<Double> timeIntervals_ = new ArrayList();

        public TimeIntervalTableModel() {
            this.syncIntervalsFromAcqEng();
            this.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    CustomTimeIntervalsPanel.this.syncCheckBoxFromAcqEng();
                }
            });
        }

        private void sendIntervalsToAcqEng() {
            if (this.timeIntervals_ == null || this.timeIntervals_.isEmpty()) {
                CustomTimeIntervalsPanel.this.acqEng_.setCustomTimeIntervals(null);
            } else {
                double[] dArray = new double[this.timeIntervals_.size()];
                for (int i = 0; i < this.timeIntervals_.size(); ++i) {
                    dArray[i] = this.timeIntervals_.get(i);
                }
                CustomTimeIntervalsPanel.this.acqEng_.setCustomTimeIntervals(dArray);
            }
            this.fireTableDataChanged();
        }

        public void syncIntervalsFromAcqEng() {
            this.timeIntervals_.clear();
            double[] dArray = CustomTimeIntervalsPanel.this.acqEng_.getCustomTimeIntervals();
            if (dArray != null) {
                for (double d : dArray) {
                    this.timeIntervals_.add(d);
                }
            }
            this.fireTableDataChanged();
        }

        public ArrayList<Double> getIntervals() {
            return this.timeIntervals_;
        }

        public void replaceList(ArrayList<Double> arrayList) {
            this.timeIntervals_.clear();
            this.timeIntervals_.addAll(arrayList);
            this.sendIntervalsToAcqEng();
        }

        public void addListToStart(ArrayList<Double> arrayList) {
            this.addList(0, arrayList);
        }

        public void addListToEnd(ArrayList<Double> arrayList) {
            this.addList(this.timeIntervals_.size(), arrayList);
        }

        public void addList(int n, ArrayList<Double> arrayList) {
            this.timeIntervals_.addAll(n, arrayList);
            this.sendIntervalsToAcqEng();
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return this.timeIntervals_.size();
        }

        public void removeAll() {
            this.timeIntervals_.clear();
            this.sendIntervalsToAcqEng();
        }

        public void removeRow(int n) {
            this.timeIntervals_.remove(n);
            this.sendIntervalsToAcqEng();
        }

        public void addRow(double d) {
            this.timeIntervals_.add(d);
            this.sendIntervalsToAcqEng();
        }

        public void insertRow(double d, int n) {
            this.timeIntervals_.add(n, d);
            this.sendIntervalsToAcqEng();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n;
            }
            if (n2 == 1) {
                return this.timeIntervals_.get(n);
            }
            if (n2 == 2) {
                return this.calcElapsedTime(n);
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.isCellEditable(n, n2)) {
                String string = (String)object;
                if (string.equals("")) {
                    this.timeIntervals_.set(n, 0.0);
                } else {
                    Double d = Double.parseDouble(string);
                    if (d != null) {
                        this.timeIntervals_.set(n, d);
                    }
                }
            }
            this.sendIntervalsToAcqEng();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 && n < this.timeIntervals_.size();
        }

        private double calcElapsedTime(int n) {
            double d = 0.0;
            for (int i = 0; i <= n; ++i) {
                d += this.timeIntervals_.get(i).doubleValue();
            }
            return d;
        }
    }

    private class IntervalTableCellRenderer
    extends DefaultTableCellRenderer {
        private final DecimalFormat formatter = new DecimalFormat("0.##");

        private IntervalTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, this.formatter.format((Number)object), bl, bl2, n, n2);
            if (n2 == 0 || n2 == 2) {
                if (bl) {
                    component.setBackground(Color.LIGHT_GRAY);
                    component.setForeground(Color.BLACK);
                } else {
                    component.setBackground(Color.DARK_GRAY);
                    component.setForeground(Color.WHITE);
                }
            } else if (bl) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
            } else {
                component.setBackground(Color.WHITE);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    private class LinearTimeDialog
    extends MMDialog {
        private JSpinner numFrames_;
        private JFormattedTextField interval_;
        private JComboBox timeUnitCombo_;
        private JComboBox creationTypeCombo_;

        public LinearTimeDialog() {
            this.setModal(true);
            this.setSize(new Dimension(350, 200));
            this.setResizable(false);
            this.initComponents();
            this.setTitle("Create equal interval time points");
            this.setLocationRelativeTo(CustomTimeIntervalsPanel.this.window_);
        }

        private void initComponents() {
            final LinearTimeDialog linearTimeDialog = this;
            GridLayout gridLayout = new GridLayout(4, 1);
            this.getContentPane().setLayout(gridLayout);
            JPanel jPanel = new JPanel();
            this.add(jPanel);
            JLabel jLabel = new JLabel();
            jLabel.setFont(new Font("Arial", 0, 14));
            jLabel.setText("Number of time points to create");
            jPanel.add(jLabel);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(new Integer(2), new Integer(2), null, new Integer(1));
            this.numFrames_ = new JSpinner(spinnerNumberModel);
            this.numFrames_.setPreferredSize(new Dimension(80, 22));
            ((JSpinner.DefaultEditor)this.numFrames_.getEditor()).getTextField().setFont(new Font("Arial", 0, 14));
            jPanel.add(this.numFrames_);
            JPanel jPanel2 = new JPanel();
            this.add(jPanel2);
            JLabel jLabel2 = new JLabel();
            jLabel2.setFont(new Font("Arial", 0, 14));
            jLabel2.setText("Time interval between points");
            jLabel2.setToolTipText("Interval between successive time points.  Setting an intervalof 0 will cause micromanager to acquire 'burts' of images as fast as possible");
            jPanel2.add(jLabel2);
            this.interval_ = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.interval_.setFont(new Font("Arial", 0, 14));
            this.interval_.setValue(new Double(1.0));
            this.interval_.setPreferredSize(new Dimension(80, 22));
            jPanel2.add(this.interval_);
            this.timeUnitCombo_ = new JComboBox();
            this.timeUnitCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"ms", "s", "min"}));
            this.timeUnitCombo_.setFont(new Font("Arial", 0, 14));
            jPanel2.add(this.timeUnitCombo_);
            JPanel jPanel3 = new JPanel();
            this.add(jPanel3);
            this.creationTypeCombo_ = new JComboBox();
            this.creationTypeCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"Replace current time point list", "Add to start of current list", "Add to end of current list", "Insert at currently selected position"}));
            this.creationTypeCombo_.setFont(new Font("Arial", 0, 14));
            jPanel3.add(this.creationTypeCombo_);
            JPanel jPanel4 = new JPanel();
            this.add(jPanel4);
            JButton jButton = new JButton("Cancel");
            jButton.setFont(new Font("Arial", 0, 14));
            jPanel4.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CustomTimeIntervalsPanel.this.closeLinearDialog();
                }
            });
            JLabel jLabel3 = new JLabel("        ");
            jPanel4.add(jLabel3);
            JButton jButton2 = new JButton("Create");
            jButton2.setFont(new Font("Arial", 0, 14));
            jPanel4.add(jButton2);
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = (Integer)LinearTimeDialog.this.numFrames_.getValue();
                    double d = ((Number)LinearTimeDialog.this.interval_.getValue()).doubleValue();
                    int n2 = LinearTimeDialog.this.timeUnitCombo_.getSelectedIndex();
                    int n3 = LinearTimeDialog.this.creationTypeCombo_.getSelectedIndex();
                    if (n >= 1 && d >= 0.0) {
                        int n4;
                        if (n2 == 1) {
                            d *= 1000.0;
                        } else if (n2 == 2) {
                            d *= 60000.0;
                        }
                        ArrayList<Double> arrayList = new ArrayList<Double>();
                        arrayList.add(0.0);
                        for (n4 = 1; n4 < n; ++n4) {
                            arrayList.add(d);
                        }
                        if (n3 == 0) {
                            CustomTimeIntervalsPanel.this.intervalTableModel_.replaceList(arrayList);
                        } else if (n3 == 1) {
                            CustomTimeIntervalsPanel.this.intervalTableModel_.addListToStart(arrayList);
                        } else if (n3 == 2) {
                            CustomTimeIntervalsPanel.this.intervalTableModel_.addListToEnd(arrayList);
                        } else {
                            n4 = CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRow();
                            if (n4 == -1) {
                                CustomTimeIntervalsPanel.this.intervalTableModel_.addListToEnd(arrayList);
                            } else {
                                CustomTimeIntervalsPanel.this.intervalTableModel_.addList(n4, arrayList);
                            }
                        }
                        CustomTimeIntervalsPanel.this.closeLinearDialog();
                    } else {
                        JOptionPane.showMessageDialog(linearTimeDialog, "Invalid number of frames or time interval");
                    }
                }
            });
        }
    }

    private class LogTimeDialog
    extends MMDialog {
        private JComboBox creationTypeCombo_;
        private JFormattedTextField aValue_;
        private JFormattedTextField rValue_;
        private JFormattedTextField tValue_;
        private JComboBox aCombo_;
        private JComboBox tCombo_;
        private JSpinner nValue_;
        private JCheckBox aCheck_;
        private JCheckBox rCheck_;
        private JCheckBox nCheck_;
        private JCheckBox tCheck_;
        private double r_;
        private double t_;
        private double a_;
        private int n_;

        public LogTimeDialog() {
            this.setModal(true);
            this.setSize(new Dimension(520, 300));
            this.setResizable(false);
            this.setTitle("Create logarithmically spaced time points");
            this.setLocationRelativeTo(CustomTimeIntervalsPanel.this.window_);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.createCheckBoxes();
            this.createCreationComboandButtons();
        }

        private double convertToMS(double d, JComboBox jComboBox) {
            double d2 = d;
            int n = jComboBox.getSelectedIndex();
            if (n == 1) {
                d2 *= 1000.0;
            } else if (n == 2) {
                d2 *= 60000.0;
            }
            return d2;
        }

        private void calcFourthParameter() {
            try {
                this.rValue_.commitEdit();
                this.nValue_.commitEdit();
                this.aValue_.commitEdit();
                this.tValue_.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (!this.aCheck_.isSelected()) {
                this.r_ = ((Number)this.rValue_.getValue()).doubleValue();
                this.t_ = this.convertToMS(((Number)this.tValue_.getValue()).doubleValue(), this.tCombo_);
                this.n_ = (Integer)this.nValue_.getValue();
                this.a_ = this.t_ / Math.pow(this.r_, this.n_ - 2);
            } else if (!this.rCheck_.isSelected()) {
                this.a_ = this.convertToMS(((Number)this.aValue_.getValue()).doubleValue(), this.aCombo_);
                this.t_ = this.convertToMS(((Number)this.tValue_.getValue()).doubleValue(), this.tCombo_);
                this.n_ = (Integer)this.nValue_.getValue();
                this.r_ = Math.pow(this.t_ / this.a_, 1.0 / (double)(this.n_ - 2));
            } else if (!this.tCheck_.isSelected()) {
                this.a_ = this.convertToMS(((Number)this.aValue_.getValue()).doubleValue(), this.aCombo_);
                this.n_ = (Integer)this.nValue_.getValue();
                this.r_ = ((Number)this.rValue_.getValue()).doubleValue();
                this.t_ = this.a_ * Math.pow(this.r_, this.n_ - 2);
            } else {
                this.a_ = this.convertToMS(((Number)this.aValue_.getValue()).doubleValue(), this.aCombo_);
                this.r_ = ((Number)this.rValue_.getValue()).doubleValue();
                this.t_ = this.convertToMS(((Number)this.tValue_.getValue()).doubleValue(), this.tCombo_);
                this.n_ = (int)Math.max(3.0, Math.log(this.t_ / this.a_) / Math.log(this.r_) + 2.0);
            }
        }

        private int numberBoxesChecked() {
            int n = 0;
            if (this.aCheck_.isSelected()) {
                ++n;
            }
            if (this.rCheck_.isSelected()) {
                ++n;
            }
            if (this.tCheck_.isSelected()) {
                ++n;
            }
            if (this.nCheck_.isSelected()) {
                ++n;
            }
            return n;
        }

        private void updateParameterValues() {
            if (this.numberBoxesChecked() != 3) {
                return;
            }
            this.calcFourthParameter();
            if (!this.aCheck_.isSelected()) {
                double d = this.a_;
                if (this.aCombo_.getSelectedIndex() == 1) {
                    d /= 1000.0;
                } else if (this.aCombo_.getSelectedIndex() == 2) {
                    d /= 60000.0;
                }
                this.aValue_.setValue(d);
            } else if (!this.rCheck_.isSelected()) {
                this.rValue_.setValue(this.r_);
            } else if (!this.tCheck_.isSelected()) {
                double d = this.t_;
                if (this.tCombo_.getSelectedIndex() == 1) {
                    d /= 1000.0;
                } else if (this.aCombo_.getSelectedIndex() == 2) {
                    d /= 60000.0;
                }
                this.tValue_.setValue(d);
            } else if (!this.nCheck_.isSelected()) {
                this.nValue_.setValue(this.n_);
            }
        }

        private void createCheckBoxes() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            this.add(jPanel2);
            jPanel2.add(new JLabel("Specify 3 of the following 4 parameters"));
            final JPanel jPanel3 = new JPanel();
            final JPanel jPanel4 = new JPanel();
            final JPanel jPanel5 = new JPanel();
            final JPanel jPanel6 = new JPanel();
            this.add(jPanel3);
            this.add(jPanel4);
            this.add(jPanel5);
            this.add(jPanel6);
            this.aCheck_ = new JCheckBox("Length of interval between first two frames", true);
            this.rCheck_ = new JCheckBox("Ratio of elapsed time of consecutive points", true);
            this.tCheck_ = new JCheckBox("Total time length", true);
            this.nCheck_ = new JCheckBox("Number of Frames", false);
            jPanel3.add(this.aCheck_);
            jPanel4.add(this.rCheck_);
            jPanel5.add(this.tCheck_);
            jPanel6.add(this.nCheck_);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    block15: {
                        int n;
                        block13: {
                            block17: {
                                block16: {
                                    block14: {
                                        n = 0;
                                        if (LogTimeDialog.this.aCheck_.isSelected()) {
                                            ++n;
                                        }
                                        if (LogTimeDialog.this.rCheck_.isSelected()) {
                                            ++n;
                                        }
                                        if (LogTimeDialog.this.tCheck_.isSelected()) {
                                            ++n;
                                        }
                                        if (LogTimeDialog.this.nCheck_.isSelected()) {
                                            ++n;
                                        }
                                        if (n != 3) break block13;
                                        if (LogTimeDialog.this.aCheck_.isSelected()) break block14;
                                        for (Component component : jPanel3.getComponents()) {
                                            component.setEnabled(false);
                                        }
                                        break block15;
                                    }
                                    if (LogTimeDialog.this.rCheck_.isSelected()) break block16;
                                    for (Component component : jPanel4.getComponents()) {
                                        component.setEnabled(false);
                                    }
                                    break block15;
                                }
                                if (LogTimeDialog.this.tCheck_.isSelected()) break block17;
                                for (Component component : jPanel5.getComponents()) {
                                    component.setEnabled(false);
                                }
                                break block15;
                            }
                            if (LogTimeDialog.this.nCheck_.isSelected()) break block15;
                            for (Component component : jPanel6.getComponents()) {
                                component.setEnabled(false);
                            }
                            break block15;
                        }
                        if (n == 2) {
                            for (Component component : jPanel3.getComponents()) {
                                component.setEnabled(true);
                            }
                            for (Component component : jPanel4.getComponents()) {
                                component.setEnabled(true);
                            }
                            for (Component component : jPanel5.getComponents()) {
                                component.setEnabled(true);
                            }
                            for (Component component : jPanel6.getComponents()) {
                                component.setEnabled(true);
                            }
                        }
                    }
                }
            };
            this.aCheck_.addActionListener(actionListener);
            this.rCheck_.addActionListener(actionListener);
            this.nCheck_.addActionListener(actionListener);
            this.tCheck_.addActionListener(actionListener);
            this.aValue_ = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.aValue_.setFont(new Font("Arial", 0, 14));
            this.aValue_.setValue(new Double(1.0));
            this.aValue_.setPreferredSize(new Dimension(80, 22));
            this.aCombo_ = new JComboBox();
            this.aCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"ms", "s", "min"}));
            this.aCombo_.setFont(new Font("Arial", 0, 14));
            jPanel3.add(this.aValue_);
            jPanel3.add(this.aCombo_);
            this.rValue_ = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.rValue_.setFont(new Font("Arial", 0, 14));
            this.rValue_.setValue(new Double(2.0));
            this.rValue_.setPreferredSize(new Dimension(80, 22));
            jPanel4.add(this.rValue_);
            this.tValue_ = new JFormattedTextField(NumberFormat.getNumberInstance());
            this.tValue_.setFont(new Font("Arial", 0, 14));
            this.tValue_.setValue(new Double(1000.0));
            this.tValue_.setPreferredSize(new Dimension(80, 22));
            this.tCombo_ = new JComboBox();
            this.tCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"ms", "s", "min"}));
            this.tCombo_.setFont(new Font("Arial", 0, 14));
            jPanel5.add(this.tValue_);
            jPanel5.add(this.tCombo_);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(new Integer(3), new Integer(3), null, new Integer(1));
            this.nValue_ = new JSpinner(spinnerNumberModel);
            this.nValue_.setPreferredSize(new Dimension(80, 22));
            ((JSpinner.DefaultEditor)this.nValue_.getEditor()).getTextField().setFont(new Font("Arial", 0, 14));
            jPanel3.add(this.nValue_);
            jPanel6.add(this.nValue_);
            ActionListener actionListener2 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LogTimeDialog.this.updateParameterValues();
                }
            };
            this.aCombo_.addActionListener(actionListener2);
            this.tCombo_.addActionListener(actionListener2);
            this.aValue_.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    if (LogTimeDialog.this.aValue_.isEnabled()) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            this.tValue_.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    if (LogTimeDialog.this.tValue_.isEnabled()) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            this.rValue_.addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    if (LogTimeDialog.this.rValue_.isEnabled()) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            this.nValue_.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (LogTimeDialog.this.nValue_.isEnabled()) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            ((JSpinner.DefaultEditor)this.nValue_.getEditor()).getTextField().addCaretListener(new CaretListener(){

                public void caretUpdate(CaretEvent caretEvent) {
                    if (LogTimeDialog.this.nValue_.isEnabled() && (Integer)LogTimeDialog.this.nValue_.getValue() >= 3) {
                        LogTimeDialog.this.updateParameterValues();
                    }
                }
            });
            for (Component component : jPanel6.getComponents()) {
                component.setEnabled(false);
            }
            this.updateParameterValues();
        }

        private boolean checkParametersValid() {
            if (!this.aCheck_.isSelected()) {
                if (this.r_ <= 1.0) {
                    JOptionPane.showMessageDialog(this, "Ratio parameter must be > 1");
                    return false;
                }
            } else if (!this.rCheck_.isSelected()) {
                if (this.t_ <= this.a_) {
                    JOptionPane.showMessageDialog(this, "Total time must be greater than interval between first two frames");
                    return false;
                }
            } else if (!this.tCheck_.isSelected()) {
                if (this.r_ <= 1.0) {
                    JOptionPane.showMessageDialog(this, "Ratio parameter must be > 1");
                    return false;
                }
            } else if (!this.nCheck_.isSelected()) {
                if (this.t_ <= this.a_) {
                    JOptionPane.showMessageDialog(this, "Total time must be greater than interval between first two frames");
                    return false;
                }
                if (this.r_ <= 1.0) {
                    JOptionPane.showMessageDialog(this, "Ratio parameter must be > 1");
                    return false;
                }
            }
            return true;
        }

        private void createButtonAction() {
            int n;
            if (this.numberBoxesChecked() != 3) {
                JOptionPane.showMessageDialog(this, "Select 3 parameters to specify");
                return;
            }
            this.calcFourthParameter();
            if (!this.checkParametersValid()) {
                return;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(0.0);
            arrayList.add(this.a_);
            for (n = 2; n < this.n_; ++n) {
                arrayList.add(this.a_ * (Math.pow(this.r_, n - 1) - Math.pow(this.r_, n - 2)));
            }
            n = this.creationTypeCombo_.getSelectedIndex();
            if (n == 0) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.replaceList(arrayList);
            } else if (n == 1) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.addListToStart(arrayList);
            } else if (n == 2) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.addListToEnd(arrayList);
            } else if (CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRow() == -1) {
                CustomTimeIntervalsPanel.this.intervalTableModel_.addListToEnd(arrayList);
            } else {
                CustomTimeIntervalsPanel.this.intervalTableModel_.addList(CustomTimeIntervalsPanel.this.timeIntervalTable_.getSelectedRow(), arrayList);
            }
            CustomTimeIntervalsPanel.this.closeLogDialog();
        }

        private void createCreationComboandButtons() {
            JPanel jPanel = new JPanel();
            this.add(jPanel);
            this.creationTypeCombo_ = new JComboBox();
            this.creationTypeCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"Replace current time point list", "Add to start of current list", "Add to end of current list", "Insert at currently selected position"}));
            this.creationTypeCombo_.setFont(new Font("Arial", 0, 14));
            jPanel.add(this.creationTypeCombo_);
            JPanel jPanel2 = new JPanel();
            this.add(jPanel2);
            JButton jButton = new JButton("Cancel");
            jButton.setFont(new Font("Arial", 0, 14));
            jPanel2.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CustomTimeIntervalsPanel.this.closeLogDialog();
                }
            });
            JLabel jLabel = new JLabel("        ");
            jPanel2.add(jLabel);
            JButton jButton2 = new JButton("Create");
            jButton2.setFont(new Font("Arial", 0, 14));
            jPanel2.add(jButton2);
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LogTimeDialog.this.createButtonAction();
                }
            });
        }
    }
}

