/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager;

import com.swtdesigner.SwingResourceManager;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import mmcorej.CMMCore;
import org.micromanager.AdvancedOptionsDialog;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.ComponentTitledBorder;
import org.micromanager.acquisition.TaggedImageStorageDiskDefault;
import org.micromanager.acquisition.TaggedImageStorageMultipageTiff;
import org.micromanager.api.AcquisitionEngine;
import org.micromanager.api.ScriptInterface;
import org.micromanager.utils.AcqOrderMode;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.ColorEditor;
import org.micromanager.utils.ColorRenderer;
import org.micromanager.utils.ContrastSettings;
import org.micromanager.utils.DisplayMode;
import org.micromanager.utils.FileDialogs;
import org.micromanager.utils.GUIColors;
import org.micromanager.utils.ImageUtils;
import org.micromanager.utils.MMException;
import org.micromanager.utils.MMScriptException;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.TooltipTextMaker;

public class AcqControlDlg
extends JFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected JButton listButton_;
    private JButton afButton_;
    private JSpinner afSkipInterval_;
    private JComboBox acqOrderBox_;
    public static final String NEW_ACQFILE_NAME = "MMAcquistion.xml";
    public static final String ACQ_SETTINGS_NODE = "AcquistionSettings";
    public static final String COLOR_SETTINGS_NODE = "ColorSettings";
    private JComboBox channelGroupCombo_;
    private JTextArea commentTextArea_;
    private JComboBox zValCombo_;
    private JTextField nameField_;
    private JTextField rootField_;
    private JTextArea summaryTextArea_;
    private JComboBox timeUnitCombo_;
    private JFormattedTextField interval_;
    private JFormattedTextField zStep_;
    private JFormattedTextField zTop_;
    private JFormattedTextField zBottom_;
    private AcquisitionEngine acqEng_;
    private JScrollPane channelTablePane_;
    private JTable channelTable_;
    private JSpinner numFrames_;
    private ChannelTableModel model_;
    private Preferences prefs_;
    private Preferences acqPrefs_;
    private Preferences colorPrefs_;
    private File acqFile_;
    private String acqDir_;
    private int zVals_ = 0;
    private JButton setBottomButton_;
    private JButton setTopButton_;
    protected JComboBox displayModeCombo_;
    private ScriptInterface gui_;
    private GUIColors guiColors_;
    private NumberFormat numberFormat_;
    private JLabel namePrefixLabel_;
    private JLabel saveTypeLabel_;
    private JRadioButton singleButton_;
    private JRadioButton multiButton_;
    private JLabel rootLabel_;
    private JButton browseRootButton_;
    private JLabel displayMode_;
    private JCheckBox stackKeepShutterOpenCheckBox_;
    private JCheckBox chanKeepShutterOpenCheckBox_;
    private AcqOrderMode[] acqOrderModes_;
    private AdvancedOptionsDialog advancedOptionsWindow_;
    private static final String ACQ_CONTROL_X = "acq_x";
    private static final String ACQ_CONTROL_Y = "acq_y";
    private static final String ACQ_FILE_DIR = "dir";
    private static final String ACQ_INTERVAL = "acqInterval";
    private static final String ACQ_TIME_UNIT = "acqTimeInit";
    private static final String ACQ_ZBOTTOM = "acqZbottom";
    private static final String ACQ_ZTOP = "acqZtop";
    private static final String ACQ_ZSTEP = "acqZstep";
    private static final String ACQ_ENABLE_SLICE_SETTINGS = "enableSliceSettings";
    private static final String ACQ_ENABLE_MULTI_POSITION = "enableMultiPosition";
    private static final String ACQ_ENABLE_MULTI_FRAME = "enableMultiFrame";
    private static final String ACQ_ENABLE_MULTI_CHANNEL = "enableMultiChannels";
    private static final String ACQ_ORDER_MODE = "acqOrderMode";
    private static final String ACQ_NUMFRAMES = "acqNumframes";
    private static final String ACQ_CHANNEL_GROUP = "acqChannelGroup";
    private static final String ACQ_NUM_CHANNELS = "acqNumchannels";
    private static final String ACQ_CHANNELS_KEEP_SHUTTER_OPEN = "acqChannelsKeepShutterOpen";
    private static final String ACQ_STACK_KEEP_SHUTTER_OPEN = "acqStackKeepShutterOpen";
    private static final String CHANNEL_NAME_PREFIX = "acqChannelName";
    private static final String CHANNEL_USE_PREFIX = "acqChannelUse";
    private static final String CHANNEL_EXPOSURE_PREFIX = "acqChannelExp";
    private static final String CHANNEL_ZOFFSET_PREFIX = "acqChannelZOffset";
    private static final String CHANNEL_DOZSTACK_PREFIX = "acqChannelDoZStack";
    private static final String CHANNEL_CONTRAST_MIN_PREFIX = "acqChannelContrastMin";
    private static final String CHANNEL_CONTRAST_MAX_PREFIX = "acqChannelContrastMax";
    private static final String CHANNEL_CONTRAST_GAMMA_PREFIX = "acqChannelContrstGamma";
    private static final String CHANNEL_COLOR_R_PREFIX = "acqChannelColorR";
    private static final String CHANNEL_COLOR_G_PREFIX = "acqChannelColorG";
    private static final String CHANNEL_COLOR_B_PREFIX = "acqChannelColorB";
    private static final String CHANNEL_SKIP_PREFIX = "acqSkip";
    private static final String ACQ_Z_VALUES = "acqZValues";
    private static final String ACQ_DIR_NAME = "acqDirName";
    private static final String ACQ_ROOT_NAME = "acqRootName";
    private static final String ACQ_SAVE_FILES = "acqSaveFiles";
    private static final String ACQ_DISPLAY_MODE = "acqDisplayMode";
    private static final String ACQ_AF_ENABLE = "autofocus_enabled";
    private static final String ACQ_AF_SKIP_INTERVAL = "autofocusSkipInterval";
    private static final String ACQ_COLUMN_WIDTH = "column_width";
    private static final String ACQ_COLUMN_ORDER = "column_order";
    private static final int ACQ_DEFAULT_COLUMN_WIDTH = 77;
    private static final String CUSTOM_INTERVAL_PREFIX = "customInterval";
    private static final String ACQ_ENABLE_CUSTOM_INTERVALS = "enableCustomIntervals";
    private static final FileDialogs.FileType ACQ_SETTINGS_FILE = new FileDialogs.FileType("ACQ_SETTINGS_FILE", "Acquisition settings", System.getProperty("user.home") + "/AcqSettings.xml", true, "xml");
    private int[] columnWidth_;
    private int[] columnOrder_;
    private CheckBoxPanel framesPanel_;
    private JPanel framesSubPanel_;
    private CardLayout framesSubPanelLayout_;
    private static final String DEFAULT_FRAMES_PANEL_NAME = "Default frames panel";
    private static final String OVERRIDE_FRAMES_PANEL_NAME = "Override frames panel";
    private CheckBoxPanel channelsPanel_;
    private CheckBoxPanel slicesPanel_;
    protected CheckBoxPanel positionsPanel_;
    private JPanel acquisitionOrderPanel_;
    private CheckBoxPanel afPanel_;
    private JPanel summaryPanel_;
    private CheckBoxPanel savePanel_;
    private ComponentTitledPanel commentsPanel_;
    private Border dayBorder_;
    private Border nightBorder_;
    private Vector<JPanel> panelList_;
    private boolean disableGUItoSettings_ = false;

    public final void createChannelTable() {
        this.model_ = new ChannelTableModel(this.acqEng_);
        this.channelTable_ = new JTable(){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent mouseEvent) {
                        Object var2_2 = null;
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        return AcqControlDlg.this.model_.getToolTipText(n2);
                    }
                };
            }
        };
        this.channelTable_.setFont(new Font("Dialog", 0, 10));
        this.channelTable_.setAutoCreateColumnsFromModel(false);
        this.channelTable_.setModel(this.model_);
        this.model_.setChannels(this.acqEng_.getChannels());
        ChannelCellEditor channelCellEditor = new ChannelCellEditor();
        ChannelCellRenderer channelCellRenderer = new ChannelCellRenderer(this.acqEng_);
        this.channelTable_.setAutoResizeMode(0);
        for (int i = 0; i < this.model_.getColumnCount(); ++i) {
            Serializable serializable;
            int n = AcqControlDlg.search(this.columnOrder_, i);
            if (n < 0) {
                n = i;
            }
            if (n == this.model_.getColumnCount() - 1) {
                serializable = new ColorRenderer(true);
                ColorEditor colorEditor = new ColorEditor(this.model_, this.model_.getColumnCount() - 1);
                TableColumn tableColumn = new TableColumn(this.model_.getColumnCount() - 1, 200, (TableCellRenderer)((Object)serializable), colorEditor);
                tableColumn.setPreferredWidth(this.columnWidth_[this.model_.getColumnCount() - 1]);
                this.channelTable_.addColumn(tableColumn);
                continue;
            }
            serializable = new TableColumn(n, 200, channelCellRenderer, channelCellEditor);
            ((TableColumn)serializable).setPreferredWidth(this.columnWidth_[n]);
            this.channelTable_.addColumn((TableColumn)serializable);
        }
        this.channelTablePane_.setViewportView(this.channelTable_);
    }

    public JPanel createPanel(String string, int n, int n2, int n3, int n4) {
        return this.createPanel(string, n, n2, n3, n4, false);
    }

    public JPanel createPanel(String string, int n, int n2, int n3, int n4, boolean bl) {
        ComponentTitledPanel componentTitledPanel = bl ? new CheckBoxPanel(string) : new LabelPanel(string);
        componentTitledPanel.setTitleFont(new Font("Dialog", 1, 12));
        this.panelList_.add(componentTitledPanel);
        componentTitledPanel.setBounds(n, n2, n3 - n, n4 - n2);
        this.dayBorder_ = BorderFactory.createEtchedBorder();
        this.nightBorder_ = BorderFactory.createEtchedBorder(Color.gray, Color.darkGray);
        componentTitledPanel.setLayout(null);
        this.getContentPane().add(componentTitledPanel);
        return componentTitledPanel;
    }

    public void updatePanelBorder(JPanel jPanel) {
        TitledBorder titledBorder = (TitledBorder)jPanel.getBorder();
        if (this.gui_.getBackgroundStyle().contentEquals("Day")) {
            titledBorder.setBorder(this.dayBorder_);
        } else {
            titledBorder.setBorder(this.nightBorder_);
        }
    }

    public final void createEmptyPanels() {
        this.panelList_ = new Vector();
        this.framesPanel_ = (CheckBoxPanel)this.createPanel("Time points", 5, 5, 220, 91, true);
        this.positionsPanel_ = (CheckBoxPanel)this.createPanel("Multiple positions (XY)", 5, 93, 220, 154, true);
        this.slicesPanel_ = (CheckBoxPanel)this.createPanel("Z-stacks (slices)", 5, 156, 220, 306, true);
        this.acquisitionOrderPanel_ = this.createPanel("Acquisition order", 226, 5, 427, 63);
        this.summaryPanel_ = this.createPanel("Summary", 226, 156, 427, 306);
        this.afPanel_ = (CheckBoxPanel)this.createPanel("Autofocus", 226, 65, 427, 154, true);
        this.channelsPanel_ = (CheckBoxPanel)this.createPanel("Channels", 5, 308, 510, 451, true);
        this.savePanel_ = (CheckBoxPanel)this.createPanel("Save images", 5, 453, 510, 560, true);
        this.commentsPanel_ = (ComponentTitledPanel)this.createPanel("Acquisition Comments", 5, 564, 530, 650, false);
    }

    private void createToolTips() {
        this.framesPanel_.setToolTipText("Acquire images over a repeating time interval");
        this.positionsPanel_.setToolTipText("Acquire images from a series of positions in the XY plane");
        this.slicesPanel_.setToolTipText("Acquire images from a series of Z positions");
        String string = this.getClass().getResource("icons/acq_order_figure.png").toString();
        String string2 = "<html>Lets you select the order of image acquisition when some combination of multiple dimensions<br>(i.e. time points, XY positions, Z-slices, or Channels)  is selected.  During image acquisition, the<br>values of each dimension are iterated in the reverse order of their listing here.  \"Time\" and \"Position\" <br>always precede \"Slice\" and \"Channel\" <br><br>For example, suppose there are are two time points, two XY positions, and two Z slices, and Acquisition<br>order is set to \"Time, Position, Slice\".  The microscope will acquire images in the following order: <br> Time point 1, XY position 1, Z-slice 1 <br>Time point 1, XY position 1, Z-slice 2 <br>Time point 1, XY position 2, Z-slice 1 <br>Time point 1, XY position 2, Z-slice 2 <br>Time point 2, XY position 1, Z-slice 1 <br>etc. <br><br><img src=" + string + "></html>";
        this.acquisitionOrderPanel_.setToolTipText(string2);
        this.acqOrderBox_.setToolTipText(string2);
        this.afPanel_.setToolTipText("Toggle autofocus on/off");
        this.channelsPanel_.setToolTipText("Lets you acquire images in multiple channels (groups of properties with multiple preset values");
        this.savePanel_.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("If the Save images option is selected, images will be saved to disk continuously during the acquisition. If this option is not selected, images are accumulated only in the 5D-Image window, and once the acquisition is finished, image data can be saved to disk. However, saving files automatically during acquisition secures the acquired data against an unexpected computer failure or accidental closing of image window. Even when saving to disk, some of the acquired images are still kept in memory, facilitating fast playback. If such behavior is not desired, check the 'Conserve RAM' option (Tools | Options)"));
    }

    public AcqControlDlg(AcquisitionEngine acquisitionEngine, Preferences preferences, ScriptInterface scriptInterface) {
        this.prefs_ = preferences;
        this.gui_ = scriptInterface;
        this.guiColors_ = new GUIColors();
        this.setIconImage(SwingResourceManager.getImage(MMStudioMainFrame.class, "icons/microscope.gif"));
        Preferences preferences2 = Preferences.userNodeForPackage(this.getClass());
        this.acqPrefs_ = preferences2.node(preferences2.absolutePath() + "/" + ACQ_SETTINGS_NODE);
        this.colorPrefs_ = preferences2.node(preferences2.absolutePath() + "/" + COLOR_SETTINGS_NODE);
        this.setDefaultCloseOperation(0);
        this.numberFormat_ = NumberFormat.getNumberInstance();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AcqControlDlg.this.close();
            }
        });
        this.acqEng_ = acquisitionEngine;
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.setTitle("Multi-dimensional Acquisition");
        this.setBackground(this.guiColors_.background.get(this.gui_.getBackgroundStyle()));
        this.createEmptyPanels();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(null);
        JLabel jLabel = new JLabel("Custom time intervals enabled");
        jLabel.setFont(new Font("Arial", 1, 12));
        jLabel.setForeground(Color.red);
        JButton jButton = new JButton("Disable custom intervals");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.acqEng_.enableCustomTimeIntervals(false);
                AcqControlDlg.this.updateGUIContents();
            }
        });
        jButton.setFont(new Font("Arial", 0, 10));
        jPanel2.add((Component)jLabel, "First");
        jPanel2.add((Component)jButton, "Last");
        this.framesPanel_.setLayout(new BorderLayout());
        this.framesSubPanelLayout_ = new CardLayout();
        this.framesSubPanel_ = new JPanel(this.framesSubPanelLayout_);
        this.framesPanel_.add(this.framesSubPanel_);
        this.framesSubPanel_.add((Component)jPanel, DEFAULT_FRAMES_PANEL_NAME);
        this.framesSubPanel_.add((Component)jPanel2, OVERRIDE_FRAMES_PANEL_NAME);
        this.framesSubPanelLayout_.show(this.framesSubPanel_, DEFAULT_FRAMES_PANEL_NAME);
        this.framesPanel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(new Font("Arial", 0, 10));
        jLabel2.setText("Number");
        jPanel.add(jLabel2);
        jLabel2.setBounds(15, 0, 54, 24);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1));
        this.numFrames_ = new JSpinner(spinnerNumberModel);
        ((JSpinner.DefaultEditor)this.numFrames_.getEditor()).getTextField().setFont(new Font("Arial", 0, 10));
        jPanel.add(this.numFrames_);
        this.numFrames_.setBounds(60, 0, 70, 24);
        this.numFrames_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(new Font("Arial", 0, 10));
        jLabel3.setText("Interval");
        jLabel3.setToolTipText("Interval between successive time points.  Setting an intervalof 0 will cause micromanager to acquire 'burts' of images as fast as possible");
        jPanel.add(jLabel3);
        jLabel3.setBounds(15, 27, 43, 24);
        this.interval_ = new JFormattedTextField(this.numberFormat_);
        this.interval_.setFont(new Font("Arial", 0, 10));
        this.interval_.setValue(new Double(1.0));
        this.interval_.addPropertyChangeListener("value", this);
        jPanel.add(this.interval_);
        this.interval_.setBounds(60, 27, 55, 24);
        this.timeUnitCombo_ = new JComboBox();
        this.timeUnitCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.timeUnitCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"ms", "s", "min"}));
        this.timeUnitCombo_.setFont(new Font("Arial", 0, 10));
        this.timeUnitCombo_.setBounds(120, 27, 67, 24);
        jPanel.add(this.timeUnitCombo_);
        this.listButton_ = new JButton();
        this.listButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.gui_.showXYPositionList();
            }
        });
        this.listButton_.setToolTipText("Open XY list dialog");
        this.listButton_.setIcon(SwingResourceManager.getIcon(AcqControlDlg.class, "icons/application_view_list.png"));
        this.listButton_.setText("Edit position list...");
        this.listButton_.setMargin(new Insets(2, 5, 2, 5));
        this.listButton_.setFont(new Font("Dialog", 0, 10));
        this.listButton_.setBounds(42, 25, 136, 26);
        this.positionsPanel_.add(this.listButton_);
        this.slicesPanel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(new Font("Arial", 0, 10));
        jLabel4.setText("Z-start [um]");
        jLabel4.setBounds(30, 30, 69, 15);
        this.slicesPanel_.add(jLabel4);
        this.zBottom_ = new JFormattedTextField(this.numberFormat_);
        this.zBottom_.setFont(new Font("Arial", 0, 10));
        this.zBottom_.setBounds(95, 27, 54, 21);
        this.zBottom_.setValue(new Double(1.0));
        this.zBottom_.addPropertyChangeListener("value", this);
        this.slicesPanel_.add(this.zBottom_);
        this.setBottomButton_ = new JButton();
        this.setBottomButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.setBottomPosition();
            }
        });
        this.setBottomButton_.setMargin(new Insets(-5, -5, -5, -5));
        this.setBottomButton_.setFont(new Font("", 0, 10));
        this.setBottomButton_.setText("Set");
        this.setBottomButton_.setToolTipText("Set value as microscope's current Z position");
        this.setBottomButton_.setBounds(150, 27, 50, 22);
        this.slicesPanel_.add(this.setBottomButton_);
        JLabel jLabel5 = new JLabel();
        jLabel5.setFont(new Font("Arial", 0, 10));
        jLabel5.setText("Z-end [um]");
        jLabel5.setBounds(30, 53, 69, 15);
        this.slicesPanel_.add(jLabel5);
        this.zTop_ = new JFormattedTextField(this.numberFormat_);
        this.zTop_.setFont(new Font("Arial", 0, 10));
        this.zTop_.setBounds(95, 50, 54, 21);
        this.zTop_.setValue(new Double(1.0));
        this.zTop_.addPropertyChangeListener("value", this);
        this.slicesPanel_.add(this.zTop_);
        this.setTopButton_ = new JButton();
        this.setTopButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.setTopPosition();
            }
        });
        this.setTopButton_.setMargin(new Insets(-5, -5, -5, -5));
        this.setTopButton_.setFont(new Font("Dialog", 0, 10));
        this.setTopButton_.setText("Set");
        this.setTopButton_.setToolTipText("Set value as microscope's current Z position");
        this.setTopButton_.setBounds(150, 50, 50, 22);
        this.slicesPanel_.add(this.setTopButton_);
        JLabel jLabel6 = new JLabel();
        jLabel6.setFont(new Font("Arial", 0, 10));
        jLabel6.setText("Z-step [um]");
        jLabel6.setBounds(30, 76, 69, 15);
        this.slicesPanel_.add(jLabel6);
        this.zStep_ = new JFormattedTextField(this.numberFormat_);
        this.zStep_.setFont(new Font("Arial", 0, 10));
        this.zStep_.setBounds(95, 73, 54, 21);
        this.zStep_.setValue(new Double(1.0));
        this.zStep_.addPropertyChangeListener("value", this);
        this.slicesPanel_.add(this.zStep_);
        this.zValCombo_ = new JComboBox();
        this.zValCombo_.setFont(new Font("Arial", 0, 10));
        this.zValCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.zValCalcChanged();
            }
        });
        this.zValCombo_.setModel(new DefaultComboBoxModel<String>(new String[]{"relative Z", "absolute Z"}));
        this.zValCombo_.setBounds(30, 97, 110, 22);
        this.slicesPanel_.add(this.zValCombo_);
        this.stackKeepShutterOpenCheckBox_ = new JCheckBox();
        this.stackKeepShutterOpenCheckBox_.setText("Keep shutter open");
        this.stackKeepShutterOpenCheckBox_.setFont(new Font("Arial", 0, 10));
        this.stackKeepShutterOpenCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.stackKeepShutterOpenCheckBox_.setSelected(false);
        this.stackKeepShutterOpenCheckBox_.setBounds(60, 121, 150, 22);
        this.slicesPanel_.add(this.stackKeepShutterOpenCheckBox_);
        this.acqOrderBox_ = new JComboBox();
        this.acqOrderBox_.setFont(new Font("", 0, 10));
        this.acqOrderBox_.setBounds(2, 26, 195, 22);
        this.acquisitionOrderPanel_.add(this.acqOrderBox_);
        this.acqOrderModes_ = new AcqOrderMode[4];
        this.acqOrderModes_[0] = new AcqOrderMode(0);
        this.acqOrderModes_[1] = new AcqOrderMode(1);
        this.acqOrderModes_[2] = new AcqOrderMode(2);
        this.acqOrderModes_[3] = new AcqOrderMode(3);
        this.acqOrderBox_.addItem(this.acqOrderModes_[0]);
        this.acqOrderBox_.addItem(this.acqOrderModes_[1]);
        this.acqOrderBox_.addItem(this.acqOrderModes_[2]);
        this.acqOrderBox_.addItem(this.acqOrderModes_[3]);
        this.summaryTextArea_ = new JTextArea();
        this.summaryTextArea_.setFont(new Font("Arial", 0, 11));
        this.summaryTextArea_.setEditable(false);
        this.summaryTextArea_.setBounds(4, 19, 350, 120);
        this.summaryTextArea_.setMargin(new Insets(2, 2, 2, 2));
        this.summaryTextArea_.setOpaque(false);
        this.summaryPanel_.add(this.summaryTextArea_);
        this.afPanel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.afButton_ = new JButton();
        this.afButton_.setToolTipText("Set autofocus options");
        this.afButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.afOptions();
            }
        });
        this.afButton_.setText("Options...");
        this.afButton_.setIcon(SwingResourceManager.getIcon(AcqControlDlg.class, "icons/wrench_orange.png"));
        this.afButton_.setMargin(new Insets(2, 5, 2, 5));
        this.afButton_.setFont(new Font("Dialog", 0, 10));
        this.afButton_.setBounds(50, 21, 100, 28);
        this.afPanel_.add(this.afButton_);
        JLabel jLabel7 = new JLabel();
        jLabel7.setFont(new Font("Dialog", 0, 10));
        jLabel7.setText("Skip frame(s): ");
        jLabel7.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("The number of 'frames skipped' correspondsto the number of time intervals of image acquisition that pass before micromanager autofocuses again.  Micromanager will always autofocus when moving to a new position regardless of this value"));
        jLabel7.setBounds(35, 54, 70, 21);
        this.afPanel_.add(jLabel7);
        this.afSkipInterval_ = new JSpinner(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        ((JSpinner.DefaultEditor)this.afSkipInterval_.getEditor()).getTextField().setFont(new Font("Arial", 0, 10));
        this.afSkipInterval_.setBounds(105, 54, 55, 22);
        this.afSkipInterval_.setValue(new Integer(this.acqEng_.getAfSkipInterval()));
        this.afSkipInterval_.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AcqControlDlg.this.applySettings();
                AcqControlDlg.this.afSkipInterval_.setValue(new Integer(AcqControlDlg.this.acqEng_.getAfSkipInterval()));
            }
        });
        this.afPanel_.add(this.afSkipInterval_);
        this.channelsPanel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        JLabel jLabel8 = new JLabel();
        jLabel8.setFont(new Font("Arial", 0, 10));
        jLabel8.setBounds(90, 19, 80, 24);
        jLabel8.setText("Channel group:");
        this.channelsPanel_.add(jLabel8);
        this.channelGroupCombo_ = new JComboBox();
        this.channelGroupCombo_.setFont(new Font("", 0, 10));
        this.updateGroupsCombo();
        this.channelGroupCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)AcqControlDlg.this.channelGroupCombo_.getSelectedItem();
                if (AcqControlDlg.this.acqEng_.setChannelGroup(string)) {
                    AcqControlDlg.this.model_.cleanUpConfigurationList();
                    if (AcqControlDlg.this.gui_.getAutofocusManager() != null) {
                        try {
                            AcqControlDlg.this.gui_.getAutofocusManager().refresh();
                        }
                        catch (MMException mMException) {
                            ReportingUtils.showError(mMException);
                        }
                    }
                } else {
                    AcqControlDlg.this.updateGroupsCombo();
                }
            }
        });
        this.channelGroupCombo_.setBounds(165, 20, 150, 22);
        this.channelsPanel_.add(this.channelGroupCombo_);
        this.channelTablePane_ = new JScrollPane();
        this.channelTablePane_.setFont(new Font("Arial", 0, 10));
        this.channelTablePane_.setBounds(10, 45, 414, 90);
        this.channelsPanel_.add(this.channelTablePane_);
        JButton jButton2 = new JButton();
        jButton2.setFont(new Font("Arial", 0, 10));
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
                AcqControlDlg.this.model_.addNewChannel();
                AcqControlDlg.this.model_.fireTableStructureChanged();
            }
        });
        jButton2.setText("New");
        jButton2.setToolTipText("Create new channel for currently selected channel group");
        jButton2.setBounds(430, 45, 68, 22);
        this.channelsPanel_.add(jButton2);
        JButton jButton3 = new JButton();
        jButton3.setFont(new Font("Arial", 0, 10));
        jButton3.setMargin(new Insets(-5, -5, -5, -5));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AcqControlDlg.this.channelTable_.getSelectedRow();
                if (n > -1) {
                    AcqControlDlg.this.applySettings();
                    AcqControlDlg.this.model_.removeChannel(n);
                    AcqControlDlg.this.model_.fireTableStructureChanged();
                    if (AcqControlDlg.this.channelTable_.getRowCount() > n) {
                        AcqControlDlg.this.channelTable_.setRowSelectionInterval(n, n);
                    }
                }
            }
        });
        jButton3.setText("Remove");
        jButton3.setToolTipText("Remove currently selected channel");
        jButton3.setBounds(430, 69, 68, 22);
        this.channelsPanel_.add(jButton3);
        JButton jButton4 = new JButton();
        jButton4.setFont(new Font("Arial", 0, 10));
        jButton4.setMargin(new Insets(0, 0, 0, 0));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AcqControlDlg.this.channelTable_.getSelectedRow();
                if (n > -1) {
                    AcqControlDlg.this.applySettings();
                    int n2 = AcqControlDlg.this.model_.rowUp(n);
                    AcqControlDlg.this.model_.fireTableStructureChanged();
                    AcqControlDlg.this.channelTable_.setRowSelectionInterval(n2, n2);
                }
            }
        });
        jButton4.setText("Up");
        jButton4.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Move currently selected channel up (Channels higher on list are acquired first)"));
        jButton4.setBounds(430, 93, 68, 22);
        this.channelsPanel_.add(jButton4);
        JButton jButton5 = new JButton();
        jButton5.setFont(new Font("Arial", 0, 10));
        jButton5.setMargin(new Insets(0, 0, 0, 0));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AcqControlDlg.this.channelTable_.getSelectedRow();
                if (n > -1) {
                    AcqControlDlg.this.applySettings();
                    int n2 = AcqControlDlg.this.model_.rowDown(n);
                    AcqControlDlg.this.model_.fireTableStructureChanged();
                    AcqControlDlg.this.channelTable_.setRowSelectionInterval(n2, n2);
                }
            }
        });
        jButton5.setText("Down");
        jButton5.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip("Move currently selected channel down (Channels lower on list are acquired later)"));
        jButton5.setBounds(430, 117, 68, 22);
        this.channelsPanel_.add(jButton5);
        this.chanKeepShutterOpenCheckBox_ = new JCheckBox();
        this.chanKeepShutterOpenCheckBox_.setText("Keep shutter open");
        this.chanKeepShutterOpenCheckBox_.setFont(new Font("Arial", 0, 10));
        this.chanKeepShutterOpenCheckBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.chanKeepShutterOpenCheckBox_.setSelected(false);
        this.chanKeepShutterOpenCheckBox_.setBounds(330, 20, 150, 22);
        this.channelsPanel_.add(this.chanKeepShutterOpenCheckBox_);
        this.savePanel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!AcqControlDlg.this.savePanel_.isSelected()) {
                    AcqControlDlg.this.displayModeCombo_.setSelectedIndex(0);
                }
                AcqControlDlg.this.applySettings();
            }
        });
        this.displayMode_ = new JLabel();
        this.displayMode_.setFont(new Font("Arial", 0, 10));
        this.displayMode_.setText("Display");
        this.displayMode_.setBounds(150, 15, 49, 21);
        this.displayModeCombo_ = new JComboBox();
        this.displayModeCombo_.setFont(new Font("", 0, 10));
        this.displayModeCombo_.setBounds(188, 14, 150, 24);
        this.displayModeCombo_.addItem(new DisplayMode(0));
        this.displayModeCombo_.addItem(new DisplayMode(1));
        this.displayModeCombo_.addItem(new DisplayMode(2));
        this.displayModeCombo_.setEnabled(false);
        this.rootLabel_ = new JLabel();
        this.rootLabel_.setFont(new Font("Arial", 0, 10));
        this.rootLabel_.setText("Directory root");
        this.rootLabel_.setBounds(10, 30, 72, 22);
        this.savePanel_.add(this.rootLabel_);
        this.rootField_ = new JTextField();
        this.rootField_.setFont(new Font("Arial", 0, 10));
        this.rootField_.setBounds(90, 30, 354, 22);
        this.savePanel_.add(this.rootField_);
        this.browseRootButton_ = new JButton();
        this.browseRootButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.setRootDirectory();
            }
        });
        this.browseRootButton_.setMargin(new Insets(2, 5, 2, 5));
        this.browseRootButton_.setFont(new Font("Dialog", 0, 10));
        this.browseRootButton_.setText("...");
        this.browseRootButton_.setBounds(445, 30, 47, 24);
        this.savePanel_.add(this.browseRootButton_);
        this.browseRootButton_.setToolTipText("Browse");
        this.namePrefixLabel_ = new JLabel();
        this.namePrefixLabel_.setFont(new Font("Arial", 0, 10));
        this.namePrefixLabel_.setText("Name prefix");
        this.namePrefixLabel_.setBounds(10, 55, 76, 22);
        this.savePanel_.add(this.namePrefixLabel_);
        this.nameField_ = new JTextField();
        this.nameField_.setFont(new Font("Arial", 0, 10));
        this.nameField_.setBounds(90, 55, 354, 22);
        this.savePanel_.add(this.nameField_);
        this.saveTypeLabel_ = new JLabel("Saving format: ");
        this.saveTypeLabel_.setFont(new Font("Arial", 0, 10));
        this.saveTypeLabel_.setBounds(10, 80, 100, 22);
        this.savePanel_.add(this.saveTypeLabel_);
        this.singleButton_ = new JRadioButton("Single-image files");
        this.singleButton_.setFont(new Font("Arial", 0, 10));
        this.singleButton_.setBounds(110, 80, 150, 22);
        this.savePanel_.add(this.singleButton_);
        this.singleButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageUtils.setImageStorageClass(TaggedImageStorageDiskDefault.class);
            }
        });
        this.multiButton_ = new JRadioButton("Multi-image files");
        this.multiButton_.setFont(new Font("Arial", 0, 10));
        this.multiButton_.setBounds(260, 80, 200, 22);
        this.savePanel_.add(this.multiButton_);
        this.multiButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageUtils.setImageStorageClass(TaggedImageStorageMultipageTiff.class);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.singleButton_);
        buttonGroup.add(this.multiButton_);
        this.updateSavingTypeButtons();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setBounds(10, 28, 485, 50);
        this.commentsPanel_.add(jScrollPane);
        this.commentTextArea_ = new JTextArea();
        jScrollPane.setViewportView(this.commentTextArea_);
        this.commentTextArea_.setFont(new Font("", 0, 10));
        this.commentTextArea_.setToolTipText("Comment for the current acquistion");
        this.commentTextArea_.setWrapStyleWord(true);
        this.commentTextArea_.setLineWrap(true);
        this.commentTextArea_.setBorder(new EtchedBorder(1));
        JButton jButton6 = new JButton();
        jButton6.setFont(new Font("Arial", 0, 10));
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.saveSettings();
                AcqControlDlg.this.saveAcqSettings();
                AcqControlDlg.this.dispose();
                AcqControlDlg.this.gui_.makeActive();
            }
        });
        jButton6.setText("Close");
        jButton6.setBounds(432, 10, 80, 22);
        this.getContentPane().add(jButton6);
        JButton jButton7 = new JButton();
        jButton7.setMargin(new Insets(-9, -9, -9, -9));
        jButton7.setFont(new Font("Arial", 1, 12));
        jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractCellEditor abstractCellEditor = (AbstractCellEditor)((Object)AcqControlDlg.this.channelTable_.getCellEditor());
                if (abstractCellEditor != null) {
                    abstractCellEditor.stopCellEditing();
                }
                AcqControlDlg.this.runAcquisition();
            }
        });
        jButton7.setText("Acquire!");
        jButton7.setBounds(432, 44, 80, 22);
        this.getContentPane().add(jButton7);
        JButton jButton8 = new JButton();
        jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.acqEng_.abortRequest();
            }
        });
        jButton8.setText("Stop");
        jButton8.setFont(new Font("Arial", 1, 12));
        jButton8.setBounds(432, 68, 80, 22);
        this.getContentPane().add(jButton8);
        JButton jButton9 = new JButton();
        jButton9.setFont(new Font("Arial", 0, 10));
        jButton9.setMargin(new Insets(-5, -5, -5, -5));
        jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.loadAcqSettingsFromFile();
            }
        });
        jButton9.setText("Load...");
        jButton9.setBounds(432, 102, 80, 22);
        this.getContentPane().add(jButton9);
        jButton9.setToolTipText("Load acquisition settings");
        JButton jButton10 = new JButton();
        jButton10.setFont(new Font("Arial", 0, 10));
        jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.saveAsAcqSettingsToFile();
            }
        });
        jButton10.setToolTipText("Save current acquisition settings as");
        jButton10.setText("Save as...");
        jButton10.setBounds(432, 126, 80, 22);
        jButton10.setMargin(new Insets(-5, -5, -5, -5));
        this.getContentPane().add(jButton10);
        JButton jButton11 = new JButton();
        jButton11.setFont(new Font("Arial", 0, 10));
        jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.showAdvancedDialog();
                AcqControlDlg.this.updateGUIContents();
            }
        });
        jButton11.setText("Advanced");
        jButton11.setBounds(432, 170, 80, 22);
        this.getContentPane().add(jButton11);
        int n = 100;
        int n2 = 100;
        this.setBounds(n, n2, 521, 690);
        if (this.prefs_ != null) {
            n = this.prefs_.getInt(ACQ_CONTROL_X, n);
            n2 = this.prefs_.getInt(ACQ_CONTROL_Y, n2);
            this.setLocation(n, n2);
        }
        this.positionsPanel_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.displayModeCombo_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.acqOrderBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AcqControlDlg.this.applySettings();
            }
        });
        this.loadAcqSettings();
        this.createChannelTable();
        this.updateGUIContents();
        this.applySettings();
        this.createToolTips();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.applySettings();
        this.summaryTextArea_.setText(this.acqEng_.getVerboseSummary());
    }

    protected void afOptions() {
        if (this.gui_.getAutofocusManager().getDevice() != null) {
            this.gui_.getAutofocusManager().showOptionsDialog();
        }
    }

    public boolean inArray(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public void updateSavingTypeButtons() {
        if (ImageUtils.getImageStorageClass().equals(TaggedImageStorageDiskDefault.class)) {
            this.singleButton_.setSelected(true);
        } else if (ImageUtils.getImageStorageClass().equals(TaggedImageStorageMultipageTiff.class)) {
            this.multiButton_.setSelected(true);
        }
    }

    public void close() {
        try {
            this.saveSettings();
        }
        catch (Throwable throwable) {
            ReportingUtils.logError(throwable, "in saveSettings");
        }
        try {
            this.saveAcqSettings();
        }
        catch (Throwable throwable) {
            ReportingUtils.logError(throwable, "in saveAcqSettings");
        }
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            ReportingUtils.logError(throwable, "in dispose");
        }
        if (null != this.gui_) {
            try {
                this.gui_.makeActive();
            }
            catch (Throwable throwable) {
                ReportingUtils.logError(throwable, "in makeActive");
            }
        }
    }

    public final void updateGroupsCombo() {
        String[] stringArray = this.acqEng_.getAvailableGroups();
        if (stringArray.length != 0) {
            this.channelGroupCombo_.setModel(new DefaultComboBoxModel<String>(stringArray));
            if (!this.inArray(this.acqEng_.getChannelGroup(), stringArray)) {
                this.acqEng_.setChannelGroup(this.acqEng_.getFirstConfigGroup());
            }
            this.channelGroupCombo_.setSelectedItem(this.acqEng_.getChannelGroup());
        }
    }

    public void updateChannelAndGroupCombo() {
        this.updateGroupsCombo();
        this.model_.cleanUpConfigurationList();
    }

    public final synchronized void loadAcqSettings() {
        int n;
        int n2;
        Component[] componentArray;
        this.disableGUItoSettings_ = true;
        this.acqEng_.clear();
        int n3 = this.acqPrefs_.getInt(ACQ_NUMFRAMES, 1);
        double d = this.acqPrefs_.getDouble(ACQ_INTERVAL, 0.0);
        this.acqEng_.setFrames(n3, d);
        this.acqEng_.enableFramesSetting(this.acqPrefs_.getBoolean(ACQ_ENABLE_MULTI_FRAME, false));
        boolean bl = this.acqEng_.isFramesSettingEnabled();
        this.framesPanel_.setSelected(bl);
        this.framesPanel_.setSelected(bl);
        for (Component component : componentArray = this.framesSubPanel_.getComponents()) {
            for (Component object2 : ((JPanel)component).getComponents()) {
                object2.setEnabled(bl);
            }
        }
        this.numFrames_.setValue(this.acqEng_.getNumFrames());
        int n4 = this.acqPrefs_.getInt(ACQ_TIME_UNIT, 0);
        this.timeUnitCombo_.setSelectedIndex(n4);
        double d2 = this.acqPrefs_.getDouble(ACQ_ZBOTTOM, 0.0);
        double d3 = this.acqPrefs_.getDouble(ACQ_ZTOP, 0.0);
        double d4 = this.acqPrefs_.getDouble(ACQ_ZSTEP, 1.0);
        if (Math.abs(d4) < Math.abs(this.acqEng_.getMinZStepUm())) {
            d4 = this.acqEng_.getMinZStepUm();
        }
        this.zVals_ = this.acqPrefs_.getInt(ACQ_Z_VALUES, 0);
        this.acqEng_.setSlices(d2, d3, d4, this.zVals_ != 0);
        this.acqEng_.enableZSliceSetting(this.acqPrefs_.getBoolean(ACQ_ENABLE_SLICE_SETTINGS, this.acqEng_.isZSliceSettingEnabled()));
        this.acqEng_.enableMultiPosition(this.acqPrefs_.getBoolean(ACQ_ENABLE_MULTI_POSITION, this.acqEng_.isMultiPositionEnabled()));
        this.positionsPanel_.setSelected(this.acqEng_.isMultiPositionEnabled());
        this.slicesPanel_.setSelected(this.acqEng_.isZSliceSettingEnabled());
        this.acqEng_.enableChannelsSetting(this.acqPrefs_.getBoolean(ACQ_ENABLE_MULTI_CHANNEL, false));
        this.channelsPanel_.setSelected(this.acqEng_.isChannelsSettingEnabled());
        this.savePanel_.setSelected(this.acqPrefs_.getBoolean(ACQ_SAVE_FILES, false));
        this.nameField_.setText(this.acqPrefs_.get(ACQ_DIR_NAME, "Untitled"));
        String string = System.getProperty("os.name", "");
        this.rootField_.setText(this.acqPrefs_.get(ACQ_ROOT_NAME, System.getProperty("user.home") + "/AcquisitionData"));
        this.acqEng_.setAcqOrderMode(this.acqPrefs_.getInt(ACQ_ORDER_MODE, this.acqEng_.getAcqOrderMode()));
        this.acqEng_.setDisplayMode(this.acqPrefs_.getInt(ACQ_DISPLAY_MODE, this.acqEng_.getDisplayMode()));
        this.acqEng_.enableAutoFocus(this.acqPrefs_.getBoolean(ACQ_AF_ENABLE, this.acqEng_.isAutoFocusEnabled()));
        this.acqEng_.setAfSkipInterval(this.acqPrefs_.getInt(ACQ_AF_SKIP_INTERVAL, this.acqEng_.getAfSkipInterval()));
        this.acqEng_.setChannelGroup(this.acqPrefs_.get(ACQ_CHANNEL_GROUP, this.acqEng_.getFirstConfigGroup()));
        this.afPanel_.setSelected(this.acqEng_.isAutoFocusEnabled());
        this.acqEng_.keepShutterOpenForChannels(this.acqPrefs_.getBoolean(ACQ_CHANNELS_KEEP_SHUTTER_OPEN, false));
        this.acqEng_.keepShutterOpenForStack(this.acqPrefs_.getBoolean(ACQ_STACK_KEEP_SHUTTER_OPEN, false));
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n5 = 0;
        while (true) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!(this.acqPrefs_.getDouble(stringBuilder.append(CUSTOM_INTERVAL_PREFIX).append(n5).toString(), -1.0) >= 0.0)) break;
            arrayList.add(this.acqPrefs_.getDouble(CUSTOM_INTERVAL_PREFIX + n5, -1.0));
            ++n5;
        }
        double[] dArray = new double[arrayList.size()];
        for (n2 = 0; n2 < dArray.length; ++n2) {
            dArray[n2] = (Double)arrayList.get(n2);
        }
        this.acqEng_.setCustomTimeIntervals(dArray);
        this.acqEng_.enableCustomTimeIntervals(this.acqPrefs_.getBoolean(ACQ_ENABLE_CUSTOM_INTERVALS, false));
        n2 = this.acqPrefs_.getInt(ACQ_NUM_CHANNELS, 0);
        ChannelSpec channelSpec = new ChannelSpec();
        this.acqEng_.getChannels().clear();
        for (n = 0; n < n2; ++n) {
            String i = this.acqPrefs_.get(CHANNEL_NAME_PREFIX + n, "Undefined");
            boolean bl2 = this.acqPrefs_.getBoolean(CHANNEL_USE_PREFIX + n, true);
            double d5 = this.acqPrefs_.getDouble(CHANNEL_EXPOSURE_PREFIX + n, 0.0);
            Boolean bl3 = this.acqPrefs_.getBoolean(CHANNEL_DOZSTACK_PREFIX + n, true);
            double d6 = this.acqPrefs_.getDouble(CHANNEL_ZOFFSET_PREFIX + n, 0.0);
            ContrastSettings contrastSettings = new ContrastSettings();
            contrastSettings.min = this.acqPrefs_.getInt(CHANNEL_CONTRAST_MIN_PREFIX + n, channelSpec.contrast_.min);
            contrastSettings.max = this.acqPrefs_.getInt(CHANNEL_CONTRAST_MAX_PREFIX + n, channelSpec.contrast_.max);
            contrastSettings.gamma = this.acqPrefs_.getDouble(CHANNEL_CONTRAST_GAMMA_PREFIX + n, channelSpec.contrast_.gamma);
            int n6 = this.acqPrefs_.getInt(CHANNEL_COLOR_R_PREFIX + n, channelSpec.color_.getRed());
            int n7 = this.acqPrefs_.getInt(CHANNEL_COLOR_G_PREFIX + n, channelSpec.color_.getGreen());
            int n8 = this.acqPrefs_.getInt(CHANNEL_COLOR_B_PREFIX + n, channelSpec.color_.getBlue());
            int n9 = this.acqPrefs_.getInt(CHANNEL_SKIP_PREFIX + n, channelSpec.skipFactorFrame_);
            Color color = new Color(n6, n7, n8);
            this.acqEng_.addChannel(i, d5, bl3, d6, contrastSettings, n9, color, bl2);
        }
        n = 7;
        this.columnWidth_ = new int[n];
        this.columnOrder_ = new int[n];
        for (int i = 0; i < n; ++i) {
            this.columnWidth_[i] = this.acqPrefs_.getInt(ACQ_COLUMN_WIDTH + i, 77);
            this.columnOrder_[i] = this.acqPrefs_.getInt(ACQ_COLUMN_ORDER + i, i);
        }
        this.disableGUItoSettings_ = false;
    }

    public synchronized void saveAcqSettings() {
        try {
            this.acqPrefs_.clear();
        }
        catch (BackingStoreException backingStoreException) {
            ReportingUtils.showError(backingStoreException);
        }
        this.applySettings();
        this.acqPrefs_.putBoolean(ACQ_ENABLE_MULTI_FRAME, this.acqEng_.isFramesSettingEnabled());
        this.acqPrefs_.putBoolean(ACQ_ENABLE_MULTI_CHANNEL, this.acqEng_.isChannelsSettingEnabled());
        this.acqPrefs_.putInt(ACQ_NUMFRAMES, this.acqEng_.getNumFrames());
        this.acqPrefs_.putDouble(ACQ_INTERVAL, this.acqEng_.getFrameIntervalMs());
        this.acqPrefs_.putInt(ACQ_TIME_UNIT, this.timeUnitCombo_.getSelectedIndex());
        this.acqPrefs_.putDouble(ACQ_ZBOTTOM, this.acqEng_.getSliceZBottomUm());
        this.acqPrefs_.putDouble(ACQ_ZTOP, this.acqEng_.getZTopUm());
        this.acqPrefs_.putDouble(ACQ_ZSTEP, this.acqEng_.getSliceZStepUm());
        this.acqPrefs_.putBoolean(ACQ_ENABLE_SLICE_SETTINGS, this.acqEng_.isZSliceSettingEnabled());
        this.acqPrefs_.putBoolean(ACQ_ENABLE_MULTI_POSITION, this.acqEng_.isMultiPositionEnabled());
        this.acqPrefs_.putInt(ACQ_Z_VALUES, this.zVals_);
        this.acqPrefs_.putBoolean(ACQ_SAVE_FILES, this.savePanel_.isSelected());
        this.acqPrefs_.put(ACQ_DIR_NAME, this.nameField_.getText());
        this.acqPrefs_.put(ACQ_ROOT_NAME, this.rootField_.getText());
        this.acqPrefs_.putInt(ACQ_ORDER_MODE, this.acqEng_.getAcqOrderMode());
        this.acqPrefs_.putInt(ACQ_DISPLAY_MODE, this.acqEng_.getDisplayMode());
        this.acqPrefs_.putBoolean(ACQ_AF_ENABLE, this.acqEng_.isAutoFocusEnabled());
        this.acqPrefs_.putInt(ACQ_AF_SKIP_INTERVAL, this.acqEng_.getAfSkipInterval());
        this.acqPrefs_.putBoolean(ACQ_CHANNELS_KEEP_SHUTTER_OPEN, this.acqEng_.isShutterOpenForChannels());
        this.acqPrefs_.putBoolean(ACQ_STACK_KEEP_SHUTTER_OPEN, this.acqEng_.isShutterOpenForStack());
        this.acqPrefs_.put(ACQ_CHANNEL_GROUP, this.acqEng_.getChannelGroup());
        ArrayList<ChannelSpec> arrayList = this.acqEng_.getChannels();
        this.acqPrefs_.putInt(ACQ_NUM_CHANNELS, arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            ChannelSpec channelSpec = arrayList.get(i);
            this.acqPrefs_.put(CHANNEL_NAME_PREFIX + i, channelSpec.config_);
            this.acqPrefs_.putBoolean(CHANNEL_USE_PREFIX + i, channelSpec.useChannel_);
            this.acqPrefs_.putDouble(CHANNEL_EXPOSURE_PREFIX + i, channelSpec.exposure_);
            this.acqPrefs_.putBoolean(CHANNEL_DOZSTACK_PREFIX + i, channelSpec.doZStack_);
            this.acqPrefs_.putDouble(CHANNEL_ZOFFSET_PREFIX + i, channelSpec.zOffset_);
            this.acqPrefs_.putInt(CHANNEL_CONTRAST_MIN_PREFIX + i, channelSpec.contrast_.min);
            this.acqPrefs_.putInt(CHANNEL_CONTRAST_MAX_PREFIX + i, channelSpec.contrast_.max);
            this.acqPrefs_.putDouble(CHANNEL_CONTRAST_GAMMA_PREFIX + i, channelSpec.contrast_.gamma);
            this.acqPrefs_.putInt(CHANNEL_COLOR_R_PREFIX + i, channelSpec.color_.getRed());
            this.acqPrefs_.putInt(CHANNEL_COLOR_G_PREFIX + i, channelSpec.color_.getGreen());
            this.acqPrefs_.putInt(CHANNEL_COLOR_B_PREFIX + i, channelSpec.color_.getBlue());
            this.acqPrefs_.putInt(CHANNEL_SKIP_PREFIX + i, channelSpec.skipFactorFrame_);
        }
        double[] dArray = this.acqEng_.getCustomTimeIntervals();
        if (dArray != null && dArray.length > 0) {
            for (int i = 0; i < dArray.length; ++i) {
                this.acqPrefs_.putDouble(CUSTOM_INTERVAL_PREFIX + i, dArray[i]);
            }
        }
        this.acqPrefs_.putBoolean(ACQ_ENABLE_CUSTOM_INTERVALS, this.acqEng_.customTimeIntervalsEnabled());
        for (int i = 0; i < this.model_.getColumnCount(); ++i) {
            this.acqPrefs_.putInt(ACQ_COLUMN_WIDTH + i, this.findTableColumn(this.channelTable_, i).getWidth());
            this.acqPrefs_.putInt(ACQ_COLUMN_ORDER + i, this.channelTable_.convertColumnIndexToView(i));
        }
        try {
            this.acqPrefs_.flush();
        }
        catch (BackingStoreException backingStoreException) {
            ReportingUtils.logError(backingStoreException);
        }
    }

    public TableColumn findTableColumn(JTable jTable, int n) {
        Enumeration<TableColumn> enumeration = jTable.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn.getModelIndex() != n) continue;
            return tableColumn;
        }
        return null;
    }

    protected void enableZSliceControls(boolean bl) {
        this.zBottom_.setEnabled(bl);
        this.zTop_.setEnabled(bl);
        this.zStep_.setEnabled(bl);
        this.zValCombo_.setEnabled(bl);
    }

    protected void setRootDirectory() {
        File file = FileDialogs.openDir(this, "Please choose a directory root for image data", MMStudioMainFrame.MM_DATA_SET);
        if (file != null) {
            this.rootField_.setText(file.getAbsolutePath());
            this.acqEng_.setRootName(file.getAbsolutePath());
        }
    }

    protected void setTopPosition() {
        double d = this.acqEng_.getCurrentZPos();
        this.zTop_.setText(NumberUtils.doubleToDisplayString(d));
        this.applySettings();
        this.summaryTextArea_.setText(this.acqEng_.getVerboseSummary());
    }

    protected void setBottomPosition() {
        double d = this.acqEng_.getCurrentZPos();
        this.zBottom_.setText(NumberUtils.doubleToDisplayString(d));
        this.applySettings();
        this.summaryTextArea_.setText(this.acqEng_.getVerboseSummary());
    }

    protected void loadAcqSettingsFromFile() {
        File file = FileDialogs.openFile(this, "Load acquisition settings", ACQ_SETTINGS_FILE);
        if (file != null) {
            this.loadAcqSettingsFromFile(file.getAbsolutePath());
        }
    }

    public void loadAcqSettingsFromFile(String string) {
        this.acqFile_ = new File(string);
        try {
            FileInputStream fileInputStream = new FileInputStream(this.acqFile_);
            this.acqPrefs_.clear();
            Preferences.importPreferences(fileInputStream);
            this.loadAcqSettings();
            this.updateGUIContents();
            fileInputStream.close();
            this.acqDir_ = this.acqFile_.getParent();
            if (this.acqDir_ != null) {
                this.prefs_.put(ACQ_FILE_DIR, this.acqDir_);
            }
        }
        catch (Exception exception) {
            ReportingUtils.showError(exception);
            return;
        }
    }

    protected boolean saveAsAcqSettingsToFile() {
        this.saveAcqSettings();
        File file = FileDialogs.save(this, "Save the acquisition settings file", ACQ_SETTINGS_FILE);
        if (file != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.acqPrefs_.exportNode(fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ReportingUtils.showError(fileNotFoundException);
                return false;
            }
            catch (IOException iOException) {
                ReportingUtils.showError(iOException);
                return false;
            }
            catch (BackingStoreException backingStoreException) {
                ReportingUtils.showError(backingStoreException);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean enoughMemoryAvailable() {
        long l;
        long l2;
        int n;
        double d;
        double d2;
        double d3;
        if (this.savePanel_.isSelected()) {
            return true;
        }
        Runtime.getRuntime().gc();
        boolean bl = this.channelsPanel_.isSelected();
        boolean bl2 = this.framesPanel_.isSelected();
        boolean bl3 = this.slicesPanel_.isSelected();
        boolean bl4 = this.positionsPanel_.isSelected();
        int n2 = Math.max(1, (Integer)this.numFrames_.getValue());
        if (this.acqEng_.customTimeIntervalsEnabled()) {
            int n3 = 0;
            while (true) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!(this.acqPrefs_.getDouble(stringBuilder.append(CUSTOM_INTERVAL_PREFIX).append(n3).toString(), -1.0) >= 0.0)) break;
                ++n3;
            }
            n2 = Math.max(1, n3);
        }
        try {
            d3 = NumberUtils.displayStringToDouble(this.zTop_.getText());
            d2 = NumberUtils.displayStringToDouble(this.zBottom_.getText());
            d = NumberUtils.displayStringToDouble(this.zStep_.getText());
        }
        catch (ParseException parseException) {
            ReportingUtils.showError("Invalid Z-Stacks input value");
            return false;
        }
        int n4 = Math.max(1, (int)(1.0 + Math.floor(Math.abs(d3 - d2) / d)));
        int n5 = 1;
        try {
            n5 = Math.max(1, this.gui_.getPositionList().getNumberOfPositions());
        }
        catch (MMScriptException mMScriptException) {
            // empty catch block
        }
        if (bl) {
            ArrayList<ChannelSpec> arrayList = ((ChannelTableModel)this.channelTable_.getModel()).getChannels();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!arrayList.get((int)i).useChannel_) continue;
                int n6 = 1;
                if (bl2) {
                    n6 *= Math.max(1, n2 / (arrayList.get((int)i).skipFactorFrame_ + 1));
                }
                if (bl3 && arrayList.get((int)i).doZStack_.booleanValue()) {
                    n6 *= n4;
                }
                if (bl4) {
                    n6 *= n5;
                }
                arrayList2.add(n6);
            }
            n = 0;
            for (Integer n7 : arrayList2) {
                n += n7.intValue();
            }
        } else {
            n = 1;
            if (bl3) {
                n *= n4;
            }
            if (bl2) {
                n *= n2;
            }
            if (bl4) {
                n *= n5;
            }
        }
        double d4 = Runtime.getRuntime().freeMemory();
        double d5 = Runtime.getRuntime().totalMemory();
        double d6 = Runtime.getRuntime().maxMemory();
        double d7 = d5 - d4;
        CMMCore cMMCore = MMStudioMainFrame.getInstance().getCore();
        long l3 = cMMCore.getBytesPerPixel();
        long l4 = l3 * (l2 = cMMCore.getImageWidth()) * (l = cMMCore.getImageHeight());
        long l5 = l4 * (long)n;
        if (d7 + (double)l5 > 0.72 * d6) {
            int n8 = JOptionPane.showConfirmDialog(this, "Warning: available RAM may be insufficent for full acquisition. \nSave images to disk or increase maximum memory by selecting \nEdit--Options--Memory & Threads on ImageJ toolbar. \n\n Would you like to run acquisition anyway?", "Insufficient memory warning", 0);
            return n8 == 0;
        }
        return true;
    }

    public String runAcquisition() {
        if (this.acqEng_.isAcquisitionRunning()) {
            JOptionPane.showMessageDialog(this, "Cannot start acquisition: previous acquisition still in progress.");
            return null;
        }
        if (!this.enoughMemoryAvailable()) {
            return null;
        }
        try {
            this.applySettings();
            ChannelTableModel channelTableModel = (ChannelTableModel)this.channelTable_.getModel();
            if (this.acqEng_.isChannelsSettingEnabled() && channelTableModel.duplicateChannels()) {
                JOptionPane.showMessageDialog(this, "Cannot start acquisition using the same channel twice");
                return null;
            }
            return this.acqEng_.acquire();
        }
        catch (MMException mMException) {
            ReportingUtils.showError(mMException);
            return null;
        }
    }

    public String runAcquisition(String string, String string2) {
        if (this.acqEng_.isAcquisitionRunning()) {
            JOptionPane.showMessageDialog(this, "Unable to start the new acquisition task: previous acquisition still in progress.");
            return null;
        }
        if (!this.enoughMemoryAvailable()) {
            return null;
        }
        try {
            this.applySettings();
            ChannelTableModel channelTableModel = (ChannelTableModel)this.channelTable_.getModel();
            if (this.acqEng_.isChannelsSettingEnabled() && channelTableModel.duplicateChannels()) {
                JOptionPane.showMessageDialog(this, "Cannot start acquisition using the same channel twice");
                return null;
            }
            this.acqEng_.setDirName(string);
            this.acqEng_.setRootName(string2);
            this.acqEng_.setSaveFiles(true);
            return this.acqEng_.acquire();
        }
        catch (MMException mMException) {
            ReportingUtils.showError(mMException);
            return null;
        }
    }

    public boolean isAcquisitionRunning() {
        return this.acqEng_.isAcquisitionRunning();
    }

    public static int search(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    private void checkForCustomTimeIntervals() {
        if (this.acqEng_.customTimeIntervalsEnabled()) {
            this.framesSubPanelLayout_.show(this.framesSubPanel_, OVERRIDE_FRAMES_PANEL_NAME);
        } else {
            this.framesSubPanelLayout_.show(this.framesSubPanel_, DEFAULT_FRAMES_PANEL_NAME);
        }
    }

    public final void updateGUIContents() {
        Component[] componentArray;
        if (this.disableGUItoSettings_) {
            return;
        }
        this.disableGUItoSettings_ = true;
        this.model_.setChannels(this.acqEng_.getChannels());
        double d = this.acqEng_.getFrameIntervalMs();
        this.interval_.setText(this.numberFormat_.format(this.convertMsToTime(d, this.timeUnitCombo_.getSelectedIndex())));
        this.zBottom_.setText(NumberUtils.doubleToDisplayString(this.acqEng_.getSliceZBottomUm()));
        this.zTop_.setText(NumberUtils.doubleToDisplayString(this.acqEng_.getZTopUm()));
        this.zStep_.setText(NumberUtils.doubleToDisplayString(this.acqEng_.getSliceZStepUm()));
        boolean bl = this.acqEng_.isFramesSettingEnabled();
        this.framesPanel_.setSelected(bl);
        for (Component n3 : componentArray = this.framesSubPanel_.getComponents()) {
            for (Component component : ((JPanel)n3).getComponents()) {
                component.setEnabled(bl);
            }
        }
        this.checkForCustomTimeIntervals();
        this.slicesPanel_.setSelected(this.acqEng_.isZSliceSettingEnabled());
        this.positionsPanel_.setSelected(this.acqEng_.isMultiPositionEnabled());
        this.afPanel_.setSelected(this.acqEng_.isAutoFocusEnabled());
        this.acqOrderBox_.setEnabled(this.positionsPanel_.isSelected() || this.framesPanel_.isSelected() || this.slicesPanel_.isSelected() || this.channelsPanel_.isSelected());
        this.afSkipInterval_.setEnabled(this.acqEng_.isAutoFocusEnabled());
        Integer n = new Integer(this.acqEng_.getNumFrames());
        Integer n2 = new Integer(this.acqEng_.getAfSkipInterval());
        if (this.acqEng_.isFramesSettingEnabled()) {
            this.numFrames_.setValue(n);
        }
        this.afSkipInterval_.setValue(n2);
        this.enableZSliceControls(this.acqEng_.isZSliceSettingEnabled());
        this.model_.fireTableStructureChanged();
        this.channelGroupCombo_.setSelectedItem(this.acqEng_.getChannelGroup());
        try {
            this.displayModeCombo_.setSelectedIndex(this.acqEng_.getDisplayMode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.displayModeCombo_.setSelectedIndex(0);
        }
        for (AcqOrderMode acqOrderMode : this.acqOrderModes_) {
            acqOrderMode.setEnabled(this.framesPanel_.isSelected(), this.positionsPanel_.isSelected(), this.slicesPanel_.isSelected(), this.channelsPanel_.isSelected());
        }
        int n3 = this.acqEng_.getAcqOrderMode();
        this.acqOrderBox_.removeAllItems();
        if (this.framesPanel_.isSelected() && this.positionsPanel_.isSelected() && this.slicesPanel_.isSelected() && this.channelsPanel_.isSelected()) {
            this.acqOrderBox_.addItem(this.acqOrderModes_[0]);
            this.acqOrderBox_.addItem(this.acqOrderModes_[1]);
            this.acqOrderBox_.addItem(this.acqOrderModes_[2]);
            this.acqOrderBox_.addItem(this.acqOrderModes_[3]);
        } else if (this.framesPanel_.isSelected() && this.positionsPanel_.isSelected()) {
            if (n3 == 0 || n3 == 2) {
                this.acqOrderBox_.addItem(this.acqOrderModes_[0]);
                this.acqOrderBox_.addItem(this.acqOrderModes_[2]);
            } else {
                this.acqOrderBox_.addItem(this.acqOrderModes_[1]);
                this.acqOrderBox_.addItem(this.acqOrderModes_[3]);
            }
        } else if (this.channelsPanel_.isSelected() && this.slicesPanel_.isSelected()) {
            if (n3 == 0 || n3 == 1) {
                this.acqOrderBox_.addItem(this.acqOrderModes_[0]);
                this.acqOrderBox_.addItem(this.acqOrderModes_[1]);
            } else {
                this.acqOrderBox_.addItem(this.acqOrderModes_[2]);
                this.acqOrderBox_.addItem(this.acqOrderModes_[3]);
            }
        } else {
            this.acqOrderBox_.addItem(this.acqOrderModes_[n3]);
        }
        this.acqOrderBox_.setSelectedItem(this.acqOrderModes_[this.acqEng_.getAcqOrderMode()]);
        this.zValCombo_.setSelectedIndex(this.zVals_);
        this.stackKeepShutterOpenCheckBox_.setSelected(this.acqEng_.isShutterOpenForStack());
        this.chanKeepShutterOpenCheckBox_.setSelected(this.acqEng_.isShutterOpenForChannels());
        this.channelTable_.setAutoResizeMode(4);
        int n4 = this.channelsPanel_.isSelected() ? 1 : 0;
        this.channelTable_.setEnabled(n4 != 0);
        this.channelTable_.getTableHeader().setForeground(n4 != 0 ? Color.black : Color.gray);
        this.updateSavingTypeButtons();
        this.summaryTextArea_.setText(this.acqEng_.getVerboseSummary());
        this.disableGUItoSettings_ = false;
    }

    private void applySettings() {
        if (this.disableGUItoSettings_) {
            return;
        }
        this.disableGUItoSettings_ = true;
        AbstractCellEditor abstractCellEditor = (AbstractCellEditor)((Object)this.channelTable_.getCellEditor());
        if (abstractCellEditor != null) {
            abstractCellEditor.stopCellEditing();
        }
        try {
            double d = NumberUtils.displayStringToDouble(this.zStep_.getText());
            if (Math.abs(d) < this.acqEng_.getMinZStepUm()) {
                d = this.acqEng_.getMinZStepUm();
            }
            this.acqEng_.setSlices(NumberUtils.displayStringToDouble(this.zBottom_.getText()), NumberUtils.displayStringToDouble(this.zTop_.getText()), d, this.zVals_ != 0);
            this.acqEng_.enableZSliceSetting(this.slicesPanel_.isSelected());
            this.acqEng_.enableMultiPosition(this.positionsPanel_.isSelected());
            this.acqEng_.setDisplayMode(((DisplayMode)this.displayModeCombo_.getSelectedItem()).getID());
            this.acqEng_.setAcqOrderMode(((AcqOrderMode)this.acqOrderBox_.getSelectedItem()).getID());
            this.acqEng_.enableChannelsSetting(this.channelsPanel_.isSelected());
            this.acqEng_.setChannels(((ChannelTableModel)this.channelTable_.getModel()).getChannels());
            this.acqEng_.enableFramesSetting(this.framesPanel_.isSelected());
            this.acqEng_.setFrames((Integer)this.numFrames_.getValue(), this.convertTimeToMs(NumberUtils.displayStringToDouble(this.interval_.getText()), this.timeUnitCombo_.getSelectedIndex()));
            this.acqEng_.setAfSkipInterval(NumberUtils.displayStringToInt(this.afSkipInterval_.getValue().toString()));
            this.acqEng_.keepShutterOpenForChannels(this.chanKeepShutterOpenCheckBox_.isSelected());
            this.acqEng_.keepShutterOpenForStack(this.stackKeepShutterOpenCheckBox_.isSelected());
        }
        catch (ParseException parseException) {
            ReportingUtils.showError(parseException);
        }
        this.acqEng_.setSaveFiles(this.savePanel_.isSelected());
        this.acqEng_.setDirName(this.nameField_.getText());
        this.acqEng_.setRootName(this.rootField_.getText());
        this.acqEng_.setComment(this.commentTextArea_.getText());
        this.acqEng_.enableAutoFocus(this.afPanel_.isSelected());
        this.disableGUItoSettings_ = false;
        this.updateGUIContents();
    }

    private void saveSettings() {
        Rectangle rectangle = this.getBounds();
        if (this.prefs_ != null) {
            this.prefs_.putInt(ACQ_CONTROL_X, rectangle.x);
            this.prefs_.putInt(ACQ_CONTROL_Y, rectangle.y);
        }
    }

    private double convertTimeToMs(double d, int n) {
        if (n == 1) {
            return d * 1000.0;
        }
        if (n == 2) {
            return d * 60.0 * 1000.0;
        }
        if (n == 0) {
            return d;
        }
        ReportingUtils.showError("Unknown units supplied for acquisition interval!");
        return d;
    }

    private double convertMsToTime(double d, int n) {
        if (n == 1) {
            return d / 1000.0;
        }
        if (n == 2) {
            return d / 60000.0;
        }
        if (n == 0) {
            return d;
        }
        ReportingUtils.showError("Unknown units supplied for acquisition interval!");
        return d;
    }

    private void zValCalcChanged() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.zValCombo_.getSelectedIndex() == 0) {
            this.setTopButton_.setEnabled(false);
            this.setBottomButton_.setEnabled(false);
        } else {
            this.setTopButton_.setEnabled(true);
            this.setBottomButton_.setEnabled(true);
        }
        if (this.zVals_ == this.zValCombo_.getSelectedIndex()) {
            return;
        }
        this.zVals_ = this.zValCombo_.getSelectedIndex();
        try {
            d4 = NumberUtils.displayStringToDouble(this.zBottom_.getText());
            d3 = NumberUtils.displayStringToDouble(this.zTop_.getText());
        }
        catch (ParseException parseException) {
            ReportingUtils.logError(parseException);
            return;
        }
        double d5 = this.acqEng_.getCurrentZPos();
        if (this.zVals_ == 0) {
            this.setTopButton_.setEnabled(false);
            this.setBottomButton_.setEnabled(false);
            d2 = d3 - d5;
            d = d4 - d5;
        } else {
            this.setTopButton_.setEnabled(true);
            this.setBottomButton_.setEnabled(true);
            d2 = d3 + d5;
            d = d4 + d5;
        }
        this.zBottom_.setText(NumberUtils.doubleToDisplayString(d));
        this.zTop_.setText(NumberUtils.doubleToDisplayString(d2));
    }

    public void setBackgroundStyle(String string) {
        this.setBackground(this.guiColors_.background.get(string));
        for (JPanel jPanel : this.panelList_) {
        }
        this.repaint();
    }

    private void showAdvancedDialog() {
        if (this.advancedOptionsWindow_ == null) {
            this.advancedOptionsWindow_ = new AdvancedOptionsDialog(this.acqEng_, this.gui_);
        }
        this.advancedOptionsWindow_.setVisible(true);
    }

    public class CheckBoxPanel
    extends ComponentTitledPanel {
        JCheckBox checkBox;

        CheckBoxPanel(String string) {
            this.titleComponent = new JCheckBox(string);
            this.checkBox = (JCheckBox)this.titleComponent;
            this.compTitledBorder = new ComponentTitledBorder(this.checkBox, this, BorderFactory.createEtchedBorder());
            this.setBorder(this.compTitledBorder);
            this.borderSet_ = true;
            final CheckBoxPanel checkBoxPanel = this;
            this.checkBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = CheckBoxPanel.this.checkBox.isSelected();
                    checkBoxPanel.setChildrenEnabled(bl);
                }
            });
        }

        public void setChildrenEnabled(boolean bl) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i].getClass().equals(JPanel.class)) {
                    Component[] componentArray2 = ((JPanel)componentArray[i]).getComponents();
                    for (int j = 0; j < componentArray2.length; ++j) {
                        componentArray2[j].setEnabled(bl);
                    }
                    continue;
                }
                componentArray[i].setEnabled(bl);
            }
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean bl) {
            this.checkBox.setSelected(bl);
            this.setChildrenEnabled(bl);
        }

        public void addActionListener(ActionListener actionListener) {
            this.checkBox.addActionListener(actionListener);
        }

        public void removeActionListeners() {
            for (ActionListener actionListener : this.checkBox.getActionListeners()) {
                this.checkBox.removeActionListener(actionListener);
            }
        }
    }

    public class LabelPanel
    extends ComponentTitledPanel {
        LabelPanel(String string) {
            this.titleComponent = new JLabel(string);
            JLabel jLabel = (JLabel)this.titleComponent;
            jLabel.setOpaque(true);
            jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.compTitledBorder = new ComponentTitledBorder(jLabel, this, BorderFactory.createEtchedBorder());
            this.setBorder(this.compTitledBorder);
            this.borderSet_ = true;
        }
    }

    public class ComponentTitledPanel
    extends JPanel {
        public ComponentTitledBorder compTitledBorder;
        public boolean borderSet_ = false;
        public Component titleComponent;

        public void setBorder(Border border) {
            if (this.compTitledBorder != null && this.borderSet_) {
                this.compTitledBorder.setBorder(border);
            } else {
                super.setBorder(border);
            }
        }

        public Border getBorder() {
            return this.compTitledBorder;
        }

        public void setTitleFont(Font font) {
            this.titleComponent.setFont(font);
        }
    }

    public class ChannelCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -4328340719459382679L;
        private AcquisitionEngine acqEng_;

        public ChannelCellRenderer(AcquisitionEngine acquisitionEngine) {
            this.acqEng_ = acquisitionEngine;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ChannelTableModel channelTableModel = (ChannelTableModel)jTable.getModel();
            ArrayList<ChannelSpec> arrayList = channelTableModel.getChannels();
            ChannelSpec channelSpec = arrayList.get(n);
            this.setEnabled(jTable.isEnabled());
            if (bl2) {
                // empty if block
            }
            n2 = jTable.convertColumnIndexToModel(n2);
            this.setOpaque(false);
            if (n2 == 0) {
                JCheckBox jCheckBox = new JCheckBox("", channelSpec.useChannel_);
                jCheckBox.setEnabled(jTable.isEnabled());
                jCheckBox.setOpaque(true);
                if (bl) {
                    jCheckBox.setBackground(jTable.getSelectionBackground());
                    jCheckBox.setOpaque(true);
                } else {
                    jCheckBox.setOpaque(false);
                    jCheckBox.setBackground(jTable.getBackground());
                }
                return jCheckBox;
            }
            if (n2 == 1) {
                this.setText(channelSpec.config_);
            } else if (n2 == 2) {
                this.setText(NumberUtils.doubleToDisplayString(channelSpec.exposure_));
            } else if (n2 == 3) {
                this.setText(NumberUtils.doubleToDisplayString(channelSpec.zOffset_));
            } else {
                if (n2 == 4) {
                    JCheckBox jCheckBox = new JCheckBox("", (boolean)channelSpec.doZStack_);
                    jCheckBox.setEnabled(this.acqEng_.isZSliceSettingEnabled() && jTable.isEnabled());
                    if (bl) {
                        jCheckBox.setBackground(jTable.getSelectionBackground());
                        jCheckBox.setOpaque(true);
                    } else {
                        jCheckBox.setOpaque(false);
                        jCheckBox.setBackground(jTable.getBackground());
                    }
                    return jCheckBox;
                }
                if (n2 == 5) {
                    this.setText(Integer.toString(channelSpec.skipFactorFrame_));
                } else if (n2 == 6) {
                    this.setText("");
                    this.setBackground(channelSpec.color_);
                    this.setOpaque(true);
                }
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setOpaque(true);
            } else {
                this.setOpaque(false);
                this.setBackground(jTable.getBackground());
            }
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    public class ChannelCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -8374637422965302637L;
        JTextField text_ = new JTextField();
        JComboBox combo_ = new JComboBox();
        JCheckBox checkBox_ = new JCheckBox();
        JLabel colorLabel_ = new JLabel();
        int editCol_ = -1;
        int editRow_ = -1;
        ChannelSpec channel_ = null;

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ChannelSpec channelSpec;
            if (bl) {
                // empty if block
            }
            ChannelTableModel channelTableModel = (ChannelTableModel)jTable.getModel();
            ArrayList<ChannelSpec> arrayList = channelTableModel.getChannels();
            this.channel_ = channelSpec = arrayList.get(n);
            n2 = jTable.convertColumnIndexToModel(n2);
            this.editRow_ = n;
            this.editCol_ = n2;
            if (n2 == 0) {
                this.checkBox_.setSelected((Boolean)object);
                return this.checkBox_;
            }
            if (n2 == 2 || n2 == 3) {
                this.text_.setText(NumberUtils.doubleToDisplayString((Double)object));
                return this.text_;
            }
            if (n2 == 4) {
                this.checkBox_.setSelected((Boolean)object);
                return this.checkBox_;
            }
            if (n2 == 5) {
                this.text_.setText(NumberUtils.intToDisplayString((Integer)object));
                return this.text_;
            }
            if (n2 == 1) {
                this.combo_.removeAllItems();
                ActionListener[] actionListenerArray = this.combo_.getActionListeners();
                for (int i = 0; i < actionListenerArray.length; ++i) {
                    this.combo_.removeActionListener(actionListenerArray[i]);
                }
                this.combo_.removeAllItems();
                String[] stringArray = channelTableModel.getAvailableChannels();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.combo_.addItem(stringArray[i]);
                }
                this.combo_.setSelectedItem(channelSpec.config_);
                channelSpec.color_ = new Color(AcqControlDlg.this.colorPrefs_.getInt("Color_" + AcqControlDlg.this.acqEng_.getChannelGroup() + "_" + channelSpec.config_, Color.white.getRGB()));
                this.combo_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        channelSpec.color_ = new Color(AcqControlDlg.this.colorPrefs_.getInt("Color_" + AcqControlDlg.this.acqEng_.getChannelGroup() + "_" + channelSpec.config_, Color.white.getRGB()));
                        ChannelCellEditor.this.fireEditingStopped();
                    }
                });
                return this.combo_;
            }
            return this.colorLabel_;
        }

        public Object getCellEditorValue() {
            try {
                if (this.editCol_ == 0) {
                    return this.checkBox_.isSelected();
                }
                if (this.editCol_ == 1) {
                    this.channel_.color_ = new Color(AcqControlDlg.this.colorPrefs_.getInt("Color_" + AcqControlDlg.this.acqEng_.getChannelGroup() + "_" + this.combo_.getSelectedItem(), Color.white.getRGB()));
                    return this.combo_.getSelectedItem();
                }
                if (this.editCol_ == 2 || this.editCol_ == 3) {
                    return new Double(NumberUtils.displayStringToDouble(this.text_.getText()));
                }
                if (this.editCol_ == 4) {
                    return this.checkBox_.isSelected();
                }
                if (this.editCol_ == 5) {
                    return new Integer(NumberUtils.displayStringToInt(this.text_.getText()));
                }
                if (this.editCol_ == 6) {
                    Color color = this.colorLabel_.getBackground();
                    return color;
                }
                String string = "Internal error: unknown column";
                return string;
            }
            catch (ParseException parseException) {
                ReportingUtils.showError(parseException);
                String string = "Internal error: unknown column";
                return string;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChannelTableModel
    extends AbstractTableModel
    implements TableModelListener {
        private static final long serialVersionUID = 3290621191844925827L;
        private ArrayList<ChannelSpec> channels_;
        private AcquisitionEngine acqEng_;
        public final String[] COLUMN_NAMES = new String[]{"Use?", "Configuration", "Exposure", "Z-offset", "Z-stack", "Skip Fr.", "Color"};
        private final String[] TOOLTIPS = new String[]{"Toggle channel/group on/off", "Choose preset property values for channel or group", "Set exposure time in ms", TooltipTextMaker.addHTMLBreaksForTooltip("Set a Z offset specific to this channel/group (the main object in one of the channels/groups is in a different focal plane from the other channels/groups"), "Collect images in multiple Z planes?", TooltipTextMaker.addHTMLBreaksForTooltip("Setting 'Skip Frame' to a number other than 0 will cause the acquisition to 'skip' taking images in that channel (after taking the first image) for the indicated number of time intervals. The 5D-Image Viewer will 'fill in' these skipped frames with the previous image. In some situations it may be desirable to acquire certain channels at lower sampling rates, to reduce photo-toxicity and to save disk space. "), "Select channel/group color for display in viewer"};

        public String getToolTipText(int n) {
            return this.TOOLTIPS[n];
        }

        public ChannelTableModel(AcquisitionEngine acquisitionEngine) {
            this.acqEng_ = acquisitionEngine;
            this.addTableModelListener(this);
        }

        @Override
        public int getRowCount() {
            if (this.channels_ == null) {
                return 0;
            }
            return this.channels_.size();
        }

        @Override
        public int getColumnCount() {
            return this.COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLUMN_NAMES[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.channels_ != null && n < this.channels_.size()) {
                if (n2 == 0) {
                    return new Boolean(this.channels_.get((int)n).useChannel_);
                }
                if (n2 == 1) {
                    return this.channels_.get((int)n).config_;
                }
                if (n2 == 2) {
                    return new Double(this.channels_.get((int)n).exposure_);
                }
                if (n2 == 3) {
                    return new Double(this.channels_.get((int)n).zOffset_);
                }
                if (n2 == 4) {
                    return new Boolean(this.channels_.get((int)n).doZStack_);
                }
                if (n2 == 5) {
                    return new Integer(this.channels_.get((int)n).skipFactorFrame_);
                }
                if (n2 == 6) {
                    return this.channels_.get((int)n).color_;
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n >= this.channels_.size() || object == null) {
                return;
            }
            ChannelSpec channelSpec = this.channels_.get(n);
            if (n2 == 0) {
                channelSpec.useChannel_ = (Boolean)object;
            } else if (n2 == 1) {
                channelSpec.config_ = object.toString();
            } else if (n2 == 2) {
                channelSpec.exposure_ = (Double)object;
            } else if (n2 == 3) {
                channelSpec.zOffset_ = (Double)object;
            } else if (n2 == 4) {
                channelSpec.doZStack_ = (Boolean)object;
            } else if (n2 == 5) {
                channelSpec.skipFactorFrame_ = (Integer)object;
            } else if (n2 == 6) {
                channelSpec.color_ = (Color)object;
            }
            this.acqEng_.setChannel(n, channelSpec);
            AcqControlDlg.this.repaint();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 4 || this.acqEng_.isZSliceSettingEnabled();
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            int n = tableModelEvent.getFirstRow();
            if (n < 0) {
                return;
            }
            int n2 = tableModelEvent.getColumn();
            if (n2 < 0) {
                return;
            }
            ChannelSpec channelSpec = this.channels_.get(n);
            TableModel tableModel = (TableModel)tableModelEvent.getSource();
            if (n2 == 6) {
                Color color = (Color)tableModel.getValueAt(n, n2);
                AcqControlDlg.this.colorPrefs_.putInt("Color_" + this.acqEng_.getChannelGroup() + "_" + channelSpec.config_, color.getRGB());
            }
        }

        public void setChannels(ArrayList<ChannelSpec> arrayList) {
            this.channels_ = arrayList;
        }

        public ArrayList<ChannelSpec> getChannels() {
            return this.channels_;
        }

        public void addNewChannel() {
            ChannelSpec channelSpec = new ChannelSpec();
            channelSpec.config_ = "";
            if (this.acqEng_.getChannelConfigs().length > 0) {
                for (String string : this.acqEng_.getChannelConfigs()) {
                    boolean bl = true;
                    for (ChannelSpec channelSpec2 : this.channels_) {
                        if (!string.contentEquals(channelSpec2.config_)) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    channelSpec.config_ = string;
                    break;
                }
                if (channelSpec.config_.length() == 0) {
                    ReportingUtils.showMessage("No more channels are available\nin this channel group.");
                } else {
                    channelSpec.color_ = new Color(AcqControlDlg.this.colorPrefs_.getInt("Color_" + this.acqEng_.getChannelGroup() + "_" + channelSpec.config_, Color.white.getRGB()));
                    this.channels_.add(channelSpec);
                }
            }
        }

        public void removeChannel(int n) {
            if (n >= 0 && n < this.channels_.size()) {
                this.channels_.remove(n);
            }
        }

        public int rowDown(int n) {
            if (n >= 0 && n < this.channels_.size() - 1) {
                ChannelSpec channelSpec = this.channels_.get(n);
                this.channels_.remove(n);
                this.channels_.add(n + 1, channelSpec);
                return n + 1;
            }
            return n;
        }

        public int rowUp(int n) {
            if (n >= 1 && n < this.channels_.size()) {
                ChannelSpec channelSpec = this.channels_.get(n);
                this.channels_.remove(n);
                this.channels_.add(n - 1, channelSpec);
                return n - 1;
            }
            return n;
        }

        public String[] getAvailableChannels() {
            return this.acqEng_.getChannelConfigs();
        }

        public void cleanUpConfigurationList() {
            Iterator<ChannelSpec> iterator = this.channels_.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().config_;
                if (string.contentEquals("") || this.acqEng_.isConfigAvailable(string)) continue;
                iterator.remove();
            }
            this.fireTableStructureChanged();
        }

        public boolean duplicateChannels() {
            for (int i = 0; i < this.channels_.size() - 1; ++i) {
                for (int j = i + 1; j < this.channels_.size(); ++j) {
                    if (!this.channels_.get((int)i).config_.equals(this.channels_.get((int)j).config_)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

