/*
 * Decompiled with CFR 0.152.
 */
import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mmcorej.CMMCore;
import org.micromanager.MMStudioMainFrame;
import org.micromanager.acquisition.AcquisitionVirtualStack;
import org.micromanager.utils.AutofocusManager;
import org.micromanager.utils.JavaUtils;
import org.micromanager.utils.ReportingUtils;

public class MMStudioPlugin
implements PlugIn,
CommandListener {
    static MMStudioMainFrame frame_;

    public void run(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (frame_ == null || !frame_.isRunning()) {
                        if (JavaUtils.isMac()) {
                            System.setProperty("apple.laf.useScreenMenuBar", "true");
                        }
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Exception exception) {
                            ReportingUtils.logError(exception);
                        }
                        if (!IJ.versionLessThan((String)"1.46e")) {
                            Executer.addCommandListener((CommandListener)MMStudioPlugin.this);
                        }
                        frame_ = new MMStudioMainFrame(true);
                        frame_.setVisible(true);
                        frame_.setDefaultCloseOperation(0);
                    }
                    if (string.equals("OpenAcq")) {
                        frame_.openAcquisitionData(true);
                    }
                }
                catch (Exception exception) {
                    ReportingUtils.logError(exception);
                }
            }
        });
    }

    public String commandExecuting(String string) {
        if (string.equalsIgnoreCase("Quit") && frame_ != null) {
            frame_.closeSequence();
            return string;
        }
        if (string.equals("Crop")) {
            if (IJ.getImage().getStack() instanceof AcquisitionVirtualStack) {
                new Duplicator().run(IJ.getImage()).show();
                return null;
            }
        } else if (string.equals("Add Noise") && IJ.getImage().getStack() instanceof AcquisitionVirtualStack) {
            AcquisitionVirtualStack acquisitionVirtualStack = (AcquisitionVirtualStack)IJ.getImage().getStack();
            if (acquisitionVirtualStack.getVirtualAcquisitionDisplay().isDiskCached()) {
                new Duplicator().run(IJ.getImage()).show();
            } else if (!IJ.showMessageWithCancel((String)"Micro-Manager data not saved", (String)"Data are not saved and Undo is impossible. \nDo you really want to execute the command?")) {
                return null;
            }
        }
        return string;
    }

    public static MMStudioMainFrame getMMStudioMainFrameInstance() {
        return frame_;
    }

    public static CMMCore getMMCoreInstance() {
        if (frame_ == null || !frame_.isRunning()) {
            return null;
        }
        return frame_.getMMCore();
    }

    public static AutofocusManager getAutofocusManager() {
        if (frame_ == null || !frame_.isRunning()) {
            return null;
        }
        return frame_.getAutofocusManager();
    }
}

