/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.stats;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.NumericType;

public class Normalize {
    public static <T extends NumericType<T> & Comparable<T>> void normalize(IterableInterval<T> iterable, T min, T max) {
        Cursor<T> cursor = iterable.cursor();
        NumericType currentMax = (NumericType)((NumericType)cursor.next()).copy();
        NumericType currentMin = (NumericType)currentMax.copy();
        for (NumericType t : iterable) {
            if (((Comparable)((Object)t)).compareTo(currentMax) > 0) {
                currentMax.set(t);
                continue;
            }
            if (((Comparable)((Object)t)).compareTo(currentMin) >= 0) continue;
            currentMin.set(t);
        }
        NumericType scale = (NumericType)max.copy();
        scale.sub(min);
        NumericType currentScale = currentMax;
        currentScale.sub(currentMin);
        for (NumericType t : iterable) {
            t.sub(currentMin);
            t.mul(scale);
            t.div(currentScale);
            t.add(min);
        }
    }
}

