/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.stats;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.Algorithm;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.img.Img;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class ComputeMinMax<T extends Type<T> & Comparable<T>>
implements Algorithm,
MultiThreaded,
Benchmark {
    final IterableInterval<T> image;
    final T min;
    final T max;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public static final <T extends Comparable<T> & Type<T>> void computeMinMax(RandomAccessibleInterval<T> interval, T min, T max) {
        ComputeMinMax<T> c = new ComputeMinMax<T>(interval);
        c.process();
        ((Type<T>)min).set(c.getMin());
        ((Type<T>)max).set(c.getMax());
    }

    public ComputeMinMax(Img<T> img, T min, T max) {
        this((IterableInterval<T>)img, min, max);
    }

    public ComputeMinMax(IterableInterval<T> interval, T min, T max) {
        this.setNumThreads();
        this.image = interval;
        this.min = min;
        this.max = max;
    }

    public ComputeMinMax(RandomAccessibleInterval<T> interval, T min, T max) {
        this(Views.iterable(interval), min, max);
    }

    public ComputeMinMax(Img<T> img) {
        this((IterableInterval<T>)img);
    }

    public ComputeMinMax(IterableInterval<T> interval) {
        this.setNumThreads();
        this.image = interval;
        this.min = ((Type)this.image.firstElement()).createVariable();
        this.max = this.min.copy();
    }

    public ComputeMinMax(RandomAccessibleInterval<T> interval) {
        this(Views.iterable(interval));
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        long imageSize = this.image.size();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
        final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, this.numThreads);
        final Vector minValues = new Vector();
        final Vector maxValues = new Vector();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            minValues.add(((Type)this.image.firstElement()).createVariable());
            maxValues.add(((Type)this.image.firstElement()).createVariable());
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    ComputeMinMax.this.compute(myChunk.getStartPosition(), myChunk.getLoopSize(), (Type)minValues.get(myNumber), (Type)maxValues.get(myNumber));
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        this.min.set((Type)((Type)minValues.get(0)));
        this.max.set((Type)((Type)maxValues.get(0)));
        for (int i = 0; i < threads.length; ++i) {
            Type value = (Type)minValues.get(i);
            if (Util.min(this.min, value) == value) {
                this.min.set((Type)value);
            }
            if (Util.max(this.max, value = (Type)maxValues.get(i)) != value) continue;
            this.max.set((Type)value);
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected void compute(long startPos, long loopSize, T min, T max) {
        Cursor<T> cursor = this.image.cursor();
        cursor.fwd();
        min.set((Type)((Type)cursor.get()));
        max.set((Type)((Type)cursor.get()));
        cursor.reset();
        cursor.jumpFwd(startPos);
        for (long j = 0L; j < loopSize; ++j) {
            cursor.fwd();
            Type value = (Type)cursor.get();
            if (Util.min(min, value) == value) {
                min.set((Type)value);
            }
            if (Util.max(max, value) != value) continue;
            max.set((Type)value);
        }
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "ScaleSpace: [Image<A> img] is null.";
            return false;
        }
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

