/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood.old;

import java.util.Iterator;
import net.imglib2.AbstractCursor;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RandomAccessible;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.region.localneighborhood.old.LocalNeighborhoodCursor2;
import net.imglib2.util.Util;

public class LocalNeighborhood2<T>
implements IterableInterval<T> {
    final int numDimensions;
    final long size;
    final long[] center;
    final RandomAccessible<T> source;

    public LocalNeighborhood2(RandomAccessible<T> source, Localizable center) {
        this.numDimensions = source.numDimensions();
        this.center = new long[this.numDimensions];
        center.localize(this.center);
        this.size = Util.pow(3, this.numDimensions) - 1;
        this.source = source;
    }

    public void updateCenter(long[] center) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.center[d] = center[d];
        }
    }

    public void updateCenter(Localizable center) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.center[d] = center.getLongPosition(d);
        }
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public T firstElement() {
        return ((AbstractCursor)this.cursor()).next();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public boolean equalIterationOrder(IterableRealInterval<?> f) {
        return this.iterationOrder().equals(f.iterationOrder());
    }

    @Override
    public double realMin(int d) {
        return this.center[d] - 1L;
    }

    @Override
    public void realMin(double[] min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min[d] = this.center[d] - 1L;
        }
    }

    @Override
    public void realMin(RealPositionable min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min.setPosition(this.center[d] - 1L, d);
        }
    }

    @Override
    public double realMax(int d) {
        return this.center[d] + 1L;
    }

    @Override
    public void realMax(double[] max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max[d] = this.center[d] + 1L;
        }
    }

    @Override
    public void realMax(RealPositionable max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max.setPosition(this.center[d] + 1L, d);
        }
    }

    @Override
    public int numDimensions() {
        return this.numDimensions;
    }

    @Override
    public Iterator<T> iterator() {
        return this.cursor();
    }

    @Override
    public long min(int d) {
        return this.center[d] - 1L;
    }

    @Override
    public void min(long[] min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min[d] = this.center[d] - 1L;
        }
    }

    @Override
    public void min(Positionable min) {
        for (int d = 0; d < this.numDimensions; ++d) {
            min.setPosition(this.center[d] - 1L, d);
        }
    }

    @Override
    public long max(int d) {
        return this.center[d] + 1L;
    }

    @Override
    public void max(long[] max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max[d] = this.center[d] + 1L;
        }
    }

    @Override
    public void max(Positionable max) {
        for (int d = 0; d < this.numDimensions; ++d) {
            max.setPosition(this.center[d] - 1L, d);
        }
    }

    @Override
    public void dimensions(long[] dimensions) {
        for (int d = 0; d < this.numDimensions; ++d) {
            dimensions[d] = 3L;
        }
    }

    @Override
    public long dimension(int d) {
        return 3L;
    }

    @Override
    public LocalNeighborhoodCursor2<T> cursor() {
        return new LocalNeighborhoodCursor2<T>(this.source.randomAccess(), this.center);
    }

    @Override
    public LocalNeighborhoodCursor2<T> localizingCursor() {
        return this.cursor();
    }
}

