/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.AbstractInterval;
import net.imglib2.FinalInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.algorithm.region.localneighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.region.localneighborhood.Neighborhood;

public abstract class HypersphereNeighborhoodLocalizableSampler<T>
extends AbstractInterval
implements Localizable,
Sampler<Neighborhood<T>> {
    protected final RandomAccessibleInterval<T> source;
    protected final HyperSphereNeighborhoodFactory<T> neighborhoodFactory;
    protected final Neighborhood<T> currentNeighborhood;
    protected final long[] currentPos;
    protected final long radius;

    public HypersphereNeighborhoodLocalizableSampler(RandomAccessibleInterval<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
        super(source);
        this.source = source;
        this.radius = radius;
        this.neighborhoodFactory = factory;
        this.currentPos = new long[this.n];
        long[] accessMin = new long[this.n];
        long[] accessMax = new long[this.n];
        source.min(accessMin);
        source.max(accessMax);
        int d = 0;
        while (d < this.n) {
            int n = d;
            accessMin[n] = accessMin[n] - radius;
            int n2 = d++;
            accessMax[n2] = accessMax[n2] + radius;
        }
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, radius, source.randomAccess(new FinalInterval(accessMin, accessMax)));
    }

    protected HypersphereNeighborhoodLocalizableSampler(HypersphereNeighborhoodLocalizableSampler<T> c) {
        super(c.source);
        this.source = c.source;
        this.radius = c.radius;
        this.neighborhoodFactory = c.neighborhoodFactory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.radius, this.source.randomAccess());
    }

    @Override
    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    @Override
    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }

    @Override
    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }
}

