/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import java.util.Iterator;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.localneighborhood.HyperSphereNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.HyperSphereNeighborhoodCursor;
import net.imglib2.algorithm.region.localneighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.region.localneighborhood.HyperSphereNeighborhoodRandomAccess;
import net.imglib2.algorithm.region.localneighborhood.HyperSphereNeighborhoodUnsafe;
import net.imglib2.algorithm.region.localneighborhood.Neighborhood;
import net.imglib2.algorithm.region.localneighborhood.Shape;
import net.imglib2.view.Views;

public class HyperSphereShape
implements Shape {
    final long radius;

    public HyperSphereShape(long radius) {
        this.radius = radius;
    }

    @Override
    public <T> IterableInterval<Neighborhood<T>> neighborhoods(RandomAccessibleInterval<T> source) {
        return Views.iterable(this.neighborhoodsRandomAccessible((RandomAccessibleInterval)source));
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsAccessible<T>(source, this.radius, HyperSphereNeighborhoodUnsafe.factory());
    }

    @Override
    public <T> IterableInterval<Neighborhood<T>> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        return Views.iterable(this.neighborhoodsRandomAccessible((RandomAccessibleInterval)source));
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsAccessible<T>(source, this.radius, HyperSphereNeighborhood.factory());
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractInterval
    implements RandomAccessibleInterval<Neighborhood<T>>,
    IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final long radius;
        final long size;
        final HyperSphereNeighborhoodFactory<T> factory;

        public NeighborhoodsAccessible(RandomAccessibleInterval<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.radius = radius;
            this.factory = factory;
            long s = source.dimension(0);
            for (int d = 1; d < this.n; ++d) {
                s *= source.dimension(d);
            }
            this.size = s;
        }

        @Override
        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new HyperSphereNeighborhoodRandomAccess<T>(this.source, this.radius, this.factory);
        }

        @Override
        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        @Override
        public Object iterationOrder() {
            return new FlatIterationOrder(this);
        }

        @Override
        public boolean equalIterationOrder(IterableRealInterval<?> f) {
            return this.iterationOrder().equals(f.iterationOrder());
        }

        @Override
        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }

        @Override
        public Cursor<Neighborhood<T>> cursor() {
            return new HyperSphereNeighborhoodCursor<T>(this.source, this.radius, this.factory);
        }

        @Override
        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }
    }
}

