/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.region.localneighborhood;

import net.imglib2.AbstractInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.region.localneighborhood.HyperSphereNeighborhoodFactory;
import net.imglib2.algorithm.region.localneighborhood.Neighborhood;

public class HyperSphereNeighborhoodRandomAccess<T>
extends AbstractInterval
implements RandomAccess<Neighborhood<T>> {
    protected final RandomAccessibleInterval<T> source;
    protected final long radius;
    protected final HyperSphereNeighborhoodFactory<T> neighborhoodFactory;
    protected final Neighborhood<T> currentNeighborhood;
    protected final long[] currentPos;

    public HyperSphereNeighborhoodRandomAccess(RandomAccessibleInterval<T> source, long radius, HyperSphereNeighborhoodFactory<T> factory) {
        super(source);
        this.source = source;
        this.radius = radius;
        this.neighborhoodFactory = factory;
        this.currentPos = new long[this.n];
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, radius, source.randomAccess());
    }

    protected HyperSphereNeighborhoodRandomAccess(HyperSphereNeighborhoodRandomAccess<T> c) {
        super(c.source);
        this.source = c.source;
        this.radius = c.radius;
        this.neighborhoodFactory = c.neighborhoodFactory;
        this.currentPos = (long[])c.currentPos.clone();
        this.currentNeighborhood = this.neighborhoodFactory.create(this.currentPos, this.radius, this.source.randomAccess());
    }

    @Override
    public Neighborhood<T> get() {
        return this.currentNeighborhood;
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.currentPos[n] = this.currentPos[n] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + localizable.getLongPosition(d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = localizable.getLongPosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.currentPos[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.currentPos[d] = position;
    }

    @Override
    public HyperSphereNeighborhoodRandomAccess<T> copy() {
        return new HyperSphereNeighborhoodRandomAccess<T>(this);
    }

    @Override
    public HyperSphereNeighborhoodRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    @Override
    public void localize(int[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.currentNeighborhood.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.currentNeighborhood.getLongPosition(d);
    }

    @Override
    public void localize(float[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.currentNeighborhood.localize(position);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.currentNeighborhood.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.currentNeighborhood.getDoublePosition(d);
    }
}

